C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine WriteFcn(luout, JJ, FormatIn, FormatOut, Record, 
     :     Velocity, Unit, N,
c xsd specifics
     :     Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit, 
     :     Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset,
     :     Xsd_Num, Xsd_Name, Xsd_Color,
c vxos specifics
     :     Vxos_NumPicks,
c 3D specifics
     :     LI, DI,
c landmark specifics
     :     Landmark_Gradient, Landmark_Dzero, Landmark_Vzero,
c usp specifics
     :     nsi, ntrc, nrec, obytes, nsampo, itr,
     :     iwd, ifmt_iwd, ln_iwd, l_iwd, 
c vds3d specifics
c geco specifics
     :     Vds_OacLine, Geco_type, Geco_LineName, Geco_comment,
c flat3d specifics
     :     Flat3d_LI, Flat3d_DI, 
c flat3d1 specifics
     :     Flat3d1_LI, Flat3d1_DI, 
c western3d specifics
c disco3d specifics
     :     West_Line, West_Shot, West_Reshot, West_Long, West_Lat, 
     :     West_Units, disco_LI, disco_DI,   
c ukooa specifics
     : ukooa_LI, ukooa_DI, ukooa_LatLong, ukooa_X, ukooa_Y, verbos,
     : velst, veled,nsamp)
cmam : round, velst, veled,nsamp)

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c routine to output velocity function in desired output format

c variables passed from calling routine

      integer luout, JJ, N
      integer Vxos_NumPicks(SZLNHD)
      integer nsi, ntrc, nrec, itr(SZLNHD), obytes, nsampo
      integer ifmt_iwd, ln_iwd, l_iwd
      integer Xsd_Num, Xsd_Color
      integer LI, DI
      integer West_Shot
      integer disco_LI, disco_DI
      integer ukooa_LI, ukooa_DI, ukooa_X, ukooa_Y
      integer Geco_type
cmam  integer ivels, itims, irecs

      real Record(2*N), Velocity(2*N), Unit(2*N)
      real Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit 
      real Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset
      real Landmark_Gradient, Landmark_Dzero, Landmark_Vzero
      real Flat3d_LI, Flat3d_DI
      real Flat3d1_LI, Flat3d1_DI
      real West_Lat, West_Long
      real velst
      real veled

      character FormatIn*20, FormatOut*20, iwd*6, Xsd_Name*20
      character Vds_OacLine*7
      character West_Line*7, West_Reshot*1, West_Units*1
      character ukooa_LatLong*26
      character Geco_LineName*10, Geco_comment*14

      logical verbos
cmam  logical verbos, round

c local variables

      integer Remainder, ukooa_time(4), ukooa_velocity(4), count
      integer i, j

      character card1*5, card9*5, handvel*7, ukooa_end*3
      character c_Segment*7, c_Name*4, c_Color*5, c_Picks*5, c_Pick*4
      character c_Record*6, c_Sample*6, c_DstSgn*6

      character c_xsegment*10, c_xcolor*10, c_xpicks*9, c_xname*6

c initialize data

      card1 = '1TDFN'
      card9 = '9TDFN'
      handvel = 'HANDVEL'
      ukooa_end = 'END'

      IF ( velst .ne. 0.0 ) THEN
         do  i = N, 1, -1
             Record (i+1) = Record (i)
             Velocity (i+1) = Velocity (i)
             Unit (i+1) = Unit (i)
         enddo
         Record (1) = Record (2)
         Unit (1) = 0
         Velocity (1) = velst
         N = N + 1
      ENDIF
 
      IF ( veled .ne. 0.0 ) THEN
         N = N + 1
         Record (N) = Record (N-1)
         Unit (N) = (nsamp-1) * nsi
         Velocity (N) = veled
      ENDIF

c determine output format and act appropriately

      IF ( FormatOut .eq. 'xsd' ) then

c write pick segment in new XSD format

         if ( Xsd_Name .eq. ' ' ) then
            Xsd_Name = '   NO_PICK_NAME_HERE' 
         endif 

         c_xsegment = 'Segment = '
         c_xname = ' Name '
         c_xcolor = '  color = '
         c_xpicks = ' picks = '

         write(luout,10) c_xsegment, Xsd_Num, c_xname, Xsd_Name, 
     :        c_xcolor, Xsd_Color, c_xpicks,N
 10      format ( a10, i5, a6, a20, a10, i5, a9, i5 )

c write out picks
         
         do j = 1, N
            write(luout,'(f12.6,1x,f12.6,1x,f12.6)')
     :           Record(j), Velocity(j), Unit(j)
         enddo         
         return

      ELSEIF ( FormatOut .eq. 'xsdheader' ) then

         if ( Xsd_Name .eq. ' ' ) then
            Xsd_Name = '   NO_PICK_NAME_HERE' 
         endif 

         c_Segment = 'Segment'
         c_Name = 'Name'
         c_Color = 'Color'
         c_Picks = 'Picks'

         write(luout,'(A7,4x,f17.6)' ) c_Segment, float(JJ)
         write(luout,'(A4,7x,A20)' ) c_Name, Xsd_Name
         write(luout,'(A5,6x,f17.6)' ) c_Color, float(Xsd_Color)
         write(luout,'(A5,6x,f17.6)' ) c_Picks, float(N)

         c_Pick = 'Pick'
         c_Record = 'Record'
         c_Sample = 'Sample'
         c_DstSgn = 'DstSgn'

         do j = 1, N
            write(luout,'(A4,7x)' ) c_Pick
            write(luout,'(A6,5x,f17.6)' ) c_Record, Record(j)
c since it doesn't matter what is in trace as this file will NEVER be loaded
c back to xsd I won't bother outputting anything for trace.
            write(luout,'(A6,5x,f17.6)' ) c_Sample, Unit(j)
            write(luout,'(A6,5x,f17.6)' ) c_DstSgn, Velocity(j)

         enddo

      ELSEIF ( FormatOut .eq. 'flat' ) then

         do k = 1, N
            write(luout,'(3(I10,1x))') nint(Unit(k)), nint(Velocity(k)), 
     :           nint(Record(k))
         enddo
         write(luout,*)'-1  0', nint(Record(N))

      ELSEIF ( FormatOut .eq. 'tdfn' ) then

         KK = N / 7
         Remainder = N - ( KK * 7 )

         if ( FormatIn .eq. 'ukooa' .or. FormatIn .eq. 'ukooa1') then
            irec = ukooa_DI

c POLICEMAN - it is possible to have time values greater than
c             9999 using ukooa input format.  Of course you 
c             are limited to 9999 or smaller on tdfn output.
c             watch out for this and bomb the user off for now
c             if this condition is violated .... pgag

            do i = 1,N
               if ( nint(Unit(i)) .gt. 9999 ) then
                  write(LERR,*)' '
                  write(LERR,*)' You have times in your input file'
                  write(LERR,*)' at record ',irec
                  write(LERR,*)' greater than 9999 units which is '
                  write(LERR,*)' not supported in TDFN output.'
                  write(LERR,*)'FATAL'
                  write(LER,*)' '
                  write(LER,*)'VOMIT: '
                  write(LER,*)' You have times in your input file'
                  write(LER,*)' at record ',irec
                  write(LER,*)' greater than 9999 units which is '
                  write(LER,*)' not supported in TDFN output.'
                  write(LER,*)'FATAL'
                  stop
               endif
            enddo            
         else
            irec = Record(1)
         endif

         count = 0 - 6

         if ( Remainder .eq. 0 ) then

c the following will put a 9TDFN card on a full line

            do k = 1, KK - 1
               count = count + 7
               write(luout,'(a5,7(i4,i5),7x,i5)') card1, 
     :              (nint(Unit(j)), nint(Velocity(j)), 
     :              j = count,count + 6),irec
            enddo
            count = count + 7
            do  j = count+6, count-1, -1
                 if(Unit(j) .eq. 0. .AND. Velocity(j) .ne. 0.) then
                    Unit(j) = (nsamp-1) * nsi
                    go to 12
                 endif
            enddo
12          continue
            write(luout, '(a5,7(i4,i5),7x,i5)') card9,  
     :           ( nint(Unit(j)), nint(Velocity(j)),
     :           j = count, count + 6 ), irec

         else

c the following will put a 9TDFN card on a partial line

            do k = 1, KK
               count = count + 7
               write(luout,'(a5,7(i4,i5),7x,i5)') card1, 
     :              (nint(Unit(j)), nint(Velocity(j)), 
     :              j = count,count + 6),irec
            enddo

            count = count + 7
            do  j = count+6, count-1, -1
                 if(Unit(j) .eq. 0. .AND. Velocity(j) .ne. 0.) then
                    Unit(j) = (nsamp-1) * nsi
                    go to 13
                 endif
            enddo
13          continue
            write(luout, '(a5,7(i4,i5),7x,i5)') card9,  
     :           ( nint(Unit(j)), nint(Velocity(j)),
     :           j = count, count + 6 ), irec

         endif

      ELSEIF ( FormatOut .eq. 'usp' ) then

         if ( FormatIn .ne. 'landmark' .and. 
     :        FormatIn .ne. 'landmark2' .and. 
     :        FormatIn .ne. 'hgs' .and. 
     :        FormatIn .ne. 'vds3d' .and. 
     :        FormatIn .ne. 'vip' .and. 
     :        FormatIn .ne. 'fairfield'  .and. 
     :        FormatIn .ne. 'flat3d'  .and. 
     :        FormatIn .ne. 'kelman'  .and. 
     :        FormatIn .ne. 'western3d'  .and. 
     :        FormatIn .ne. 'western3d1'  .and. 
     :        FormatIn .ne. 'geco'  .and. 
     :        FormatIn .ne. 'flat3d1'  ) then
            irec = nint(Record(1))
            call savew2(itr, ifmt_iwd, l_iwd, ln_iwd, irec, TRACEHEADER)
         endif

c if input format is usp then velocity has nsampo entries, otherwise 
c itr has already been filled out in BuildTrace[] and can just be output here

         if (FormatIn.eq.'omnivel') then
             call vmov ( Velocity, 1, itr(ITHWP1), 1, nsampo)
         endif

         if ( FormatIn .eq. 'usp' ) then
             call vmov ( Velocity, 1, itr(ITHWP1), 1, nsampo)
	 endif

         call wrtape( luout, itr, obytes )

      ELSEIF ( FormatOut .eq. 'disco' .or. 
     :        FormatOut .eq. 'disco3d' .or. 
     :        FormatOut .eq. 'disco3d2' ) 
     :        then

c make sure nothing left over in the arrays after entry N or it might
c turn up on one of the padded entries of the handvel card

         call vclr ( unit(N+1), 1, N )
         call vclr ( velocity(N+1), 1, N )

         KK = N / 4
         Remainder = N - ( KK * 4 )
         irec = nint ( Record(1) )
         count = 0 - 3

         if ( FormatOut .eq. 'disco' ) then

            write(luout,'(a7,1x,i8)') handvel, irec

         elseif ( FormatOut .eq. 'disco3d' ) then

            write(luout,'(a7,1x,i8,46x,2i6)') handvel, irec, disco_LI, 
     :           disco_DI

         elseif ( FormatOut .eq. 'disco3d2' ) then

            write(luout,'(a7,i9,1x,i9)') handvel, disco_LI, disco_DI

         endif

         do k = 1, KK
            count = count + 4
            write(luout,'(4(2f8.1))' ) 
     :           ( Unit(j), Velocity(j), j = count, count + 3)
         enddo
         
         if ( Remainder .gt. 0 ) then
            count = count + 4
            write(luout,'(4(2f8.1))' )
     :           ( Unit(j), Velocity(j), j = count, count + 3)
         endif

      ELSEIF ( FormatOut .eq. 'vxos' ) then

         if ( FormatIn .eq. FormatOut ) N = Vxos_NumPicks(JJ)

c convert velocity to trace for output

         if ( FormatIn .ne. 'vxos' ) then
            do i = 1, N
               Velocity(i) = (Velocity(i) - Xsd_VelOffset)/ Xsd_VelUnit
            enddo
         endif

         c_xsegment = 'Segment = '
         c_xname = ' Name '
         c_xcolor = '  color = '
         c_xpicks = ' picks = '

         write(luout,10) c_xsegment, JJ, c_xname, Xsd_Name, 
     :        c_xcolor, Xsd_Color, c_xpicks, N

c write out picks
         
         do j = 1, N
            write(luout,'(f12.6,1x,f12.6,1x,f12.6)')
     :           Record(j), Velocity(j), Unit(j)
         enddo         
         return
         
      ELSEIF ( FormatOut .eq. 'landmark' ) then

         write(luout,*) DI, LI, nint(Landmark_Gradient),  
     :        nint(Landmark_Dzero), nint(Landmark_Vzero), 
     :        ( nint(unit(i)), nint(velocity(i)), i = 2, N )

      ELSEIF ( FormatOut .eq. 'vds3d' ) then

c write the 0TDFN card followed by regular TDFN cards with one
c exception... no record number...instead output OACLINE
cmam for agip format in, set Vds_OacLine to blanks
         if ( FormatIn .eq. 'agip' ) then
              Vds_OacLine = '       '
              LI = ukooa_LI
              DI = ukooa_DI
         endif

         write(luout, 20) LI, DI, Vds_OacLine
 20      format('0TDFN',2i5,53x,a7)

         if ( FormatIn .eq. 'ukooa'.or.
     :        FormatIn .eq. 'ukooa1' .or.
     :        FormatIn .eq. 'agip' ) then

c POLICEMAN - it is possible to have time values greater than
c             9999 using ukooa input format.  Of course you 
c             are limited to 9999 or smaller on vds3d output.
c             watch out for this and bomb the user off for now
c             if this condition is violated .... pgag
cmam..........might also occur with agip input, so check it as well

            do i = 1,N
               if ( nint(Unit(i)) .gt. 9999 ) then
                  write(LERR,*)' '
                  write(LERR,*)' You have times in your input file'
                  write(LERR,*)' at record ',irec
                  write(LERR,*)' greater than 9999 units which is '
                  write(LERR,*)' not supported in vds3d output.'
                  write(LERR,*)'FATAL'
                  write(LER,*)' '
                  write(LER,*)'VOMIT: '
                  write(LER,*)' You have times in your input file'
                  write(LER,*)' at record ',irec
                  write(LER,*)' greater than 9999 units which is '
                  write(LER,*)' not supported in vds3d output.'
                  write(LER,*)'FATAL'
                  stop
               endif
            enddo            
         endif

         KK = N / 7
         Remainder = N - ( KK * 7 )

         count = 0 - 6

         if ( Remainder .eq. 0 ) then

c the following will put a 9TDFN card on a full line

            do k = 1, KK - 1
               count = count + 7
               write(luout,'(a5,7(i4,i5),a7)') card1, 
     :              (nint(Unit(j)), nint(Velocity(j)), 
     :              j = count,count + 6),Vds_OacLine
            enddo
            count = count + 7
            write(luout, '(a5,7(i4,i5),a7)') card9,  
     :           ( nint(Unit(j)), nint(Velocity(j)),
     :           j = count, count + 6 ), Vds_OacLine

         else

c the following will put a 9TDFN card on a partial line

            do k = 1, KK
               count = count + 7
               write(luout,'(a5,7(i4,i5),a7)') card1, 
     :              (nint(Unit(j)), nint(Velocity(j)), 
     :              j = count,count + 6),Vds_OacLine
            enddo

            count = count + 7
cmam..zero out end of arrays to be sure nothing is there

	    zero = 0.0
	    nnn = 7 - Remainder
            call vfill(zero,Unit(N+1),1,nnn)
            call vfill(zero,Velocity(N+1),1,nnn)

            write(luout, '(a5,7(i4,i5),a7)') card9,  
     :           ( nint(Unit(j)), nint(Velocity(j)),
     :           j = count, count + 6 ), Vds_OacLine

         endif

      ELSEIF ( FormatOut .eq. 'flat3d' ) then

         do i = 1,N
            write(luout,'(4(F10.1,1x))') Flat3d_LI, Flat3d_DI, Unit(i), 
     :           Velocity(i)
         enddo
         
      ELSEIF ( FormatOut .eq. 'flat3d1' ) then

         write(luout,'(30i5)') nint(Flat3d1_LI), nint(Flat3d1_DI), 
     :        ( nint(Unit(i)), nint(Velocity(i)) , i = 1, N )
         
      ELSEIF ( FormatOut .eq. 'western3d' ) then

         write(luout, 100)West_Line, West_Shot, West_Reshot, West_Long, 
     :        West_Lat, West_Units, N,
     :        (nint(Unit(i)),i=1,N), (nint(Velocity(j)),j=1,N)

 100     format(a7, i5, a1, 13x, 2f8.3, 13x, a1, i4, 68i5 )
         
      ELSEIF ( FormatOut .eq. 'ukooa' ) then

c write the function header
c for agip input, set LatLong to zeros or blanks???
         if ( FormatIn .eq. 'agip')
     :      ukooa_LatLong = '00000000000000000000000000'

         write( luout,'(4x,2i5,4x,a26,2i8)' ) ukooa_LI, ukooa_DI, 
     :        ukooa_LatLong, ukooa_X, ukooa_Y

         KK = N / 4
         Remainder = N - ( KK * 4 )
         count = 0 - 3

         if ( Remainder .eq. 0 ) then

c no padding of entries with -1's required

            do k = 1, KK
               count = count + 4
               write(luout,'(8x,4(2i5,10x))') (nint(Unit(j)), 
     :              nint(Velocity(j)),j = count, count + 3 )
            enddo
            
         else

c will need to do some padding on the last function card

            do k = 1, KK
               count = count + 4
               write(luout,'(8x,4(2i5,10x))') (nint(Unit(j)), 
     :              nint(Velocity(j)),j = count, count + 3 )
            enddo
            
            count = count + 4
            
            do k = 1,4
               ukooa_time(k) = -1
               ukooa_velocity(k) = -1
            enddo

            do k = count, N
               ukooa_time(k-count+1) = nint(Unit(k))
               ukooa_velocity(k - count + 1) = nint(Velocity(k))
            enddo

            write(luout,'(8x,4(2i5,10x))') ( ukooa_time(j), 
     :           ukooa_velocity(j), j = 1,4 )

         endif

c write the trailing END card

         write(luout,'(a3)') ukooa_end

      ELSEIF ( FormatOut .eq. 'ukooa1' ) then

c write the function header
c for agip input, set LatLong to zeros or blanks???
         if ( FormatIn .eq. 'agip')
     :      ukooa_LatLong = '00000000000000000000000000'

         write( luout,'(4x,2i10,a20,2i8)' ) ukooa_LI, ukooa_DI, 
     :        ukooa_LatLong, ukooa_X, ukooa_Y

         KK = N / 4
         Remainder = N - ( KK * 4 )
         count = 0 - 3

         if ( Remainder .eq. 0 ) then

c no padding of entries with -1's required

            do k = 1, KK
               count = count + 4
               write(luout,'(8x,4(2i5,10x))') (nint(Unit(j)), 
     :              nint(Velocity(j)),j = count, count + 3 )
            enddo
            
         else

c will need to do some padding on the last function card or not
c let us try and see

            do k = 1, KK
               count = count + 4
               write(luout,'(8x,4(2i5,10x))') (nint(Unit(j)), 
     :              nint(Velocity(j)),j = count, count + 3 )
            enddo
            
            count = count + 4
            
            write(luout,'(8x,4(2i5,10x))') (nint(Unit(j)),
     :           nint(Velocity(j)), j = count,count+Remainder-1 )

         endif

c write the trailing END card

         write(luout,'(a3)') ukooa_end

      ELSEIF ( FormatOut .eq. 'geco' ) then

         do i = 1,N
            write(luout, 30 )Geco_LineName, LI, DI, Geco_comment, 
     :           nint(Unit(i)), Geco_type, nint(Velocity(i))
 30          format( a10, 2i5, 1x, a14, i5, 10x, i1, 9x, i5 )
         enddo
  
      ELSEIF ( FormatOut .eq. 'tdq' ) then

c the first function value must also contain x,y information
c and the sequential function number

         write(luout,'(f10.0,1x,2(f13.2,1x),2(f10.2,1x) )') float(JJ), 
     :        float(ukooa_X), float(ukooa_Y), Unit(1), Velocity(1)

         do i = 2,N
            write(luout,'(39x, 2(f10.2,1x))') Unit(i), Velocity(i)
         enddo

      ELSEIF ( FormatOut .eq. 'tdq2' ) then

c I cannot believe that this is necessary but it is easier to add this
c to vomit than to try to figure out what Khaled is up to.  For some
c reason he requires that all function entries have the x,y data
c and function number installed.  He also wants integer instead of
c floating point function number and x,y data in different format
c locations that above

         do i = 1,N
            write(luout,'(i6,2i10,3x,2f10.2) )') JJ, 
     :           ukooa_X, ukooa_Y, Unit(i), Velocity(i)
         enddo

      ELSEIF ( FormatOut .eq. 'promax' ) then
         write(LERR,*) ' '
         write(LERR,*) 'Not Yet Hoser'
         write(LERR,*) ' '
         write(LER,*) ' '
         write(LER,*) 'Not Yet Hoser'
         write(LER,*) ' '
         stop

      ELSEIF ( FormatOut .eq. 'promax3d' ) then
         write(LERR,*) ' '
         write(LERR,*) 'Not Yet Hoser'
         write(LERR,*) ' '
         write(LER,*) ' '
         write(LER,*) 'Not Yet Hoser'
         write(LER,*) ' '
         stop

      ELSEIF ( FormatOut .eq. 'zmap' ) then

c all function set values must also contain x,y information
c and the sequential function numbering

         do i = 1,N
            write(luout,'(I10,1x,2(f13.2,1x),2(f10.2,1x) )') 
     :           JJ, float(ukooa_X), float(ukooa_Y), Unit(i), 
     :           Velocity(i)
         enddo

      ENDIF

      return
      end
      
