C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, FormatIn, FormatOut, vin, vout,
     :     sin, sout, linear, eta, rnmo, charisma_vel_flag,
c xsd specifics
     :     Xsd_SmpUnitOverride, XSDInitVelOverride,
     :     XSDVelUnitsOverride, Xsd_mnemonic,
c usp specifics
     :     SlopeAdjustmentFactor, iwd, Force, depth_time_curve,
     :     nsamp, nrec, ntrc, nsi, Usp_SmpIntOverride, UnitSc_out,
     :     MBSdx, MBSdy, MBSdz, UnitSc_override, time_depth_curve,
     :     Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth,
c landmark specifics
     :     Landmark_nhor, Landmark_Vmax, Landmark_watvel,
c vds specifics
     :     Vds_OacLine,
c flat3d1 specifics, kelman specifics
     :     Flat3d1_Nelem, Kelman_vref,
c earth vision specifics
     :     Earth_ntop, Earth_nbottom, Earth_topWrd, Earth_botWrd,
c western3d specifics
     :     West_Line, West_Reshot, West_Units,
c geco specifics
     :     Geco_LineName, Geco_comment,
c omnivel specifics
     :     Omni_3D,
c
     :     tdq_c_units, tdq_datum, verbos,velst,veled)
 
c parse arguments entered on command line

      implicit none
 
#include <f77/iounit.h>
 
      integer   argis, nsamp, nrec, ntrc, nsi
      integer   Usp_SmpIntOverride, MBSdx, MBSdy, MBSdz
      integer   Landmark_nhor
      integer   Flat3d1_Nelem
 
      real      XSDInitVelOverride, XSDVelUnitsOverride
      real      SlopeAdjustmentFactor, Xsd_SmpUnitOverride
      real      dx, dy, dz
      real      Landmark_Vmax, Landmark_watvel
      real      Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth
      real      UnitSc_override, UnitSc_out
      real      velst
      real      veled, Kelman_vref
      real      tdq_datum
 
      character ntap*(*), otap*(*), iwd*(*)
      character sin*(*), sout*(*), vin*(*), vout*(*)
      character formatin*(*), formatout*(*), Xsd_mnemonic*6
      character Vds_OacLine*7
      character Earth_ntop*(*), Earth_nbottom*(*)
      character Earth_topWrd*6, Earth_botWrd*6
      character West_Line*7, West_Reshot*1, West_Units*1
      character Geco_LineName*10, Geco_comment*14
      character tdq_c_units*6
 
      logical   Force, linear, eta, rnmo, charisma_vel_flag, verbos
      logical	Omni_3D, time_depth_curve, depth_time_curve

 
c initialize variables
 
      verbos = .false.

      Force = .false.
      Omni_3D = .false.
      time_depth_curve = .false.

c grab command line keys and their associated values, get them
c in alphabetical order longest first
 
      call argstr ('-comment', Geco_comment, ' ', ' ' )

      call argr4  ('-d2tmax',Usp_Depth2Time_MaxTime,0.0,0.0)
      depth_time_curve  = ( argis('-DT') .gt. 0)
      call argr4  ('-dv',XSDVelUnitsOverride,0.,0.)
 
c read this to store in the line header for mbs guys if required
 
      call argr4  ('-dx',dx, 0., 0.)
      call argr4  ('-dy',dy, 0., 0.)
      call argr4  ('-dz',dz, 0., 0.)
      MBSdx = nint ( 1000. * dx )
      MBSdy = nint ( 1000. * dy )
      MBSdz = nint ( 1000. * dz )
 
      eta  = ( argis('-eta') .gt. 0)
      call argstr ('-ew1', Earth_topWrd, 'TVPT01', 'TVPT01' )
      call argstr ('-ew2', Earth_botWrd, 'TVPV01', 'TVPV01' )
      call argstr ('-E1', Earth_ntop, ' ', ' ' )
      call argstr ('-E2', Earth_nbottom, ' ', ' ' )
 
      Force = ( argis('-force') .gt. 0)
      call argstr ('-fi', FormatIn, ' ', ' ' )
      call argstr ('-fo', FormatOut, ' ', ' ' )
 
      call argstr ('-hw', iwd, 'RecNum', 'RecNum' )
 
      linear = ( argis('-linear') .gt. 0)
      call argstr ('-line', West_Line, ' ', ' ' )
      Geco_LineName = West_Line
 
      if ( FormatIn .ne. 'usp' ) then
         call argi4 ( '-nsamp', nsamp, 0, 0 )
         call argi4 ( '-nelem', Flat3d1_Nelem, 0, 0 )
         call argi4 ( '-nhor', Landmark_nhor, 0, 0 )
         call argi4 ( '-nrec', nrec, 0, 0 )
         call argi4 ( '-ntrc', ntrc, 0, 0 )
         call argi4 ( '-nsi', nsi, 0, 0 )
      endif

      call argstr ('-N', ntap, ' ', ' ' )
 
      Omni_3D = ( argis('-omni3d') .gt. 0 )
      call argstr ('-oac', Vds_OacLine, ' ', ' ' )
      call argi4 ( '-osi', Usp_SmpIntOverride, 0, 0 )
      call argstr ('-O', otap, ' ', ' ' )
 
c policeman for clobbering input dataset during all the confusion of
c a multi-conversion job
 
      if ( ntap .eq. otap ) then
c check for pipes in and/or out...
       if ( ntap .ne. ' ' .and. otap .ne. ' ') then
         write(LERR,*)' '
         write(LERR,*)'VOMIT: You have used the same filename for'
         write(LERR,*)'       both the input and output files.'
         write(LERR,*)'       Job terminated for your own good'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'VOMIT: You have used the same filename for'
         write(LER,*)'       both the input and output files.'
         write(LER,*)'       Job terminated for your own good'
         write(LER,*)'FATAL'
         stop
       endif
      endif
 
      call argstr ('-reshot', West_Reshot, ' ', ' ' )
      rnmo  = ( argis('-rnmo') .gt. 0)
 
      call argstr ('-sout', sout, 'T', 'T' )
      call argr4  ('-saf',SlopeAdjustmentFactor,0.0,0.0)
      call argstr ('-sin', sin, 'T', 'T' )
 
      call argr4  ('-t2dmax',Usp_Time2Depth_MaxDepth,0.0,0.0)
      call argr4 ('-tdq_datum',tdq_datum, 0.0, 0.0 )
      call argstr ('-tdq_units', tdq_c_units, 'METERS', 'METERS' )
      time_depth_curve = ( argis('-TD') .gt. 0 )
 
      call argr4  ('-UnitSc_out', UnitSc_out, 0.0, 0.0 )
      call argr4  ('-UnitSc', UnitSc_override, 0.0, 0.0 )
      call argstr ('-units', West_Units, ' ', ' ' )
      call argr4  ('-u',Xsd_SmpUnitOverride,1.,1.)

      if ( UnitSc_out .eq. 0.0 ) UnitSc_out = UnitSc_override
 
      Charisma_vel_flag = ( argis('-velocity') .gt. 0 )
      call argr4  ('-vmax', Landmark_Vmax, 0.0, 0.0 )
      call argr4  ('-vref', Kelman_vref, 0.0, 0.0 )

cmam......start: charisma defaults are different

      if ( FormatIn .eq. 'charisma') then
      	call argstr ('-vout', vout, 'I', 'I' )
      	call argstr ('-vin', vin, 'A', 'A' )
      else
      	call argstr ('-vout', vout, 'R', 'R' )
      	call argstr ('-vin', vin, 'R', 'R' )
      endif

cmam.......end

      call argr4  ('-velst',velst, 0., 0.)
      call argr4  ('-veled',veled, 0., 0.)
      call argr4  ('-v0',XSDInitVelOverride,0.,0.)
      verbos = ( argis('-V') .gt. 0 )
      
      call argr4  ('-watvel',Landmark_watvel, 1500., 1500.)

      call argstr ('-xhw', Xsd_mnemonic, ' ', ' ' )
 
c set SlopeAdjustmentFactor used to decimate usp dataset sample-wise
c to generate a reasonable number of entries in a function.
 
      if ( abs ( SlopeAdjustmentFactor ) .lt. 1.e-32 ) then
         if ( vout .eq. 'I' ) then
            SlopeAdjustmentFactor = 0.01
         else
            SlopeAdjustmentFactor = 0.001
         endif
      else
         SlopeAdjustmentFactor = SlopeAdjustmentFactor / 100.
      endif
 
c policeman to make sure that the user specified an input format or kill the job
 
      if ( FormatIn .ne. 'usp'
     :     .and. FormatIn .ne. 'agip'
     :     .and. FormatIn .ne. 'charisma'
     :     .and. FormatIn .ne. 'hgs'
     :     .and. FormatIn .ne. 'digicon'
     :     .and. FormatIn .ne. 'disco'
     :     .and. FormatIn .ne. 'disco3d'
     :     .and. FormatIn .ne. 'disco3d1'
     :     .and. FormatIn .ne. 'disco3d3'
     :     .and. FormatIn .ne. 'disco3dxy'
     :     .and. FormatIn .ne. 'essov2'
     :     .and. FormatIn .ne. 'ev3d'
     :     .and. FormatIn .ne. 'fairfield'
     :     .and. FormatIn .ne. 'flat'
     :     .and. FormatIn .ne. 'flat3d'
     :     .and. FormatIn .ne. 'flat3d1'
     :     .and. FormatIn .ne. 'geco'
     :     .and. FormatIn .ne. 'hmig'
     :     .and. FormatIn .ne. 'kelman'
     :     .and. FormatIn .ne. 'landmark'
     :     .and. FormatIn .ne. 'landmark2'
     :     .and. FormatIn .ne. 'omnivel'
     :     .and. FormatIn .ne. 'promax'
     :     .and. FormatIn .ne. 'promax3d'
     :     .and. FormatIn .ne. 'tdfn'
     :     .and. FormatIn .ne. 'ukooa'
     :     .and. FormatIn .ne. 'ukooa1'
     :     .and. FormatIn .ne. 'ukooa2'
     :     .and. FormatIn .ne. 'vds3d'
     :     .and. FormatIn .ne. 'vip'
     :     .and. FormatIn .ne. 'vxos'
     :     .and. FormatIn .ne. 'western3d'
     :     .and. FormatIn .ne. 'western3d1'
     :     .and. FormatIn .ne. 'xsd'
     :     .and. FormatIn .ne. 'xsdheader' ) then
 
         write(LERR,*)' '
         write(LERR,*)' No VALID input velocity format specified'
         write(LERR,*)' Specify -fin on the command line and rerun'
         write(LERR,*)' FATAL'
         write(LER,*)' '
         write(LER,*)' VOMIT: No VALID input velocity format specified'
         write(LERR,*)' Specify -fin on the command line and rerun'
         write(LER,*)' '
         write(LER,*)' FATAL'
         write(LER,*)' '
         stop
      endif
 
      if ( FormatOut .ne. 'usp'
     :     .and. FormatOut .ne. 'disco'
     :     .and. FormatOut .ne. 'disco3d'
     :     .and. FormatOut .ne. 'disco3d2'
     :     .and. FormatOut .ne. 'ev3d'
     :     .and. FormatOut .ne. 'flat'
     :     .and. FormatOut .ne. 'flat3d'
     :     .and. FormatOut .ne. 'flat3d1'
     :     .and. FormatOut .ne. 'geco'
     :     .and. FormatOut .ne. 'hmig'
     :     .and. FormatOut .ne. 'landmark'
     :     .and. FormatOut .ne. 'landmark2'
     :     .and. FormatOut .ne. 'omnivel'
     :     .and. FormatOut .ne. 'tdfn'
     :     .and. FormatOut .ne. 'tdq'
     :     .and. FormatOut .ne. 'tdq2'
     :     .and. FormatOut .ne. 'ukooa'
     :     .and. FormatOut .ne. 'ukooa1'
     :     .and. FormatOut .ne. 'ukooa2'
     :     .and. FormatOut .ne. 'vds3d'
     :     .and. FormatOut .ne. 'vxos'
     :     .and. FormatOut .ne. 'western3d'
     :     .and. FormatOut .ne. 'xsd'
     :     .and. FormatOut .ne. 'xsdheader'
     :     .and. FormatOut .ne. 'zmap' ) then
	if (FormatIn .eq. 'charisma' .and. FormatOut .eq. ' ' ) then            
	   FormatOut = 'usp'
	elseif (FormatIn .eq. 'hgs' .and. FormatOut .eq. ' ' ) then            
	   FormatOut = 'usp'
	elseif (FormatIn .eq. 'digicon' .and. FormatOut .eq. ' ' ) then
	   FormatOut = 'usp'
	elseif (FormatIn .eq. 'essov2' .and. FormatOut .eq. ' ' ) then
	   FormatOut = 'usp'
	elseif (FormatIn .eq. 'fairfield' .and.
     :      FormatOut .eq. ' ' ) then
	   FormatOut = 'usp'
	else
 
         write(LERR,*)' '
         write(LERR,*)' No valid output velocity format specified'
         write(LERR,*)' Check spelling etc. then'
         write(LERR,*)' Specify -fout on the command line and rerun'
         write(LERR,*)' FATAL'
         write(LER,*)' '
         write(LER,*)' VOMIT: No valid output velocity format'
         write(LER,*)' Check spelling etc. then'
         write(LER,*)' Specify -fout on the command line and rerun'
         write(LER,*)' '
         write(LER,*)' FATAL'
         write(LER,*)' '
         stop
	endif

      endif

      if ( FormatIn .eq. 'digicon' .and. FormatOut .ne. 'usp') then
         write(LERR,*)' '
         write(LERR,*)'VOMIT: invalid output format specified.'
         write(LERR,*)'digicon input only allows usp output.'
         write(LERR,*)'Check spelling, etc., for -fo argument.'
         write(LER ,*)' '
         write(LER ,*)'VOMIT: invalid output format specified.'
         write(LER ,*)'digicon input only allows usp output.'
         write(LER ,*)'Check spelling, etc., for -fo argument.'
      endif

      if ( FormatIn .eq. 'essov2' .and. FormatOut .ne. 'usp') then
         write(LERR,*)' '
         write(LERR,*)'VOMIT: invalid output format specified.'
         write(LERR,*)'essov2 input only allows usp output.'
         write(LERR,*)'Check spelling, etc., for -fo argument.'
         write(LER ,*)' '
         write(LER ,*)'VOMIT: invalid output format specified.'
         write(LER ,*)'essov2 input only allows usp output.'
         write(LER ,*)'Check spelling, etc., for -fo argument.'
      endif

      if ( FormatIn .eq. 'fairfield' .and. FormatOut .ne. 'usp') then
         write(LERR,*)' '
         write(LERR,*)'VOMIT: invalid output format specified.'
         write(LERR,*)'fairfield input only allows usp output.'
         write(LERR,*)'Check spelling, etc., for -fo argument.'
         write(LER ,*)' '
         write(LER ,*)'VOMIT: invalid output format specified.'
         write(LER ,*)'fairfield input only allows usp output.'
         write(LER ,*)'Check spelling, etc., for -fo argument.'
      endif

      if ( FormatIn .eq. 'omnivel' .and. FormatOut .ne. 'usp') then
         write(LERR,*)' '
         write(LERR,*)'VOMIT: invalid output format specified.'
         write(LERR,*)'omnivel input only allows usp output.'
         write(LERR,*)'Check spelling, etc., for -fo argument.'
         write(LER ,*)' '
         write(LER ,*)'VOMIT: invalid output format specified.'
         write(LER ,*)'omnivel input only allows usp output.'
         write(LER ,*)'Check spelling, etc., for -fo argument.'
      endif
 
c policeman to make check for Paul Singer like typos on the sample
c and velocity input / output  parameters sin, sout, vin, vout

      if ( sin .ne. 'T' .and. sin .ne. 'D' ) then
         write(LERR,*)' '
         write(LERR,*)' You have entered an illegal value for -sin '
         write(LERR,*)'      your -sin entry = ',sin
         write(LERR,*)' Correct this entry to one of T or D and '
         write(LERR,*)' resubmit'
         write(LER,*)' '
         write(LER,*)'VOMIT:'
         write(LER,*)' You have entered an illegal value for -sin '
         write(LER,*)'      your -sin entry = ',sin
         write(LER,*)' Correct this entry to one of T or D and '
         write(LER,*)' resubmit'
         write(LER,*)'FATAL'
         close(LERR)
         stop
      endif

      if ( sout .ne. 'T' .and. sout .ne. 'D' ) then
         write(LERR,*)' '
         write(LERR,*)' You have entered an illegal value for -sout '
         write(LERR,*)'      your -sout entry = ',sout
         write(LERR,*)' Correct this entry to one of T or D and '
         write(LERR,*)' resubmit'
         write(LER,*)' '
         write(LER,*)'VOMIT:'
         write(LER,*)' You have entered an illegal value for -sout '
         write(LER,*)'      your -sout = ',sout
         write(LER,*)' Correct this entry to one of T or D and '
         write(LER,*)' resubmit'
         write(LER,*)'FATAL'
         close(LERR)
         stop
      endif
         
      if ( vin .ne. 'R' .and. vin .ne. 'A' .and. vin .ne. 'I' ) then
         write(LERR,*)' '
         write(LERR,*)' You have entered an illegal value for -vin '
         write(LERR,*)'      your -vin entry = ',vin
         write(LERR,*)' Correct this entry to one of R, I or A and '
         write(LERR,*)' resubmit'
         write(LER,*)' '
         write(LER,*)'VOMIT:'
         write(LER,*)' You have entered an illegal value for -vin '
         write(LER,*)'      your -vin entry = ',vin
         write(LER,*)' Correct this entry to one of R, I or A and '
         write(LER,*)' resubmit'
         write(LER,*)'FATAL'
         close(LERR)
         stop
      endif

      if ( vout .ne. 'R' .and. vout .ne. 'A' .and. vout .ne. 'I' ) then
         write(LERR,*)' '
         write(LERR,*)' You have entered an illegal value for -vout '
         write(LERR,*)'      your -vout entry = ',vout
         write(LERR,*)' Correct this entry to one of R, I or A and '
         write(LERR,*)' resubmit'
         write(LER,*)' '
         write(LER,*)'VOMIT:'
         write(LER,*)' You have entered an illegal value for -vout '
         write(LER,*)'      your -vout entry = ',vout
         write(LER,*)' Correct this entry to one of R, I or A and '
         write(LER,*)' resubmit'
         write(LER,*)'FATAL'
         close(LERR)
         stop
      endif

c if the user is looking for a time,depth curve out then it would
c be best to force vout to be average so that a depth time calculation
c would be painless on the way out.

      if ( time_depth_curve ) then
         vout = 'A'
         sout = 'T'

         if ( sin .ne. 'T' ) then
            write(LERR,*)' when using -TD you must have input units of'
            write(LERR,*)' time.  If this is a problem please call the'
            write(LERR,*)' USP helpline for a program upgrade'

            write(LER,*)' '
            write(LER,*)'VOMIT: '
            write(LERR,*)' when using -TD you must have input units of'
            write(LERR,*)' time.  If this is a problem please call the'
            write(LERR,*)' USP helpline for a program upgrade'
            write(LER,*)'FATAL'
            stop
         endif  
      endif          

      if ( depth_time_curve ) then
         vout = 'A'
         sout = 'D'

         if ( sin .ne. 'D' ) then
            write(LERR,*)' when using -DT you must have input units of'
            write(LERR,*)' depth.  If this is a problem please call the'
            write(LERR,*)' USP helpline for a program upgrade'

            write(LER,*)' '
            write(LER,*)'VOMIT: '
            write(LERR,*)' when using -DT you must have input units of'
            write(LERR,*)' depth.  If this is a problem please call the'
            write(LERR,*)' USP helpline for a program upgrade'
            write(LER,*)'FATAL'
            stop
         endif            
      endif

c if the user has specified Kelman input then a reference velocity is required
c which if not entered requires the program to stop now and prompt for same

      if ( FormatIn .eq. 'kelman' .and. Kelman_vref .eq. 0.0 ) then
         write(LERR,*)' when using -fi kelman you must supply a '
         write(LERR,*)' reference velocity -vref[]'
         write(LERR,*)' Do so and try again'
         
         write(LER,*)' '
         write(LER,*)'VOMIT: '
         write(LER,*)' when using -fi kelman you must supply a '
         write(LER,*)' reference velocity -vref[]'
         write(LER,*)' Do so and try again'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif            
      if ( FormatIn .eq. 'kelman' .and. vin .ne. 'R' ) then
         write(LERR,*)' when using -fi kelman you must input '
         write(LERR,*)' an RMS velocity dataset. '
         write(LERR,*)' Do so and try again'
         
         write(LER,*)' '
         write(LER,*)'VOMIT: '
         write(LER,*)' when using -fi kelman you must input'
         write(LER,*)' an RMS velocity dataset. '
         write(LER,*)' Do so and try again'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif            
         

      return
      end
 
 
 
 
