C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine d2t( rt, rv, nn )
 
c d2t converts the DEPTH axis to TIME assuming:
c         rv() = INTERVAL velocity in units/second
c         rt() = DEPTH in units
c
c it is also assumed that the interval velocity is
c posted at the base of the interval over which it
c applies [to be consistent with MBS, ILIS etc.
c
c output will be 2way TIME
 
#include <f77/lhdrsz.h>
 
      integer nn, i
 
      real*4 rt(*), rv(*)
      real*4 tint, Time(SZLNHD)
 
c initialize memory
 
      call vclr ( Time, 1, SZLNHD )
 
c first RMS velocity = first INTERVAL velocity
c calculate intial time
 
      Time(1) = rt(1) / rv(1)
 
      do i = 2, nn
         tint = ( rt(i) - rt(i - 1) ) / rv(i)
         Time(i) = Time(i - 1) + tint
      enddo
 
      do i = 1, nn
 
c load depth into output array
 
         rt(i) = Time(i) * 2.
      enddo
 
      return
      end
