C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tr2ti( rt, rv, nn, tape, SlopeAdjustmentFactor, vflag,
     :     Force, JJ)
 
c tr2ti converts an input RMS velocity function to INTERVAL velocity
c using Dix Equation.
c
c it is assumed that:
c
c  rt() = 2way TIME in seconds
c  rv() = RMS velocity in units/second
c
c on output rv() = INTERVAL velocity in units/second
c velocity is referenced to the bottom of the interval
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
      integer nn, i, NewNumberOfPoints, JJ
 
      real rt(*), rv(*), vint(SZLNHD), Numerator, SlopeAdjustmentFactor
      real IntervalTime(SZLNHD), temprv(SZLNHD), temprt(SZLNHD), Slope
      real NewSlope
 
      character switch*3
 
      logical tape, vflag, Force
 
c initialize memory
 
      call vclr( vint, 1, SZLNHD )
      call vclr( IntervalTime, 1, SZLNHD )
      call vclr( temprv, 1, SZLNHD )
      call vclr( temprt, 1, SZLNHD )
 
c assign first interval velocity
 
      vint(1) = rv(1)
 
c if TAPE then scan function for slope breaks greater than
c         SlopeAdjustmentFactor * Slope
c glean rv() values at these locations only.
 
      IF( tape .and. .not. vflag ) then
         switch = 'off'
         Slope = ( rv(2) - rv(1) ) / ( rt(2) - rt(1) )
         NewNumberOfPoints = 0
 
         DO i = 3, nn
            NewSlope = ( rv(i) - rv(i-1) ) / ( rt(i) - rt(i-1) )
 
            if ( ( abs( NewSlope - Slope ) ) .gt.
     :           ( SlopeAdjustmentFactor * abs( Slope ) ) ) then
 
               if ( switch .ne. 'on' ) then
                  switch = 'on'
                  NewNumberOfPoints = NewNumberOfPoints + 1
                  temprt(NewNumberOfPoints) = rt(i)
                  temprv(NewNumberOfPoints) = rv(i)
                  Slope = NewSlope
               else
                  switch = 'off'
                  Slope = NewSlope
               endif
            endif
         ENDDO
 
        do i=1,NewNumberOfPoints
           rt(i) = temprt(i)
           rv(i) = temprv(i)
        enddo
 
c if the max time is already used don't use it again, otherwise put
c the max time and max vel at the end of the function
 
        if ( ( temprt(NewNumberOfPoints) - rt(nn) ) .gt. 1.e-30 ) then
           NewNumberOfPoints=NewNumberOfPoints+1
           rv(NewNumberOfPoints) = rv(nn)
           rt(NewNumberOfPoints) = rt(nn)
        endif
 
        nn = NewNumberOfPoints
      ENDIF
 
c assign IntervalTime[1]
 
      IntervalTime(1) = rt(1) / 2.

 10   continue
 
      DO i = 2, nn

c calculate interval time
 
         IntervalTime(i) = ( rt(i) - rt(i-1) ) / 2.
 
c form numerator
 
         Numerator = ( rv(i)**2 * rt(i) / 2. ) -
     :        ( rv(i-1)**2 * rt(i-1) / 2. )

c POLICEMAN: check to see if numerator is negative (ie. rms velocity inversion)
c            if so, then stop and warn user of this problem and suggest
c            options......use interval velocities....supply maxtime rms velocity
c            use -force on command line and hope for the best.
 
         if ( Numerator .lt. 0. .and. .not. Force ) then
            write(LERR,*)' '
            write(LERR,*)'VOMIT: You have rms velocity inversions '
            write(LERR,*)'       in your input RMS velocity function ',
     :           'number ',JJ
            write(LERR,*)'       severe enough to cause negative square'
            write(LERR,*)'       which is BAD.'
            write(LERR,*)' '
            write(LERR,*)'       You may flag the command option -force'
            write(LERR,*)'       which will cause vomit to drop the '
            write(LERR,*)'       function point casuing the negative '
            write(LERR,*)'       root and go on to the next one.  This'
            write(LERR,*)'       may result in changes to your input'
            write(LERR,*)'       function set so careful QC is required'
            write(LERR,*)' '
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'VOMIT: You have rms velocity inversions '
            write(LER,*)'       in your input RMS velocity function ',
     :           'number ',JJ
            write(LER,*)'       severe enough to cause negative square '
            write(LER,*)'       which is BAD.'
            write(LER,*)' '
            write(LER,*)'       You may flag the command option -force'
            write(LER,*)'       which will cause vomit to drop the '
            write(LER,*)'       function point casuing the negative '
            write(LER,*)'       root and go on to the next one.  This'
            write(LER,*)'       may result in odd changes to your input'
            write(LER,*)'       function set so careful QC is required'
            write(LER,*)' '

            write(LER,*)' '
            write(LER,*)'FATAL'
            stop
         endif

         if ( Numerator .lt. 0. ) then

c we want to discard point i and try again at i+1 with i-1 to see
c if we have a positive numerator.  We want to keep this up until 
c we either get a physically realizable situation or we run out of 
c function   

            if ( (i+1) .le. nn ) then

c drop current function value and try again
               
               do j= i,nn-1
                  rt(j) = rt(j+1)
                  rv(j) = rv(j+1)
               enddo

               nn = nn - 1
               goto 10

            elseif ( (i+1) .gt. nn ) then

c just drop the last function value and go on              
               
               nn = nn - 1

            endif

c         elseif ( Numerator .lt. 0. .and. Force ) then
c            vint(i) = vint(i-1)
         else
            vint(i) = sqrt ( Numerator / IntervalTime(i) )
         endif
 
c calculate vint
 
      ENDDO
 
c handle zero TIME entry, since interval velocity is referenced to the
c base of the interval the first entry [if zero] must contain the
c same velocity as at the base of the first interval.
 
      IF ( rt(1) .gt. 1.0e-20 ) then
 
c there is no zero time entry, must manufacture one
c bump rt() values up one slot to make room for zero entry
 
         do i = nn + 1, 2, -1
            rt(i) = rt(i-1)
         enddo
 
c assign zero TIME rt() value
 
         rt(1) = 0.
 
c load INTERVAL velocities to rv()
 
         call vmov( vint, 1, rv(2), 1, nn )
 
c assign zero TIME rv[1] value
 
         rv(1) = rv(2)
 
c increase function count by one
 
         nn = nn + 1
 
      ELSE
 
c load INTERVAL velocities to rv()
 
         call vmov( vint, 1, rv, 1, nn )
 
      ENDIF
 
      return
      end
 
