C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdv(slow,zdatum,
     1               tdatum,zmin,nxgrid,nzgrid,ITRWRD,
     3               ifmt_FlDtEl,l_FlDtEl,ln_FlDtEl,
     4               luvgrid,TRACEHEADER,verbose,lerr)
c
      real      slow(-ITRWRD:nzgrid,nxgrid)     
      real      zdatum(nxgrid)
c
      integer   ifmt_FlDtEl,l_FlDtEl,ln_FlDtEl
      integer   TRACEHEADER
c
      logical   tdatum 
      logical   verbose
c_______________________________________________________________________
c     read in the velocity trace.
c     if velocity is non zero, calculate the slowness=1./velocity. 
c_______________________________________________________________________
      ierror=0
      do 40000 ix=1,nxgrid     
       nbyptr=0
       call rtape(luvgrid,slow(-ITRWRD,ix),nbyptr)
       do 32000 iz=0,nzgrid
        if(slow(iz,ix) .le. 0.) then
           write(lerr,*) 'error in routine rdv'
           write(lerr,*) 'trace  = ',ix              
           write(lerr,*) 'sample = ',iz+1           
           Write(lerr,*) 'v      = ',slow(iz,ix)
           ierror=ierror+1
           slow(iz,ix)=0.
        else
           slow(iz,ix)=1./slow(iz,ix)
        endif
32000  continue 
40000 continue
      if(ierror .gt. 0.) then
         write(lerr,*) 'program exited due to ', ierror,' errors!'
         call exitfu(6001)
      endif
      if(tdatum) then
c_______________________________________________________________________
c        extract floating datum from the trace headers.
c_______________________________________________________________________
         do 53000 ix=1,nxgrid
          call saver2(slow(-ITRHDR,ix),ifmt_FlDtEl,l_FlDtEl, 
     1                ln_FlDtEl,jval,TRACEHEADER)
          zdatum(ix)=-jval   
53000    continue
      else
         do 54000 ix=1,nxgrid
          zdatum(ix)=zmin
54000    continue
      endif
      if(verbose) then
         write(lerr,'(2a12)') 'ix','zdatum(ix)'
         write(lerr,'(i12,f12.3)') (ix,zdatum(ix),ix=1,nxgrid)
      endif
C
      return
      end 
