C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdv(slow,ztopo,zmin,topo,
     1     nxgrid,nzgrid,ITRWRD,luvgrid,
     2     ifmt_GrpElv, l_GrpElv, ln_GrpElv,
     3     ifmt_DphInd, l_DphInd, ln_DphInd,
     4     ifmt_LinInd, l_LinInd, ln_LinInd,
     5     xpick,zpick,npicks,lutopo,rdtopo,
     6     xvo,dxgrid,zvo,dzgrid,lerr,verbose)

c     
      integer   GrpElv, ifmt_GrpElv, l_GrpElv, ln_GrpElv
      integer   DphInd, ifmt_DphInd, l_DphInd, ln_DphInd
      integer   LinInd, ifmt_LinInd, l_LinInd, ln_LinInd
      real      slow(-ITRWRD:nzgrid,0:nxgrid)     
      real      ztopo(0:nxgrid)
      real      xpick(npicks),zpick(npicks)
      logical   topo,rdtopo,verbose
      logical   sometopography
c_______________________________________________________________________
c     initialize
c_______________________________________________________________________
      do 10000 jx=0,nxgrid
       ztopo(jx)=0.
10000 continue
      sometopography=.false.
c_______________________________________________________________________
c     read in the velocity trace.
c     if velocity is non zero, calculate the slowness=1./velocity. 
c_______________________________________________________________________
      nbyptr=0
      call rtape(luvgrid,slow(-ITRWRD,0),nbyptr)
      call saver2(slow(-ITRWRD,0),ifmt_DphInd,l_DphInd, ln_DphInd,
     1            DphInd, 1)
      call saver2(slow(-ITRWRD,0),ifmt_LinInd,l_LinInd, ln_LinInd,
     1            LinInd, 1)
      write(LERR,*)' '
      write(LERR,*)'Smoothing LI= ',LinInd,'  DI= ',DphInd

      do 40000 ix=0,nxgrid     
       nbyptr=0
       if(ix .ge. 1) then
          call rtape(luvgrid,slow(-ITRWRD,ix),nbyptr)
       endif
       do 30000 iz=0,nzgrid
        if(slow(iz,ix) .le. 0.) then
           write(lerr,*) 'non positive velocity detected on input!'
           write(lerr,*) 'trace number  ',ix+1
           write(lerr,*) 'sample number ',iz+1
           write(lerr,*) 'v =           ',slow(iz,ix)
           close(lerr)
           call exitfu(4666)
        else
           slow(iz,ix)=1./slow(iz,ix)
        endif
30000  continue 
       if(topo) then
          call saver2(slow(-ITRWRD,ix),ifmt_GrpElv,l_GrpElv,ln_GrpElv,
     1                GrpElv, 1)
          ztopo(ix) = - GrpElv
c_____________________________________________________________________
c         check for unfilled out trace headers.
c_____________________________________________________________________
          if(ztopo(ix) .ne. 0) sometopography=.true.
       else
          ztopo(ix)=zmin
       endif
40000 continue
      if(rdtopo) then
         write(lerr,*) 'npicks = ',npicks
         sometopography=.true.
         do 60000 ipick=1,npicks             
          read(lutopo,*,err=99994,end=99994) 
     1               recno,xpick(ipick),zpick(ipick)
          write(lerr,*) 'echo picks ',
     1               ipick,recno,xpick(ipick),zpick(ipick)
C__________________________________________________________________
c         reverse positive elevations to be negative depths.
C__________________________________________________________________
          zpick(ipick)=-zpick(ipick)
60000    continue
C__________________________________________________________________
c        check for bad picks.                         
C__________________________________________________________________
         ierror=0           
         do 65000 ipick=2,npicks
          if(xpick(ipick) .le. xpick(ipick-1)) then
             write(lerr,*) 'pick ',ipick, ' out of sequence!'
             write(lerr,'(i10,f12.3)') ipick-1,xpick(ipick-1),
     1                                 ipick,xpick(ipick)
             ierror=ierror+1
          endif
65000    continue
         if(ierror .gt. 0) then
            write(lerr,*) 'routine rdv exiting due to improperly'
     1            //' ordered or duplicate picks in xsd pick file'
            close(lerr)
            call exitfu(5003)
         endif
C__________________________________________________________________
c        interpolate picks to velocity grid spacing. 
C__________________________________________________________________
         call interph(xpick,zpick,ztopo,npicks,nxgrid,xvo,dxgrid)    
C__________________________________________________________________
c        store in trace headers.                     
C__________________________________________________________________
         do 70000 ix=0,nxgrid
            GrpElv =-ztopo(ix)
            call savew2(slow(-ITRWRD,ix), ifmt_GrpElv, l_GrpElv,
     :           ln_GrpElv, GrpElv, 1)
70000    continue
      endif
      if(.not. sometopography) then
C__________________________________________________________________
c        degenerate topography. set to top of the model.
C__________________________________________________________________
         do 71000 ix=0,nxgrid
            ztopo(ix)=zmin
            GrpElv =-ztopo(ix)
            call savew2(slow(-ITRWRD,ix), ifmt_GrpElv, l_GrpElv,
     :           ln_GrpElv, GrpElv, 1)
71000    continue
      endif
      if(rdtopo .and. verbose) then
         write(lerr,'(/,a,/)') 'topography supplied by xsd pick file'
         write(lerr,*) 'npicks = ',npicks
         write(lerr,'(3a12)') 'ipick','xpick','zpick'                 
         write(lerr,'(i12,2f12.3)') (ipick,xpick(ipick),zpick(ipick),
     1                             ipick=1,npicks)
      endif
      if(topo) then
         write(lerr,'(/,a,/)') 'topography applied to the model'
         if(verbose) then
            write(lerr,'(2a16,a25,a16)') 'ix','x position',
     1               'z (depth below sea level)','nearest z node'                 
            write(lerr,'(i16,2f16.3,9x,i16)') 
     1                 (ix,xvo+ix*dxgrid,ztopo(ix),
     1                  nint((ztopo(ix)-zmin)/dzgrid),ix=0,nxgrid)
         endif
      
C__________________________________________________________________
c        check for degenerate case where topography is flat and lies
c        along the top of the model.
C__________________________________________________________________
         topo=.false.
         do 80000 ix=0,nxgrid
          if(nint((ztopo(ix)-zmin)/dzgrid) .ne. 0) then
             topo=.true.
          endif
80000    continue
         if(.not. topo) write(lerr,*) 'degenerate topography lies'
     1     //' along top of the velocity model. topography turned off'
      endif
C
      return
99994 write(lerr,*) 'error in routine rdv! error/end of file'
     1             //' encountered in reading xsd topo file picks'
      write(lerr,*) 'check file spelling and completeness!'
      close(lerr)
      call exitfu(20002)
      end 
