C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
       program VSM    
C
C      smooth a gridded velocity v(x,z)
c      Revised:    January 31, 1996        Marfurt/Thornton
C      Corrected an error in the interpolation routine interph.F
C***********************************************************************
      parameter (maxs=0 000 002)                      
      parameter (PI=3.1415926)
      dimension s(maxs)       
      pointer   (pntrs,s)   
C
      integer   argis
      integer   vheader(6000)
      integer   ifmt_GrpElv, l_GrpElv, ln_GrpElv
      logical   query,verbose
      logical   radial,rectangular,notaper
      logical   topo,rdtopo,D3,first
      integer   stderr
      real      cputim(20),waltim(20)
C
      character*80 file_in,file_out,file_topo
      character*3   name
c

#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
#include <save_defs.h>

      data name     /'VSM'/
      data         undefined/1.e+32/
      data         lutopo/61/
      data         first /.true./
c
      call timstr(vtot,wtot)
      stderr=ler
c____________________________________________________________________
c     get online help if necessary
c____________________________________________________________________
      query=(argis('-?').gt.0 .or. argis('-h').gt.0)
      if(query) then
         call help()
         call exitfu(0)
      endif
c
      call openpr(lupprt,lerr,name,jerr)
c____________________________________________________________________
c     read input/output file names
c____________________________________________________________________
      call argstr('-N',file_in,' ',' ')
      call argstr('-O',file_out,' ',' ')
      call argstr('-T',file_topo,' ',' ')
C***********************************************************************
C     open seismic worktape format files.
c     warning, unit numbers will be changed by getln or lbopen!
C***********************************************************************
      ierror=0
c
      call getln(luin,file_in,'r',0)
      if  (luin .lt. 0)   then
          write(lerr,*) 'vsm error: velocity file -v not '
     1                 //' accessible'
          ierror=ierror+1
      endif
c
      call getln(luout,file_out,'w',1)
      if(file_topo .eq. ' ') then
         rdtopo=.false.
         topo=(argis('-GrpElv') .gt. 0)
         npicks=1
         maxpicks=1
      else
C__________________________________________________________________
c        read in topography info in xsd format.
C__________________________________________________________________
         rdtopo=.true.
         topo=.true.
         open(lutopo,file=file_topo,status='old',err=99992)
         read(lutopo,100,err=99993)recunit,trcunit,smpunit,
     1                             nrec,ntrace,nsamp,
     1                             recoff,trcoff,smpoff,
     3                             nsegments,maxpicks
100      format(6x,f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5,
     1          7x,f12.6,1x,f12.6,1x,f12.6,8x,i5,1x,i5)
         if(nsegments .le. 0 .or. maxpicks .le. 0) then
            write(lerr,*) 'error in topo file!'
            write(lerr,*) 'nsegments = ',nsegments
            write(lerr,*) 'maxpicks  = ',maxpicks
            write(lerr,*) 'probable cause: xsd pick file not saved '
     1                 //' correctly'
            close(lerr)
            call exitfu(10002)
         endif
         read(lutopo,201,err=99993) iseg,icolor,npicks
201      format(10x,i5,6x,20x,10x,i5,9x,i5)
      endif
c
      if(luout .lt. 0)   then
          write(lerr,*) 'vsm error: velocity file -v not '
     1                 //' accessible'
          ierror=ierror+1
      endif
      if(ierror .gt. 0) then
         write(lerr,*) 'program vsm aborted due to command line'//
     1                   'errors'
      endif
C***********************************************************************
C     read in velocity work tape header
C***********************************************************************
      lenvh  = 0
      call rtape(luin,vheader,lenvh)
      call hlhprt(vheader,lenvh,name,4,lerr)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

C***********************************************************************
C     pull input data parameters off the line header.
C***********************************************************************
      status=saver(vheader,'NumTrc',nveltr,LINEHEADER)  
      status=saver(vheader,'NumRec',nvelrec,LINEHEADER)  
      status=saver(vheader,'NumSmp',nz_tape,LINEHEADER)  
      status=saver(vheader,'Dx1000',idx_1000,LINEHEADER)
      status=saver(vheader,'Dz1000',idz_1000,LINEHEADER)

      D3      = (argis('-threed') .gt. 0)           

c____________________________________________________________________
c 3D:    data must be in LI (or DI) order with nveltr traces
c        line. The attribute option is turned off.
c____________________________________________________________________
      IF (D3) THEN

         nxgrid = nveltr-1
         nline = nvelrec
         nattributes = nline

      ELSE
c____________________________________________________________________
c 2D:    single trace records as generated from program 'velin'.
c        assume the record index is the 'x' index.
c____________________________________________________________________
         nline = 1
         if(nveltr .eq. 1) then
            nxgrid=nvelrec-1
            nattributes=1
         else
            nxgrid=nveltr-1
            nattributes=nvelrec
         endif

      ENDIF

      nzgrid   = nz_tape-1
      dxheader = .001*idx_1000
      dzheader = .001*idz_1000
C***********************************************************************
C     read in command line arguements   
C***********************************************************************
      call argr4('-dxv',dxgrid,0.0,0.0)
      if (dxgrid .eq. 0.) dxgrid = dxheader
      call argr4('-dzv',dzgrid,0.0,0.0)  
      if (dzgrid .eq. 0.) dzgrid = dzheader
      call argr4('-rsm',rsm,0.0,0.0)                    
      if (rsm .eq. 0.0) rsm = undefined
      call argr4('-hsm',hsm,0.0,0.0)                    
      if (hsm .eq. 0.0) hsm = undefined
      call argr4('-dsm',dsm,0.0,0.0)                    
      if (dsm .eq. 0.0) dsm = undefined
      call argr4('-xvo',xvo,999999.,999999.)
      if (xvo .eq. 999999.) xvo = undefined
      call argr4('-zvo',zvo,999999.,999999.)
      if (zvo .eq. 999999.) zvo = undefined
      notaper=(argis('-notaper') .gt. 0)
c
      verbose = (argis('-V') .gt. 0)           

c check for extraneous arguments and abort if found to
c catch all manner of user typo's
 
      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

c______________________________________________________________________
c     check command line data.
c______________________________________________________________________
      ierror=0
      if(dxgrid .le. 0. .or. dxgrid .gt. 1000.) then
         write(lerr,*) 'error in input parameters detected in vsm!'
         write(lerr,*) 'velocity worktape increment (-dxv) = ',dxgrid
         write(lerr,*) 'dxheader = ',dxheader                          
         write(lerr,*) 'Dx1000   = ',idx_1000                          
         write(lerr,*) 'check command line and/or line headers!'         
         write(lerr,*)
         ierror=ierror+1
      endif
      if(dzgrid .le. 0. .or. dzgrid .gt. 1000.) then
         write(lerr,*) 'error in input parameters detected in vsm!'
         write(lerr,*) 'velocity worktape increment (-dzv) = ',dzgrid
         write(lerr,*) 'dzheader = ',dzheader                          
         write(lerr,*) 'Dz1000   = ',idz_1000                          
         write(lerr,*) 'check command line and/or line headers!'         
         write(lerr,*)
         ierror=ierror+1
      endif
c
      if(zvo .eq. undefined) then
         if(topo) then
             write(lerr,*) 'error in input parameters detected in vsm!'
             write(lerr,*) 'velocity worktape z origin  (-zvo) '
     1                         //' undefined'
             write(lerr,*) 'must be defined when using -GrpElv or '
     1                   //'-T option'
             write(lerr,*)
             ierror=ierror+1
         else
            zvo=0.
         endif
      endif
c
      if(rdtopo .and. xvo .eq. undefined) then
         write(lerr,*) 'error in input parameters detected in vsm!'
         write(lerr,*) 'velocity worktape x origin  (-xvo) undefined'
         write(lerr,*) 'must be defined when using -T option'
         write(lerr,*)
         ierror=ierror+1
      elseif(xvo .eq. undefined) then
          xvo=0.
      endif
      if(rdtopo .and. trcunit .eq. 1. .and. dxgrid .ne. 1.) then
         write(lerr,*) 'probable error in input xsd topography file!'
         write(lerr,'(a,t40,f12.6)') 'dx of velocity grid',dxgrid
         write(lerr,'(a,t40,f12.6)') 'dx (trcunit) of xsd file'
     1                        //' remains as default',trcunit
         write(lerr,*) 'resave xsd pick file with world coordinates'
     1          //' in trcunit and trcoff that match the velocity grid'
         ierror=ierror+1
      endif
      if(rdtopo .and. smpunit .eq. 1. .and. dzgrid .ne. 1.) then
         write(lerr,*) 'probable error in input  xsd topography file!'
         write(lerr,'(a,t40,f12.6)') 'dz of velocity grid',dxgrid
         write(lerr,'(a,t40,f12.6)') 'dz (smpunit) of xsd file'
     1                        //' remains as default',trcunit
         write(lerr,*) 'resave xsd pick file with world coordinates'
     1          //' in smpunit and smpoff that match the velocity grid'
         ierror=ierror+1
      endif
c
      if(ierror .gt. 0.) then
         write(lerr,*) 'program terminated due to command line errors'
         close(lerr)
         call exitfu(7666)
      endif
      zmin=-zvo
      write(lerr,*) 'nxgrid = ',nxgrid
      write(lerr,*) 'nzgrid = ',nzgrid
      write(lerr,*) 'dxgrid = ',dxgrid
      write(lerr,*) 'dzgrid = ',dzgrid
      write(lerr,*) 'ITRWRD = ',ITRWRD
      if (D3) then
      write(lerr,*) '# lines= ',nattributes
      else
      write(lerr,*) 'nattributes = ',nattributes
      endif
      write(lerr,*) 'zvo    = ',zvo   
      write(lerr,*) 'zmin   = ',zmin  
      write(lerr,*) 'honor velocity discontinuity at topography? ',topo
      if(rsm .ne. undefined) then
         radial=.true. 
         rectangular=.false.
         nxpad=rsm/dxgrid
         nzpad=rsm/dzgrid
      elseif(hsm .ne. undefined .or. dsm .ne. undefined) then
         radial=.false.
         rectangular=.true. 
         if(hsm .eq. undefined) then
            hsm=.1*dxgrid
         endif
         nxpad=hsm/dxgrid
         if(dsm .eq. undefined) then
            dsm=.1*dzgrid
         endif
         nzpad=dsm/dzgrid
      else
         write(lerr,*) 'error in routine VSM'
         write(lerr,*) 'must enter one of the following distances:'
         write(lerr,*) 'radial     smoothing -rsm'
         write(lerr,*) 'horizontal smoothing -hsm'
         write(lerr,*) 'depth      smoothing -dsm'
         close(lerr)
         call  exit(666)
      endif
c      
      write(lerr,*) 'rsm = ',rsm
      write(lerr,*) 'hsm = ',hsm
      write(lerr,*) 'dsm = ',dsm
      write(lerr,*) 'nxpad  = ',nxpad 
      write(lerr,*) 'nzpad  = ',nzpad 
      write(lerr,*) 'taper weights?         ',.not. notaper 
      write(lerr,*) 'rectangular smoothing? ',rectangular
      write(lerr,*) 'radial      smoothing? ',radial           
c__________________________________________________________________
c     look up hardware specific trace header indices.
c     these indices will be the same for all output records.
c__________________________________________________________________
      call savelu('GrpElv',ifmt_GrpElv,l_GrpElv,ln_GrpElv,TRACEHEADER)
C***********************************************************************
C     calculate memory requirements for velocity model processing.
C***********************************************************************
      write(lerr,'(///,80A1)') ('_',I=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
      write(lerr,'(A20,3A10)')'variable name','begin','end','length'
C
      l_free=1
      lenvgrid=(ITRWRD+nzgrid+1)*(nxgrid+1)
      lenvbuf=(nzgrid+1+2*nzpad)*(nxgrid+1+2*nxpad)
      lenwgt=(2*nzpad+1)*(2*nxpad+1)
      call mapmem('vgrid',l_vgrid,l_free,lenvgrid,lerr)
      call mapmem('vbuf',l_vbuf,l_free,lenvbuf,lerr)
      call mapmem('wgt',l_wgt,l_free,lenwgt,lerr)
      call mapmem('wgtx',l_wgtx,l_free,2*nxpad+1,lerr)
      call mapmem('wgtz',l_wgtz,l_free,2*nzpad+1,lerr)
      call mapmem('ztopo',l_ztopo,l_free,nxgrid+1,lerr)
      call mapmem('xpick',l_xpick,l_free,maxpicks,lerr)
      call mapmem('zpick',l_zpick,l_free,maxpicks,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.                      
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for VSM: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(stderr,'(//,a)') 'allocate dynamic memory for VSM: '
      write(stderr,*) 1.e-6*lens,' Mwords'
      write(stderr,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)                   
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'   
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)'program VSM aborted'
         close(lerr)
         call exitfu(101)
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lens       
C_______________________________________________________________________
c     read in the velocity worktape.
c     convert to slowness.
C_______________________________________________________________________
      DO  JR = 1, nline

      call rdv(s(l_vgrid),s(l_ztopo),zmin,topo,
     1     nxgrid,nzgrid,ITRWRD,luin,
     2     ifmt_GrpElv, l_GrpElv, ln_GrpElv,
     3     ifmt_DphInd, l_DphInd, ln_DphInd,
     4     ifmt_LinInd, l_LinInd, ln_LinInd,
     5     s(l_xpick),s(l_zpick),npicks,lutopo,rdtopo,
     6     xvo,dxgrid,zvo,dzgrid,lerr,verbose)
C_______________________________________________________________________
c     smooth velocity worktape.
C_______________________________________________________________________
      call vsmsub(s(l_vgrid),s(l_vbuf),s(l_wgt),ITRWRD,nzgrid,nzpad,
     1            nxgrid,nxpad,dxgrid,dzgrid,rsm,hsm,dsm,
     2            radial,rectangular,s(l_ztopo),zmin,topo,lerr,
     3            s(l_wgtx),s(l_wgtz),notaper,first)
C_______________________________________________________________________
c     for first time into the data...
c     write out the resampled velocity worktape line header.
C_______________________________________________________________________
      IF (first) THEN
         if(topo) then
            status=savew(vheader,'CrwNam','v_topo',LINEHEADER)
         else
            status=savew(vheader,'CrwNam','v_rect',LINEHEADER)
         endif
         idz_1000=nint(1000.*dzgrid)
         idx_1000=nint(1000.*dxgrid)
         write(0,*) 'dxgrid,idx_1000 ',dxgrid,idx_1000
         write(0,*) 'dzgrid,idz_1000 ',dzgrid,idz_1000
         status=savew(vheader,'Dz1000',idz_1000,LINEHEADER)
         status=savew(vheader,'Dx1000',idx_1000,LINEHEADER)
         status=savew(vheader,'MxRSEL',nint(zvo),LINEHEADER)
         status=savew(vheader,'NumTrc',nxgrid+1,LINEHEADER)  
         status=savew(vheader,'NumRec',nattributes,LINEHEADER)  
         call savhlh(vheader,lenvh,lbyout)
         call wrtape(luout,vheader,lbyout)
         first = .false.
      ENDIF
C_______________________________________________________________________
c     write out the smoothed velocity.              
C_______________________________________________________________________
      nbytes_out=(ITRWRD+nzgrid+1)*szsmpd
      call wrsis(s(l_vgrid),nzgrid+1,0,nxgrid,ITRWRD,luout,nbytes_out)

      ENDDO

      IF (.not.D3) THEN

         do 50000 jattribute=2,nattributes
C_______________________________________________________________________
c      copy additional attributes that will NOT be smoothed 
c      (e.g. epsilon, delta, theta, vs/vp) from the input to the 
c      output file.
C_______________________________________________________________________
          call copyrec(s(l_vgrid),luin,luout,nxgrid,nzgrid,ITRWRD,
     1                 jattribute,lerr,nbytes_out)
50000    continue
      ENDIF

      call lbclos(luout)
c
      call timend(cputim(20),vtot,V2,waltim(20),wtot,W2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'total',cputim(20),waltim(20)

C
      write(lerr,*) 'Normal completion of routine VSM'
      write(stderr,*) 'Normal completion of routine VSM'
      close(lerr)
      call exitfu(0)
c
99992 write(lerr,*) 'Error in opening xsd format topo pick file!'
      write(lerr,*) 'lutopo = ',lutopo
      write(lerr,*) 'file_topo = ',file_topo
      close(lerr)
      call exitfu(5001)
99993 write(lerr,*) 'Error in reading xsd format topo pick file!'
      write(lerr,*) 'lutopo = ',lutopo
      write(lerr,*) 'file_topo = ',file_topo
      close(lerr)
      call exitfu(5002)
c
      end
      subroutine  help
#include <f77/iounit.h>
      write(LER,*)' '
      write(LER,*)'Command Line Arguments for vsm: '
      write(LER,*)'Velocity sampling smoothing program for mbs'   
      write(LER,*)' '
      write(LER,*)'Input....................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N file_in] (stdin)     :'
      write(ler,*)'                Input velocity model'
      write(LER,*)'-O [file_out] (stdout)      :'
      write(ler,*)'                Output smoothed velocity model'  
      write(LER,*)'-T [file_topo] (optional)    :'
      write(ler,*)'      input xsd format topography file saved in '
     1                //'m or ft'
      write(LER,*)'      (honor velocity discontinuity at topography)' 
c
      write(LER,*)'-dxv[dxgrid] -- velocity tape x increment'//
     1                           ' (default in line header dx1000)'
      write(LER,*)'-dzv[dzgrid] -- velocity tape z increment'//
     1                           ' (default in line header dz1000)'
      write(ler,*) 
      write(ler,*)'must enter either -rsm option '//
     1             ' or -hsm and -dsm options'
      write(ler,*)
      write(LER,*)'-rsm[rsm]    -- radial smoothing dist in m or ft'
      write(LER,*)'-hsm[hsm]    -- horizontal smoothing dist '//
     1                                   'in m or ft'                
      write(LER,*)'-dsm[dsm]    -- depth  smoothing dist in m or ft' 
      write(LER,*)'-GrpElv      -- honor velocity discontinuity at'
     1                             //' topographic surface'
      write(ler,*)'                (values in trace header GrpElv)'
      write(LER,*)'-xvo[xvo]    -- x position of first sample on '//
     1                           ' velocity work tape'
      write(ler,*)'                (no default if topographic'
     1                            //' discontinuity)'
      write(LER,*)'-zvo[zvo]    -- z position of first sample on '//
     1                           ' velocity work tape'
      write(ler,*)'                (no default if topographic'
     1                            //' discontinuity)'
      write(ler,*)'                (z positive up) (no default)'
      write(LER,*)'-notaper     -- if present, do not taper weights.'
      write(LER,*)'-threed      -- input data is 3D volume'
      write(LER,*)'-V           -- verbose output'               
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'        vsm -N[] -O[] -T[]'
      write(ler,*)'            -dxv[] -dzv[] -rsm[] -hsm[]'
      write(ler,*)'            -dsm[] -xvo[] -zvo[] '
      write(ler,*)'            -[GrpElv -notaper -threed -V]'
      write(LER,*)' '

      return
      end
