C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      real function mdianm (luprt , nmix  , ntwind, ntlive, b     ,
     *                      livetr, itotal)
c
c     implement the median algorithm for finding the representative
c     value of ntwind points in vector b, some of which may correspond
c     to samples from dead traces.
c
      logical livetr(ntwind), oddntl
      real b(ntwind)
      data iprint/0/
c
c     print the function name and window size
c
      if (iprint .eq. 0) then
         iprint = 1
         itotal = 0
         nmd2 = nmix/2
         nmd2p1 = nmd2 + 1
         write (luprt,1200) nmix, nmd2, nmd2p1
 1200    format(/' MDIANM:  nmix = ',i2,3x,'nmix/2 = ',i2,3x,
     *          '(nmix/2)+1 = ',i2/)
      endif
c
c     set mdianm to zero if ntwind < 1 or ntwind > nmix or ntlive < 1
c
      if ((ntwind .lt. 1) .or. (ntwind .gt. nmix) .or.
     *    (ntlive .lt. 1)) then
         mdianm = 0.0
         return
      endif
c
c     set mdianm to b(ntwind) if ntwind = 1.
c
c
      if (ntwind .eq. 1) then
         mdianm = b(ntwind)
         itotal = itotal + 1
         return
      endif
c
c     move any elements of b corresponding to dead traces
c     to the end of b.  it is assumed that at least one
c     trace is live.
c
      if (ntlive .lt. ntwind) then
         do 120 k = 1, ntlive
            if (.not. livetr(k)) then
               do 100 l = ntwind, k+1, -1
                  if (livetr(l)) then
                     b(k) = b(l)
                     b(l) = 0.0
                     livetr(k) = .true.
                     livetr(l) = .false.
                     go to 120
                  endif
  100          continue
            endif
  120    continue
      endif
c
c     sort the ntlive elements of b
c
      call sortqk (ntlive, b)
c
c     find center index of array b (if ntlive is odd, nd2p1 is center;
c     if ntlive is even, nd2 and nd2p1 are the center 2 values)
c
      nd2 = ntlive/2
      nd2p1 = nd2 + 1
c
c     find the median value of the data in b and update the data
c     value count
c
      oddntl = mod(ntlive,2) .eq. 1
      if (oddntl) then
         mdianm = b(nd2p1)
       else
         mdianm = 0.5*(b(nd2) + b(nd2p1))
      endif
      itotal = itotal + 1
      return
      end
