C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c      program vsmxae
c
c     Changes:
C
C     Sept/97
c            added logic to allow -dff0 application inside XIKP
c     Garossino
c
c     Nov/95 
c            changed array sizes to allow really long traces 
c     Garossino
c
#include <localsys.h>
#include <save_defs.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
c
      character*3 system
c
#include <f77/iounit.h>

c set up maximum data constraint parameters

      parameter (mxnspt = 2*SZLNHD, mxnmix = 101)
      parameter (mxabuf = mxnspt*mxnmix)
      parameter (mxdead = 200)
      parameter (mxhbuf = itrwrd*mxnmix)

c dynamic memory allocation variables

      integer dthbuf, itrh

      real a 

      pointer (wkitrh, itrh(1))
      pointer (wkdthbuf, dthbuf(1))
      pointer (wka, a(1))

c static variables

      integer lnarr1(2), lnarr2(2), lnarr3(7), lnarr4(2)
      integer ix(ithwp1), ixdead(ithwp1)
      integer nlh(2*SZLNHD), nlh2(2*SZLNHD)
      integer deadpt(mxdead), pipe

      real rx(mxnspt), rxdead(mxnspt)
      real b(mxnmix), c(mxnspt), cdiff(mxnspt)

      character arr1(2)*35, arr2(2)*30, arr3(7)*35, arr4(2)*29
      character icard*80, cardid*4
      character*255 ntap, otap1, otap2, cfile

      logical lvtrsv(mxnmix), livetr(mxnmix), condst
      logical verbos, dvntp, dvotp1, dvotp2, heap
      logical ikp

c functions

      real alftmm, modtmm, dwmtmm, rngtmm, dwrtmm, asrtmm, mdianm

      equivalence (rx(1),ix(ithwp1))
      equivalence (rxdead(1),ixdead(ithwp1))

c initialize variables

      data system    /'CR2'/
      data cardid    /'VSMX'/
      data arr1(1)   /'VSMX:  (trace sequential by line)  '/
      data arr1(2)   /'VSMX:  (trace sequential by record)'/
      data lnarr1    /33,35/
      data arr2(1)   /'  (constant depth option)     '/
      data arr2(2)   /'  (constant live trace option)'/
      data lnarr2    /25,30/
      data arr3(1)   /'  (median)                         '/
      data arr3(2)   /'  (alpha trimmed mean)             '/
      data arr3(3)   /'  (range trimmed mean)             '/
      data arr3(4)   /'  (double window rng. trim. mean)  '/
      data arr3(5)   /'  (asymmetric range trimmed mean)  '/
      data arr3(6)   /'  (modified trimmed mean)          '/
      data arr3(7)   /'  (double window mod. trim. mean)  '/
      data lnarr3    /10,22,22,33,33,25,33/
      data arr4(1)   /'  (output mixed data)        '/
      data arr4(2)   /'  (output input - mixed data)'/
      data lnarr4    /21,29/
      data pipe /3/

c start timing, total program

      call secon1 (cputo0, wallo0)

c set up file to receive program run information

      call opnlst (LUPRT, LUER, LUPPRT, cardid)

c print program name and version

      write (luprt,1000)
 1000 format(//' Program vsmx'///)
c
c     read data card, interpret card parameters, default or check for
c     unreasonable card parameters.
c
      call rdparm (luso  , luprt , lucard, cardid, mxnmix, name  ,
     *             ntap  , otap1 , otap2 , cfile , mode  , ialgor,
     *             nmix  , lmix  , range , idiff , condst, icard ,
     *             ikp, verbos)
c
c     open input tape, and check input tape requirements.

      if (ntap .ne. ' ') then
c
c        open input for data from a file
c
         call lbopen (luntap, ntap  , 'r')
         dvntp = .true.
       else
c
c        open input for data from a pipe
c
         luntap = 0
         dvntp = .true.
      endif
c
c     check for proper input unit number
c
      if (luntap .lt. 0) then
         write (luprt,1020) luntap
 1020    format(/' -Could not open unit ',i3,' for input.'/
     *          ' -Execution terminated'//)
         stop 1020
      endif
c
c     read input line header and check input tape requirements
c
      lbytes = 0
      call rtape (luntap, nlh, lbytes)
c
c     check for successful read
c
      if (lbytes .eq. 0) then
         write (luprt,1100)
 1100    format (' -EOF encountered attempting to read input tape'/
     *           ' -Execution terminated')
         stop 1100
      endif
c
c     define input data set parameters:
c         number of traces/record, records, samples/trace, data format
c

      call saver (nlh, 'NumTrc', ntpr  , linhed)
      call saver (nlh, 'NumRec', nrecs , linhed)
      call saver (nlh, 'NumSmp', nspt  , linhed)
      call saver (nlh, 'Format', lhform, linhed)

      write (luprt,*) 'ntpr,nrecs,nspt,lhform=',ntpr,nrecs,nspt,lhform

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('InTrCn',ifmt_InTrCn,l_InTrCn,ln_InTrCn,TRACEHEADER)

c
c     check that input data trace length is with program limitation
c
      if (nspt .gt. mxnspt) then
          write (luprt,1400) mxnspt
 1400     format (' -No. of samples/trace on input tape is greater',
     *            ' than ',i5/' -Execution terminated')
          stop 1400
      endif
c
c     prepare array for hlh, call hlh, and call accounting routine.
c
      write (luprt,1500)
 1500 format(///)

      call hlhprt (nlh, lbytes, arr1(mode), lnarr1(mode), luprt)
      if (condst) then
         indx = 1
       else
         indx = 2
      endif

      call hlhprt (nlh, lbytes, arr2(indx), lnarr2(indx), luprt)
      call hlhprt (nlh, lbytes, arr3(ialgor), lnarr3(ialgor), luprt)

      if (idiff .eq. 0) then
         l2byts = lbytes
         call move (1, nlh2, nlh, l2byts)
         call hlhprt  (nlh , lbytes, arr4(1), lnarr4(1), luprt)
         call hlhprt  (nlh2, l2byts, arr4(2), lnarr4(2), luprt)
       else if (idiff .eq. 1) then
         call hlhprt  (nlh , lbytes, arr4(1), lnarr4(1), luprt)
       else if (idiff .eq. 2) then
         call hlhprt  (nlh , lbytes, arr4(2), lnarr4(2), luprt)
      endif

      write (luprt,1500)
      chg = 1.0
      call nacct (name, nlh, chg)
c
c     depending on value of 'mode', calculate number of panels
c     and number of traces/panel
c
      if (mode .eq. 1) then
          ntrpp = nrecs*ntpr
          npanls = 1
        elseif (mode .eq. 2) then
          ntrpp = ntpr
          npanls = nrecs
      endif
c
c     mixing window width must not be larger than the panel size
c
      if (nmix .gt. ntrpp) then
          write (luprt,1600) nmix, ntrpp
 1600     format (' -No. of traces in mixing window = ',i2,
     *            ' is greater than the no. of traces to be mixed',
     *            ' per panel = ',i2/' -Execution terminated')
          stop 1600
      endif
c
c     compute parameter values
c
      nedge = nmix/2
      nmiddl = nedge + 1
      noprpp = ntrpp + nedge
      mworda = (nmix - 1)*nspt
      mwordi = (nmix - 1)*itrwrd
      mbytes = iszbyt*nspt
      nbytes = mbytes + iszbyt*itrwrd

      heap = .true.
      itemi = ntpr * ITRWRD
      items = ntpr * nspt * SZSMPD

      ierr = 0
      call galloc (wkitrh, itemi, ier, iab)
      ierr = ierr + ier
      call galloc (wkdthbuf, itemi, ierr, iab)
      ierr = ierr + ier
      call galloc (wka, items, ierr, iab)
      ierr = ierr + ier

      if (ierr .ne. 0) heap = .false.

      if (.not. heap) then
         write(luprt,*)' '
         write(luprt,*)'Unable to allocate workspace:'
         write(luprt,*) itemi,'  bytes'
         write(luprt,*) itemi,'  bytes'
         write(luprt,*) items,'  bytes'
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemi,'  bytes'
         write(LER ,*) itemi,'  bytes'
         write(LER ,*) items,'  bytes'
         go to 999
      else
         write(luprt,*)' '
         write(luprt,*)'Allocating workspace:'
         write(luprt,*) itemi,'  bytes'
         write(luprt,*) itemi,'  bytes'
         write(luprt,*) items,'  bytes'
      endif
c
c     zero the data part of the dead trace vector
c
      call vclr (rxdead, 1, nspt)
c
c     open output tape(s), and write updated header to output tape(s).
c

      IF (ikp) then

C OTAP1 LOGIC: this is strange logic...for some reason the original
c              programmer did not want to use getln().  Well in the
c              spirit of minimal changes I will work with what is here
c Garossino

         if (otap1 .ne. ' ') then

c open output for data to a file

            call lbopen (luotp1, otap1, 'w')
            dvotp1 = .true.
         else

c open output luotp1 for data to a pipe

            luotp1 = 1
            dvotp1 = .true.
         endif

c check for proper output unit number for luotp1

         if (luotp1 .lt. 0) then
            write (luprt,1620) luotp1
            stop
         endif

c save hlh and write out lineheader

         call savhlh (nlh, lbytes, lbyout)
         call wrtape (luotp1, nlh, lbyout)


         if (idiff .eq. 0) then

c open socket for output inside ikp, pipe is initialized as 3 and is 
c associate with lu 3 inside ikp  DO NOT CHANGE IT...Garossino

            call sisfdfit (luotp2, pipe)
            dvotp2 = .true.

            if (luotp2 .lt. 0) then
               write (luprt,1660) luotp2
               stop 
            endif

c write out lineheader to luotp2

            call wrtape (luotp2, nlh2, l2byts)
         endif

      ELSE

c this is the original program logic that still works outside 
c of ikp

         if (otap1 .ne. ' ') then

c open output for data to a file

            call lbopen (luotp1, otap1, 'w')
            dvotp1 = .true.
         else

c open output luotp1 for data to a pipe

            luotp1 = 1
            dvotp1 = .true.
         endif

c check for proper output unit number for luotp1

         if (luotp1 .lt. 0) then
            write (luprt,1620) luotp1
 1620       format(/' -Could not open unit ',i3,' for output.'/
     *           /' -Execution terminated'//)
            stop 1620
         endif

         call savhlh (nlh, lbytes, lbyout)
         call wrtape (luotp1, nlh, lbyout)
         if (idiff .eq. 0) then
            if (otap2 .ne. ' ') then

c open output for data to a file

               call lbopen (luotp2, otap2, 'w')
               dvotp2 = .true.
            else
               if (otap1 .eq. ' ') then

c cannot also open luotp2 to a pipe.  error exit.

                  write (luprt,1640)
 1640             format(/' -Cannot open luotp2 for pipe output.'/
     *                 ' -luotp1 already opened for pipe output.'/
     *                 ' -Execution terminated'//)
                  stop 1640
               else

c open output luotp2 for data to a pipe

                  luotp2 = 1
                  dvotp2 = .true.
               endif
            endif

c check for proper output unit number for luotp2

            if (luotp2 .lt. 0) then
               write (luprt,1660) luotp2
 1660          format(/' -Could not open unit ',i3,' for output.'/
     *              ' -Execution terminated'//)
               stop 1660
            endif
            call wrtape (luotp2, nlh2, l2byts)
         endif

      ENDIF

c
c     perform mixing.  start loop over the number of panels.
c       number of panels is equal to the number of records
c       for the sequential-by-record mode and is equal to one
c       for the sequential-by-line mode.
c
      do 440 np = 1, npanls
      ntwind = 0
      kdead = 0
      kdmax1 = 0
      kdmax2 = 0
c
c     start loop over the number of operations per panel.
c       the number of operations per panel is equal
c       to the sum of the no. of traces per panel plus
c       half of (number of traces in mixing window minus one).
c
      do 400 nopr = 1, noprpp
c
c     if mixing window is not rolling off end of panel,
c     read a trace from the input tape and put data portion
c     of this trace into array a and header portion into
c     array itrh.  arrays a and itrh are conceptually
c     two-dimensional arrays for the traces in the mixing
c     window but for efficiency are actually one-dimensional
c     arrays.
c
      if (nopr .le. ntrpp) then
c
c        read a trace from the input
c
         call saver2(ix,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               lstrec , TRACEHEADER)
         ibytes = 0
         call rtape (luntap, ix, ibytes)
c
c        check for successful read
c
         if (ibytes .eq. 0) then
             write (luprt,1800) lstrec, nrecs
 1800        format (//' -EOF encountered before expected at record ',
     *               i5/' -Line header predicted ',i5,' records')
             go to 500
         endif
         if (nopr .le. (nmix+kdmax1)) then
c
c           at start of panel, load the trace and its header
c           into arrays a and itrh.  ntwind will increase by
c           1 each operation until ntwind = nmix.
c
            if (condst) then
c
c              constant depth option of processing:
c              store data in data buffer a and trace header
c              in trace header buffer itrh.
c
               ntwind = ntwind + 1
               call vmov (rx, 1, a(((ntwind-1)*nspt)+1)     , 1, nspt)
               call vmov (ix, 1, itrh(((ntwind-1)*itrwrd)+1), 1, itrwrd)
             else
c
c              constant trace option of processing:
c              if new trace is dead, store the header in dead
c              trace buffer, update dead trace buffer pointer,
c              and go read another trace.  if new trace is live,
c              store data in data buffer a and trace header in
c              trace header buffer itrh.
c
               call saver2(ix,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istatc , TRACEHEADER)
               if (istatc .eq. 30000) then
                  kdead = kdead + 1
                  ipt = (kdead - 1) * ITRWRD
                  call vmov (ix, 1, dthbuf(ipt+1), 1, itrwrd)
                  call saver2(ix,ifmt_InTrCn,l_InTrCn, ln_InTrCn,
     1                        deadpt(kdead) , TRACEHEADER)
                  kdmax1 = kdmax1 + 1
                  if (nopr .le. (nedge+kdmax2)) kdmax2 = kdmax2 + 1
                  go to 400
                else
                  ntwind = ntwind + 1
                  call vmov (rx, 1, a(((ntwind-1)*nspt)+1), 1, nspt)
                  call vmov (ix, 1, itrh(((ntwind-1)*itrwrd)+1), 1, 
     *                       itrwrd)
               endif
            endif
          else
c
c           mixing window fully immersed in data:
c           move data in arrays a and itrh down one trace
c           position and load new trace and header into the
c           ends of arrays a and itrh.
c
            if (condst) then
c
c              constant depth option of processing:
c              store data in data buffer a and trace header
c              in trace header buffer itrh.
c
               call vmov (a(nspt+1)   , 1, a(1)   , 1, mworda)
               call vmov (itrh(ithwp1), 1, itrh(1), 1, mwordi)
               call vmov (rx, 1, a(mworda+1)   , 1, nspt)
               call vmov (ix, 1, itrh(mwordi+1), 1, itrwrd)
             else
c
c              constant trace option of processing:
c              if new trace is dead, store the header in dead
c              trace buffer, update dead trace buffer pointer,
c              and go read another trace.  if new trace is live,
c              store data in data buffer a and trace header in
c              trace header buffer itrh, moving down existing data.
c
               call saver2(ix,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istatc , TRACEHEADER)
               if (istatc .eq. 30000) then
                  kdead = kdead + 1
                  ipt = (kdead - 1) * ITRWRD
                  call vmov (ix, 1, dthbuf(ipt+1), 1, itrwrd)
                  call saver2(ix,ifmt_InTrCn,l_InTrCn, ln_InTrCn,
     1                        deadpt(kdead) , TRACEHEADER)
                  go to 400
                else
                  call vmov (a(nspt+1)   , 1, a(1)   , 1, mworda)
                  call vmov (itrh(ithwp1), 1, itrh(1), 1, mwordi)
                  call vmov (rx, 1, a(mworda+1)   , 1, nspt)
                  call vmov (ix, 1, itrh(mwordi+1), 1, itrwrd)
               endif
            endif
         endif
       else
c
c        mixing window is rolling off end of panel, slide
c        traces in window matrices a and itrh one trace.
c
         ntwind = ntwind - 1
         nworda = ntwind*nspt
         nwordi = ntwind*itrwrd
         call vmov (a(nspt+1)   , 1, a(1)   , 1, nworda)
         call vmov (itrh(ithwp1), 1, itrh(1), 1, nwordi)
      endif
c
c     if mixing window is at least halfway onto panel
c     of traces to be mixed, compute mix.  first,
c     determine location of input trace header (in array
c     itrh) for next output trace and put into output trace
c     array.  then determine no. of live traces and their
c     positions in mixing window (array a).  compute
c     mix of live traces sample-by-sample.  place mix
c     into array for output trace.
c
      if (nopr .gt. (nedge+kdmax2)) then
         if (nopr .lt. (nmix+kdmax1)) then
            nhdpnt = nopr - nedge - kdmax1
          else
            nhdpnt = nmiddl
         endif
         call vmov (itrh(((nhdpnt-1)*itrwrd)+1), 1, ix, 1, itrwrd)
c
c        dead trace output if in constant distance mode
c
         if (condst) then
c
c           constant distance mode:
c               check to see if input trace corresponding to
c               current output trace position is dead.  if so,
c               set data to zero and skip to tape output section.
c
            call saver2(ix,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  istatc , TRACEHEADER)
            if (istatc .eq. 30000) then
c
c              input trace in center of mixing window is dead,
c              load the output buffer with zeros and output a
c              dead trace.
c
               call vclr (rx, 1, nspt)
               go to 300
            endif
         endif
c
c        count live traces and indicate in vector lvtrsv which
c        traces are live.  this data will not change for the
c        current contents of vectors a and itrh.
c
         ntlive = 0
         do 200 j = 1, ntwind
            lvtrsv(j) = .false.
            call saver2(itrh(((j-1)*itrwrd)+1),ifmt_StaCor,l_StaCor,
     1                  ln_StaCor, istatc , TRACEHEADER)
            if (istatc .eq. 30000) go to 200
            ntlive = ntlive + 1
            lvtrsv(j) = .true.
  200    continue
c
c        for each time value, collect the data values from
c        array a and store in array b.  call the mixing
c        function to produce output trace c.  the live trace
c        indicator must be reloaded into vector livetr for
c        each new time value (k) because the functions change
c        the contents of livetr.
c
         do 240 k = 1, nspt
            do 220 j = 1, ntwind
               jm1nsp = (j - 1)*nspt
               b(j) = a(k+jm1nsp)
               livetr(j) = lvtrsv(j)
  220       continue
            if (ialgor .eq. 1) then
               c(k) = mdianm (luprt , nmix  , ntwind, ntlive, b     ,
     *                        livetr, itotal)
             elseif (ialgor .eq. 2) then
               c(k) = alftmm (luprt , range , nmix  , ntwind, ntlive,
     *                        b     , livetr, itotal)
             elseif (ialgor .eq. 3) then
               c(k) = rngtmm (luprt , range , nmix  , ntwind, ntlive,
     *                        b     , livetr, itotal)
             elseif (ialgor .eq. 4) then
               c(k) = dwrtmm (luprt , range , nmix  , lmix  , ntwind,
     *                        ntlive, b     , livetr, itotal)
             elseif (ialgor .eq. 5) then
               c(k) = asrtmm (luprt , range , nmix  , ntwind, ntlive,
     *                        b     , livetr, itotal)
             elseif (ialgor .eq. 6) then
               c(k) = modtmm (luprt , range , nmix  , ntwind, ntlive,
     *                        b     , livetr, itotal)
             elseif (ialgor .eq. 7) then
               c(k) = dwmtmm (luprt , range , nmix  , lmix  , ntwind,
     *                        ntlive, b     , livetr, itotal)
            endif
  240    continue
c
c        subtract the filtered data from the input data if
c        idiff = 0 or 2
c
         if (idiff .ne. 1) then
            ioffst = (nhdpnt - 1)*nspt
            do 250 k = 1, nspt
               cdiff(k) = a(ioffst+k) - c(k)
  250       continue
         endif
c
c        write output trace to output tape(s), print message
c        if last trace of record.
c
  300    if (condst) then
c
c           constant distance option:
c               write current output trace to tape(s).
c
            if (idiff .le. 1) then
               call vmov (c, 1, rx, 1, nspt)
               call wrtape (luotp1, ix, nbytes)
            endif
            if (idiff .ne. 1) then
               call vmov (cdiff, 1, rx, 1, nspt)
               if (idiff .eq. 2) then
                  call wrtape (luotp1, ix, nbytes)
                else
                  call wrtape (luotp2, ix, nbytes)
               endif
            endif
            if (verbos) then
               call saver2(ix,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irtemp , TRACEHEADER)
               call saver2(ix,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     ittemp , TRACEHEADER)

#ifdef IODEBUG
               call saver2(ix,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istemp , TRACEHEADER)
               call saver2(ix,ifmt_InTrCn,l_InTrCn, ln_InTrCn,
     1                     ictemp , TRACEHEADER)

               write (luprt,3000) nopr, ntwind, irtemp, ittemp,
     *                              istemp, kdead, ictemp
 3000          format(1x,'3000: ',i3,2x,i3,2x,'rec=',i4,2x,'trc=',
     *               i4,2x,'(125)=',i6,2x,'kdead=',i3,2x,'(40)=',i5)
#endif

               if (ittemp .eq. ntpr) write (luprt,3200) irtemp
 3200          format (' processed record ',i5)
            endif
          else
c
c           constant trace option:
c               before writing output trace, it must be determined
c               if some dead traces must be output first.
c               this is done by checking the incremental trace
c               counter (trace header 4 byte word 20) of the
c               dead trace headers versus that of the current
c               output trace header and writing a dead trace for
c               every trace in the dead trace header buffer having
c               a smaller incremental trace counter.
c
            if (kdead .gt. 0) then
c
c              there are dead traces in buffer.  check to see
c              if some must be written to tape.
c
               kdout = 0
               do 340 ik = 1, kdead
                  call saver2(ix,ifmt_InTrCn,l_InTrCn, ln_InTrCn,
     1                        icount , TRACEHEADER)
                  if (deadpt(ik) .lt. icount) then
                     kdout = kdout + 1
                     ipt = (ik - 1) * ITRWRD
                     call vmov (dthbuf(ipt+1), 1, ixdead, 1, itrwrd)
                     call wrtape (luotp1, ixdead, nbytes)
                     if (idiff .eq. 0) then
                        call wrtape (luotp2, ixdead, nbytes)
                     endif
                     if (verbos) then
                        call saver2(ix,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                              irtemp , TRACEHEADER)
                        call saver2(ix,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                              ittemp , TRACEHEADER)

#ifdef IODEBUG
                        call saver2(ix,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                              istemp , TRACEHEADER)
                        call saver2(ix,ifmt_InTrCn,l_InTrCn, ln_InTrCn,
     1                              ictemp , TRACEHEADER)
                        write (luprt,3300) nopr, ntwind,
     *                  irtemp, ittemp, istemp, kdead, ictemp
 3300                   format(1x,'3300: ',i3,2x,i3,2x,'rec=',i4,2x,
     *                         'trc=',i4,2x,'(125)=',i6,2x,'kdead=',
     *                         i3,2x,'(40)=',i5)
#endif

                        if (ittemp .eq. ntpr) write (luprt,3200) irtemp
                     endif
                  endif
  340          continue
c
c              update the dead trace buffer.
c
               if (kdout .gt. 0) then
                  kdead = kdead - kdout
                  call vmov (deadpt(kdout+1), 1, deadpt(1), 1, kdead)
                  ipt1 = kdout * ITRWRD
                  ipt2 = (kdout-1) * ITRWRD
                  call vmov (dthbuf(ipt1+1), 1, dthbuf(ipt2+1), 1, 
     *                       kdead*itrwrd)
               endif
            endif
c
c           write the live trace under the constant trace option.
c
            if (idiff .le. 1) then
               call vmov (c, 1, rx, 1, nspt)
               call wrtape (luotp1, ix, nbytes)
            endif
            if (idiff .ne. 1) then
               call vmov (cdiff, 1, rx, 1, nspt)
               if (idiff .eq. 2) then
                  call wrtape (luotp1, ix, nbytes)
                else
                  call wrtape (luotp2, ix, nbytes)
               endif
            endif
            if (verbos) then
               call saver2(ix,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irtemp , TRACEHEADER)
               call saver2(ix,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     ittemp , TRACEHEADER)

#ifdef IODEBUG
               call saver2(ix,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istemp , TRACEHEADER)
               call saver2(ix,ifmt_InTrCn,l_InTrCn, ln_InTrCn,
     1                     ictemp , TRACEHEADER)
               write (luprt,3900) nopr, ntwind, irtemp, ittemp,
     *                              istemp, kdead, ictemp
 3900          format(1x,'3900: ',i3,2x,i3,2x,'rec=',i4,2x,'trc=',
     *               i4,2x,'(125)=',i6,2x,'kdead=',i3,2x,'(40)=',i5)
#endif

               if (ittemp .eq. ntpr) write (luprt,3200) irtemp
            endif
         endif
      endif
  400 continue
c
c     processing of this panel is complete unless in constant
c     trace mode and dead trace buffer contains headers for dead
c     traces at the end of the panel.
c
      if ((.not. condst) .and. (kdead .gt. 0)) then
         do 420 ik = 1, kdead
            ipt = (ik-1) *ITRWRD
            call vmov (dthbuf(ipt+1), 1, ixdead, 1, itrwrd)
            call wrtape (luotp1, ixdead, nbytes)
            if (idiff .eq. 0) then

#ifdef IODEBUG
               call saver2(ixdead,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istemp , TRACEHEADER)
               call saver2(ixdead,ifmt_InTrCn,l_InTrCn, ln_InTrCn,
     1                     ictemp , TRACEHEADER)
               write (luprt,4100) nopr, ntwind, irtemp, ittemp,
     *                              istemp, kdead, ictemp
 4100          format(1x,'4100: ',i3,2x,i3,2x,'rec=',i4,2x,'trc=',
     *               i4,2x,'(125)=',i6,2x,'kdead=',i3,2x,'(40)=',i5)
#endif

               call wrtape (luotp2, ixdead, nbytes)
            endif
            if (verbos) then
               call saver2(ixdead,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irtemp , TRACEHEADER)
               call saver2(ixdead,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     ittemp , TRACEHEADER)

#ifdef IODEBUG
               call saver2(ixdead,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istemp , TRACEHEADER)
               call saver2(ixdead,ifmt_InTrCn,l_InTrCn, ln_InTrCn,
     1                     ictemp , TRACEHEADER)
               write (luprt,4150) nopr, ntwind, irtemp, ittemp,
     *                              istemp, kdead, ictemp
 4150          format(1x,'4150: ',i3,2x,i3,2x,'rec=',i4,2x,'trc=',
     *               i4,2x,'(125)=',i6,2x,'kdead=',i3,2x,'(40)=',i5)
#endif

               if (ittemp .eq. ntpr) write (luprt,3200) irtemp
            endif
  420    continue
      endif
  440 continue
c
c     print itotal and limits to itotal.  a true median algorithm
c     would use one point from the mixing window per output trace
c     position.  a mean algorithm using all points in the mixing
c     window would use nmix points per output trace position.
c
  500 limlo = nrecs*ntpr*nspt
      limhi = limlo*nmix
      ratiol = float(limlo)/float(limlo)
      ratioh = float(limhi)/float(limlo)
      ratiot = float(itotal)/float(limlo)
      if (verbos) then
         write (luprt,5000) limlo, limhi, itotal, ratiol,
     *                      ratioh, ratiot
 5000    format(/' Data count used in averaging:'/
     *          5x,'  low limit = ',i10/
     *          5x,' high limit = ',i10/5x,'points used = ',i10//
     *          ' count ratios:'/5x,' low/low = ',f8.4/5x,
     *          'high/low = ',f8.4/5x,'used/low = ',f8.4/)
      endif
c
c     print final message, call accounting routine, and close tapes.
c
      write (luprt,5100)
 5100 format (/////,' -Execution complete')
999   continue
      call nacct2 (nrecs)
      if (dvntp) call lbclos (luntap)
      if (dvotp1) call lbclos (luotp1)
      if (dvotp2) call lbclos (luotp2)
c
c      end timing, total program (outer timing loop)
c
       call secon1 (cputo1, wallo1)
       cputo = cputo1 - cputo0
       wallo = wallo1 - wallo0
       write (luprt,9000) cputo, wallo
 9000  format(//' Timing:  outer loop'/5x,' total cpu = ',
     *        f12.3/5x,'wall clock = ',f12.3)
      stop
      end
