C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadTDFN ( luvel, Time, Velocity, nn, irec, MaxTime,
     :     tfact, EndFunctionReadFlag )    

c ReadTDFN read the next function assuming TDFN format input returning
c EndFunctionReadFlag =  .true. on EOF

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer luvel, nn, CardNumber
      integer itime(2*SZLNHD), ivelocity(2*SZLNHD), irec, count
      integer ThisRec

      real Time(*), Velocity(*), MaxTime, tfact

      logical EndFunctionReadFlag

c initialize memory

      do i = 1, SZLNHD
         itime(i) = 0
         ivelocity(i) = 0
      enddo

c read velocity function data down to and including next 9TDFN card

      count = 0 - 6

      DO while (1 .eq. 1)
         
         count = count + 7

         read ( luvel, 10, end=999, err=990 ) CardNumber,
     :        (itime(i),ivelocity(i), i = count , count + 6 ), irec
 10      format(i1,4x,7(I4,I5),7X,I5)   


c POLICEMAN: if irec = 0 then you have a completely blank card in the file
c            or have forgotten to enter a function index on the TDFN card
c            the first is likely a blank card at the end of the file, the
c            last is a disaster

         if ( irec .eq. 0 ) then
            if ( itime(1) .eq. 0 .and. ivelocity(1) .eq. 0 ) then
               write(LERR,*)' '
               write(LERR,*)'VELIN: Have encountered a blank card in'
               write(LERR,*)'       your TDFN file.  Will ignore and'
               write(LERR,*)'       continue'
               write(LERR,*)'Warning'
               goto 999
            else
               write(LERR,*)'VELIN: Have encountered a blank record'
               write(LERR,*)'       number entry in your TDFN file.'
               write(LERR,*)'FATAL'
               stop
            endif
         endif

         if ( count .eq. 1 ) ThisRec = irec
         
         if ( CardNumber .ne. 9 ) then
               
            do i = count, count + 6
               Time(i) = float( itime(i) ) / tfact
               Velocity(i) = float(ivelocity(i))
            enddo

c POLICEMAN: watch for record number changes within a function

            if ( irec .ne. ThisRec ) then
               write(LERR,*)'VELIN: The record number has changed'
               write(LERR,*)'       within a velocity function on'
               write(LERR,*)'       you TDFN cards at record number' 
               write(LERR,*)'      ',ThisRec
               write(LERR,*)'FATAL'
               stop
            endif
            
         else

c have reached the end of the input velocity function for this record
c load last remaining time,velocity pairs and return

            do i = count, count + 6

               if(itime(i) .ge. 0 .and. ivelocity(i) .gt. 0) then

c only add elements to velocity function if they exist

                  Time(i) = float( itime(i) ) / tfact
                  Velocity(i) = float(ivelocity(i))
               else
                  nn = i - 1
                  goto 1000
               endif
            enddo
            
            nn = count + 6
            goto 1000

         endif              
         
      ENDDO

 1000 continue

      do i = 2, nn

c POLICEMAN: check for increasing time in function

         if ( ( Time(i-1) - Time(i) ) .ge. 1.e-32 ) then
            write(LERR,*)'VELIN: times must increase in your'
            write(LERR,*)'       input velocity function at record'
            write(LERR,*)'       number ',ThisRec,'. The times involved'
            write(LERR,*)'       are ', Time(i-1) * tfact, ' and ',
     :           Time(i) * tfact
            write(LERR,*)'FATAL'
            stop
         endif

c POLICEMAN: check for zero velocity entry

         if ( Velocity(i-1) .lt. 1.e-32 
     :        .or. Velocity(i) .lt. 1.e-32 ) then
            write(LERR,*)'VELIN: you have a zero velocity entry in your'
            write(LERR,*)'       input velocity function at record'
            write(LERR,*)'       number ',ThisRec,'. The times involved'
            write(LERR,*)'       are ', Time(i-1) * tfact, ' and ',
     :           Time(i) * tfact
            write(LERR,*)'FATAL'
            stop
         endif
      enddo

c POLICEMAN: check to see if function exceeds trace length
c turning this off to test if it matters, actually would be 
c better if this was not on then last sample would be adequately
c interpolated

c
c WARNING#### I have run velin through the exersizer with this
c             turned off and it passed!!! Why was this here???
c             I am going to release this but if it fails one
c             day I am leaving this code here so it will be easy
c             to turn on in an emergency.
c
c      if ( Time(nn) .gt. MaxTime ) then
c         write(LERR,*)'VELIN: your input velocity function at '
c         write(LERR,*)'       record number',ThisRec,' contains'
c         write(LERR,*)'       times greater than the maximum time'
c         write(LERR,*)'       on your input dataset.  This function'
c         write(LERR,*)'       will be truncated.'
c         write(LERR,*)'WARNING'

c         do i = 1, nn
c            if ( Time(i) .gt. MaxTime ) then
c               nn = i - 1
c               return
c            endif
c         enddo
c      endif

      return

 990  continue
      
      write(LERR,*)'VELIN: error reading TDFN velocity function'
      write(LERR,*)'       at input record',ThisRec
      write(LERR,*)'FATAL'
      stop

 999        continue
      
      EndFunctionReadFlag = .true.
      count = count - 7
      if ( count .lt. 0 ) return
      goto 1000

      end
