C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C****************************** vspstk *******************************72
c
c performs vsp combo nmo/stack & 
c writes the results to an output file
c 
c
c**********************************************************************c
c
c Changes:
c
c March 12, 2002 - fixed binning logic, syncd help, man page, pattern
c                  file.  Also fixed memory management errors in mismatched
c                  subroutine declarations.  lfit routine had mismatched call
c                  where A and B [slope and intercept] were cross wired in the
c                  call statement.  Routine needs dynamic memory
c                  allocation and a refit of subroutine declarations but will
c                  do that next time.
c Garossino
c
c     declare variables
c
c-----
      implicit none
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
c declare standard USP variables

      integer     itr ( 2*SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
      integer     argis, jerr

      real tri ( 2*SZLNHD )
      real UnitSc

      character   ntap * 255, otap * 255, name*6

      logical     verbos

c  dynamic memory allocation for big arrays, eg whole records

      integer item1, item2, errcdx, errcdy, errcd2, errcd3, abort

      real  xs, ys, bigar2, bigar3

      pointer     (wkadrx,     xs(2))
      pointer     (wkadry,     ys(2))
      pointer     (wkadr2, bigar2(2))
      pointer     (wkadr3, bigar3(2))
 
      logical     heap1, heap2

c local variables

      integer iz(2*SZLNHD)
      integer recnum, trcnum
      integer stacor, nrecc, jtr, is, jj, ic, kk, isrcx, isrcy
      integer itstep, nsiw, lunfil, nbins, nsampi, nsampw, ishdr, tmax
      integer nsampm, i, icinit, numbn, itoo, j, idepth, irec, istrc
      integer ifmt_MutVel, l_MutVel, ln_MutVel
      integer ifmt_WatVel, l_WatVel, ln_WatVel
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC
      integer ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC
      integer ifmt_HdrWrd, l_HdrWrd, ln_HdrWrd

      real Tn(2*SZLNHD), vintar(2*SZLNHD), Zn(2*SZLNHD)
      real Vn(2*SZLNHD)
      real twt(2*SZLNHD), xrng(2*SZLNHD), tint(2*SZLNHD)
      real xint(2*SZLNHD), angle(2*SZLNHD) 
      real sig(2*SZLNHD)
      real tabl1 (2*SZLNHD), tabl2(2*SZLNHD)
      real zz(8*SZLNHD)
      real deg, frac, srcxi, srcyi, dx, tscl, xmin, xmax
      real dt, srcx, srcy, xs0, ys0, b, a, sa, sb, chi, q, theta
      real xp, yp, zr

      character   hdrwrd * 6, vtap * 255
 
      logical     rms, ave, int, tdfn, owt, tzero
 
c initialize variables

      data lbytes / 0 /, nbytes / 0 /, name/'VSPSTK'/, abort/0/
 
      deg = 180./3.14159265

c-----
c     read program parameters from command line card image file
c-----

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0) then
         call help()
         stop
      endif
 
c open printout file

#include <f77/open.h>

c parse command line
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,frac,srcxi,srcyi,
     1     lunfil,vtap, xmin, xmax, dx,verbos, nsiw,
     2     rms, ave, int,itstep,tscl,tdfn,owt,hdrwrd,tzero)
 
c determine global output parameters

      if     (xmin .ne. 0. .AND. xmax .ne. 0.) then
             nbins = nint ( (xmax - xmin)/dx + 1.0)
      elseif (abs(xmin) .ne. 0. .AND. xmax .eq. 0.) then
             nbins =  nint (xmin / dx + 1.0)
      elseif (xmin .eq. 0. .AND. xmax .ne. 0.) then
             nbins = nint (xmax / dx + 1.0)
      endif

      write(LERR,*)'nbins= ',nbins

c POLICEMAN: at present you cannot pipe into this algorithm as the routine
c            needs to backup on the pipe so we will not let you pipe in
c
      if ( ntap .eq. ' ' ) then
         
         write(LERR,*)' '
         write(LERR,*)' Piping into this routine is not allowed '
         write(LERR,*)' You must supply an input dataset on the'
         write(LERR,*)' command line using -N[]'
         write(LERR,*)'FATAL'
         write(LER,*)'VSPSTK: '
         write(LERR,*)'Piping into this routine is not allowed '
         write(LERR,*)'You must supply an input dataset on the'
         write(LERR,*)'command line using -N[]'
         write(LERR,*)'FATAL'
         stop
      endif

c-----
c open input and output datasets
c-----

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)

      if(lbytes .eq. 0) then
         write(LER,*)'VSPSTK: '
         write(LER,*)' no line header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers 
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)

c get global parameters from input line header

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 6, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c I am not sure why all this is done but will defer to the original 
c authors and leave this alone, although it does look like overkill
c Garossino

      nsampi = nsamp
      nsamp  = 1.5 * nsamp
      nsampw = 2 * nsi * nsamp / nsiw
      tmax   = nsiw * nsampw
      nsampm = max (nsampw, nsamp)

      do  i = 1, nsampm
          tabl1 (i) = float (i) * nsi
      enddo
      do  i = 1, nsampm
          tabl2 (i) = float (i) * nsiw
      enddo
      icinit = 1

c This velfin stuff does a cubic spline interpolation on the velocity
c input under certain conditions.  This may not be good in all cases
c so be sure to warn the user to look at the velocity printout in 
c the printout file to verify the interpolation.  Might be a good idea
c to put in a linear interpolation of velocity but I do not have time
c at the moment....Garossino

      call velfin (Vn, Tn, Zn, numbn, tmax, vintar, tscl,
     1     lunfil, ave, int, rms, nsiw, nsampw, itstep,
     2     tdfn, owt)


c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      dt = real (nsiw) * unitsc
 
c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.
      heap2 = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      item1 = ntrc   * nrec   * SZSMPD
      item2 = nbins  * nsampw * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 0  (allocation succeeded)
c     errcod = 1  (allocation failed)
c--------
 
      call galloc (wkadrx, item1, errcdx, abort)
      call galloc (wkadry, item1, errcdy, abort)
      call galloc (wkadr2, item2, errcd2, abort)
      call galloc (wkadr3, item2, errcd3, abort)
 
      if (errcdx .ne. 0.) heap1 = .false.
      if (errcdy .ne. 0.) heap1 = .false.
      if (errcd2 .ne. 0.) heap2 = .false.
      if (errcd3 .ne. 0.) heap2 = .false.
 
      if (.not. heap1 .or. .not. heap2) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) item1,'  bytes'
         write(LER ,*) item1,'  bytes'
         write(LER ,*) item2,'  bytes'
         write(LERR,*) item2,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*)' '
      endif

c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', nbins, LINHED)
      call savew(itr, 'NumSmp', nsamp, LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout  )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----

      call verbal(nsamp, nsi, ntrc, nrec, iform,srcyi,
     1     frac,srcxi,xmin,xmax,dx,itstep,nbins,
     1     vtap,ntap,otap,rms, ave, int, tdfn, owt)
 
c--------------------------------------------------
c initialize array to hold amplitude at model reflection
c points

      do  i = 1, nrec
          sig (i) = 1.0
      enddo

c--------------------------------------------------
c initialize arrays to hold binned amplitude and fold
c 
c bigar2 will contain the output binned amplitudes
c bigar3 will contain the sample wise weighting with
c        which to normalize the former

      do  i = 1, nbins*nsampw
          bigar2 (i) = 0.
          bigar3 (i) = 0.
      enddo

c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file

c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
 
c-----
c     process desired trace records
c-----
      is = 0
      DO  JJ = irs, ire
 
c----------------------
c  skip to start trace

         call trcskp(jj,1,ns-1,luin,ntrc,itr)

c----------------------
 
         ic = 0
         DO  KK = ns, ne
 
            nbytes = 0
            call rtape( luin, itr, nbytes)

c------
c first read thru data extracting src Xs & Ys for all live traces
c this activity is why you cannot pipe into this routine.  Once this
c is done we have to back up and actually process the data
c------
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
            endif
            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           stacor , TRACEHEADER)
            call saver2(itr,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1           isrcx  , TRACEHEADER)
            call saver2(itr,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1           isrcy  , TRACEHEADER)

            IF (stacor .ne. 30000) THEN
               ic = ic + 1
               is = is + 1
               srcx    = float (isrcx) - srcxi
               srcy    = float (isrcy) - srcyi
               xs (is) = srcx
               ys (is) = srcy
            ENDIF

         ENDDO
      ENDDO

c------
c for all src Xs & Ys fit a line thru points and get the slope
c the slope is used to rotate the Xs & Ys to orient the X axis
c along the actual shooting line
c the new src Xs are computed; if the Ys lie off the line somewhat
c then so be it
c------
      xs0 = xs (1)
      ys0 = ys (1)
      itoo = 0

      do  i = 2, is
         if (xs(i).eq.xs0 .and. ys0.eq.ys0) then
            itoo = itoo + 1
         endif
      enddo

      if (itoo+1 .lt. is) then
c oops looks like a cross wire of slope [A] and intercept[B] with 
c subroutine...fixed ...Garossino
c         call lfit (xs,ys,is,sig,0,B,A,sa,sb,chi,q)

         call lfit (xs,ys,is,sig,0,A,B,sa,sb,chi,q)
         theta = atan ( A )
         write(LERR,*)' '
         write(LERR,*)'Linear fit slope= ',A,' intercept= ',B,
     1        ' slope(deg)= ',deg*theta
         do  j = 1, is
            xp =  xs (j) * cos (theta) + (ys (j) -B) * sin (theta)
            yp = -xs (j) * sin (theta) + (ys (j) -B) * cos (theta)
            if (verbos)
     1           write(LERR,*)'Input src x,y= ',xs(j),ys(j),
     2           ' Output src xp,yp= ',xp,yp
            xs (j) = xp
         enddo

         write(LERR,*)' '
      endif

c------
c rewind data and read line header
c------

      call rwd (luin)
      call rtape (luin, itr, lbytes)
      call recskp(1,irs-1,luin,ntrc,itr)

c------
c now go thru the data reading trace data and doing the binned stack
c------
      is = 0
      
      DO JJ = irs, ire
 
c----------------------
c  skip to start trace
         call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
         ic = 0

c set cubic spline table initiation to happen
         icinit = 1

         DO  KK = ns, ne
 
            nbytes = 0
            call rtape( luin, itr, nbytes)
            call vmov (itr(ITHWP1), 1, tri, 1, nsampi)
            call vclr (sig, 1, nsampw)

c do cubic spline interpolation of input amplitudes onto processing
c sample interval 

            call fcuint (tabl1, tri, nsampi, tabl2, sig, nsampw,
     1           iz, zz, icinit)

c set cubic spline table initiation to use tables already calculated
            icinit = 0
 
c------
c     use previously derived pointers to trace header values
            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1           recnum , TRACEHEADER)
            call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1           trcnum , TRACEHEADER)
            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           stacor , TRACEHEADER)
            call saver2(itr,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1           idepth , TRACEHEADER)

            IF (stacor .eq. 30000) THEN

c clear dead traces

               call vclr (tri,1,nsamp)
               
            ELSE
c----------------------
c  pack data into array
               ic = ic + 1
               is = is + 1
               zr    = iabs (idepth)
               srcx  = xs (is)
               if (verbos) then
                  write(LERR,*)'Rec/trc= ',JJ, KK,
     1                 ' rcvr depth= ',zr,' source offset= ',srcx
                  write(LER ,*)'Rec/trc= ',JJ, KK,
     1                 ' rcvr depth= ',zr,' source offset= ',srcx
               endif

c do ray tracing, interpolation and bin population.  On exit 
c bigar2 will hold the binned data and bigar3 will hold the sample
c wise fold for use in normalization

               call subs (nsampw, sig, bigar2, bigar3, KK,
     1              xmin, xmax, frac, numbn, nbins, srcx, zr,
     2              Vn, Tn, Zn, vintar, twt, xrng, xint,
     3              angle, tint, tmax, nsiw, dx, dt, tzero)
            ENDIF

c-----------------------
         ENDDO
c----------------------
c  skip to end of record
         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
 
      ENDDO

c--------
c normalize the binned samples according to how many times a particular
c bin at each sample was "hit"
c--------

      call snorm (nsampw, nbins, bigar2, bigar3)

c---------------------
c  extract traces from
c  output array and
c  write output data
      irec = 1

c set cubic spline table initiation on

      icinit = 1

      DO KK = 1, nbins
 
         istrc = (kk-1) * nsampw
         ishdr = (kk-1) * ITRWRD

c move interpolated output into workspace

         call vmov (bigar2(istrc+1),1,sig,1, nsampw)

c clear output trace

         call vclr (tri, 1, nsampw)

c using cubic spline interpolation to fit output data to trace
c going from processing sample interval to output sample interval

         call fcuint (tabl2, sig, nsampw, tabl1, tri, nsamp,
     1        iz, zz, icinit)

c set cubic spline table initiation off

         icinit = 0
         
c output trace

         call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
         call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1        irec   , TRACEHEADER)
         call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1        kk     , TRACEHEADER)
         call wrtape (luout, itr, obytes)
         
      ENDDO
 
 999  continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'end of vspstk, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER ,*)'end of vspstk, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'vspstk does a combination VSP nmo & stack into horizontal bins'
        write(LER,*)' '
        write(LER,*)
     :'execute vspstk by typing vspstk and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)        : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)        : output data file name'
        write(LER,*)
     :' -v [vtap]    (no default)        : input vel flat file'
        write(LER,*)
     :'              (must be 2 columns  : time velocity)'
        write(LER,*) ' '
        write(LER,*)
     :' -dx[dx]      (default = none)    : horizontal bin size (ft,m)'
        write(LER,*)
     :' -sx[wrcx]    (default = 0)       : horiz well X-offset (ft,m)'
        write(LER,*)
     :' -sy[wrcy]    (default = 0)       : horiz well Y-offset (ft,m)'
        write(LER,*)
     :' -xmin[xmin]  (default = 0)       : min distance from well to ima
     :ge'
        write(LER,*)
     :' -xmax[xmax]  (default = none)    : max distance from well to ima
     :ge'
        write(LER,*)
     :' -f[frac]     (default = 5.0)     : ray tracing tolerance (ft,m)'
        write(LER,*)
     :' -ts[step]    (default = 250ms)   : resample input vel func at '
        write(LER,*)
     :'                                    this time step, a negative '
        write(LER,*)
     :'                                    entry will cause program to'
        write(LER,*)
     :'                                    use model as is.'
        write(LER,*)
     :' -Hw [hdrwrd] (default = GrpElv)  : hdr wrd where sonde depth is'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :' -owt  include on command line if velocity file is 1-way time'
        write(LER,*)
     :' -T  include on command line if velocity file is TDFN format,'
        write(LER,*)
     :' -ZT correct to T0 of zero offset S-R ray path'
        write(LER,*)
     :'     else file is 2-col format: time-velocity'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   vspstk -N[] -O[] -v[] -Hw[] -dx[] -xmin[] -xmax[]'
        write(LER,*)
     :'                 -f[] -sx[] -sy[] -ts[] [ -rms -ave -int -owt -T 
     : -ZT -V]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,frac,srcxi,srcyi,
     1     lunfil,vtap,xmin,xmax,dx,verbos, nsiw,
     2     rms, ave, int,itstep,tscl,tdfn,owt,hdrwrd,tzero)
c-----
c     get command arguments
c
c     ntap  - C*255    input file name
c     otap  - C*255    output file name
c     vel   - R*4      design velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), vtap*(*), hdrwrd*6
      integer     ns, ne, irs, ire, nsiw
      real        dx,xmin,xmax,frac,srcxi, tscl
      logical     verbos, rms, ave, int, tdfn, owt, tzero
      integer     argis

      lunfil = 57
      rms  = .false.
      ave  = .false.
      int  = .false.
      tdfn = .false.
      owt  = .false.
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program vspstk might be invoked in the following way:
 
c     vspstk  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into vspstk and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            if (ntap(1:1) .eq. ' ') then
               write(LER,*)'FATAL ERROR: vspstk: cannot pipe in'
               write(LER,*)'Rerun with -N[]'
               stop 666
            endif
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-v', vtap, ' ', ' ' )
            if (vtap(1:1) .eq. ' ') then
               write(LER,*)'FATAL ERROR: vspstk: must enter velocity'
               write(LER,*)'flat file using -v[] cmd line argument'
               stop 666
            else
               open (unit=lunfil, file=vtap,status='old',iostat=ierr)
               if (ierr .ne. 0) then
                  write(LERR,*)'Could not open velocity file ',vtap
                  write(LERR,*)'Check existence'
                  stop 666
               endif
            endif
            call argstr( '-Hw', hdrwrd, 'GrpElv', 'GrpElv' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-ts', itstep ,   0  ,  0    )
            call argi4 ( '-dt', nsiw ,   2  ,  2    )
            call argr4 ( '-tmul', tscl, 1.0, 1.0)
            call argr4 ( '-f', frac, 5.0, 5.0)
            call argr4 ( '-sx', srcxi, 0., 0.)
            call argr4 ( '-sy', srcyi, 0., 0.)
            call argr4 ( '-dx', dx, 0., 0.)
            if (dx .eq. 0.) then
               write(LER,*)'FATAL ERROR: vspstk: must enter horz bin sz'
               write(LER,*)'flat file using -dx[] cmd line argument'
               stop 666
            endif
            call argr4 ( '-xmin', xmin, 0., 0.)
            call argr4 ( '-xmax', xmax, 0., 0.)
            if (xmin .eq. 0. .AND. xmax .eq. 0.) then
               write(LER,*)'FATAL ERROR: vspstk: both xmin & xmax cannot
     1 be both zero'
               stop 666
            endif

            rms    =   (argis('-rms') .gt. 0)
            ave    =   (argis('-ave') .gt. 0)
            int    =   (argis('-int') .gt. 0)
            tdfn   =   (argis('-T') .gt. 0)
            owt    =   (argis('-owt') .gt. 0)
            tzero  =   (argis('-ZT') .gt. 0)

            if (.not. int .AND. .not. ave) rms = .true.
            if ((int .and. rms) .OR. (int .and. ave) .OR.
     1          (rms .and. ave)) then
                write(LER,*)'FATAL ERROR in vspstk:'
                write(LER,*)'Must specify 1 type of velocity function:'
                write(LER,*)' -rms or -ave or -int'
                stop 666
            endif
            
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,srcyi,
     1     frac,srcxi,xmin,xmax,dx,itstep,nbins,
     2     vtap,ntap,otap,rms, ave, int, tdfn, owt)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*255   input file name
c     otap  - C*255   output file name
c-----
#include <f77/iounit.h>
 
      integer nsamp, nsi, ntrc, nrec, iform, itstep, nbins
      real xmin, xmax, frac, dx, srcxi, srcyi
      character ntap*(*), otap*(*), vtap*(*)
      logical rms, ave, int, tdfn, owt
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' ray tolerance (ft,m)        = ',frac
            write(LERR,*) ' X-origin           =  ', srcxi
            write(LERR,*) ' Y-origin           =  ', srcyi
            write(LERR,*) ' min dist from well =  ', xmin
            write(LERR,*) ' max dist from well =  ', xmax
            write(LERR,*) ' max horz survey dist (ft,m) = ',xmax
            write(LERR,*) ' hoizontal bin size (ft,m)   = ',dx
            write(LERR,*) ' number of hoizontal bins    = ',nbins
            write(LERR,*) ' resample input vel func at ',itstep,' samps'
            write(LERR,*) ' velocity input func rms?    = ',rms
            write(LERR,*) ' velocity input func ave?    = ',ave
            write(LERR,*) ' velocity input func int?    = ',int
            write(LERR,*) ' velocity input func owt?    = ',owt
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' input velocity file =  ', vtap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
