************************************************************************
*                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
************************************************************************
*  ROUTINE:       APNMO                                                *
*  ROUTINE TYPE:  SUBROUTINE                                           *
*  PURPOSE:  ???                                                       *
*  ENTRY POINTS:                                                       *
*      APNMO  (X,V,OFFSET,NS,SR,Y)                                     *
*  ARGUMENTS:                                                          *
*      X       REAL     ??IOU*  (*) -                                  *
*      V       REAL     ??IOU*  (*) -                                  *
*      OFFSET  REAL     ??IOU*      -                                  *
*      NS      INTEGER  ??IOU*      -                                  *
*      SR      REAL     ??IOU*      -                                  *
*      Y       REAL     ??IOU*  (*) -                                  *
*       +------------------------------------------------------+       *
*       |               DEVELOPMENT INFORMATION                |       *
*       +------------------------------------------------------+       *
*  AUTHOR:   ???                                ORIGIN DATE: 94/06/07  *
*  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 94/12/07  *
*       +------------------------------------------------------+       *
*       |                 EXTERNAL ENVIRONMENT                 |       *
*       +------------------------------------------------------+       *
*  ROUTINES CALLED:  NONE                                              *
*  INTRINSIC FUNCTIONS CALLED:                                         *
*      AINT    GENERIC -                                               *
*      INT     INTEGER -                                               *
*      SQRT    GENERIC -                                               *
*  FILES:            NONE                                              *
*  COMMON:           NONE                                              *
*  STOP CODES:       NONE                                              *
*       +------------------------------------------------------+       *
*       |             OTHER DOCUMENTATION DETAILS              |       *
*       +------------------------------------------------------+       *
*  ERROR HANDLING:  ???                                                *
*  GENERAL DESCRIPTION:  ???                                           *
*  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
*       +------------------------------------------------------+       *
*       |                 ANALYSIS INFORMATION                 |       *
*       +------------------------------------------------------+       *
*  NONSTANDARD FEATURES:   NONE DETECTED                               *
********************   END OF DOCUMENTATION PACKAGE   ******************
************************************************************************
      subroutine apnmo(X,v,offset,NS,SR,Y,work)
************************************************************************
*                                                                      *
*    SUBROUTINE TO PERFORM HYPERBOLIC MOVEOUT CORRECTION.              *
*      INPUTS ARE:                                                     *
*           X = DATA TO BE CORRECTED                                   *
*           V = SQURARED VELOCITY ARRAY                                *
*          PT = ARRAY TO TP's                                          *
*      OFFSET = OFFSET FOR X                                           *
*          NS = NUMBER SAMPLES PER TRACE                               *
*         SR = SAMPLE INTERVAL IN seconds                              *
*           Y = CORRECTED DATA                                         *
*	 WORK = TEMPORARY ARRAY (WORK(1:ns+ns/2)  <- DR:98.02.03       *
*                                                                      *
************************************************************************
*          V0 = VELOCITY OF RECORDING MEDIUM FORM IMAGE POINT COMPS    *
************************************************************************
      real X(*),Y(*),v(*),work(*),offset,sr
      integer ns
      real vo
 
      ns2 = ns+ ns/2
      do i=1,ns
       work(i+1)=x(i)
      end do
      do i=ns+1,ns2
       work(i)=0.
      end do
      dist=offset*offset
      do i=1,ns
       t0 = (i-1)*sr
       vo = v(i)
       vo = vo*vo
       shft = (sqrt(t0*t0 + dist/vo) - t0)/sr
       if(shft.le.ns-2)then
        if(shft.gt.0)then
         tj = i + shft
         it=int(tj)
         if(it.eq.0)it=1
          f=tj-aint(tj)
          fs=f*f
          c1 = fs-f
          c2 = 2.0 - 2.0*fs
          c3 = fs+f
          y(i)=0.5 *(
     :        work(it)*c1 +
     :        work(it+1)*c2 +
     :        work(it+2)*c3
     :               )
         else
           y(i)=work(i)
         endif
        else
         y(i)=0
       endif
      end do
      RETURN
      END
