C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       APTAUP                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      APTAUP  (Y,DT,N,P,V,TOL,REMOVE,Z)                               *
C  ARGUMENTS:                                                          *
C      Y       REAL     ??IOU*  (*) -                                  *
C      DT      REAL     ??IOU*      -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C      P       REAL     ??IOU*      -                                  *
C      V       REAL     ??IOU*  (*) -                                  *
C      TOL     REAL     ??IOU*      -                                  *
C      REMOVE  INTEGER  ??IOU*      -                                  *
C      Z       REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 94/06/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 94/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C      SQRT    GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine aptaup(y,dt,n,p,v,tol,remove,z)
c
c     y = data trace
c     v = velocity trace (velocity vs sample)
c    dt = sample interval
c     n = number samples/trace
c     p = ray parameter
c   tol = use this % of the ellipse measured from p=0
c remove= if true to 'unmormal movelout'
c
C#include <f77/lhdrsz.h>  Nothing from this .h file used
 
      real     sinei,p,tol,tnmo
      real     y(*), v(*)
      real     z(*)
      integer  j,i,n
      integer  remove
      parameter (deg = 180. / 3.14159265)
 
 
      pa  = abs (p)
 
      do i=1,n
       z(i)= 0.
      end do
 
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  remove nmo (inverse nmo)
 
      IF (remove.eq.1) THEN
 
         do 2000 i = n,1,-1
 
              sinep = pa * v(i)
              sinei = abs ( sinep )
 
              if(sinei .le. tol) then
 
                 tnmo = (i-1) * sqrt( abs(1. - sinei*sinei) )
                 j= tnmo
                 f    = tnmo - j
                 fs   = f * f
                 c1   = fs - f
                 c2   = 2.0 - 2.0 * fs
                 c3   = fs + f
c-------
c      check for bounds
c-----
                 if (i .gt. 1 .and. i .lt. n) then
c                   z(j) = y(i) +  f * (y(i-1) - y(i))
                    z(j) = .5 * (
     1                     c3 * y(i-1) + c2 * y(i) + c1 * y(i+1)
     2                          )
                 else
                    z(j) = 0.
                 endif
 
              endif
 
 2000    continue
 
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      ELSE
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  apply nmo (forward nmo)
 
         do 1000 i = 1,n
 
              sinep = p * v(i)
              sinei = abs ( sinep )
 
              if(sinei .le. tol) then
 
                 tnmo = (i-1) * sqrt ( abs(1. - sinei*sinei) )
                 j    = tnmo
                 f    = tnmo - j
                 fs   = f * f
                 c1   = fs - f
                 c2   = 2.0 - 2.0 * fs
                 c3   = fs + f
c---------------------------------------
c      check for bounds
c-----
 
                 if (j .gt. 1 .and. j .lt. n) then
c-------------
c  interpolate
c                    z(i) = y(j) +  f * (y(j+1) - y(j))
                     z(i) = .5 * (
     1                      c1 * y(j-1) + c2 * y(j) + c3 * y(j+1)
     2                           )
                 else
                     z(i) = 0.
                 endif
c---------------------------------------
              else
                     z(i) = 0.
              endif
 
 1000    continue
 
      ENDIF
 
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 
 
      return
      end
