C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       BVEL                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      BVEL  (TIME,VEL,NVEL,NS,SR,V)                                   *
C  ARGUMENTS:                                                          *
C      TIME    REAL     ??IOU*  (*) -                                  *
C      VEL     REAL     ??IOU*  (*) -                                  *
C      NVEL    INTEGER  ??IOU*      -                                  *
C      NS      INTEGER  ??IOU*      -                                  *
C      SR      REAL     ??IOU*      -                                  *
C      V       REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 94/06/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 94/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VCLR -                                                          *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE BVEL(TIME,VEL,NVEL,NS,SR,V)
C ******************************************************************** C
C *                                                                  * C
C *  Subroutine to create a trace-length expansion of a velocity     * C
C * function.  Inputs are:                                           * C
C *                                                                  * C
C *  TIME - R*4() - Vector of function times, in sec.                * C
C *  VEL  - R*4() - Vector of function velocities                    * C
C *  NVEL - I*4   - Number points in this velocity function          * C
C *  NS   - I*4   - Number of samples in the trace                   * C
C *  SR   - R*4   - Sample interval in sec.                          * C
C *                                                                  * C
C *  Output is                                                       * C
C *  V    - R*4() - Output velocity trace                            * C
C *                                                                  * C
C ******************************************************************** C
      REAL TIME(*),VEL(*),V(*), xl1, xl2,cvel(100)
      REAL lastv
      INTEGER NS, NVEL
      call vclr(v,1,ns)
      nvel1=nvel-1
cmam	print *,'in bvel:nvel=',nvel
cmam	print *,'function:',(time(i),vel(i),i=1,nvel)
      do 25 i=1,nvel1
        xl1 = time(i)/sr
        il = xl1
        if(il.eq.xl1)then
          cvel(i)=vel(i)
        else
          xl2 = time(i+1)/sr
          zz = xl2 - xl1
          if(zz.ne.0.0)then
            slope = (vel(i+1)-vel(i))/zz
          else
            slope = 0.
          endif
          cvel(i) = slope * (xl1 - il) + vel(i)
        endif
   25 continue
      cvel(nvel)=vel(nvel)
      do 200 i = 2, NVEL
        xl1 = time(i-1)/sr
        il1 = xl1 + 1
        if(il1.gt.ns)il1 = ns
        xl2 = time(i)/sr
        il2 = xl2 + 1
        if(il2.gt.ns)il2 = ns
        if(i.eq.2.and.il1.gt.1)then
          do 50 j=1,il1
   50      v(j)= cvel(1)
        endif
        dvel = cvel(i)-cvel(i-1)
        zz = xl2 - xl1
        if(zz.ne.0.0)then
         slope = dvel/zz
        else
         slope = 0.
        endif
        xk = 0.
        il21=il2-1
        vstart = cvel(i-1)
        do 100 j=il1,il21
          v(j)= xk * slope + vstart
          xk = xk + 1.
          lastv = v(j)
  100   continue
        if(i.eq.nvel.and.il21.lt.ns)then
          do 150 j=il21,ns
  150      v(j)=lastv
        endif
  200 continue
      RETURN
      END
