/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "xos.h"
#include "globals.h"
/*
** Set the message in the error dialog and manage the error widget
*/

void update_error (string)
String string ;
{
   Arg args[1] ;
   XmString xmstring ;

   xmstring = XmStringCreateLtoR (string, XmSTRING_DEFAULT_CHARSET) ;
   XtSetArg (args[0], XmNmessageString, xmstring) ;
   XtSetValues (error_dialog, args, 1) ;
   XtManageChild (error_dialog) ;
   XmStringFree (xmstring) ;
}
/*
** Synchronize horizontal scrolling, CDP window is the master
*/

XtCallbackProc sync_HscrollbarsCB (w, sp, call)
Widget      w ;
Seisplot    *sp ;
XmScrollBarCallbackStruct  *call ;
{
   int i, j=CDP, max, value, hvalue, dummy, slider_size, increment, page ;
   int rec, trc, ntrcs, t0, isamp, rsamp ;
   float prorata ;
   Arg args[1] ;

   value = call->value ;
   xy2rts(&sp[j], value,sp[j].yorg, &rec, &trc, &ntrcs, &t0, &isamp, &rsamp); 
   prorata = (float)(rec - sp[j].st_rec) + (float)trc / (float)sp[j].ntr ;
	valhsb = value;
/*
   call->value = hvalue ;
*/

   for (i = TP ; i <= VEL ; i++) {
      if (i == TP) {
         if (value > sp[j].xorg)
            hvalue = (int)(prorata * (float)sp[i].ntr) *
                     sp[i].pix_per_trace + sp[i].xorg ;
         else
            hvalue = value ;
      }
      else {
/*...........changed feb 24, 1994   mam...........*/
	   if(done_moveout == 1)
            hvalue = (int)(prorata * (float)sp[MO].ntr) *
                     sp[MO].pix_per_trace + sp[MO].xorg ;
         else if (value > sp[j].xorg)
            hvalue = prorata * (float)sp[TP].velplot->width ;
/*.................end of changes..................*/
         else
            hvalue = 0 ;
      }

      XmScrollBarGetValues(hsb[i], &dummy, &slider_size, &increment, &page);
      XtSetArg (args[0], XmNmaximum, &max) ;
      XtGetValues (hsb[i], args, 1) ;
      if (hvalue >= max - slider_size) hvalue = max - slider_size - 1 ;
      if (hvalue < 0) hvalue = 0 ;
      call->value = hvalue ;
      XmScrollBarSetValues(hsb[i], hvalue, slider_size, increment, page, False);

      XtCallCallbacks (hsb[i], XmNdragCallback, call) ;
      XtCallCallbacks (hsb[i], XmNtoTopCallback, call) ;
      XtCallCallbacks (hsb[i], XmNtoBottomCallback, call) ;
      XtCallCallbacks (hsb[i], XmNincrementCallback, call) ;
      XtCallCallbacks (hsb[i], XmNdecrementCallback, call) ;
      XtCallCallbacks (hsb[i], XmNpageIncrementCallback, call) ;
      XtCallCallbacks (hsb[i], XmNpageDecrementCallback, call) ;
   }
}
/*
** Synchronize vertical scrolling, CDP window is the master
*/

XtCallbackProc sync_VscrollbarsCB (w, vsb, call)
Widget      w ;
Widget      *vsb ;
XmScrollBarCallbackStruct  *call ;
{
   int i, max, value, slider_size, increment, page, dummy ;
   Arg args[1] ;

/*cmam.8-17-95. goes with problem solution below...*/
	value = call->value ;

   XtSetArg (args[0], XmNmaximum, &max) ;
   XtGetValues (w, args, 1) ;
   XmScrollBarGetValues(w, &dummy, &slider_size, &increment, &page);
   /*XmScrollBarGetValues(w, &value, &slider_size, &increment, &page);*/
	valvsb = value;

   for (i = TP ; i <= VEL ; i++) {
/*cmam.8-17-95.taking this out gets rid of the warning messages on
	VertScrollBar about slider gt max value - min value    and
	value gt max value - slider size  ---- go figure.........*/
      /*XtSetArg (args[0], XmNmaximum, max) ;
      XtSetValues (vsb[i], args, 1) ;*/

      XmScrollBarSetValues( vsb[i], value, slider_size, increment, page, False);
      XtCallCallbacks (vsb[i], XmNdragCallback, call) ;
      XtCallCallbacks (vsb[i], XmNtoTopCallback, call) ;
      XtCallCallbacks (vsb[i], XmNtoBottomCallback, call) ;
      XtCallCallbacks (vsb[i], XmNincrementCallback, call) ;
      XtCallCallbacks (vsb[i], XmNdecrementCallback, call) ;
      XtCallCallbacks (vsb[i], XmNpageIncrementCallback, call) ;
      XtCallCallbacks (vsb[i], XmNpageDecrementCallback, call) ;
   }
}
/*
** Get seismic display parameters from dialog, read data,
**  display traces  
*/

XtCallbackProc get_parmsCB(w, sp, call)
Widget w;
Seisplot *sp;
caddr_t call;
{
   int i, k, ierr, nread, srec, erec, strc, etrc, maxovlp;
   int ssrec, serec;
   int numpix ;
   int n, m, st_rec, end_rec;
   float ips, tpi, scalr ;
   String string;
   char plotmsg[255], errmsg[255];
   Seisplot restore ;
   extern XtCallbackProc display_timerCB();
   static Seisplot savem[2] ;
   static int saved[2] = {FALSE, FALSE} ;
   Arg args[2] ; 
   static Boolean first_time[2] = {True,True} ;
   static char *data_set[2] = {"CDP", "CMO"};

   extern void draw_it(), clear_message(), update_message(), 
               update_error(), copy_seisplot() ;
   extern void initialize_velplot () , cp_cdp_to_mo();
	extern void free_digits(), free_digrec();
   extern int get_data() ; 
   extern XtCallbackProc exposeCB () ;
   extern XtEventHandler handle_eventsCB () ;
	extern void draw_new_picks();

   if(sp[0].file == NULL || sp[1].file == NULL) {
     sprintf(errmsg,"Both the CDP and CMO data sets MUST be selected\n");
     XBell (display, 0) ;
     update_error(errmsg);
     return;
   }
   string=XmTextGetString(texts[0]);
   if(strlen(string))
     sscanf(string,"%d", &srec);
   else
     erec = 0;
   XtFree(string);

   string=XmTextGetString(texts[1]);
   if(strlen(string)) 
     sscanf(string,"%d", &erec);
   else
     erec = 0;
   XtFree(string);

   string=XmTextGetString(texts_a[0]);
   sscanf(string,"%d", &ssrec);
   XtFree(string);

   string=XmTextGetString(texts_a[1]);
   sscanf(string,"%d", &serec);
   XtFree(string);

   string=XmTextGetString(texts[2]);
   sscanf(string,"%f", &ips);
   XtFree(string);

   if(ssrec == 0)ssrec = 1;
   if(serec == 0)serec = 1;
   if(XmToggleButtonGadgetGetState(record_toggle[1]) == True)
     sequent = 1;
   else
     sequent = 0;
   if(srec == 0) srec = 1;
   if(erec == 0) erec = 1;
   for (i = CDP ; i <= TP ; i++) {
    ierr = 0;
    string=XmTextGetString(texts[9]);
    sscanf(string,"%d", &sp[i].agclw);
    XtFree(string);

    sp[i].agc = 0;
    if(XmToggleButtonGadgetGetState(agc_toggle[1]) == True) {
     if(i == CDP) 
       sp[i].agc = 1;
    }
 
    if(sp[i].agc && !sp[i].agclw) sp[i].agclw = 500;

      if(sequent) {
        if(ssrec > sp[i].trecs) {
          sprintf(errmsg,"The %s data set does not have a sequential record %d\n",
                   data_set[i], ssrec);
          ierr++;
        }
        if(serec > sp[i].trecs && serec != ssrec) {
          if(ierr == 0)
          sprintf(errmsg,"The %s data set does not have a sequential record %d\n",
                   data_set[i], serec);
          else {
          sprintf(plotmsg,"The %s data set does not have a sequential record %d\n",
                   data_set[i], serec);
          strcat(errmsg, plotmsg);
          }
          ierr++;
        }
        if(ierr) {
          XBell (display, 0) ;
          update_error(errmsg);
          return;
        }
        srec = sp[i].recbuf[ssrec-1];
        erec = sp[i].recbuf[serec-1];
      }
      st_rec=-1;
      for (k=0; k < sp[i].trecs; k++) {
	/*...sp->recbuf was taken from the corresponding dataset using
		get_ri, which uses lseek to read each record and get
		the record number out of the trace header...........*/
        if(sp[i].recbuf[k] == srec)
            st_rec = k;
      }
      if(st_rec == -1) {
        sprintf(errmsg,"Record %d does not exist on the %s data set\n",
              srec, data_set[i]);
        ierr++;
      }
      end_rec=-1;
      for (k=0; k < sp[i].trecs; k++) {
        if(sp[i].recbuf[k] == erec)
            end_rec = k;
      }
      if(end_rec == -1) {
        if(ierr == 0)
        sprintf(errmsg,"Record %d does not exist on the %s data set\n",
              erec, data_set[i]);
        else {
        sprintf(plotmsg,"Record %d does not exist on the %s data set\n",
              erec, data_set[i]);
        strcat(errmsg, plotmsg);
        }
        ierr++;
      }
      if(ierr != 0) {
        XBell (display, 0) ;
        update_error(errmsg);
        return;
      }
      n = end_rec - st_rec + 1;
      sp[i].nrecs = n;
      if(sp[i].irec_buf == NULL) {
        sp[i].irec_buf = (int *)calloc(n,sizeof(int));
        sp[i].li_di_ind = (int *)calloc(n,sizeof(int));
      }
      else {
        free(sp[i].irec_buf);
        free(sp[i].li_di_ind);
        sp[i].irec_buf = (int *)calloc(n,sizeof(int));
        sp[i].li_di_ind = (int *)calloc(n,sizeof(int));
      }
      m = 0;
      for (k=st_rec; k<= end_rec; k++) {
        sp[i].irec_buf[m]=sp[i].recbuf[k];
        sp[i].li_di_ind[m]=k;
        m++;
      }
      sp[i].st_rec = 0;
      sp[i].end_rec = m-1;
      sp[i].rec_st = srec;
      sp[i].rec_end = erec;

      if(ips == 0.0)
         sp[i].inches_per_second = 2.5 ;
      else
         sp[i].inches_per_second = ips ;

      string=XmTextGetString(texts[3+i]);
      sscanf(string,"%f", &tpi);
      XtFree(string);
      if(tpi == 0.0)
         sp[i].traces_per_inch = 24 ;
      else
         sp[i].traces_per_inch = tpi ;

      if (i == CDP) {
         string = XmTextGetString(texts[5]);
         sscanf(string,"%d", &maxovlp);
         XtFree(string);
         if(maxovlp == 0)
            sp[i].maxovlp = 3 ;
         else
            sp[i].maxovlp = maxovlp ;

         string = XmTextGetString(texts[7]);
         sscanf(string,"%f", &scalr);
         XtFree(string);
         if(scalr == 0.0)
            sp[i].scalr = 0.15 ;
         else
            sp[i].scalr = scalr ;
      }
      else {
         /* not used for VD display, but set values anyway */
         sp[i].maxovlp = 3 ;
         sp[i].scalr = 0.15 ;
      }

/*
**    If nothing has changed then no need to read or plot
*/

      if (!saved[i]                                             ||
          savem[i].rec_st            != sp[i].rec_st            ||
          savem[i].rec_end           != sp[i].rec_end           ||
          savem[i].inches_per_second != sp[i].inches_per_second ||
          savem[i].traces_per_inch   != sp[i].traces_per_inch   ||
          savem[i].maxovlp           != sp[i].maxovlp           ||
          savem[i].scalr             != sp[i].scalr             ||
          savem[i].agc               != sp[i].agc               ||
          savem[i].agclw             != sp[i].agclw             ||
          strlen(savem[i].file)      != strlen(sp[i].file)      ||
          strcmp(savem[i].file,sp[i].file) != 0 ) {

/*
**       If data files or record ranges have not changed, do not read
*/
         if (!saved[i]                                             ||
             savem[i].rec_st            != sp[i].rec_st            ||
             savem[i].rec_end           != sp[i].rec_end           ||
             strlen(savem[i].file)      != strlen(sp[i].file)      ||
             strcmp(savem[i].file,sp[i].file) != 0 ) {

            if (i == CDP)
               update_message ("Reading CDP data") ;
            else
               update_message ("Reading SCAN data") ;

            copy_seisplot (&restore, &sp[i]) ;
            nread = get_data (&sp[i]) ;
            if (nread != sp[i].ntrace) {
               copy_seisplot (&sp[i], &restore) ;
               return ;
            }
/*
** added mon 14:01
*/
            if (sp[i].new_digits) {
             free_digits (sp[i].new_digits) ;
             sp[i].new_digits = NULL ;
            }
 
/*....cmam...following stuff changed 10-11-96......
......we have to remember to delete the forward & backward ptrs to
      deleted members of a linked list............*/
	if(sp[i].old_digrec) {
	  if(sp[i].old_digrec->next) {
	    if(sp[i].old_digrec->prev) {
		/*.....both forward and backward ptrs exist...*/
		if(sp[i].accepted_digrec_head == sp[i].old_digrec)
		   sp[i].accepted_digrec_head = sp[i].old_digrec->next;
		if(sp[i].accepted_digrec_tail == sp[i].old_digrec)
		   sp[i].accepted_digrec_tail = sp[i].old_digrec->prev;
		sp[i].old_digrec->prev->next = sp[i].old_digrec->next;
		sp[i].old_digrec->next->prev = sp[i].old_digrec->prev;
	    }
	    else {
		/*...only forward ptr exists...*/
		if(sp[i].accepted_digrec_head == sp[i].old_digrec)
		   sp[i].accepted_digrec_head = sp[i].old_digrec->next;
		sp[i].old_digrec->next->prev = NULL;
	    }
	  }
	  else if (sp[i].old_digrec->prev) {
	    /*...only backward ptr exists...*/
	    if(sp[i].accepted_digrec_tail == sp[i].old_digrec)
		sp[i].accepted_digrec_tail = sp[i].old_digrec->prev;
	    sp[i].old_digrec->prev->next = NULL;
	  }
	  /*...now delete this ptr...*/
	  free_digrec (sp[i].old_digrec);
	  sp[i].old_digrec = NULL;
	}
/*.........cmam .. end of changes 10-11-96......*/
 
            if (sp[i].accepted_digrec_head) {
               free_all_digrec (sp[i].accepted_digrec_head) ;     
               sp[i].accepted_digrec_head = sp[i].accepted_digrec_tail
                               =  NULL ;
            }

         }

         if (i == CDP) {
            update_message ("Plotting CDP data") ;
            sp[CDP].display_type = 1 ;
            numpix = 1 ;
            sp[CDP].create1 = 1;
         }
         else if (i == TP) {
            update_message ("Plotting SCAN data") ;
            sp[TP].display_type  = 7 ;
            numpix = 2 ;
            sp[TP].create1 = 1;
         }

         ierr = 0 ;        
         sp[i].file_flag=0;
         sp[i].direction = 0;
         sp[i].ts = 0;
         sp[i].te = (sp[i].nss - 1)*sp[i].smpint;
         sp[i].datamax = sp[i].avg_abs;
         display_timerCB(toplevel, toplevel, NULL);
         draw_it(&ierr, &sp[i], toplevel);
         sp[i].width = sp[i].pixwidth;
         sp[i].height = sp[i].can_hi;

         if(done_moveout && i == CDP) {
          cp_cdp_to_mo(&sp[i],&sp[MO]);
          draw_mo(sp);
         }

         if (ierr) {
            update_message (plotmsg) ;
            return ;
         }

         XtSetArg (args[0], XmNwidth, sp[i].width) ;
         XtSetArg (args[1], XmNheight, sp[i].height) ;
         XtSetValues (sp[i].drawA, args, 2) ;
         if (i == TP && !done_moveout) {
            initialize_velplot (&sp[i]) ;
          }

/*
**       First time through, install expose callback and event handlers
**       otherwise they will crater if envoked before data and displays exist
*/

         if (first_time[sp[i].which]) {
            first_time[sp[i].which] = False ;
            XtAddCallback (sp[i].drawA,
                           XmNexposeCallback, (XtCallbackProc)exposeCB, sp) ;

            if (i == TP) {
               XtAddCallback (sp[i].velplot->drawA,
                              XmNexposeCallback, (XtCallbackProc)exposeCB, sp) ;

               XtAddEventHandler (sp[i].drawA,
                                  ButtonPressMask |
                                  LeaveWindowMask |  
                                  PointerMotionMask,
                                  False, (XtEventHandler)handle_eventsCB, sp) ;


               XtAddEventHandler (sp[i].velplot->drawA,
                                  LeaveWindowMask | 
                                  PointerMotionMask,
                                  False, (XtEventHandler)handle_eventsCB, sp) ;
            }
            else {
               XtAddEventHandler (sp[i].drawA,
                                  LeaveWindowMask |
                                  PointerMotionMask,
                                  False, (XtEventHandler)handle_eventsCB, sp) ;
            }
         }

         clear_message() ;

/*
**     Update the new display using a cheap trick to generate an expose
*/
         XtUnmanageChild (sp[i].drawA) ;
         XtManageChild   (sp[i].drawA) ;
         if(done_moveout && i == CDP) {
          XtUnmanageChild (sp[MO].drawA) ;
          XtManageChild   (sp[MO].drawA) ;
         }
         if (i == TP) {
           XtUnmanageChild (sp[i].velplot->drawA) ;
           XtManageChild   (sp[i].velplot->drawA) ;
         }

/*
**       ReDraw any picks and velocity functions that exist
*/
         if (i == TP ) {
          draw_new_picks (&sp[i]) ;
         }

/*
**       Save current state for test to see if read or plot needed next time
*/
         savem[i].rec_st            = sp[i].rec_st ;
         savem[i].rec_end           = sp[i].rec_end ;
         savem[i].inches_per_second = sp[i].inches_per_second ;
         savem[i].traces_per_inch   = sp[i].traces_per_inch ;
         savem[i].maxovlp           = sp[i].maxovlp ;
         savem[i].scalr             = sp[i].scalr ;
         savem[i].agc               = sp[i].agc   ;
         savem[i].agclw             = sp[i].agclw ;
         if (saved[i]) {
            (void) free((char*) savem[i].file) ;
	    savem[i].file = NULL;
	 }
         savem[i].file =
             (char *) malloc((unsigned)(strlen(sp[i].file)+1) * sizeof(char)) ;
         strcpy (savem[i].file,sp[i].file) ;
         saved[i] = TRUE ;
         XtUnmanageChild (sp[i].drawA) ;
         XtManageChild   (sp[i].drawA) ;
   
      }
   }
/*
**  Now make sure that the data sets have the same record numbers,
**  or at least the smaller data set has a subset of the numbers on
**  the larger, before we go any further.  The initial tests made
**  sure the start and end records were on the data set, but
**  need to make sure they are in the same order.
*/
    if((sp[CDP].end_rec - sp[CDP].st_rec) !=
       (sp[TP].end_rec - sp[TP].st_rec)) {
        fprintf(stderr,"Data Sets don't agree in number of records\n");
        fprintf(stderr," %d records has been displayed for data set 1 (CDP)\n", (sp[CDP].end_rec - sp[CDP].st_rec)+1);
        fprintf(stderr," %d records has been displayed for data set 2 (CMO)\n", (sp[TP].end_rec - sp[TP].st_rec)+1);
        return;
    }

/*
** Enable all function to operate now
*/
   XtSetSensitive (readp_button, True) ;
   XtSetSensitive (savep_button, True) ;
   XtSetSensitive (clearp_button, True) ;
   XtSetSensitive (copyp_button, True) ;
   XtSetSensitive (colr_button, True) ;
   XtSetSensitive (vboard_button, True) ;
   for (i = 0 ; i < MAX_DIG_OPT ; i++)
      XtSetSensitive (dig_option[i], True) ;
   if(!allow_moveout) XtSetSensitive(apmo_button, False);

   cp_cdp_to_mo(&seisplot[CDP],&seisplot[MO]);

}
/*
** Create the velocity plotting area, clear and draw record numbers, dividers
*/

void initialize_velplot (sp)
Seisplot *sp ;
{
   extern int depth;

   int i, j, mb, lenr, x, y, vwid ;
   char cchron[7] ;
   Arg args[2] ;

   vwid = sp->velplot->width * (sp->end_rec - sp->st_rec + 1) ;
   XtSetArg (args[0], XmNwidth, vwid) ;
   XtSetArg (args[1], XmNheight, sp->height) ;
   XtSetValues (sp->velplot->drawA, args, 2) ;

   if (sp->velplot->pixmap)
      XFreePixmap(display, sp->velplot->pixmap);
   sp->velplot->pixmap = XCreatePixmap(display, sp->velplot->window,
                          (unsigned)vwid, (unsigned)sp->height,(unsigned) depth);

   if (sp->velplot->backup)
      XFreePixmap(display, sp->velplot->backup);
   sp->velplot->backup = XCreatePixmap(display, sp->velplot->window,
                          (unsigned)vwid, (unsigned)sp->height,(unsigned) depth);

   XSetForeground (display, gc, white) ;
   XFillRectangle(display, sp->velplot->pixmap, gc,
                  0, 0, (unsigned) vwid, (unsigned) sp->height);
   XFillRectangle(display, sp->velplot->backup, gc,
                  0, 0, (unsigned) vwid, (unsigned) sp->height);
   XSetForeground (display, gc, black) ;
   y = sp->yorg + (int)((float)sp->nss * sp->pix_per_sample) ;
   for (i = sp->st_rec ; i <= sp->end_rec ; i++) {
      x = i * sp->velplot->width ;
      XDrawLine (display, sp->velplot->pixmap, gc, x, sp->yorg, x, y) ;
      XDrawLine (display, sp->velplot->backup, gc, x, sp->yorg, x, y) ;
      sprintf(cchron, "%d", sp->irec_buf[i]);
      mb = 5 * num_font.height;
      lenr = strlen(cchron);
      mb = mb - ((lenr-1) * num_font.height);
      for (j = 0; j < lenr; j++) {
         XDrawString (display, sp->velplot->pixmap, gc,
                      x+2, mb, cchron+j, (int)1);
         XDrawString (display, sp->velplot->backup, gc,
                      x+2, mb, cchron+j, (int)1);
         mb += num_font.height;
      }
   }
}
/*
** Copy all member of a seisplot structure
*/

void copy_seisplot (to_struct, from_struct)
Seisplot *to_struct, *from_struct ;
{
      *to_struct = *from_struct ;
}
/*
** Invoke Color Editor
*/

XtCallbackProc adj_colorsCB(w, sp, call)
Widget w ;
Seisplot *sp ;
caddr_t call ;
{
   extern void DisplayColorEditor() ;

   /* Save pointer to be used by limits_change() */
   global_sp = sp ;
   DisplayColorEditor();
}
/*
** Color Editor calls this is colormap endpoints are changed
*/

void limits_change(def_cm)
/*void limits_change()*/
Colormap	def_cm ;
{
   int ierr, numpix=2, strc, etrc;
   char plotmsg[255] ;
   extern void update_message(), clear_message(), draw_it() ;
   extern XtCallbackProc display_timerCB();
	extern void draw_new_picks();

   update_message ("Re-Plotting SCAN data") ;

   display_timerCB(toplevel, toplevel, NULL);
   ierr = 0 ;        
   draw_it(&ierr, global_sp, toplevel);

   if (ierr) {
      update_message (plotmsg) ;
      return ;
   }

   draw_new_picks(global_sp) ;
   clear_message() ;

   XtUnmanageChild (global_sp->drawA) ;
   XtManageChild   (global_sp->drawA) ;
   XtUnmanageChild (global_sp->velplot->drawA) ;
   XtManageChild   (global_sp->velplot->drawA) ;
}
/*
** Get out of here, adios amigos, sayonara, auf wiedersehen, bye-bye
*/

XtCallbackProc exit_nowCB (w, client, call)
Widget w ;
caddr_t client, call ;
{
   XCloseDisplay (display) ;
   exit (0) ;
}
/*
** This one does what is says
*/

XtCallbackProc unmanage_widgetCB (w, client, call)
Widget      w, client ;
caddr_t     call ;
{
   XtUnmanageChild (client) ;
}
/*
** This one does what is says
*/

XtCallbackProc manage_widgetCB (w, client, call)
Widget      w, client ;
caddr_t     call ;
{
   XtManageChild (client) ;
}
/*
** Reset proportional position of CDP right and TP left side scrolled window
*/

XtCallbackProc setup_window1CB (w, sw, call)
Widget      w ;
Widget      *sw ;
XmScaleCallbackStruct  *call ;
{
   static int  percent ;
   Arg args[1] ;

   percent = call->value/2 ;
   percent = (percent>49) ? 49 : percent ;
   percent = (percent<3)  ?  3 : percent ;
   XtSetArg (args[0], XmNrightPosition, percent) ;
   XtSetValues (sw[CDP], args, 1) ;
   XtSetArg (args[0], XmNleftPosition, percent) ;
   XtSetValues (sw[TP], args, 1) ;
}
/*
** Reset proportional position of TP right and VEL left side scrolled window
*/

XtCallbackProc setup_window2CB (w, sw, call)
Widget      w ;
Widget      *sw ;
XmScaleCallbackStruct  *call ;
{
   static int  percent ;
   Arg args[1] ;

   percent = call->value/2+50 ;
   percent = (percent>97) ? 97 : percent ;
   percent = (percent<52) ? 52 : percent ;
   XtSetArg (args[0], XmNrightPosition, percent) ;
   XtSetValues (sw[TP], args, 1) ;
   XtSetArg (args[0], XmNleftPosition, percent) ;
   XtSetValues (sw[VEL], args, 1) ;
}
/*
** Get file name from file selection box, open dataset, get first record number
*/

XtCallbackProc open_seismicCB (w, sp, call)
Widget w ;
Seisplot  *sp ;
XmFileSelectionBoxCallbackStruct   *call ;
{
   int    i, j, len, luin, nbytes, error, ifrec, lineheader[6000] ;
   Arg args[4];
   static int cdp_ok=FALSE, tp_ok=FALSE ;
   float rtr[MAXSAMP] ;
   char   first_rec[7], string[100];
   char *hold1, *hold2;
   extern char *strip();
   XmString  xmstring;
   extern void update_message(), update_text() , update_error() ;
   if (sp->file) {
      (void) free((char *) sp->file);
      sp->file = NULL;
   }
   XmStringGetLtoR(call->value, XmSTRING_DEFAULT_CHARSET, &(sp->file)) ;

   if(sp->which == CDP ) {
     len = strlen(sp->file); j=len;
     hold1 = (char *)calloc(j+2, sizeof(char));
     hold2 = (char *)calloc(j+2, sizeof(char));
     strcpy(hold1, sp->file);
     memset(hold1+j, '\0',1);
     len--; 
     strcpy(hold2, strip(hold1));
     free(hold1);
     XtSetArg(args[0], XmNlabelString,
        XmStringCreateLtoR(hold2, XmSTRING_DEFAULT_CHARSET));
     XtSetValues(lab_cdp, args, 1);
     free(hold2);
   }
   else {
     len = strlen(sp->file); j=len;
     hold1 = (char *)calloc(j+2, sizeof(char));
     hold2 = (char *)calloc(j+2, sizeof(char));
     strcpy(hold1, sp->file);
     memset(hold1+j, '\0',1);
     len--; 
     strcpy(hold2, strip(hold1));
     free(hold1);
     XtSetArg(args[0], XmNlabelString,
        XmStringCreateLtoR(hold2, XmSTRING_DEFAULT_CHARSET));
     XtSetValues(lab_cmo, args, 1);
     free(hold2);
   }

   C_LBOPEN(&luin, sp->file, "r");
   if (luin != -1) {
      if(sp->recbuf) {
	free(sp->recbuf);
	sp->recbuf = NULL;
      }
/*..added 2 buffers to hold li and di numbers of each tr 1..*/
      if(sp->libuf) {
	free(sp->libuf);
        sp->libuf = NULL;
      }
      if(sp->dibuf) {
	free(sp->dibuf);
        sp->dibuf = NULL;
      }
/*..........................................................*/
      sp->trecs = 0;
      /*..sp->trecs = get_ri(&luin, &sp->recbuf);..*/
/*..retrieve li and di values as well as rec numbers...*/
      sp->trecs = get_ri(&luin, &sp->recbuf, &sp->libuf, &sp->dibuf );
      C_SISABORT(luin, "off");
      nbytes = 0;
      C_RTAPE(luin, lineheader, &nbytes);
      C_SISERROR(luin, &error);
      C_SISABORT(luin, "on");
      if (error == 0) {
         C_SAVER(lineheader, "NumSmp", &(sp->nss), LINHED);
         if (sp->which == CDP) {
            nbytes = 0;
            C_RTAPE(luin, rtr, &nbytes); 
            if(nbytes) {
               C_SAVER(rtr,"RecNum", &ifrec, TRCHED);
               sprintf (first_rec, "%d", ifrec) ;
               /*sprintf (first_rec, "%6d", ifrec) ;*/
               update_text (texts[0], first_rec) ; 
               update_text (texts[1], first_rec) ; 
               sprintf (first_rec, "%d", 1);
               /*sprintf (first_rec, "%6d", 1);*/
               update_text (texts_a[0], first_rec) ; 
               update_text (texts_a[1], first_rec) ; 
               cdp_ok = TRUE ;
               if (tp_ok)
                  XtSetSensitive (disp_button, True) ;
            }
            else {
               sprintf(string, "Error scanning first trace in %s", sp->file);
               update_message (string) ;
            }
         }
         else if (sp->which == TP) {
            tp_ok = TRUE ;
            if (cdp_ok)
               XtSetSensitive (disp_button, True) ;
         }
      }
      else {
         if (error == 20)
            sprintf(string, "%s is not SIS format", sp->file) ;
         else
            sprintf(string, "Error %d reading %s", error, sp->file) ;
         XBell (display, 0) ;
         update_error (string) ;
      }
      C_LBCLOS(luin);
   }
   else {
      sprintf(string, "Could not open file %s", sp->file);
      update_message (string) ;
   }    
}
/*
** A Drawing Area managed by a scrolled window only exposes when scrolled
** and this handles general exposes taboot.
*/

XtCallbackProc exposeCB (w, sp, call)
Widget    w ;
Seisplot  *sp ;
XmDrawingAreaCallbackStruct *call ;
{
   XExposeEvent *xpose ;

   xpose = (XExposeEvent *) call->event ;
   if (w == sp[CDP].drawA) {
      XCopyArea (display, sp[CDP].pixmap, XtWindow(w), gc,
                 xpose->x, xpose->y,
                 xpose->width, xpose->height,
                 xpose->x, xpose->y) ;
   }
   else if (w == sp[TP].drawA) {
      XCopyArea (display, sp[TP].pixmap, XtWindow(w), gc,
                 xpose->x, xpose->y,
                 xpose->width, xpose->height,
                 xpose->x, xpose->y) ;
   }
   else if (w == sp[TP].velplot->drawA) {
      if(done_moveout)
      XCopyArea (display, sp[MO].pixmap, XtWindow(w), gc,
                 xpose->x, xpose->y,
                 sp[MO].width, sp[MO].height,
                 xpose->x, xpose->y) ;
      else
      XCopyArea (display, sp[TP].velplot->pixmap, XtWindow(w), gc,
                 xpose->x, xpose->y,
                 xpose->width, xpose->height,
                 xpose->x, xpose->y) ;
   }
   else
      printf("\nunknown window %d exposed",(int)XtWindow(w)) ;
}
/*
** Reset digitization mode and handle mode switching contingencies
*/

XtCallbackProc set_digmodeCB (w, sp, call)
Widget      w ;
Seisplot    *sp ;
caddr_t     call ;
/*XmScrollBarCallbackStruct  *call ;*/

{
   int i, draw ;
/*....*/
   int min, val, max, value, hvalue, dummy, slider_size, increment, page ;
/*....*/
   static int old_digmode = EDIT ;
   extern void clear_message(), clear_seismic_area(), clear_velocity_area(),
               draw_xy_picks(), draw_vfunc() ;
	extern void free_digits();
   Arg args[3];

   for (i = 0; i < MAX_DIG_OPT ; i++)
      if (dig_option[i] == w)
         digmode = i ;

   clear_message () ;

   if (digmode == NEW) 
     XtSetSensitive (apmo_button, False) ;
   else
     XtSetSensitive (apmo_button, True);

   if(done_moveout) {
/*....*/
      XmScrollBarGetValues(hsb[CDP], &dummy, &slider_size, &increment, &page);
      XtSetArg (args[0], XmNmaximum, &max) ;
      XtSetArg (args[1], XmNminimum, &min) ;
      XtGetValues (hsb[CDP], args, 2) ;
	val = (valhsb - min) / (max - min);
	/*val = (slider_size - min) / (max - min);*/
      XmScrollBarGetValues(hsb[VEL], &dummy, &slider_size, &increment, &page);
      XtGetValues (hsb[VEL], args, 2) ;
	hvalue = min + val*(max - min);
      /*if (hvalue >= max - slider_size) hvalue = max - slider_size - 1 ;*/
      if (hvalue < 0) hvalue = 0 ;
      /*call->value = hvalue ;*/
      XmScrollBarSetValues(hsb[VEL], hvalue, slider_size, increment,
	page, True);
	/*page, False);*/
 
      /*XtCallCallbacks (hsb[VEL], XmNdragCallback, call) ;
      XtCallCallbacks (hsb[VEL], XmNtoTopCallback, call) ;
      XtCallCallbacks (hsb[VEL], XmNtoBottomCallback, call) ;
      XtCallCallbacks (hsb[VEL], XmNincrementCallback, call) ;
      XtCallCallbacks (hsb[VEL], XmNdecrementCallback, call) ;
      XtCallCallbacks (hsb[VEL], XmNpageIncrementCallback, call) ;
      XtCallCallbacks (hsb[VEL], XmNpageDecrementCallback, call) ;*/
/*....*/

     XtSetArg (args[0], XmNwidth, sp->width) ;
     XtSetArg (args[1], XmNheight, sp->height) ;
     XtSetValues (sp->velplot->drawA, args, 2) ;
     XtUnmanageChild (sp->velplot->drawA) ;
     XtManageChild   (sp->velplot->drawA) ;
/*@@@ dr - leave the moveout plot intact @@@*/
     if( !done_moveout )
       done_moveout = 0;
   }
   draw = FALSE ;
   if (digmode != MOVE && old_digmode == MOVE) {
      /* cancel move operation */
      moving = FALSE ;
      draw = TRUE ;
   }
   else if (digmode != NEW && old_digmode == NEW) {
      /* cancel new function not accepted yet when mode changed */
      free_digits (sp->new_digits) ;
      sp->new_digits = NULL ;
      draw = TRUE ;
   }
   old_digmode = digmode ;

   if (draw) {
      clear_seismic_area  (sp, 0, 0) ;
      clear_velocity_area (sp, 0, 0) ;
      if (sp->old_digrec) {
         draw_xy_picks (sp, sp->old_digrec->digits, black) ;
         draw_vfunc    (sp, sp->old_digrec->digits, apcolor) ;
      }
   }
}
/*
** This is the one everybody hates to implement
*/

XtCallbackProc helpCB (w, client, call)
Widget      w ;
caddr_t     client, call ;
{
int i;
i = 0;
}
/*
** For interface development convenience as a stub for newly registered
** callbacks before the real one is hacked out
*/

XtCallbackProc noopCB (w, client, call)
Widget      w ;
caddr_t     client, call ;
{
   if (dbx) printf("\nHello from noopCB") ;
}

char *
strip(string)
char *string;
{
   int i,n,m;

   n = strlen(string);

   m = 0;
   for (i=n-1; i>=0; i--) {
        if (memcmp(string+i,"/",1) == 0) {
            m = i+1;
            break;
        }
    }
    return(string+m);
}
XtCallbackProc get_save_pick_parmsCB(w, sp, call)
Widget w;
Seisplot *sp;
caddr_t call;
{
   int i, k, ierr, nread, srec, erec, strc, etrc, maxovlp;
   int ssrec, serec;
   int numpix ;
   int n, m, st_rec, end_rec;
   float ips, tpi, scalr ;
   String string;
   Arg args[2] ; 


   save_picks_type = 0;
   if(XmToggleButtonGadgetGetState(save_type_toggle[1]) == True)
     save_picks_type = 1;
}
