/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
/************************************************************************
 * X  includes  
 ************************************************************************/
#include <Xm/Xm.h>

int CopyColormapToPrivate(Display *dpy, 
			  Colormap DefCmap, 
			  Colormap *NewCmap, 
			  int NCmin )
{
/*********************************************************************** 
  The function allocates a NCmin of R/W colors in the private color map. 
  It also copies as many as possible colors used by other applications
  in global color map into the privat colormap, which results in 
  illumination of color 'flashing'.  
  Drawbacks:	
	*) This is a hack, the X11 does not provide the means to do
	   it properly.  So, be warned
	*) Any program allocating colors in the global colormap, 
	   which is started started after the program calling 
	   CopyColormapToPrivate was launched will have its colors
	   flashing
 ***********************************************************************/
  XColor  DefColors[256]; /* Copy of the colormap                  */
  int     nfreecol = 0;   /* Number of free colors in the colormap */
  XColor  CopyColor ;     /* Copy of the color */       
  Pixel   junkpix;
  int     i;
  int     NColCanCopy = 256;

printf(" CopyColormapToPrivate\n");

  /* Initialize work array */
  for( i=0 ; i<256 ; i++ ) DefColors[i].pixel = (Pixel) i;

  /* Grab all the free colors in the Default colormap */
  while( XAllocColorCells(dpy,DefCmap,False,NULL,0,&junkpix,1) || nfreecol>256 )
  {
    DefColors[junkpix].pixel = (Pixel)(-1);  /* This pixel is free */
    nfreecol++;
  }
  nfreecol--;

  /* If we could not allocate enough colors */
  if( nfreecol < NCmin ) {
    NColCanCopy = 256 - NCmin;
    fprintf(stderr,
	    "*** WARNING: Not enough free colors: %d available and %d requested\n"
	    "*** WARNING: Will keep only %d colors allocated by other applications\n"
	    "*** WARNING: Some color 'flashing' can appear... \n",
	    nfreecol, NCmin, NColCanCopy);
    nfreecol    = NCmin;
  }

  /* Copy all the allocated colors from the Default colormap */ 
  for( i=0 ; i<256 ; i++ ) {
    if( DefColors[i].pixel != (Pixel)(-1) ) {  /* Allocated color */
       XQueryColor(dpy, DefCmap, &DefColors[i]);
    }
  }

  /* Create a new colormap, where all Free Default-colormap colors are taken  */
  *NewCmap = XCopyColormapAndFree( dpy, DefCmap );

  /* Reallocate all allocated Default-colormap colors as read only */
  for( i=0 ; i<256 ; i++ ) {
    if( DefColors[i].pixel != (Pixel)(-1) && NColCanCopy > 0) {
      CopyColor.red   = DefColors[i].red;
      CopyColor.green = DefColors[i].green;
      CopyColor.blue  = DefColors[i].blue;
      CopyColor.flags = DoRed | DoGreen | DoBlue;
      XAllocColor(dpy, *NewCmap, &CopyColor);
      NColCanCopy--;
      /* Color was allocated twice, allocate it as R/W color */
      if( CopyColor.pixel != DefColors[i].pixel ) {
	  XAllocColorCells(dpy, *NewCmap, False, NULL, 0, &CopyColor.pixel, 1);
	  XStoreColor     (dpy, *NewCmap, &CopyColor);
      }
    }
  }

  /* Now, free all Free Default-colormap colors */
  for( i=0 ; i<256 ; i++ ) {
    if( DefColors[i].pixel == (Pixel)(-1) ) {
      junkpix = i;
      if( ! XFreeColors(dpy, *NewCmap, &junkpix, 1, 0) )  {
	/*
	fprintf(stderr,
		"***WARNING: failed to free temporary allocated color %d "
		"in the private colormap\n", i);
	*/
      };
    }
  }

  /* Return the number of free colors in the new colormap */
  return (nfreecol);
}

