/*********************************************************************
**
** Program name: create_data_dialog
**
** Languate:     C
**
** Author:       Richard Crider
**
** Date written: June, 1992
**
**
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
**
** Abstract:
**
** Modification history:
**
************************************************************************
**
*/

#include "xos.h"
#include "globals.h"

XmStringCharSet charsetb = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;

Widget create_data_dialog (sp, parm_panel, parent)
Seisplot *sp;
Widget parm_panel;
Widget parent;
{ 
   int n ;
   Arg args[10] ;
   Widget   bboard, dialog1, dialog2,rca, rcb, crr, rcd, rc2;
   Widget   seper, lab;
   Widget   pb_ok, pb_dismiss;
   XmString xmstring ; 

   extern XtCallbackProc manage_widgetCB(), 
          unmanage_widgetCB(), open_seismicCB();

   /* file dialog */

   n = 0;
   xmstring = XmStringCreateLtoR("Data File Selection", charsetb);
   XtSetArg(args[n], XmNdialogTitle, xmstring); n++;
   bboard = XmCreateBulletinBoardDialog (parent, "Load Seismic Data",
                                            args, n);
   XmStringFree(xmstring);

    n = 0;
    XtSetArg(args[n], XmNorientation, XmVERTICAL ); n++;
    rca = XmCreateRowColumn(bboard, "workarea", args, n);
    XtManageChild(rca);

    n = 0;
    XtSetArg(args[n], XmNpacking, XmPACK_TIGHT ); n++;
    XtSetArg(args[n], XmNspacing, 30 ); n++;
    XtSetArg(args[n], XmNorientation, XmHORIZONTAL ); n++;
    rcb = XmCreateRowColumn(rca, "workarea", args, n);
    XtManageChild(rcb);

    n = 0;
    XtSetArg(args[n], XmNorientation, XmVERTICAL ); n++;
    crr = XmCreateRowColumn(rcb, "workarea", args, n);
    XtManageChild(crr);

   n = 0;
   XtSetArg(args[n], XmNselectionLabelString,
      XmStringCreateLtoR("Selection -  CDP Data", charsetb)); n++;
   XtSetArg(args[n], XmNlistVisibleItemCount, 20); n++;
   dialog1 = XmCreateFileSelectionBox(crr, "cdpdialog", args,n);
   XtManageChild(dialog1);
   XtAddCallback(dialog1, XmNokCallback,
       (XtCallbackProc)open_seismicCB, &sp[CDP]);

   n = 0 ;
   XtSetArg (args[n], XmNlabelString, 
          XmStringCreateLtoR("Selected CDP Data file:", charsetb)); n++ ;
   lab = XmCreateLabel (crr, "lab", args, n) ;
   XtManageChild (lab) ;

   n = 0 ;
   XtSetArg (args[n], XmNlabelString, 
             XmStringCreateLtoR(" ", charsetb)) ; n++ ;
   lab_cdp = XmCreateLabel (crr, "lab", args, n) ;
   XtManageChild (lab_cdp) ;

   n = 0;
   XtSetArg(args[n], XmNorientation, XmVERTICAL ); n++;
   crr = XmCreateRowColumn(rcb, "workarea", args, n);
   XtManageChild(crr);

   n = 0;
   XtSetArg(args[n], XmNselectionLabelString,
      XmStringCreateLtoR("Selection -  CMO Data", charsetb)); n++;
   XtSetArg(args[n], XmNlistVisibleItemCount, 20); n++;
   dialog2 = XmCreateFileSelectionBox(crr, "cmodialog", args,n);
   XtManageChild(dialog2);
   XtAddCallback(dialog2, XmNokCallback,
       (XtCallbackProc)open_seismicCB, &sp[TP]);

   n = 0 ;
   XtSetArg (args[n], XmNlabelString, 
        XmStringCreateLtoR("Selected CMO Data file:", charsetb)); n++ ;
   lab = XmCreateLabel (crr, "lab", args, n) ;
   XtManageChild (lab) ;

   n = 0 ;
   XtSetArg (args[n], XmNlabelString, 
             XmStringCreateLtoR(" ", charsetb)) ; n++ ;
   lab_cmo = XmCreateLabel (crr, "lab", args, n) ;
   XtManageChild (lab_cmo) ;

   n = 0;
   seper = XmCreateSeparatorGadget(rca, "sepe", args, n);
   XtManageChild (seper) ;

   n = 0 ;
   XtSetArg (args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++ ;
   rc2 = XmCreateRowColumn (rca, "rca", args, n) ;
   XtManageChild (rc2) ;
  
   n = 0;
   XtSetArg(args[n], XmNshowAsDefault, 1); n++;
   pb_ok = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, rc2, args, n);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)manage_widgetCB,parm_panel);

   n = 0;
   XtSetArg(args[n], XmNdefaultButton, pb_ok); n++;
   XtSetValues(bboard,args,n);

   pb_dismiss = XtCreateManagedWidget("cancel", xmPushButtonWidgetClass,
                 rc2, NULL, 0);
   XtAddCallback(pb_dismiss, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);

   return (bboard);


}
