/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "xos.h"
#include "globals.h"
#ifdef hpux
#define vmov_ vmov
#endif
#ifdef CRAY
#define vmov_ VMOV
#endif

void
cp_cdp_to_mo(sp1,sp2)
Seisplot *sp1, *sp2;
{
   int i;

    sp2->st_rec = sp1->st_rec;
    sp2->end_rec = sp1->end_rec;
    sp2->end_rec = sp1->end_rec;
    sp2->rec_st = sp1->rec_st;
    sp2->rec_end = sp1->rec_end;
    sp2->nrecs = sp1->nrecs;
    sp2->irec_ctr = sp1->irec_ctr;
    if(sp2->irec_buf != NULL) free(sp2->irec_buf);
    sp2->irec_buf = (int *)calloc(sp2->nrecs, sizeof(int));
    for (i=0; i< sp2->nrecs; i++)
      sp2->irec_buf[i] = sp1->irec_buf[i];
    sp2->inches_per_second = sp1->inches_per_second;
    sp2->traces_per_inch = sp1->traces_per_inch;
    sp2->maxovlp = sp1->maxovlp;
    sp2->scalr = sp1->scalr;
    sp2->display_type = sp1->display_type;
    sp2->ntrace = sp1->ntrace;
    sp2->nss = sp1->nss;
    sp2->ntr = sp1->ntr;
    sp2->smpint = sp1->smpint;
    sp2->datamax = sp1->datamax;
    sp2->avg_abs = sp1->avg_abs;
    sp2->ts = sp1->ts;
    sp2->te = sp1->te;
    sp2->direction = sp1->direction;
    sp2->file_flag = sp1->file_flag;
    sp2->width = sp1->width;
    sp2->height = sp1->height;
    sp2->xoffset = sp1->xoffset;
    sp2->slowbuf = sp1->slowbuf;
    sp2->agc = sp1->agc;
    sp2->agclw = sp1->agclw;
    if(sp2->file != NULL)    free(sp2->file);
    sp2->file =(char *)malloc(((unsigned)strlen(sp1->file)+1)*sizeof(char));
    /*sp2->file =(char *)malloc((unsigned)strlen(sp1->file)*sizeof(char));*/
    strcpy(sp2->file, sp1->file);
}

XtCallbackProc do_moveoutCB(w, sp, call)
Widget w ;
Seisplot *sp;
caddr_t   call ;
{
  int     m, i, j, k,kk , n,k3;
  float   dig_int, record, trace, time , tol;
  Digits *dg ;
  Digrec *dr;
  float  *tarr, *v, *time_arr, *t, *evel, sr,offset,fsr;
  float  *vdata;
  int     one=1;
  float   slow;
  int     nvel, rec, nss, ntr, nrecs, remove;
  int ierror;

  float  *work;  /* TEMPORARY ARRAY TO BE PASSED TO apnmo, WORK(1:ns+ns/2) */ 

/*....cmam.........................*/
	Digrec **dg_sort;
	int *dg_rec, num, l, ll, krec, kfirst, rec1;
/*.................................*/

   extern float get_vstk();
   extern void update_message(), apnmo_(), draw_mo(), bvel_();
   extern void aptaup_();
   extern void writer_();
	extern void shynmo_();


  if(!allow_moveout) return;
  fsr = (float)seisplot[CDP].smpint;
  nrecs = seisplot[CDP].nrecs;
  sr = fsr * .001;
  if(seisplot[CDP].smpint > 16 ) sr *= .001;
  ntr = seisplot[CDP].ntr;
  nss = seisplot[CDP].nss;
  tarr = (float *)calloc(nss, sizeof(float));
  evel = (float *)calloc(nss, sizeof(float));
  if(mo_type == 1) vdata = (float *)calloc(nss, sizeof(float));
  time_arr = (float *)calloc(nss, sizeof(float));
  
     dg_sort = (Digrec **) calloc(nrecs, sizeof(Digrec *));
     dg_rec  = (int *) calloc(nrecs, sizeof(int));
     work    = (float *) calloc(nss+nss/2, sizeof(float));
/**** DR:98.02.03 *** ME MUST INITIALIZE THE DATA IF WE LATER CHECK FOR NULL */
     for( i=0 ; i<nrecs ; i++ ) {
       dg_sort[i] = NULL;
       dg_rec[i]  = -999;
     }
/*****/

  dr = seisplot[TP].accepted_digrec_head;

/*..cmam..if dr=NULL, there are no functions to apply...*/
  if(dr == NULL) {
    XtSetSensitive (apmo_button, False) ;
    return;
  }

  num = 0;
  for (i=0; dr != NULL ; i++) {
    dg = dr->digits;
    dr->v = (float *)calloc(nss, sizeof(float));
    dr->t = (float *)calloc(nss, sizeof(float));
    dr->nv = 0;
    for(j = 0; dg != NULL; j++) {
      dr->v[dr->nv] = get_vstk(&seisplot[TP], dg->trc, dg->t0);
      dr->t[dr->nv] = (float)dg->t0 * .001;
      dr->nv++;
      dg = dg->next;
    }
    dg_sort[i] = dr;
    ll = dr->rec;
    dg_rec[i] = seisplot[CDP].irec_buf[ll];
    num ++;
    dr = dr->next;
  }
/*....cmam....sort the Digrec pointers into order of ascending
		associated record numbers........................*/

  for (i=0; i < num; i++) {
    for (j=1; j < num-i; j++) {
      if(dg_rec[j-1] > dg_rec[j]) {
	dr = dg_sort[j-1];
	dg_sort[j-1] = dg_sort[j];
	dg_sort[j] = dr;
	k = dg_rec[j-1];
	dg_rec[j-1] = dg_rec[j];
	dg_rec[j] = k;
      }
    }
    
  }
/*....cmam....make array of sample times (in secs) for use in the new
		shifted hyperbolic moveout function...8-18-95...*/
  for (n=0; n<nss; n++) {
    tarr[n] = (float)n*sr;
  }

   /*...cmam...use first digitized function to correct all the
	records up to the next record having a digitized function...*/
  l = 0;
  dr = dg_sort[0];
  dg = dr->digits;
  rec = dg_rec[0];
  bvel_(dr->t,dr->v,&dr->nv,&nss, &sr, evel);
  
  /**** DR:98.02.03 *** ARRAYS IN C ARE ZERO BASED */
     if(dg_sort[1] == NULL)
        rec1 = -999;
     else
        rec1 = dg_rec[1];
/*
  if(dg_sort[0] == NULL)
    rec1 = -999;
  else
    rec1 = dg_rec[0];
*/
  

  for (i=0; i<nrecs; i++) {
    krec = seisplot[CDP].irec_buf[i];
    /*...cmam...rec1 is -999 when there are no more digitized functions..*/
    if(rec1 != -999) {
      if(krec == rec1) {
	/*...cmam...we have reached the record corresponding to
	  the next digitized function; now, we use that
	  function til we find the next function, or until
	  we finish processing all the records if there
	  are no more functions after this one...*/

	/**** DR:98.02.03 *** INCREMENT AFTERWARDS */
	l++; 
	dr = dg_sort[l];
	dg = dr->digits;
	rec = dg_rec[l];
	bvel_(dr->t,dr->v,&dr->nv,&nss, &sr, evel);
	if(dg_sort[l+1] == NULL)
	  rec1 = -999;
	else
	  rec1 = dg_rec[l+1];
	/* l++; */
      }
    }
    m=i*ntr*nss;
/*....cmam......8-18-95....added new shifted hyperbolic mo function..*/
    if(mo_type==0) {
      /*....i had this backward.....if(mo_type==1) {*/
      /*...........old hyperbolic moveout functions.............*/
      for (n=0; n<ntr; n++) {
	k=n*nss;
	kk = m+k;
	k3 = i*ntr+n;
	offset = (float)seisplot[CDP].xoffset[k3];
	slow = seisplot[CDP].slowbuf[k3];
	if (smode == 4) {
	  tol = 1.;
	  remove = 0;
	  aptaup_(&seisplot[CDP].data[kk],&sr,&nss,&slow,
		  evel,&tol,&remove, &sp[MO].data[kk]) ;
	}
	else
	  /* Added a work array DR:98.02.03 */
	  apnmo_(&seisplot[CDP].data[kk], evel, &offset,
		 &nss, &sr, &seisplot[MO].data[kk], work);  
      }
    }
    else {
/*............new shifted hyperbolic moveout function.......*/
      
      k3 = i * ntr;
      
      vmov_(evel,&one,vdata,&one,&nss);
      shynmo_(&seisplot[CDP].data[m], &nss, &ntr,
	      &seisplot[CDP].xoffset[k3],vdata,tarr,&sr,&ierror,
	      /* &seisplot[CDP].xoffset[k3],evel,tarr,&sr,&ierror, */
	      &seisplot[MO].data[m] );
    }
  }
  

   free(tarr);
   free(evel);
   free(time_arr);
	free(dg_sort);
	free(dg_rec);
	if(mo_type == 1) free(vdata);
   draw_mo(seisplot);
   done_moveout = 1;
}

void draw_mo(sp)
Seisplot *sp;
{
   int i, k, ierr;
   int numpix ;
   int n;
   char plotmsg[255];
   extern XtCallbackProc display_timerCB();
   Arg args[2] ; 
   static Boolean first_time[4] = {True,True,True,True} ;
   static char *data_set[4] = {"CDP", "CMO","   ","MO "};

   extern void draw_it(), clear_message(), update_message();
   extern void update_odometer();
   extern XtCallbackProc exposeCB (), mo_exposeCB() ;
   extern XtEventHandler handle_eventsCB ();


    strcpy(plotmsg,"Plotting Moveout Corrected data");
    update_message (plotmsg);
    sp[MO].display_type = sp[CDP].display_type;
    numpix = 1 ;
    sp[MO].create1 = 1;

    ierr = 0 ;        
    sp[MO].file_flag=0;
    sp[MO].direction = sp[CDP].direction;
    sp[MO].ts = sp[CDP].ts;
    sp[MO].te = sp[CDP].te;
    sp[MO].datamax = sp[CDP].avg_abs;
    display_timerCB(toplevel, toplevel, NULL);
    draw_it(&ierr, &sp[MO], toplevel);
    sp[MO].width = sp[MO].pixwidth;
    sp[MO].height = sp[MO].can_hi;

    if (ierr) {
       update_message (sp[MO].pltmsg) ;
       return ;
    }

    XtSetArg (args[0], XmNwidth, sp[MO].width) ;
    XtSetArg (args[1], XmNheight, sp[MO].height) ;
    XtSetValues (sp[TP].velplot->drawA, args, 2) ;

/*
**       First time through, install expose callback and event handlers
**       otherwise they will crater if envoked before data and displays exist
*/
         clear_message() ;

/*
**      Update the new display using a cheap trick to generate an expose
*/
         XtUnmanageChild (sp[TP].velplot->drawA) ;
         XtManageChild   (sp[TP].velplot->drawA) ;

}


extern void clear_seismic_area();
extern void draw_vfunc();
extern void initialize_velplot();


/*======================================================================
 * Clear NMO corrected semblance and draw the RMS and Interval velocity
 * curves.  Set the flag 'done_moveout' to allow rubberband drawing
 * of the velocity functions upon picks modification
 * DR
 *======================================================================*/
void show_velocityCB(Widget w, Seisplot *sp, XtPointer call)
{
  int     i, rec_save;
  Digrec *old_digrec_save;   /* was int - Joe M. Wade 1/25/2000 */
  Digrec *dr = sp[TP].old_digrec;

   done_moveout = 0;

/*----------------------------------------------------------------------*
 * Clear pixmap from the old velocity function
 *----------------------------------------------------------------------*/
   XSetForeground(display, gc, white);
   XFillRectangle(display, sp[TP].velplot->pixmap, gc,
                  0, 0, (unsigned) sp[TP].velplot->width, 
		        (unsigned) sp[TP].height);

/*----------------------------------------------------------------------*
 * Draw a new velocity function
 *----------------------------------------------------------------------*/
/* draw_vfunc(&sp[TP], sp[TP].old_digrec->digits, apcolor);             */

   if( dr != NULL ) {
     draw_vfunc(&sp[TP], dr->digits, apcolor);
   }
   else if( sp[TP].accepted_digrec_head != NULL ) {
     rec_save        = sp[TP].current_rec;
     old_digrec_save = sp[TP].old_digrec;
     dr              = sp[TP].accepted_digrec_head;
     for (i = 0 ; dr != NULL ; i++) {
       if (dr->rec >= sp[TP].st_rec && dr->rec <= sp[TP].end_rec) {
	 sp[TP].old_digrec  = dr;
	 sp[TP].current_rec = dr->rec ;
	 draw_vfunc(&sp[TP], dr->digits, apcolor);
	 /* printf("Plotting vfunc for rec= %d\n", dr->rec); */
       }
       dr = dr->next;
     }
     sp[TP].current_rec = rec_save;
     sp[TP].old_digrec  = old_digrec_save;
   }
 
/*
**      Update the new display using a cheap trick to generate an expose
*/
   XtUnmanageChild (sp[TP].velplot->drawA) ;
   XtManageChild   (sp[TP].velplot->drawA) ;
}



