/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>

#include <Xm/Xm.h>

void dumpWidgetTree( Widget w )
{
   WidgetList list = NULL;
   Cardinal num_children = 0;
   int i;
   static int n = 0;
   Widget child;
   static char* indent = "-----------------------------------------------------------------------------";
   char tmp[256];

   *tmp = ' ';

   if ( n >= strlen( indent ) +1 )
   {
      printf(
         "ERROR:Widget tree is too deep, not enough indent string ( < %d )!\n",
          n );
      n = 0;
      return;
   }

   strncpy( tmp, indent, n );
   tmp[n] = ' ';

   printf( "%s> Dumping widget tree of %s - %#x \n", tmp, XtName( w ), w );

   if ( ! XtIsComposite( w ) )
   {
      printf(
         "%s>   %s is not a subclass of Composite and therefore has no children\n",
         tmp, XtName( w ) );
      return;
   }

   XtVaGetValues( w,
         XmNchildren, &list,
         XmNnumChildren, &num_children,
         NULL );

   printf( "%s>   %s has %d %s\n", tmp, XtName( w ),
      num_children, num_children == 1 ? "child" : "children" );

   for ( i = 1; i <= num_children; i++ )
   {
      child = list[i-1];
      printf( "%s>   child %2d  %20s \t (%#x)\n", tmp, i, XtName( child ), child );
   }

   printf( "\n" );

   for ( i = 1; i <= num_children; i++ )
   {
      child = list[i-1];
      n += 3;
      dumpWidgetTree( child );

      n -= 3;
   }
   printf( "\n" );
}
