/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <localsys.h>
/* jmw
#ifdef hpux
*/
#include <size_defs.h>
#include <sisio_c.h>
/* jmw
#else
#include <f77/size_defs.h>
#include <f77/sisio_c.h>
#endif
*/

#define SZGRWD 4
#define SZDHWD 2
#define SZDFWD 4
#define NUMBER_OF_TRACES_OFFSET 48
#define NUMBER_OF_RECORDS_OFFSET 52
#define RECORD_NUMBER_OFFSET 210
/*...offsets for LinInd and DphInd..*/
#define LININD_OFFSET 28
/*#define LININD_OFFSET 30*/
#define DPHIND_OFFSET 2

#if (BYTE_ORDER == LITTLE_ENDIAN )
#define CONVERT2(word) (short)(((long)word<<8)&0x0000ff00)|(((long)word>>8)&0x000000ff)
#define CONVERT4(word) (((word<<24)&0xff000000)|((word<<8)&0x00ff0000)|((word>>8)&0x0000ff00)|((word>>24)&0x000000ff))
#endif

#ifdef CRAYSYSTEM
#define SZMHWD 8
#define SZMFWD 8
#else
#define SZMHWD 4
#define SZMFWD 4
#endif

#ifdef CRAYSYSTEM
union {
  struct {
    char dummy[4];
    char value[4];
    } fullword;
  struct {
    char dummy[6];
    char value[2];
    } halfword;
  int value;
  } buffer;
#else
union {
  struct {
    char value[4];
    } fullword;
  struct {
    char dummy[2];
    char value[2];
    } halfword;
  int value;
  } buffer;
#endif

#include "xos.h"
#include "globals.h"

/*..int get_ri(luu,ri_array)..*/
int get_ri(luu,ri_array,li_array,di_array)
int *luu;
int **ri_array;
/*...add buffers for li and di values from tr 1 of each record..*/
int **li_array;
int **di_array;
{
	int is_a_pipe();
	int ri_count = 0, lu;
	unsigned int hdr_byte_count,array_size,skip_size;
	unsigned int no_of_traces,no_of_records;
	void read_err(),write_err();
	int get_full_word(),get_half_word();
	void put_full_word(),put_half_word();
	int location;
	int fit[200];	/* this is currently smaller, but ya never know */

    lu = *luu;
	sisinfo(lu,fit);

	buffer.value = 0;
	if (read(fit[0],&buffer.fullword.value[0],SZGRWD) == 0) read_err();
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	hdr_byte_count = CONVERT4(buffer.value);
#else
	hdr_byte_count = buffer.value;
#endif

	if ( lseek(fit[0],(off_t)NUMBER_OF_TRACES_OFFSET,SEEK_CUR) <= 0) read_err();
	buffer.value = 0;
	if (read(fit[0],&buffer.fullword.value[0],SZGRWD) == 0) read_err();
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	no_of_traces = CONVERT4(buffer.value);
#else
	no_of_traces = buffer.value;
#endif
	buffer.value = 0;
	if (read(fit[0],&buffer.fullword.value[0],SZGRWD) == 0) read_err();
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	no_of_records = CONVERT4(buffer.value);
#else
	no_of_records = buffer.value;
#endif

	*ri_array = (int *)malloc(no_of_records * sizeof(int));
/*..add buffers for li and di values from tr 1 of each record..*/
	*li_array = (int *)malloc(no_of_records * sizeof(int));
	*di_array = (int *)malloc(no_of_records * sizeof(int));
	if ((*ri_array == NULL) || (*li_array == NULL) ||
		(*di_array == NULL)) {
	      fprintf(stderr,"error in memory allocation for %d bytes\n",
		no_of_records);
	      exit(1);
	  }
	array_size = no_of_records;

	if ( lseek(fit[0],(off_t)(hdr_byte_count + SZGRWD),SEEK_SET) <= 0) read_err();

	buffer.value = 0;
	if (read(fit[0],&buffer.fullword.value[0],SZGRWD) == 0) read_err();
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	hdr_byte_count = CONVERT4(buffer.value);
#else
	hdr_byte_count = buffer.value;
#endif
	/*skip_size = no_of_traces*(hdr_byte_count+SZGRWD) - SZDHWD -36;*/
	skip_size = no_of_traces*(hdr_byte_count+SZGRWD) - SZDHWD -32;
	/*..skip_size = no_of_traces*(hdr_byte_count+SZGRWD) - SZDHWD;..*/

	if ( lseek(fit[0],(off_t) RECORD_NUMBER_OFFSET,SEEK_CUR) <= 0) read_err();
	buffer.value = 0;
	while (read(fit[0],&buffer.halfword.value[0],SZDHWD) != 0) {
	  if (ri_count == array_size) {
	    array_size += 100;
	    *ri_array = (int *) realloc(*ri_array,array_size);
/*..add buffers for li and di values from tr 1 of each record..*/
	    *li_array = (int *) realloc(*li_array,array_size);
	    *di_array = (int *) realloc(*di_array,array_size);
	    if ((*ri_array == NULL) || (*li_array == NULL) ||
		(*di_array == NULL)) {
	      fprintf(stderr,"error in memory allocation for %d bytes\n",
		array_size);
	      exit(1);
	      }
	    }
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	  *(*ri_array+ri_count) = CONVERT4(buffer.value);
#else
	  *(*ri_array+ri_count) = buffer.value;
#endif
	  /*..*(*ri_array+ri_count++) = buffer.value;..*/
/*..get LinInd value..*/
        if ( lseek(fit[0],(off_t)LININD_OFFSET,SEEK_CUR) <= 0) read_err();
        buffer.value = 0;
        if (read(fit[0],&buffer.halfword.value[0],SZDHWD) == 0) read_err();
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	  *(*li_array+ri_count) = CONVERT4(buffer.value);
#else
	  *(*li_array+ri_count) = buffer.value;
#endif
/*..get DphInd value..*/
       /*.. if ( lseek(fit[0],DPHIND_OFFSET,SEEK_CUR) <= 0) read_err(); ..*/
        buffer.value = 0;
        if (read(fit[0],&buffer.halfword.value[0],SZDHWD)  == 0) read_err();
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	*(*di_array+ri_count) = CONVERT4(buffer.value);
#else
	*(*di_array+ri_count) = buffer.value;
#endif
	ri_count += 1;
/*....................*/

	  if ( lseek(fit[0],(off_t)skip_size,SEEK_CUR) <= 0) read_err();
	  }
	 
	if (lseek(fit[0],(off_t)0L,SEEK_SET) == -1) {
	  perror("Subroutine get_ri:");
	  exit(1);
	  }

	return(ri_count);
}
void read_err()
{
 	fprintf(stderr,
	  "error in get_ri - error reading input data\n");
	fprintf(stderr,"CDP file=%s\n",seisplot[0].file);
	fprintf(stderr,"TP file=%s\n",seisplot[1].file);
	perror("Subroutine get_ri:");
	exit(1);
}

int get_full_word(source)
char *source;
{
	buffer.value = 0;
	memcpy(buffer.fullword.value,source,SZDFWD);
	return(buffer.value);
}
int get_half_word(source)
char *source;
{
	buffer.value = 0;
	memcpy(buffer.halfword.value,source,SZDHWD);
	return(buffer.value);
}
void put_full_word(source,value)
char *source;
int value;
{
	buffer.value = value;
	memcpy(source,buffer.fullword.value,SZDFWD);
	return;
}
void put_half_word(source,value)
char *source;
int value;
{
	buffer.value = value;
	memcpy(source,buffer.halfword.value,SZDHWD);
	return;
}
