C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       IMAXV                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      IMAXV  (A,IA,C,LC,N)                                            *
C  ARGUMENTS:                                                          *
C      A       INTEGER  ??IOU*  (1) -                                  *
C      IA      INTEGER  ??IOU*      -                                  *
C      C       INTEGER  ??IOU*      -                                  *
C      LC      INTEGER  ??IOU*      -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 94/06/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 94/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****  MAXV    Maximum Element in Vector         MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL MAXV (A,IA,C,LC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output scalar, maximum value detected.
C
C       LC      Integer output number of elements sampled
C               to reach maximum value.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine finds the maximum-value element in a vector
C       and stores it in C.   Output value LC indicates the number
C       of tests that were performed to reach the first occurrence
C       of the maximum value.
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL MAXV (A,1,C,LC,5)
C
C       Input Operands:
C
C       A = 2.000
C          -3.000
C           1.000
C          -2.000
C          -1.000
C
C       Output Operands:
C
C       C =  2.000
C
C       LC = 1
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE IMAXV(A,IA,C,LC,N)
C
      INTEGER IA,N,II,M,LC
      integer A(1),C,TMP
      IF (N.LE.0) GO TO 12
      II = 1
      LC = 1
      TMP = A(1)
      DO 10 M=1,N
        IF (TMP.GE.A(II)) GOTO 7
          TMP = A(II)
          LC = M
7       II = II + IA
10    CONTINUE
      C = TMP
12    RETURN
      END
