C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       INSAMP                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      INSAMP  (X,NX,Y,NY,SI,INIT)                                     *
C  ARGUMENTS:                                                          *
C      X       REAL     ??IOU*  (*) -                                  *
C      NX      INTEGER  ??IOU*      -                                  *
C      Y       REAL     ??IOU*  (*) -                                  *
C      NY      INTEGER  ??IOU*      -                                  *
C      SI      REAL     ??IOU*      -                                  *
C      INIT    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 94/06/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 95/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      GALLOC -                                                        *
C      GFREE  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      AINT    GENERIC -                                               *
C      FLOAT   REAL    -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      100  ( 1) -                                                     *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      2 DETECTED                               *
C      POINTER (PT,TABLE), (PIT,ITABLE)                                *
C      statement out of order :      SAVE PT, PIT,NDO,IST,JALLOC       *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine insamp(x,nx,y,ny,si,init)
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
 
************************************************************************
*                                                                      *
*    SUBROUTINE TO PERFORM STATIC SHIFT USING PARABOLIC                *
*    INTERPOLATION.                                                    *
*                                                                      *
*      ARGUMENTS ARE:                                                  *
*         X  - [R ()] - DATA TO BE SHIFTED                             *
*        NX  - [I   ] - Length of x                                    *
*         Y  - [R ()] - Resampled data (Returned)                      *
*        NY  - [I   ] - Length of resampled data (Returned)            *
*        SI  - [R   ] - Ratio of sample interval of X and Y            *
*                                                                      *
************************************************************************
      real X(*),Y(*)
      real si
      integer ndo,ist(2)
      real table(1)
      integer itable(1)
      POINTER (pt,table), (pit,itable)
      integer init
      data jalloc/0/
      save pt, pit,ndo,ist,jalloc
 
cmam  ISZBYT = 4
      rsi = aint(si)
      if(init.lt.2)then
cmam  if(rsi.eq.1.and.init.eq.0) then
      if(si.eq.1.and.init.eq.0) then
        do i=1,nx
         y(i)=x(i)
        end do
        ny = nx
        return
      else
cmam    if(rsi.eq.1.0)return
        if(si.eq.1.0)return
      endif
      if(si.eq.rsi.and.init.eq.0)then
        istride = si
        ny = float(nx+istride-1)/si
        k = 1
        do i=1,ny
          y(i)=x(k)
          k = k+istride
        end do
        return
      else
        if(si.eq.rsi)return
      endif
      if (init.eq.1)then
        jalloc = 1
        ist(1)=0
        ist(2)=0
        nalloc = (1.0/si)*nx + 2
        ndo = nalloc
        nalloc = nalloc*3 * ISZBYT
        ierror = 0
        iabort = 0
        jab = 0
        call galloc(pt,nalloc,ierror,iabort)
        if (ierror.ne.0)jab = 1
        call galloc(pit,nalloc,ierror,iabort)
        if (ierror.ne.0)jab=1
        if(jab.eq.1)then
            print *,' Memory allocation error'
            stop 100
        endif
        f = 0
        j = 0
        i = 0
        r = 0
   10   i=i+1
        z = i
        if(i.gt.nx)go to 50
   20   r = r+si
        if(r.gt.z)then
          r=r-si
          go to 10
        endif
        f = r-z
        fs = f*f
        c1=fs-f
        c2 =2.0 - 2.0*fs
        c3 = fs+f
        j = j+1
        ndx1=j
        ndx2 = ndx1 + ndo
        ndx3 = ndx2 + ndo
        table(ndx1)=c1*0.5
        table(ndx2)=c2*0.5
        table(ndx3)=c3*0.5
        itable(ndx1)=i-1
        itable(ndx2)=i
        itable(ndx3)=i+1
        if(ist(1).eq.0.and.i.gt.1)then
          ist(1)=j-1
        endif
        if(ist(2).eq.0.and.i+1.gt.nx)then
          ist(2)=j-1
        endif
        go to 20
   50   continue
        ny = j
        return
      endif
      if(init.eq.0)then
        do i=1,ist(1)
          ndx1 =i
          ndx2 =ndx1 + ndo
          ndx3 =ndx2 + ndo
          y(i)= x(itable(ndx2))*table(ndx2) +
     :         x(itable(ndx3))*table(ndx3)
        end do
        ny1 = ist(1)+1
        ny2 = ist(2)
        do i=ny1,ny2
         ndx1 = i
         ndx2 = ndx1+ndo
         ndx3 = ndx2+ndo
         y(i)= x(itable(ndx1))*table(ndx1) +
     :          x(itable(ndx2))*table(ndx2)  +
     :          x(itable(ndx3))*table(ndx3)
        end do
        ny1 = ist(2)+1
        do i=ny1,ny
         ndx1 = i
         ndx2 = ndx1+ndo
         ndx3 = ndx2+ndo
         y(i)= x(itable(ndx1))*table(ndx1) +
     :          x(itable(ndx2))*table(ndx2) +
     :          x(itable(ndx2))*table(ndx3)
        end do
        return
      endif
      else
        if(jalloc.ne.0)then
          call gfree(pt)
          call gfree(pit)
        endif
        jalloc = 0
        return
      endif
      RETURN
      END
