/*
***********************************************************************
**
** Program name: create_mostly_widgets
**
** Languate:     C
**
** Author:       David Nelson, with modification by R. Crider
**
** Date written: May 21, 1991
**
**                   Amoco Production Company proprietary 
**                      to be maintained in confidence
**
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
**
** Abstract: Instantiate or control creation of all application
**           widgets and register all callbacks. variables and 
**           structures are allocated and possibly initialized.
**
** Modification history: May 21, 1991 - Initial release
**
***********************************************************************
*/

#include "xos.h"
#include "globals.h"

void color2pixel();

extern Colormap AppCmap;  /* Application colormap (private or global) */

Widget create_mostly_widgets (parent, draw)
Widget parent;
Widget *draw;
{ 
   extern Visual *visual;
   extern int depth;

   int n, zero, one, two, three ;
/*...cmam....added option for vi3d format...3-27-96*/
   int five ;
/*...cmam....added option for XSD standard pick format..*/
   int six ;
/*.................................................*/
   Arg args[10] ;
   Widget   form, form2, menu, dig_radio, sep1, scale1, scale2, 
            lab, dig_label;
   Widget   exitbox, openbb ;
   Widget   parm_panel, button, vboard , copy_merge_panel;
   Widget   hyp_color;
   Widget   cursor_color;
   Widget   type_mo;
     Widget siv_button;
   Widget   filesb;
   Widget   menu_pane, cascade, pb_ok, pb_cancel, pick_switch, choice;
   Widget   pick_format_box, rc1, rc2,rc3,rc4, rc5 ;
   Widget   data_dialog;
   /*static Widget  sw[MAX_DRAWING_AREA], vsb[MAX_DRAWING_AREA] ;*/
   static Widget  sw[MAX_DRAWING_AREA], vsb[MAX_DRAWING_AREA] ;
   XmStringCharSet charseta = (XmStringCharSet)XmSTRING_DEFAULT_CHARSET;

   XmString xmstring ; 
   XColor color, dummy ;
   /*Cursor cursor ; */

   GContext gcontext ;
   Font font ;
   XFontStruct *font1;
   XFontStruct *file_font;
   XmFontList select_font;
   XmFontList the_font_list;


   int  i, percent1=33, percent2=67 ;
   static int flag ;
   static char *title[] = {
                                "Optical Stack Analysis Tool",
                                "Copyright 1992",
                                "Amoco Production Company"};
   static int ntitle=3;


   extern XtCallbackProc manage_widgetCB(), unmanage_widgetCB(),
          read_save_picksCB(), adj_colorsCB(), arm_falseCB(),
          active_trueCB(), set_pick_flagCB(), clear_all_picksCB(),
          setup_window1CB(), setup_window2CB(),
          sync_VscrollbarsCB(), sync_HscrollbarsCB(), sync_displayCB(),
          helpCB(), do_moveoutCB(), clear_pik_msgCB(),
          set_pick_formatCB(), get_save_pick_parmsCB(),
          manage_pickbbCB(), set_digmodeCB(), show_velocityCB(), noopCB() ;

   extern void create_message() ;

   extern Widget  create_exit_box(), create_error_box(), 
                  create_data_dialog(),
                  create_display_panel(), create_velocity_panel() ;
/*cmam.......hyperbola color.......apr 27, 1994..*/
   extern Widget	create_hy_col();
   extern Widget	create_cursor_color_panel();
   extern Widget	create_mo_type();
/*cmam...........................................*/
   extern Widget  create_copy_merge();

/*
*  Some locally used constants
*/
    zero = 0;
    one = 1;
    two = 2;
    three = 3;

    five = 5;
/*...cmam...for XSD standard pick format output...*/
    six = 6;

    seisplot[CDP].dpy = display;
    seisplot[TP].dpy = display;
    seisplot[MO].dpy = display;
/*
** Identifiers set in seismic plotting structure
*/

   seisplot[CDP].which = CDP ;
   seisplot[TP].which  = TP ;
   seisplot[MO].which = MO;

/*
** Allocate colors for use in Graphics Contexts 
*/

   black  = BlackPixel(display,DefaultScreen(display)) ;
   white  = WhitePixel(display,DefaultScreen(display)) ;

/*
 * 98.01.19 - Changed DefaultColormapOfScreen(XtScreen(parent)) to AppCmap
 */

/*
** Initialize Color editor for TP display 
*/

   CreateColorEditor(parent, "xos", "TPSCAN", 128);


   if(visual->class == PseudoColor) {
     (void) XAllocNamedColor(display, AppCmap, "red", &color, &dummy) ; 
     red = hycolor = npcolor = color.pixel ;
     (void) XAllocNamedColor(display, AppCmap, "green", &color, &dummy) ;
     green = color.pixel ;
     (void) XAllocNamedColor(display, AppCmap, "yellow", &color, &dummy) ;
     yellow = color.pixel ;
     (void) XAllocNamedColor(display, AppCmap, "LimeGreen", &color, &dummy) ; 
     apcolor = color.pixel ;

   }
   else {
     (void) XLookupColor(display, AppCmap, "red", &dummy, &color) ; 
     color2pixel(&color,visual,depth);
     red = hycolor = npcolor = color.pixel ;
     (void) XLookupColor(display, AppCmap, "green", &dummy, &color) ;
     color2pixel(&color,visual,depth);
     green = color.pixel ;
     (void) XLookupColor(display, AppCmap, "yellow", &dummy, &color) ;
     color2pixel(&color,visual,depth);
     yellow = color.pixel ;
     (void) XLookupColor(display, AppCmap, "LimeGreen", &dummy, &color) ; 
     color2pixel(&color,visual,depth);
     apcolor = color.pixel ;
   }


/*
** Create global Graphics Contexts
*/

   gcvals.foreground = BlackPixel(display, DefaultScreen(display));
   gcvals.background = WhitePixel(display, DefaultScreen(display));
   gcvals.line_width = 1;
   gc = XCreateGC(display, RootWindowOfScreen(XtScreen(parent)),
                    GCForeground|GCBackground|GCLineWidth, &gcvals);

   font = XLoadFont (display, "9x15") ;
   file_font = XLoadQueryFont(display, "9x15");
   select_font = (XmFontList) XmFontListCreate(file_font, charseta);
   gcvals.foreground = BlackPixel(display, DefaultScreen(display));
   gcvals.background = WhitePixel(display, DefaultScreen(display));
   gcvals.font = font;
   gc_odometer = XCreateGC(display, RootWindowOfScreen(XtScreen(parent)),
                    GCForeground|GCBackground|GCFont, &gcvals);


   gcvals.foreground = BlackPixel(display, DefaultScreen(display));
   gcvals.background = BlackPixel(display, DefaultScreen(display));
   gcvals.line_width = 1;
   gcvals.line_style = LineSolid;
   gcvals.function = GXinvert;
   gc_rubber = XCreateGC(display, RootWindowOfScreen(XtScreen(parent)),
               GCForeground|GCLineWidth|GCLineStyle|GCFunction, &gcvals);

   gcontext = XGContextFromGC (gc) ;
   font1 = XQueryFont(display, gcontext);
   the_font_list = XmFontListCreate(font1, XmSTRING_DEFAULT_CHARSET);
   xmstring = XmStringCreateLtoR("4", XmSTRING_DEFAULT_CHARSET) ;
   num_font.width = XmStringWidth(the_font_list, xmstring) ;
   XmStringFree (xmstring) ;
   xmstring = XmStringCreateLtoR("9", XmSTRING_DEFAULT_CHARSET) ;
   num_font.height = XmStringHeight(the_font_list, xmstring);
   XmStringFree (xmstring) ;
   xmstring = XmStringCreateLtoR("a", XmSTRING_DEFAULT_CHARSET) ;
   letter_font.width = XmStringWidth(the_font_list, xmstring);
   XmStringFree (xmstring) ;
   xmstring = XmStringCreateLtoR("W", XmSTRING_DEFAULT_CHARSET) ;
   letter_font.height = XmStringHeight(the_font_list, xmstring);
   XmStringFree (xmstring) ;
   if(the_font_list)XmFontListFree (the_font_list) ;

/*
** Determine the pixel resolution of the device
*/

   pix_res = 100. ;

   /* note device resolution hardcoded to 100 pixels/inch
 
   ----- height/width in MM not correct in Sun screen structure -----

   int      x_res_pix, y_res_pix, x_res_mm, y_res_mm ;
   Screen   *screen ;

   screen = ScreenOfDisplay (display, DefaultScreen(display)) ;
   x_res_pix = (int) WidthOfScreen    (screen) ;
   y_res_pix = (int) HeightOfScreen   (screen) ;
   x_res_mm  = (int) WidthMMOfScreen  (screen) ;
   y_res_mm  = (int) HeightMMOfScreen (screen) ;
   printf ("\nresvals = %d %d %d %d",x_res_pix,y_res_pix,x_res_mm,y_res_mm);
   printf ("\nresolution = %f x %f", 25.4*(float)x_res_pix/(float)x_res_mm,
                                     25.4*(float)y_res_pix/(float)y_res_mm) ;
   */


/*
** Create an error message dialog for later use
*/

   parm_panel = create_display_panel(seisplot,parent);
   copy_merge_panel = create_copy_merge(&seisplot[TP]);
   data_dialog = create_data_dialog(seisplot, parm_panel, parent);
   error_dialog = create_error_box() ;
	hyp_color = create_hy_col(parent);
	cursor_color = create_cursor_color_panel(parent);
	type_mo = create_mo_type(parent);

/*
** Create a form widget and attach all major widgets together to
** present the same geometry regardless of application window size 
*/

   n = 0 ;
   form = XmCreateForm (parent, "appForm", args, n) ;
   XtManageChild (form) ;

/*
** Create menu bar with pushbuttons and managed popup dialogs
*/

   n=0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg(args[n], XmNpacking, XmPACK_TIGHT); n++ ;
   XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++ ;
   menu = XmCreateMenuBar(form,"menu", args,n);

    n = 0;
    menu_pane = XmCreatePulldownMenu (menu, "menu_pane", args, n);
    for (i=0;i<ntitle; i++) {
            n=0;
            XtSetArg(args[n], XmNlabelString,
                    XmStringCreateLtoR(title[i], charseta)); n++;
            lab = XmCreateLabel(menu_pane, "about_lab", args, n);
            XtManageChild(lab);
    }

    n = 0;
    XtSetArg (args[n], XmNsubMenuId, menu_pane);  n++;
    XtSetArg(args[n], XmNlabelString,
            XmStringCreateLtoR("About", charseta)); n++;
    XtSetArg(args[n], XmNaccelerator,"A"); n++;
    XtSetArg(args[n], XmNmnemonic, 'A'); n++;
    cascade = XmCreateCascadeButton (menu, "About", args, n);
    XtManageChild (cascade);

   n = 0;
   menu_pane = XmCreatePulldownMenu(menu,"file", args, n);
   
   n = 0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Select Data Files", charseta)); n++;
   XtSetArg(args[n], XmNmnemonic, 'S'); n++;
   XtSetArg(args[n], XmNacceleratorText,
     XmStringCreateLtoR("F1", charseta)); n++;
   XtSetArg(args[n], XmNaccelerator, "<Key>F1:"); n++;
   button = XtCreateManagedWidget("loaddata", 
   xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback (button, XmNactivateCallback, (XtCallbackProc)manage_widgetCB, 
                                               data_dialog) ;
   n = 0 ;
   XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR("Exit", charseta)); n++;
    XtSetArg(args[n], XmNmnemonic, 'E'); n++;
   XtSetArg(args[n], XmNacceleratorText,
     XmStringCreateLtoR("F3", charseta)); n++;
   XtSetArg(args[n], XmNaccelerator, "<Key>F3:"); n++;
   button = XmCreatePushButton (menu_pane, "exit", args, n) ;
   XtManageChild (button) ;
   exitbox = create_exit_box () ;
   XtAddCallback (button, XmNactivateCallback,(XtCallbackProc)manage_widgetCB,exitbox);

   n = 0;
   XtSetArg (args[n], XmNsubMenuId, menu_pane);  n++;
   XtSetArg(args[n], XmNlabelString,
        XmStringCreateLtoR("File", charseta)); n++;
   XtSetArg(args[n], XmNmnemonic, 'F'); n++;
   cascade = XmCreateCascadeButton (menu, "File", args, n);
   XtManageChild (cascade);

   menu_pane = XmCreatePulldownMenu(menu,"disp", NULL, NULL);
   n = 0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Enter Display Parameters", charseta)); n++;
   disp_button = XtCreateManagedWidget("dispb",
                  xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback(disp_button, XmNactivateCallback, (XtCallbackProc)manage_widgetCB,
                                                       parm_panel);
   n = 0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Change Colors", charseta)); n++;
   colr_button = XtCreateManagedWidget("colors",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback(colr_button, XmNactivateCallback, (XtCallbackProc)adj_colorsCB, &seisplot[TP]);

/*cmam.........to change hyperbola color     apr 27, 1994 */
   n = 0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Hyperbola Color", charseta)); n++;
   hycol_button = XtCreateManagedWidget("hycolor",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback(hycol_button, XmNactivateCallback, (XtCallbackProc)manage_widgetCB, 
						hyp_color);
/*cmam................................................... */
/*    .........to change cursor color     feb 1, 2000 */
   n = 0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Cursor Color", charseta)); n++;
   cursor_color_button = XtCreateManagedWidget("cursor",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback(cursor_color_button, XmNactivateCallback, (XtCallbackProc)manage_widgetCB, 
						cursor_color);
/*cmam................................................... */
   n = 0;
   XtSetArg (args[n], XmNsubMenuId, menu_pane);  n++;
   XtSetArg(args[n], XmNlabelString,
        XmStringCreateLtoR("Display", charseta)); n++;
   XtSetArg(args[n], XmNmnemonic, 'F'); n++;
   cascade = XmCreateCascadeButton (menu, "File", args, n);
   XtManageChild (cascade);

/*  
*   Build a bulletin board to hold the file selection dialog box 
*   for pick file selection
*/
   n = 0 ;
   XtSetArg(args[n], XmNbuttonFontList, select_font); n++;
   XtSetArg(args[n], XmNlabelFontList, select_font); n++;
   XtSetArg(args[n], XmNtextFontList, select_font); n++;
   pickbb = XmCreateBulletinBoardDialog (parent, "pickbb", args, n) ;
/*
*  Build the pick file selection box, assign to pickbb
*/
   n = 0 ;
   XtSetArg(args[n], XmNselectionLabelString,
            XmStringCreateLtoR("Read pick file", charseta)); n++;
   XtSetArg(args[n], XmNwidth, 300); n++;
   filesb = XmCreateFileSelectionBox (pickbb, "filesb", args, n) ;
   XtManageChild (filesb) ;
   XtAddCallback (filesb, XmNokCallback, (XtCallbackProc)clear_pik_msgCB, NULL) ;
   XtAddCallback (filesb, XmNcancelCallback, (XtCallbackProc)clear_pik_msgCB, NULL) ;
   XtAddCallback (filesb, XmNokCallback, (XtCallbackProc)read_save_picksCB, &seisplot[TP]) ;
   XtAddCallback (filesb, XmNokCallback, (XtCallbackProc)unmanage_widgetCB, pickbb) ;
   XtAddCallback (filesb, XmNcancelCallback, (XtCallbackProc)unmanage_widgetCB, pickbb) ;
   button = XmFileSelectionBoxGetChild (filesb, XmDIALOG_HELP_BUTTON) ;
   XtUnmanageChild (button) ;

/*
*  Create the pick format selection box
*/
   n = 0;
   pick_format_box = XmCreateBulletinBoardDialog (parent, "pickbox", args, n);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc1 = XmCreateRowColumn (pick_format_box, "rc1", args, n);
   XtManageChild (rc1);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n);
   XtManageChild (rc2);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc3 = XmCreateRowColumn (rc2, "rc3", args, n);
   XtManageChild (rc3);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc4 = XmCreateRowColumn (rc3, "rc4", args, n);
   XtManageChild (rc4);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc5 = XmCreateRowColumn (rc4, "rc4", args, n);
   XtManageChild (rc5);

   n = 0;
   XtSetArg(args[n], XmNlabelString,
       XmStringCreateLtoR("Save as ....", charseta)); n++;
   lab = XmCreateLabel(rc5,"label",args,n);
   XtManageChild(lab);

   n = 0;
   XtSetArg(args[n], XmNmarginWidth, 20 ); n++;
   XtSetArg(args[n], XmNradioBehavior, True); n++;
   XtSetArg(args[n], XmNradioAlwaysOne, True); n++;
   rc5 = XmCreateRowColumn(rc4, "pickrc",
                  args, n);
   XtManageChild(rc5);

/*..cmam...add option for xsd or vxos standard pick formats..*/
   n = 0 ;
   XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR("VXOS Standard Pick Format(r/v/t)", charseta)); n++;
   XtSetArg(args[n], XmNset, True); n++;
   choice = XmCreateToggleButton(rc5, "setfore", args, n);
   XtManageChild(choice);
   XtAddCallback (choice, XmNarmCallback,
        (XtCallbackProc)set_pick_formatCB, (XtPointer)zero) ;

   n = 0 ;
   XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR("XSD Standard Pick Format(r/t/s)", charseta)); n++;
   XtSetArg(args[n], XmNset, False); n++;
   /*XtSetArg(args[n], XmNset, True); n++;*/
   choice = XmCreateToggleButton(rc5, "setfore", args, n);
   XtManageChild(choice);
   XtAddCallback (choice, XmNarmCallback, 
        (XtCallbackProc)set_pick_formatCB, (XtPointer)six) ;
   n = 0;
   XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR("Velocity in DISCO Format", charseta)); n++;
   XtSetArg(args[n], XmNset, False); n++;
   choice = XtCreateManagedWidget("setback",
                         xmToggleButtonWidgetClass, rc5, args, n);
   XtAddCallback (choice, XmNarmCallback, 
        (XtCallbackProc)set_pick_formatCB, (XtPointer)one) ;
   n = 0 ;
   XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR("Velocity in TDFN Format", charseta)); n++;
   XtSetArg(args[n], XmNset, False); n++;
   choice = XmCreateToggleButton(rc5, "setfore", args, n);
   XtManageChild(choice);
   XtAddCallback (choice, XmNarmCallback, 
        (XtCallbackProc)set_pick_formatCB, (XtPointer)two) ;

   n = 0;
   XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR("Velocity as Time/Velocity Pairs", charseta)); n++;
   XtSetArg(args[n], XmNset, False); n++;
   choice = XtCreateManagedWidget("setback",
                         xmToggleButtonWidgetClass, rc5, args, n);
   XtAddCallback (choice, XmNarmCallback, 
        (XtCallbackProc)set_pick_formatCB, (XtPointer)three) ;

/*cmam...added option for vi3d format...3-27-96*/
   n = 0 ;
   XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR("Velocity in vi3d Format", charseta)); n++;
   XtSetArg(args[n], XmNset, False); n++;
   choice = XmCreateToggleButton(rc5, "setfore", args, n);
   XtManageChild(choice);
   XtAddCallback (choice, XmNarmCallback,
        (XtCallbackProc)set_pick_formatCB, (XtPointer)five) ;
/*......................................3-27-96*/

   n = 0;
   XtSetArg(args[n],XmNorientation, XmVERTICAL); n++;
   sep1 = XmCreateSeparator(rc2,"sep",args,n);
   XtManageChild(sep1);

   n = 0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg(args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc4 = XmCreateRowColumn(rc2, "rc4", args, n);
   XtManageChild(rc4);

   n = 0;
   XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg(args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc5 = XmCreateRowColumn(rc4, "rc4", args, n);
   XtManageChild(rc5);
   n = 0;

   xmstring = XmStringCreateLtoR("For existing data sets ...",charseta);
   XtSetArg(args[n], XmNlabelString, xmstring); n++;
   lab = XmCreateLabel(rc5, "lab", args, n);
   XtManageChild(lab);
   XmStringFree(xmstring);

   n=0;
   XtSetArg(args[n], XmNmarginWidth, 10); n++;
   XtSetArg(args[n], XmNradioBehavior, True); n++;
   XtSetArg(args[n], XmNradioAlwaysOne, True); n++;
   rc5 = XtCreateWidget("tog", xmRowColumnWidgetClass, rc4, args, n);
   XtManageChild(rc5);
   
   n=0;
   XtSetArg(args[n], XmNlabelString,
       XmStringCreateLtoR("Overwrite", charseta)); n++;
   XtSetArg(args[n], XmNset, True); n++;
   save_type_toggle[0] = XtCreateManagedWidget("togg",
               xmToggleButtonGadgetClass, rc5, args, n);
   
   n=0;
   XtSetArg(args[n], XmNlabelString,
       XmStringCreateLtoR("Append   ", charseta)); n++;
   XtSetArg(args[n], XmNset, False); n++;
   save_type_toggle[1] = XtCreateManagedWidget("togg",
               xmToggleButtonGadgetClass, rc5, args, n);

   n = 0;
   XtSetArg(args[n],XmNorientation, XmHORIZONTAL); n++;
   sep1 = XmCreateSeparator(rc1,"sep",args,n);
   XtManageChild(sep1);
 
   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2a", args, n) ;
   XtManageChild (rc2) ;
  
   pb_ok = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, rc2, NULL, 0);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, pick_format_box);
   XtAddCallback (pb_ok, XmNactivateCallback, (XtCallbackProc)set_pick_flagCB, (XtPointer)SAVEP) ;
   XtAddCallback (pb_ok, XmNactivateCallback, (XtCallbackProc)get_save_pick_parmsCB, NULL) ;
   XtAddCallback (pb_ok, XmNdisarmCallback, (XtCallbackProc)manage_pickbbCB, &flag);

   pb_cancel = XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, rc2, NULL, 0);
   XtAddCallback(pb_cancel, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, pick_format_box);

/*
*  Build the menu for pick file selection
*/
   n = 0;
   menu_pane = XmCreatePulldownMenu(menu,"picks", args, n);
   n=0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Read Picks", charseta)); n++;
   readp_button = XtCreateManagedWidget("readp",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback (readp_button, XmNarmCallback, (XtCallbackProc)arm_falseCB, &flag) ;
   XtAddCallback (readp_button, XmNactivateCallback, (XtCallbackProc)active_trueCB, &flag) ;
   XtAddCallback (readp_button, XmNactivateCallback, (XtCallbackProc)set_pick_flagCB, READP) ;
   XtAddCallback (readp_button, XmNdisarmCallback, (XtCallbackProc)manage_pickbbCB, &flag);
   n=0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Save Picks", charseta)); n++;
   savep_button = XtCreateManagedWidget("savep",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback (savep_button, XmNarmCallback, (XtCallbackProc)arm_falseCB, &flag) ;
   XtAddCallback (savep_button, XmNactivateCallback, (XtCallbackProc)active_trueCB, &flag) ;
   XtAddCallback (savep_button, XmNdisarmCallback, (XtCallbackProc)manage_widgetCB, 
                                                 pick_format_box);

   n=0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Copy Picks", charseta)); n++;
   copyp_button = XtCreateManagedWidget("copyp",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback (copyp_button, XmNactivateCallback, (XtCallbackProc)manage_widgetCB,
                                                     copy_merge_panel);

   n=0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Clear Picks", charseta)); n++;
   clearp_button = XtCreateManagedWidget("clearp",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback (clearp_button, XmNactivateCallback, (XtCallbackProc)clear_all_picksCB,
                                                      &seisplot[TP]) ;

   n = 0;
   XtSetArg (args[n], XmNsubMenuId, menu_pane);  n++;
   XtSetArg(args[n], XmNlabelString,
        XmStringCreateLtoR("Picks", charseta)); n++;
   XtSetArg(args[n], XmNmnemonic, 'P'); n++;
   cascade = XmCreateCascadeButton (menu, "Picks", args, n);
   XtManageChild (cascade);

   seisplot[TP].velplot = &velplot ;
   seisplot[CDP].velplot = NULL ;
   vboard = create_velocity_panel(&seisplot[TP]) ;
   n = 0;
   menu_pane = XmCreatePulldownMenu(menu,"vboarD", args, n);

/*@@@ dr - show interval velocity graph in the leftmost panel */
   n = 0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Show Interval Velocity", charseta)); n++;
   siv_button = XtCreateManagedWidget("sivbutton",
                         xmPushButtonWidgetClass, menu_pane, args, n);
/* XtAddCallback(siv_button, XmNactivateCallback, noopCB, NULL); */
   XtAddCallback (siv_button, XmNactivateCallback, (XtCallbackProc)show_velocityCB, seisplot);

/*   XtAddCallback (siv_button, XmNactivateCallback, sync_displayCB, vsb) ; */
/*.......................................................................*/

   n=0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Apply Current Function", charseta)); n++;
   XtSetArg(args[n], XmNsensitive, False); n++;
   apmo_button = XtCreateManagedWidget("abutton",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback (apmo_button, XmNactivateCallback, (XtCallbackProc)do_moveoutCB, seisplot);
   XtAddCallback (apmo_button, XmNactivateCallback, (XtCallbackProc)sync_displayCB,
        vsb) ;

   n=0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Set Velocity Range", charseta)); n++;
   vboard_button = XtCreateManagedWidget("vbutton",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback (vboard_button, XmNactivateCallback, (XtCallbackProc)manage_widgetCB, vboard);

/*..........add selection of moveout type here....8-18-95...mam...*/
   n = 0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Select Moveout Type", charseta)); n++;
   motyp_button = XtCreateManagedWidget("motype",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback(motyp_button, XmNactivateCallback, (XtCallbackProc)manage_widgetCB,
                                                type_mo);
/*cmam................................................... */
   n = 0;
   XtSetArg (args[n], XmNsubMenuId, menu_pane);  n++;
   XtSetArg(args[n], XmNlabelString,
        XmStringCreateLtoR("Velocity", charseta)); n++;
   XtSetArg(args[n], XmNmnemonic, 'V'); n++;
   cascade = XmCreateCascadeButton (menu, "velocity", args, n);
   XtManageChild (cascade);

   /* n=0;
   XtSetArg(args[n], XmNlabelString,
     XmStringCreateLtoR("Apply Current Function", charseta)); n++;
   XtSetArg(args[n], XmNsensitive, False); n++;
   apmo_button = XtCreateManagedWidget("abutton",
                         xmPushButtonWidgetClass, menu_pane, args, n);
   XtAddCallback (apmo_button, XmNactivateCallback, (XtCallbackProc)do_moveoutCB, seisplot);
   XtAddCallback (apmo_button, XmNactivateCallback, (XtCallbackProc)sync_displayCB,
	vsb) ; */

#ifdef SUNSYSTEM
/*
**  Create Help button
*/
    n = 0;
    cascade = XmCreateCascadeButton (menu, "Help", args, n);
    XtAddCallback (cascade, XmNactivateCallback, (XtCallbackProc)helpCB, "vxos");
    /*XtAddCallback (cascade, XmNactivateCallback, helpCB, "xos");*/
    XtManageChild (cascade);

    n = 0;
    XtSetArg (args[n], XmNmenuHelpWidget, cascade);  n++;
    XtSetValues (menu, args, n);
#endif


/*  
*  Manage the menu bar
*/

   XtManageChild(menu);


/*
** Create another form to manage picking radio buttons and message bar
*/

   n = 0 ;
   form2 = XmCreateForm (form, "pickForm", args, n) ;
   XtManageChild (form2) ;

   dig_label = XmCreateLabelGadget(form2, "dig_label", NULL, NULL) ;
   XtManageChild(dig_label);

   n = 0 ;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg(args[n], XmNpacking, XmPACK_TIGHT); n++ ;
   XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++ ;
   XtSetArg(args[n], XmNentryClass, xmToggleButtonWidgetClass); n++ ;
   dig_radio = XmCreateRadioBox(form2, "dig_radio", args, n) ;
   XtManageChild(dig_radio);
   n = 0 ;
   dig_option[NEW]    = XmCreateToggleButton(dig_radio,"dig_new",args,n) ;
   dig_option[EDIT]   = XmCreateToggleButton(dig_radio,"dig_edit",args,n) ;
   dig_option[MOVE]   = XmCreateToggleButton(dig_radio,"dig_move",args,n) ;

   XtManageChildren(dig_option, MAX_DIG_OPT);
   XmToggleButtonSetState(dig_option[EDIT], True, False) ;
   digmode = EDIT ;
   for (i = 0 ; i < MAX_DIG_OPT ; i++)
      XtAddCallback(dig_option[i], XmNvalueChangedCallback, (XtCallbackProc)set_digmodeCB,
                                                            &seisplot[TP]);
 
   message = XmCreateLabel(form2, "message", NULL, NULL) ;
   XtManageChild(message);
   clear_message () ;
   
   n = 0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   sep1 = XmCreateSeparator(form, "sep1", args, n);
   XtManageChild(sep1);

/*
** Create drawing area for cursor odometer digitial read-out
*/

   n = 0;
   odometer = XmCreateDrawingArea (form, "odometer", args, n);
   XtManageChild (odometer) ;

/*
** Create scale bars that manage proportional layout of seismic and
** velocity display windows
*/

   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
   XtSetArg (args[n], XmNprocessingDirection, XmMAX_ON_RIGHT) ; n++ ;
   XtSetArg (args[n], XmNminimum, (int) 0) ; n++ ;
   XtSetArg (args[n], XmNmaximum, (int) 100) ; n++ ;
   XtSetArg (args[n], XmNvalue, 2*percent1) ; n++ ;
   scale1 = XmCreateScale (form, "scale1", args, n) ;
   XtManageChild (scale1) ;
   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
   XtSetArg (args[n], XmNprocessingDirection, XmMAX_ON_RIGHT) ; n++ ;
   XtSetArg (args[n], XmNminimum, (int) 0) ; n++ ;
   XtSetArg (args[n], XmNmaximum, (int) 100) ; n++ ;
   XtSetArg (args[n], XmNvalue, 2*(percent2-50)) ; n++ ;
   scale2 = XmCreateScale (form, "scale2", args, n) ;
   XtManageChild (scale2) ;


   n = 0 ;
   XtSetArg (args[n], XmNscrollingPolicy, XmAUTOMATIC) ; n++ ;
   XtSetArg (args[n], XmNscrollBarPlacement, XmBOTTOM_LEFT) ; n++ ;
   XtSetArg (args[n], XmNscrollBarDisplayPolicy, XmSTATIC) ; n++ ;
   XtSetArg (args[n], XmNvisualPolicy, XmVARIABLE) ; n++ ;
   sw[CDP] = XmCreateScrolledWindow (form, "sw1", args, n) ;
   XtManageChild (sw[CDP]) ;
   sw[TP] = XmCreateScrolledWindow (form, "sw2", args, n) ;
   XtManageChild (sw[TP]) ;
   sw[VEL] = XmCreateScrolledWindow (form, "sw3", args, n) ;
   XtManageChild (sw[VEL]) ;

   XtAddCallback (scale1, XmNdragCallback, (XtCallbackProc)setup_window1CB, sw) ;
   XtAddCallback (scale1, XmNvalueChangedCallback, (XtCallbackProc)setup_window1CB, sw) ;
   XtAddCallback (scale2, XmNdragCallback, (XtCallbackProc)setup_window2CB, sw) ;
   XtAddCallback (scale2, XmNvalueChangedCallback, (XtCallbackProc)setup_window2CB, sw) ;

/*
** Setup scrollbar synchronization. CDP window is the master window.
*/

   n = 0 ;
   XtSetArg (args[n], XmNverticalScrollBar, &vsb[CDP]) ; n++ ;
   XtGetValues (sw[CDP], args, n) ;
   n = 0 ;
   XtSetArg (args[n], XmNverticalScrollBar, &vsb[TP]) ; n++ ;
   XtGetValues (sw[TP], args, n) ;
   n = 0 ;
   XtSetArg (args[n], XmNwidth, (Dimension) 7) ; n++ ;
   XtSetArg (args[n], XmNmappedWhenManaged, False) ; n++ ;
   XtSetValues (vsb[TP], args, n) ;
   n = 0 ;
   XtSetArg (args[n], XmNverticalScrollBar, &vsb[VEL]) ; n++ ;
   XtGetValues (sw[VEL], args, n) ;
   n = 0 ;
   XtSetArg (args[n], XmNwidth, (Dimension) 7) ; n++ ;
   XtSetArg (args[n], XmNmappedWhenManaged, False) ; n++ ;
   XtSetValues (vsb[VEL], args, n) ;

   XtAddCallback (vsb[CDP], XmNdragCallback, (XtCallbackProc)sync_VscrollbarsCB, vsb) ;
   XtAddCallback (vsb[CDP], XmNtoTopCallback, (XtCallbackProc)sync_VscrollbarsCB, vsb) ;
   XtAddCallback (vsb[CDP], XmNtoBottomCallback, (XtCallbackProc)sync_VscrollbarsCB, vsb) ;
   XtAddCallback (vsb[CDP], XmNincrementCallback, (XtCallbackProc)sync_VscrollbarsCB, vsb) ;
   XtAddCallback (vsb[CDP], XmNdecrementCallback, (XtCallbackProc)sync_VscrollbarsCB, vsb) ;
   XtAddCallback (vsb[CDP], XmNpageIncrementCallback, (XtCallbackProc)sync_VscrollbarsCB, vsb) ;
   XtAddCallback (vsb[CDP], XmNpageDecrementCallback, (XtCallbackProc)sync_VscrollbarsCB, vsb) ;


   n = 0 ;
   XtSetArg (args[n], XmNhorizontalScrollBar, &hsb[CDP]) ; n++ ;
   XtGetValues (sw[CDP], args, n) ;
   n = 0 ;
   XtSetArg (args[n], XmNhorizontalScrollBar, &hsb[TP]) ; n++ ;
   XtGetValues (sw[TP], args, n) ;
   n = 0 ;
   XtSetArg (args[n], XmNmappedWhenManaged, False) ; n++ ;
   XtSetValues (hsb[TP], args, n) ;
   n = 0 ;
   XtSetArg (args[n], XmNhorizontalScrollBar, &hsb[VEL]) ; n++ ;
   XtGetValues (sw[VEL], args, n) ;
   n = 0 ;
   XtSetArg (args[n], XmNmappedWhenManaged, False) ; n++ ;
   XtSetValues (hsb[VEL], args, n) ;

   XtAddCallback (hsb[CDP], XmNdragCallback, (XtCallbackProc)sync_HscrollbarsCB, &seisplot[0]) ;
   XtAddCallback (hsb[CDP], XmNtoTopCallback, (XtCallbackProc)sync_HscrollbarsCB, &seisplot[0]) ;
   XtAddCallback (hsb[CDP], XmNtoBottomCallback, (XtCallbackProc)sync_HscrollbarsCB, &seisplot[0]) ;
   XtAddCallback (hsb[CDP], XmNincrementCallback, (XtCallbackProc)sync_HscrollbarsCB,
                  &seisplot[0]) ;
   XtAddCallback (hsb[CDP], XmNdecrementCallback, (XtCallbackProc)sync_HscrollbarsCB,
                  &seisplot[0]) ;
   XtAddCallback (hsb[CDP], XmNpageIncrementCallback, (XtCallbackProc)sync_HscrollbarsCB,
                  &seisplot[0]) ;
   XtAddCallback (hsb[CDP], XmNpageDecrementCallback, (XtCallbackProc)sync_HscrollbarsCB,
                  &seisplot[0]) ;

/*
** Now that main widget are instantiated, setup geometry via the form
*/

   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   XtSetValues (menu, args, n) ;

   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   XtSetArg (args[n], XmNtopWidget, menu) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   XtSetValues (form2, args, n) ;

   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
   XtSetValues (dig_label, args, n) ;

   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET) ; n++ ;
   XtSetArg (args[n], XmNleftWidget, dig_label) ; n++ ;
   XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
   XtSetValues (dig_radio, args, n) ;

   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET) ; n++ ;
   XtSetArg (args[n], XmNleftWidget, dig_radio) ; n++ ;
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
   XtSetValues (message, args, n) ;

   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   XtSetArg (args[n], XmNtopWidget, form2) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   XtSetValues (sep1, args, n) ;

   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   XtSetArg (args[n], XmNtopWidget, sep1) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   XtSetValues (odometer, args, n) ;

   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   XtSetArg (args[n], XmNtopWidget, odometer) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION) ; n++ ;
   XtSetArg (args[n], XmNrightPosition, (int) 50) ; n++ ;
   XtSetValues (scale1, args, n) ;

   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   XtSetArg (args[n], XmNtopWidget, odometer) ; n++ ;
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION) ; n++ ;
   XtSetArg (args[n], XmNleftPosition, (int) 50) ; n++ ;
   XtSetValues (scale2, args, n) ;

   
   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   XtSetArg (args[n], XmNtopWidget, scale1) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION) ; n++ ;
   XtSetArg (args[n], XmNrightPosition, percent1) ; n++ ;   
   XtSetValues (sw[CDP], args, n) ;
   
   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   XtSetArg (args[n], XmNtopWidget, scale1) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION) ; n++ ;
   XtSetArg (args[n], XmNleftPosition, percent1) ; n++ ;   
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION) ; n++ ;
   XtSetArg (args[n], XmNrightPosition, percent2) ; n++ ;
   XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
   XtSetValues (sw[TP], args, n) ;

   n = 0 ;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET) ; n++ ;
   XtSetArg (args[n], XmNtopWidget, scale2) ; n++ ;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION) ; n++ ;
   XtSetArg (args[n], XmNleftPosition, percent2) ; n++ ;   
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM) ; n++ ;
   XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM) ; n++ ;
   XtSetValues (sw[VEL], args, n) ;
  
/*
** Create drawing areas managed by each scrolled window
*/

   for (i = 0 ; i < MAX_DRAWING_AREA ; i++) {
      n = 0 ;
      draw[i] = XmCreateDrawingArea (sw[i], "drawingA", args, n) ;
      XtManageChild (draw[i]) ;
      n = 0 ;
      XtSetArg (args[n], XmNworkWindow, draw[i]) ; n++ ;
      XtSetValues (sw[i], args, n) ;
   }


/*
** Do not allow most functions until data is displayed the first time
*/

   XtSetSensitive (disp_button, False) ;
   XtSetSensitive (colr_button, False) ;
   XtSetSensitive (readp_button, False) ;
   XtSetSensitive (savep_button, False) ;
   XtSetSensitive (clearp_button, False) ;
   XtSetSensitive (copyp_button, False) ;
   XtSetSensitive (vboard_button, False) ;
   for (i = 0 ; i < MAX_DIG_OPT ; i++)
      XtSetSensitive (dig_option[i], False) ;

   return(menu);
}
/*
** Create the Exit message box
** Author : David Nelson    Date : May 21, 1991
*/
  
Widget create_exit_box ()
{
   Widget exitbox, button ;
   extern XtCallbackProc exit_nowCB() ;
   
   exitbox = XmCreateMessageDialog (toplevel, "exitbox", NULL, NULL) ;
   XtAddCallback (exitbox, XmNokCallback, (XtCallbackProc)exit_nowCB, NULL) ;
   button = XmMessageBoxGetChild (exitbox, XmDIALOG_HELP_BUTTON) ;
   XtUnmanageChild (button) ;
   return (exitbox) ;
}
/*
** Create the error message box
** Author : David Nelson    Date : Jun 12, 1991
*/
  
Widget create_error_box ()
{
   int n ;
   Arg args[1] ;
   Widget errorbox, button ;
   extern XtCallbackProc unmanage_widgetCB() ;

   n = 0 ;
   XtSetArg (args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL) ; n++ ;
   errorbox = XmCreateErrorDialog (toplevel, "errorbox", args, n) ;
   XtAddCallback (errorbox, XmNokCallback, (XtCallbackProc)unmanage_widgetCB, errorbox) ;
   XtAddCallback (errorbox, XmNcancelCallback, (XtCallbackProc)unmanage_widgetCB, errorbox) ;
   button = XmMessageBoxGetChild (errorbox, XmDIALOG_HELP_BUTTON) ;
   XtUnmanageChild (button) ;
   return (errorbox) ;
}
/*
** Create a popup dialog to query for seismic display parameters
** Author : David Nelson    Date : May 21, 1991
*/

Widget create_display_panel(sp,parent)
Seisplot *sp ;
Widget parent;
{
   int i, n, k;
   Arg args[10] ;
   XmString xmstring ;
   Widget bboard, pb_dismiss, pb_ok, rc1, rc2, rc3, lab, sep;
   Widget rc4, rc5;
   Widget rc6, rc7, rc8;
   Widget rc9, rc10, rc11, rc12;
   Widget rc13, rc14;
   extern XtCallbackProc unmanage_widgetCB(), get_parmsCB() ;
   XmStringCharSet charsetx = (XmStringCharSet)XmSTRING_DEFAULT_CHARSET;
   static char *records[] = {"Use Actual", "Use Sequential"};
   static char *do_agc[]  = {"No ", "Yes"};

   n = 0;
   bboard = XmCreateBulletinBoardDialog (parent, "parmboard", args, n);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc1 = XmCreateRowColumn (bboard, "rc1", args, n);
   XtManageChild (rc1);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT) ; n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n) ;
   XtManageChild (rc2) ;

/*....actual/sequential stuff....*/
   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   XtSetArg (args[n], XmNspacing, 18) ; n++ ;
   rc3 = XmCreateRowColumn (rc2, "rc3a", args, n);
   XtManageChild (rc3) ;

/*
**  Test stuff, too
*/
   n = 0 ;
   xmstring = XmStringCreateLtoR(" ", charsetx);
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR("Start Record Number", charsetx);
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   xmstring = XmStringCreateLtoR("End Record Number", charsetx);
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   xmstring = XmStringCreateLtoR("Inches per Second", charsetx) ; 
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;

   n = 0;
   XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg(args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc6 = XmCreateRowColumn(rc2, "rc4", args, n);
   XtManageChild(rc6);
   n = 0;
   xmstring = XmStringCreateLtoR("Actual", charsetx);
   XtSetArg(args[n], XmNlabelString, xmstring); n++;
   lab = XmCreateLabel(rc6, "lab", args, n);
   XtManageChild(lab);
   XmStringFree(xmstring);
   n = 0;
   texts[0] =  XmCreateText (rc6, "txt", args, n) ;
   XtManageChild (texts[0]) ;
   texts[1] =  XmCreateText (rc6, "txt", args, n) ;
   XtManageChild (texts[1]) ;
   n = 0;
   XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg(args[n], XmNpacking, XmPACK_TIGHT); n++;
   XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   rc7 = XmCreateRowColumn(rc2, "rc4", args, n);
   XtManageChild(rc7);
   n = 0;
   xmstring = XmStringCreateLtoR("Sequential", charsetx);
   XtSetArg(args[n], XmNlabelString, xmstring); n++;
   lab = XmCreateLabel(rc7, "lab", args, n);
   XtManageChild(lab);
   XmStringFree(xmstring);
   n = 0;
   texts_a[0] =  XmCreateText (rc7, "txt", args, n) ;
   XtManageChild (texts_a[0]) ;
   texts_a[1] =  XmCreateText (rc7, "txt", args, n) ;
   XtManageChild (texts_a[1]) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "2.5") ; n++ ;
   texts[2] =  XmCreateText (rc7, "txt", args, n) ;
   XtManageChild (texts[2]) ;
   n=0;
   XtSetArg(args[n], XmNmarginWidth, 10); n++;
   XtSetArg(args[n], XmNradioBehavior, True); n++;
   XtSetArg(args[n], XmNradioAlwaysOne, True); n++;
   rc5 = XtCreateWidget("tog", xmRowColumnWidgetClass, rc2, args, n);
   XtManageChild(rc5);
   for(k=0;k<2;k++) {
      n = 0;
      XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR(records[k], charsetx)); n++;
      if(k == 0)
         XtSetArg(args[n], XmNset, True);
      else
         XtSetArg(args[n], XmNset, False);
      n++;
      record_toggle[k] = XtCreateManagedWidget("togg",
               xmToggleButtonGadgetClass, rc5, args, n);
   }

/*...CDP/Scan stuff...*/
   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n) ;
   XtManageChild (rc2) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   XtSetArg (args[n], XmNspacing, 18) ; n++ ;
   rc8 = XmCreateRowColumn (rc2, "rc3b", args, n);
   XtManageChild (rc8) ;
   n = 0 ;
   xmstring = XmStringCreateLtoR(" ", XmSTRING_DEFAULT_CHARSET) ; 
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc8, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   xmstring = XmStringCreateLtoR("Traces per Inch", XmSTRING_DEFAULT_CHARSET) ; 
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc8, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   xmstring = XmStringCreateLtoR("Maximum Overlap", XmSTRING_DEFAULT_CHARSET) ; 
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc8, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR("Scale Factor", 
                   XmSTRING_DEFAULT_CHARSET) ; 
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc8, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR("AGC Window Length (ms)", 
                   XmSTRING_DEFAULT_CHARSET) ; 
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc8, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc9 = XmCreateRowColumn (rc2, "rc3", args, n);
   XtManageChild (rc9) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR("CDP Data", XmSTRING_DEFAULT_CHARSET); 
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc9, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "25") ; n++ ;
   texts[3] =  XmCreateText (rc9, "txt", args, n) ;
   XtManageChild (texts[3]) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "3") ; n++ ;
   texts[5] =  XmCreateText (rc9, "txt", args, n) ;
   XtManageChild (texts[5]) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "0.15") ; n++ ;
   texts[7] =  XmCreateText (rc9, "txt", args, n) ;
   XtManageChild (texts[7]) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "500") ; n++ ;
   texts[9] =  XmCreateText (rc9, "txt", args, n) ;
   XtManageChild (texts[9]) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc10 = XmCreateRowColumn (rc2, "rc3", args, n);
   XtManageChild (rc10) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR("Scan Data", XmSTRING_DEFAULT_CHARSET) ; 
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc10, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "50") ; n++ ;
   texts[4] =  XmCreateText (rc10, "txt", args, n) ;
   XtManageChild (texts[4]) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "3") ; n++ ;
   XtSetArg(args[n], XmNmappedWhenManaged, False) ; n++ ;
   texts[6] =  XmCreateText (rc10, "txt", args, n) ;
   XtManageChild (texts[6]) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "0.15") ; n++ ;
   XtSetArg(args[n], XmNmappedWhenManaged, False) ; n++ ;
   texts[8] =  XmCreateText (rc10, "txt", args, n) ;
   XtManageChild (texts[8]) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc11 = XmCreateRowColumn (rc2, "rc3", args, n);
   XtManageChild (rc11) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR("Apply AGC",XmSTRING_DEFAULT_CHARSET); 
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc11, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;

   n=0;
   XtSetArg(args[n], XmNmarginWidth, 10); n++;
   XtSetArg(args[n], XmNradioBehavior, True); n++;
   XtSetArg(args[n], XmNradioAlwaysOne, True); n++;
   rc5 = XtCreateWidget("tog", xmRowColumnWidgetClass, rc11, args, n);
   XtManageChild(rc5);
   for(k=0;k<2;k++) {
      n = 0;
      XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR(do_agc[k], charsetx)); n++;
      if(k == 0)
         XtSetArg(args[n], XmNset, True);
      else
         XtSetArg(args[n], XmNset, False);
      n++;
      agc_toggle[k] = XtCreateManagedWidget("togg",
               xmToggleButtonGadgetClass, rc5, args, n);
   }

/*...cmam....adding stuff for units/offset input for rec,tr,smp*/
/*.............
   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc6", args, n) ;
   XtManageChild (rc2) ;
 
   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   XtSetArg (args[n], XmNspacing, 18) ; n++ ;
   rc12 = XmCreateRowColumn (rc2, "rc9b", args, n);
   XtManageChild (rc12) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR(" ", XmSTRING_DEFAULT_CHARSET) ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc12, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   xmstring = XmStringCreateLtoR("Record  ", XmSTRING_DEFAULT_CHARSET) ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc12, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   xmstring = XmStringCreateLtoR("Trace", XmSTRING_DEFAULT_CHARSET) ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc12, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   xmstring = XmStringCreateLtoR("Sample", XmSTRING_DEFAULT_CHARSET) ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc12, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
 

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc13 = XmCreateRowColumn (rc2, "rc7", args, n);
   XtManageChild (rc13) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR("Units   ", XmSTRING_DEFAULT_CHARSET);
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc13, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "1.0") ; n++ ;
   texts[11] =  XmCreateText (rc13, "txt", args, n) ;
   XtManageChild (texts[11]) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "1.0") ; n++ ;
   texts[13] =  XmCreateText (rc13, "txt", args, n) ;
   XtManageChild (texts[13]) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "1.0") ; n++ ;
   texts[15] =  XmCreateText (rc13, "txt", args, n) ;
   XtManageChild (texts[15]) ;
 



   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc14 = XmCreateRowColumn (rc2, "rc8", args, n);
   XtManageChild (rc14) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR("Offset  ", XmSTRING_DEFAULT_CHARSET) ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc14, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "0.0") ; n++ ;
   texts[12] =  XmCreateText (rc14, "txt", args, n) ;
   XtManageChild (texts[12]) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "0.0") ; n++ ;
   texts[14] =  XmCreateText (rc14, "txt", args, n) ;
   XtManageChild (texts[14]) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "0.0") ; n++ ;
   texts[16] =  XmCreateText (rc14, "txt", args, n) ;
   XtManageChild (texts[16]) ;

.......................*/
/*...cmam...end of adding stuff for units/offset.....*/
   n=0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   sep = XmCreateSeparator(rc1, "sep", args, n);
   XtManageChild(sep);
  
   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2a", args, n) ;
   XtManageChild (rc2) ;
  
   pb_ok = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, rc2, NULL, 0);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)get_parmsCB, sp);

   pb_dismiss = XtCreateManagedWidget("cancel", xmPushButtonWidgetClass,
                 rc2, NULL, 0);
   XtAddCallback(pb_dismiss, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);

   return (bboard);
}
/*
** Create a popup dialog to query for velocity display parameters
** Author : David Nelson    Date : May 21, 1991
*/

Widget create_velocity_panel(sp)
Seisplot *sp ;
{
   int n ;
   Arg args[10] ;
   Widget bboard, pb_dismiss, pb_ok, rc1, rc2, rc3, lab, sep ;
   static Widget vtexts[3];
   XmString xmstring ;
   static Velch velch ;
   extern XtCallbackProc unmanage_widgetCB(), change_velocityCB() ;

   velch.seisplot = sp ;

   n = 0;
   bboard = XmCreateBulletinBoardDialog (toplevel, "vboard", args, n);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc1 = XmCreateRowColumn (bboard, "rc1", args, n);
   XtManageChild (rc1);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT) ; n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n) ;
   XtManageChild (rc2) ;

   xmstring = XmStringCreateLtoR("Minimum Velocity", XmSTRING_DEFAULT_CHARSET) ;
   n = 0 ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc2, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "1400") ; n++ ;
   velch.seisplot->velplot->velmin = 1400 ;
   vtexts[0] = XmCreateText (rc2, "txt", args, n) ;
   XtManageChild (vtexts[0]) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n);
   XtManageChild (rc2) ;
   xmstring = XmStringCreateLtoR("Maximum Velocity", XmSTRING_DEFAULT_CHARSET) ;
   n = 0 ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc2, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "5000") ; n++ ;
   velch.seisplot->velplot->velmax = 5000 ;
   vtexts[1] =  XmCreateText (rc2, "txt", args, n) ;
   XtManageChild (vtexts[1]) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n);
   XtManageChild (rc2) ;
   xmstring = XmStringCreateLtoR("Width in inches ", XmSTRING_DEFAULT_CHARSET) ;
   n = 0 ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc2, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   XtSetArg(args[n], XmNvalue, "2.0") ; n++ ;
   velch.seisplot->velplot->width = 201 ;
   vtexts[2] =  XmCreateText (rc2, "txt", args, n) ;
   XtManageChild (vtexts[2]) ;

   n=0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   sep = XmCreateSeparator(rc1, "sep", args, n);
   XtManageChild(sep);
  
   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2a", args, n) ;
   XtManageChild (rc2) ;

   velch.vtexts = vtexts ;

   pb_ok = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, rc2, NULL, 0);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)change_velocityCB, &velch);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);

   pb_dismiss = XtCreateManagedWidget("cancel", xmPushButtonWidgetClass,
                 rc2, NULL, 0);
   XtAddCallback(pb_dismiss, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);

   return (bboard);
}

Widget create_copy_merge(sp)
Seisplot *sp ;
{
   int n ;
   Arg args[10] ;
   Widget bboard, pb_dismiss, pb_ok, rc1, rc2, rc3, lab, sep ;
   XmString xmstring ;
   extern XtCallbackProc unmanage_widgetCB();
   extern XtCallbackProc copy_or_merge_picksCB();

   n = 0;
   bboard = XmCreateBulletinBoardDialog (toplevel, "cboard", args, n);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc1 = XmCreateRowColumn (bboard, "rc1", args, n);
   XtManageChild (rc1);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT) ; n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n) ;
   XtManageChild (rc2) ;
  
   xmstring = XmStringCreateLtoR("Copy picks...",XmSTRING_DEFAULT_CHARSET);
   XtSetArg(args[n], XmNlabelString, xmstring); n++;
   lab = XmCreateLabel(rc2, "lab", args, n);
   XtManageChild(lab);
   XmStringFree(xmstring);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n);
   XtManageChild (rc2);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT) ; n++ ;
   rc3 = XmCreateRowColumn (rc2, "rc3", args, n) ;
   XtManageChild (rc3) ;
  
   xmstring = XmStringCreateLtoR("From", XmSTRING_DEFAULT_CHARSET) ;
   n = 0 ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
   n = 0 ;
   copy_text[0] = XmCreateText (rc3, "txt", args, n) ;
   XtManageChild (copy_text[0]) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc3 = XmCreateRowColumn (rc2, "rc3", args, n);
   XtManageChild (rc3) ;

   xmstring = XmStringCreateLtoR("To  ", XmSTRING_DEFAULT_CHARSET) ;
   n = 0 ;
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;

   n = 0 ;
   copy_text[1] =  XmCreateText (rc3, "txt", args, n) ;
   XtManageChild (copy_text[1]) ;

   n=0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   sep = XmCreateSeparator(rc1, "sep", args, n);
   XtManageChild(sep);
  
   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2a", args, n) ;
   XtManageChild (rc2) ;

   pb_ok = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, rc2, NULL, 0);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)copy_or_merge_picksCB, sp);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);

   pb_dismiss = XtCreateManagedWidget("cancel", xmPushButtonWidgetClass,
                 rc2, NULL, 0);
   XtAddCallback(pb_dismiss, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);

   return (bboard);
}

/*....mam.....hyperbola color.......apr 27, 1994.........*/

XtCallbackProc get_hycolCB(w, parent, call)
Widget w;
Widget parent;
caddr_t call;
{

static char *hypcol[3] = {"red", "yellow", "green"};
int acolor, i;
   XColor color, dummy ;

for(i=0; i<3; i++) {
if(XmToggleButtonGadgetGetState(hycol_toggle[i]) == True)
     acolor = i;
}

/*...............
   (void) XAllocNamedColor (display,
          DefaultColormapOfScreen(XtScreen(parent)), hypcol[acolor], 
				&color, &dummy) ;
   hycolor = color.pixel ;
...............*/

	if(acolor == 0) hycolor = red;
	else if (acolor == 1) hycolor = yellow;
	else hycolor = green;
}
/*...cmam.......hyperbola color......apr 27,1994.......*/

Widget create_hy_col(parent)
Widget parent;
{
   int i, n, k;
   Arg args[10] ;
   XmString xmstring ;
   Widget bboard, pb_dismiss, pb_ok, rc1, rc2, rc3, lab, sep;
   Widget rc4, rc5;
   extern XtCallbackProc unmanage_widgetCB(), get_parmsCB() ;
   XmStringCharSet charsetx = (XmStringCharSet)XmSTRING_DEFAULT_CHARSET;
   static char *hy_col[]  = {"red   ", "yellow", "green "};

   n = 0;
   bboard = XmCreateBulletinBoardDialog (parent, "parmboard", args, n);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc1 = XmCreateRowColumn (bboard, "rc1", args, n);
   XtManageChild (rc1);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT) ; n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n) ;
   XtManageChild (rc2) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc3 = XmCreateRowColumn (rc2, "rc3a", args, n);
   XtManageChild (rc3) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR("Hyperbola Color",XmSTRING_DEFAULT_CHARSET);
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;

   n=0;
   XtSetArg(args[n], XmNmarginWidth, 10); n++;
   XtSetArg(args[n], XmNradioBehavior, True); n++;
   XtSetArg(args[n], XmNradioAlwaysOne, True); n++;
   rc5 = XtCreateWidget("tog", xmRowColumnWidgetClass, rc3, args, n);
   XtManageChild(rc5);
   for(k=0;k<3;k++) {
      n = 0;
      XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR(hy_col[k], charsetx)); n++;

      if(k == 0) {
         XtSetArg(args[n], XmNset, True); n++;
         XtSetArg(args[n], XmNselectColor, red); n++;
        }
      else if (k == 1) {
         XtSetArg(args[n], XmNset, False); n++;
         XtSetArg(args[n], XmNselectColor, yellow); n++;
        }
      else {
         XtSetArg(args[n], XmNset, False); n++;
         XtSetArg(args[n], XmNselectColor, green); n++;
        }

      hycol_toggle[k] = XtCreateManagedWidget("togg",
               xmToggleButtonGadgetClass, rc5, args, n);
   }

   n=0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   sep = XmCreateSeparator(rc1, "sep", args, n);
   XtManageChild(sep);

   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2a", args, n) ;
   XtManageChild (rc2) ;

   pb_ok = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, rc2, NULL, 0);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)get_hycolCB, parent);

   pb_dismiss = XtCreateManagedWidget("cancel", xmPushButtonWidgetClass,
                 rc2, NULL, 0);
   XtAddCallback(pb_dismiss, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);

   return (bboard);
}
/*
 * Added this to enable cursor color changes  - Joe M. Wade - 2/1/2000
 */
XtCallbackProc get_cursorcolCB(w, parent, call)
Widget w;
Widget parent;
caddr_t call;
{

   extern Visual *visual;
   extern int depth;
   extern Cursor cursor;

   static char *cursorcol[4] = {"black", "red", "yellow", "green"};
   int i;
   XColor color, dummy ;

   for(i=0; i<4; i++) {

     if (XmToggleButtonGadgetGetState(cursor_color_toggle[i]) == True) {

       if(visual->class == PseudoColor) 
         (void) XAllocNamedColor(display, AppCmap, cursorcol[i], &color, &dummy) ; 
       else  {
         (void) XLookupColor(display, AppCmap, cursorcol[i], &dummy, &color) ; 
          color2pixel(&color,visual,depth);
       }

       XRecolorCursor(display,cursor,&color,&color);
       return;
     }
   }

}

Widget create_cursor_color_panel(parent)
Widget parent;
{
   int i, n, k;
   Arg args[10] ;
   XColor color,dummy;
   XmString xmstring ;
   Widget bboard, pb_dismiss, pb_ok, rc1, rc2, rc3, lab, sep;
   Widget rc4, rc5;
   extern XtCallbackProc unmanage_widgetCB(), get_parmsCB() ;
   XmStringCharSet charsetx = (XmStringCharSet)XmSTRING_DEFAULT_CHARSET;
   static char *cursor_color[]  = {"black ", "red   ", "yellow", "green "};

   n = 0;
   bboard = XmCreateBulletinBoardDialog (parent, "parmboard", args, n);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc1 = XmCreateRowColumn (bboard, "rc1", args, n);
   XtManageChild (rc1);

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT) ; n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n) ;
   XtManageChild (rc2) ;

   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc3 = XmCreateRowColumn (rc2, "rc3a", args, n);
   XtManageChild (rc3) ;

   n = 0 ;
   xmstring = XmStringCreateLtoR("Cursor Color",XmSTRING_DEFAULT_CHARSET);
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;

   n=0;
   XtSetArg(args[n], XmNmarginWidth, 10); n++;
   XtSetArg(args[n], XmNradioBehavior, True); n++;
   XtSetArg(args[n], XmNradioAlwaysOne, True); n++;
   rc5 = XtCreateWidget("tog", xmRowColumnWidgetClass, rc3, args, n);
   XtManageChild(rc5);
   for(k=0;k<4;k++) {
      n = 0;
      XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR(cursor_color[k], charsetx)); n++;

      switch (k) {
       case 0:
         XtSetArg(args[n], XmNset, True); n++;
         XtSetArg(args[n], XmNselectColor, black); n++;
	 break;
       case 1:
         XtSetArg(args[n], XmNset, False); n++;
         XtSetArg(args[n], XmNselectColor, red); n++;
	 break;
       case 2:
         XtSetArg(args[n], XmNset, False); n++;
         XtSetArg(args[n], XmNselectColor, yellow); n++;
	 break;
       case 3:
         XtSetArg(args[n], XmNset, False); n++;
         XtSetArg(args[n], XmNselectColor, green); n++;
       }

      cursor_color_toggle[k] = XtCreateManagedWidget("togg",
               xmToggleButtonGadgetClass, rc5, args, n);
   }

   n=0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   sep = XmCreateSeparator(rc1, "sep", args, n);
   XtManageChild(sep);

   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2a", args, n) ;
   XtManageChild (rc2) ;

   pb_ok = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, rc2, NULL, 0);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)get_cursorcolCB, parent);

   pb_dismiss = XtCreateManagedWidget("cancel", xmPushButtonWidgetClass,
                 rc2, NULL, 0);
   XtAddCallback(pb_dismiss, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);

   return (bboard);
}

/*...........mam..........moveout type.................*/
XtCallbackProc get_motypCB(w, parent, call)
Widget w;
Widget parent;
caddr_t call;
{
 
  int i;

  for(i=0; i<2; i++) {
    if(XmToggleButtonGadgetGetState(motyp_toggle[i]) == True)
       mo_type = i;
  }
 
}
 
Widget create_mo_type(parent)
Widget parent;
{
   int i, n, k;
   Arg args[10] ;
   XmString xmstring ;
   Widget bboard, pb_dismiss, pb_ok, rc1, rc2, rc3, lab, sep;
   Widget rc4, rc5;
   extern XtCallbackProc unmanage_widgetCB(), get_parmsCB() ;
   XmStringCharSet charsetx = (XmStringCharSet)XmSTRING_DEFAULT_CHARSET;
   static char *mo_typ[] = {"Hyperbolic Moveout        ",
			    "Shifted Hyperbolic Moveout"};
 
   n = 0;
   bboard = XmCreateBulletinBoardDialog (parent, "parmboard", args, n);
 
   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc1 = XmCreateRowColumn (bboard, "rc1", args, n);
   XtManageChild (rc1);
 
   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL) ; n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT) ; n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2", args, n) ;
   XtManageChild (rc2) ;
 
   n = 0;
   XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg (args[n], XmNpacking, XmPACK_TIGHT); n++;
   rc3 = XmCreateRowColumn (rc2, "rc3a", args, n);
   XtManageChild (rc3) ;
 
   n = 0 ;
   xmstring = XmStringCreateLtoR("Moveout Type",XmSTRING_DEFAULT_CHARSET);
   XtSetArg (args[n], XmNlabelString, xmstring) ; n++ ;
   lab = XmCreateLabel (rc3, "lab", args, n) ;
   XtManageChild (lab) ;
   XmStringFree (xmstring) ;
 
   n=0;
   XtSetArg(args[n], XmNmarginWidth, 10); n++;
   XtSetArg(args[n], XmNradioBehavior, True); n++;
   XtSetArg(args[n], XmNradioAlwaysOne, True); n++;
   rc5 = XtCreateWidget("tog", xmRowColumnWidgetClass, rc3, args, n);
   XtManageChild(rc5);
   for(k=0;k<2;k++) {
      n = 0;
      XtSetArg(args[n], XmNlabelString,
         XmStringCreateLtoR(mo_typ[k], charsetx)); n++;
 
      if(k == 0) {
         XtSetArg(args[n], XmNset, True); n++;
         XtSetArg(args[n], XmNselectColor, red); n++;
        }
      else {
         XtSetArg(args[n], XmNset, False); n++;
         XtSetArg(args[n], XmNselectColor, red); n++;
        }
 
      motyp_toggle[k] = XtCreateManagedWidget("togg",
               xmToggleButtonGadgetClass, rc5, args, n);
   }
 
   n=0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   sep = XmCreateSeparator(rc1, "sep", args, n);
   XtManageChild(sep);
 
   n = 0 ;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++ ;
   XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++ ;
   rc2 = XmCreateRowColumn (rc1, "rc2a", args, n) ;
   XtManageChild (rc2) ;
 
   pb_ok = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, rc2, NULL, 0);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);
   XtAddCallback(pb_ok, XmNactivateCallback, (XtCallbackProc)get_motypCB, parent);
 
   pb_dismiss = XtCreateManagedWidget("cancel", xmPushButtonWidgetClass,
                 rc2, NULL, 0);
   XtAddCallback(pb_dismiss, XmNactivateCallback, (XtCallbackProc)unmanage_widgetCB, bboard);
 
   return (bboard);
}
