/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "xos.h"
#include "globals.h"
/*
** Search a digitized list for the nearest link to the given coordinates
** within a threshold distance
*/

void find_nearest_neighbor (dg, nearest, fx, fy, min)
Digits *dg, **nearest ;
int fx, fy, min ;
{
   int  i, dist2 ;

   *nearest = NULL ;
   for (i = 0 ; dg != NULL ; i++) {
      dist2 = (fx - dg->x) * (fx - dg->x) + (fy - dg->y) * (fy - dg->y) ;
      if (dist2 < min) {
         min = dist2 ;
         *nearest = dg ;
      }
      dg = dg->next ;
   }
}
/*
** Restore the backup velocity picture at the current record location
*/

void clear_velocity_area (sp, y1, y2)
Seisplot *sp ;
int y1, y2 ;
{
   int x ;
	int xck999 = -9999;

/*.............check out new button..........*/
   if(done_moveout == 0 && sp->current_rec != xck999) {
     y2 = y2 == 0 ? sp->height - y1 : y2 ;
     x = (sp->current_rec - sp->st_rec) * sp->velplot->width ;
     XCopyArea (display, sp->velplot->backup, sp->velplot->window, gc,
		x, y1, sp->velplot->width, y2-y1+1, x, y1) ;
     XCopyArea (display, sp->velplot->backup, sp->velplot->pixmap, gc,
             x, y1, sp->velplot->width, y2-y1+1, x, y1) ;
   }
}
/*
** Restore the backup seismic picture at the current record location
*/

void clear_seismic_area (sp, y1, y2)
Seisplot *sp ; /* TP */
int y1,y2 ;
{
   int x, width ;
	int xck999 = -9999;

	if(sp->current_rec != xck999) {
   y2 = y2 == 0 ? sp->height - y1 : y2 ;
   width = sp->ntr * sp->pix_per_trace ;
   x = (sp->current_rec - sp->st_rec) * width + sp->xorg ;
   XCopyArea (display, sp->backup, sp->window, gc,
              x, y1, width, y2-y1+1, x, y1) ;
   XCopyArea (display, sp->backup, sp->pixmap, gc,
              x, y1, width, y2-y1+1, x, y1) ;
	}
}
/*
** Restore the backup seismic picture over a rectangle encompassing xy picks
*/

void clear_xy_area (sp, dg, max)
Seisplot *sp ; /* TP */
Digits   *dg ;
int      max ;
{
   int  i, xmin=9999, xmax=-9999, ymin=9999, ymax=-9999 ;

   if (dg && dg->next) {
      for (i = 0 ; dg != NULL && i < max ; i++ ) {
         if (dg->x > xmax) xmax = dg->x ;
         if (dg->x < xmin) xmin = dg->x ;
         if (dg->y > ymax) ymax = dg->y ;
         if (dg->y < ymin) ymin = dg->y ;
         dg = dg->next ;
      }
      XCopyArea (display, sp->backup, sp->window, gc,
                 xmin, ymin, xmax-xmin+1, ymax-ymin+1, xmin, ymin) ;
      XCopyArea (display, sp->backup, sp->pixmap, gc,
                 xmin, ymin, xmax-xmin+1, ymax-ymin+1, xmin, ymin) ;
   }
}
/*
** Draw seismic picks, x and y locations expected to be computed already
*/

void draw_xy_picks (sp, dg, color)
Seisplot *sp ; /* TP */
Digits   *dg ;
Pixel    color ;
{
   int i, j = 5 ;

   if (dg) {
      XSetForeground (display, gc, color) ;
      XDrawLine(display, sp->pixmap, gc, dg->x-j, dg->y-j, dg->x+j, dg->y+j) ;
      XDrawLine(display, sp->window, gc, dg->x-j, dg->y-j, dg->x+j, dg->y+j) ;
      XDrawLine(display, sp->pixmap, gc, dg->x-j, dg->y+j, dg->x+j, dg->y-j) ;
      XDrawLine(display, sp->window, gc, dg->x-j, dg->y+j, dg->x+j, dg->y-j) ;
      dg = dg->next ;
      for (i = 1 ; dg != NULL ; i++) {
         XDrawLine(display,sp->pixmap,gc,dg->prev->x,dg->prev->y,dg->x,dg->y) ;
         XDrawLine(display,sp->window,gc,dg->prev->x,dg->prev->y,dg->x,dg->y) ;
         XDrawLine(display, sp->pixmap, gc, dg->x-j, dg->y-j, dg->x+j, dg->y+j);
         XDrawLine(display, sp->window, gc, dg->x-j, dg->y-j, dg->x+j, dg->y+j);
         XDrawLine(display, sp->pixmap, gc, dg->x-j, dg->y+j, dg->x+j, dg->y-j);
         XDrawLine(display, sp->window, gc, dg->x-j, dg->y+j, dg->x+j, dg->y-j);
         dg = dg->next ;
      }
   }
}
/*
** Draw velocity functions, stacking and interval
*/

void draw_vfunc (sp, dg, color)
Seisplot *sp ; /* TP */
Digits   *dg ;
Pixel    color ;
{
	int xck999 = -9999;
   int   i, xvstk1, xvstk2, xvint1, xvint2 ;
   float wm1, vdiff, voffset ;
   extern void set_vclip() ;
   
   /*if (dg == NULL || dg->next == NULL)*/
   if (dg == NULL || dg->next == NULL || sp->current_rec == xck999)
      return ;

   wm1   = sp->velplot->width - 1 ;
   vdiff = sp->velplot->velmax - sp->velplot->velmin ;
   voffset = (sp->current_rec - sp->st_rec) * sp->velplot->width + 0.5 ;

   XSetForeground (display, gc, color) ;
   set_vclip (sp, gc) ;

   xvstk1 = voffset + wm1 * (float)(dg->vstk - sp->velplot->velmin) / vdiff ;

   if (dg->vint == 0) {
      gcvals.line_width = 1;
      gcvals.line_style = LineOnOffDash;
      XChangeGC(display, gc, GCLineWidth|GCLineStyle, &gcvals);
   }
   xvint1 = voffset + wm1 * (float)(dg->vint - sp->velplot->velmin)/vdiff ;
   xvint2 = xvint1 ;
   XDrawLine(display, sp->velplot->pixmap, gc,
             xvint1, dg->y, xvint1, dg->next->y) ;
   XDrawLine(display, sp->velplot->window, gc,
             xvint1, dg->y, xvint1, dg->next->y) ;
   gcvals.line_style = LineSolid;
   gcvals.line_width = 0;
   XChangeGC(display, gc, GCLineWidth|GCLineStyle, &gcvals);

   dg = dg->next ;
   for (i = 1 ; dg != NULL ; i++) {
      xvstk2 = voffset + wm1 * (float)(dg->vstk - sp->velplot->velmin)/vdiff ;
      XDrawLine(display, sp->velplot->pixmap, gc,
                         xvstk1, dg->prev->y, xvstk2, dg->y) ;
      XDrawLine(display, sp->velplot->window, gc,
                         xvstk1, dg->prev->y, xvstk2, dg->y) ;
      xvstk1 = xvstk2 ;

      if (dg->next != NULL) {
         xvint1 = voffset + wm1 *
                 (float)(dg->vint - sp->velplot->velmin) / vdiff ;
         if (dg->prev->vint == 0 || dg->vint == 0) {
            gcvals.line_width = 1;
            gcvals.line_style = LineOnOffDash;
            XChangeGC(display, gc, GCLineWidth|GCLineStyle, &gcvals);
         }
         XDrawLine(display, sp->velplot->pixmap, gc,
                            xvint2, dg->y, xvint1, dg->y) ;
         XDrawLine(display, sp->velplot->window, gc,
                            xvint2, dg->y, xvint1, dg->y) ;
         gcvals.line_style = LineSolid;
         gcvals.line_width = 0;
         XChangeGC(display, gc, GCLineWidth|GCLineStyle, &gcvals);
         if (dg->vint == 0) {
            gcvals.line_width = 1;
            gcvals.line_style = LineOnOffDash;
            XChangeGC(display, gc, GCLineWidth|GCLineStyle, &gcvals);
         }
         if (dg->next) {
            XDrawLine(display, sp->velplot->pixmap, gc,
                               xvint1, dg->y, xvint1, dg->next->y) ;
            XDrawLine(display, sp->velplot->window, gc,
                               xvint1, dg->y, xvint1, dg->next->y) ;
         }
         gcvals.line_style = LineSolid;
         gcvals.line_width = 0;
         XChangeGC(display, gc, GCLineWidth|GCLineStyle, &gcvals);
         xvint2 = xvint1 ;
      }
      dg = dg->next ;
   }
   XSetClipMask (display, gc, None) ;
}
/*
** Restore backup seismic and velocity picture over entire working area
** and free and reset digitized list information
*/

XtCallbackProc clear_all_picksCB (w, sp, call)
Widget w ;
Seisplot *sp ;
caddr_t call ;
{
   int i ;
   Arg args[2];
   extern void clear_velocity_area(), free_all_digrec(), free_digits() ,
		free_digrec();
           
   XtSetSensitive (apmo_button, False) ;
   done_moveout = 0;
   XtSetArg (args[0], XmNwidth, sp->width) ;
   XtSetArg (args[1], XmNheight, sp->height) ;
   XtSetValues (sp->velplot->drawA, args, 2) ;
   done_moveout=0;
   XtUnmanageChild (seisplot[TP].velplot->drawA) ;
   XtManageChild   (seisplot[TP].velplot->drawA) ;
   XCopyArea (display, sp->backup, sp->window, gc,
              0, 0, sp->width, sp->height, 0, 0) ;
   XCopyArea (display, sp->backup, sp->pixmap, gc,
              0, 0, sp->width, sp->height, 0, 0) ;

   for (i = sp->st_rec ; i <= sp->end_rec ; i++) {
      sp->current_rec = i ;
      clear_velocity_area (sp, 0, 0) ;
   }
   sp->current_rec = -9999 ;

   if (sp->new_digits) {
      free_digits (sp->new_digits) ;
      sp->new_digits = NULL ;
   }

/*....cmam...changed 10-11-96 because of linked lists.....
if(sp->old_digrec) {
   free_digrec(sp->old_digrec);
   sp->old_digrec = NULL ;
}
.......................................................*/
/*......we have to remember to delete the forward & backward ptrs to
      deleted members of a linked list............*/
        if(sp->old_digrec) {
          if(sp->old_digrec->next) {
            if(sp->old_digrec->prev) {
                /*.....both forward and backward ptrs exist...*/
                if(sp->accepted_digrec_head == sp->old_digrec)
                   sp->accepted_digrec_head = sp->old_digrec->next;
                if(sp->accepted_digrec_tail == sp->old_digrec)
                   sp->accepted_digrec_tail = sp->old_digrec->prev;
                sp->old_digrec->prev->next = sp->old_digrec->next;
                sp->old_digrec->next->prev = sp->old_digrec->prev;
            }
            else {
                /*...only forward ptr exists...*/
                if(sp->accepted_digrec_head == sp->old_digrec)
                   sp->accepted_digrec_head = sp->old_digrec->next;
                sp->old_digrec->next->prev = NULL;
            }
	  }
          else if (sp->old_digrec->prev) {
            /*...only backward ptr exists...*/
            if(sp->accepted_digrec_tail == sp->old_digrec)
                sp->accepted_digrec_tail = sp->old_digrec->prev;
            sp->old_digrec->prev->next = NULL;
          }
          /*...now delete this ptr...*/
          free_digrec (sp->old_digrec);
          sp->old_digrec = NULL;
        }
/*.........cmam .. end of changes 10-11-96......*/


   if (sp->accepted_digrec_head) {
      free_all_digrec (sp->accepted_digrec_head) ;     
      sp->accepted_digrec_head = sp->accepted_digrec_tail = NULL ;
   }
}
/*
** Compute a stacking velocity given trace number and t0 in digitized structure
*/

void compute_vstk (sp, dg)
Seisplot *sp ;
Digits *dg ;
{
   float s, tp ;

   if (smode == 0 || smode == 1 || smode == 4)
         dg->vstk = (sp->vbuf)[dg->trc-1];
   else  if (smode == 2) {
      tp = (float) (sp->tpbuf)[dg->trc-1] ;
      if (tp >= 0.0)
         dg->vstk = v1 * 1000. * sqrt(tp/(float)dg->t0) ;
      else
         dg->vstk = -v1 * 1000. * sqrt(-tp/(float)dg->t0) ;
   }
   else {
      dg->vstk = (float)(sp->tpbuf)[dg->trc-1]*sqrt((float)tofe/(float)dg->t0) ;
   }
}
/*
** Compute a interval velocity given upper and lower stacking velocity
** in digitized structure list
*/

void compute_vint (dg)
Digits *dg ;
{
   float  vint2, vu, vl, tu, tl ;

   if (dg && dg->vstk > 0 && dg->next && dg->next->vstk > 0) {
      vu = (float) (dg->vstk * dg->vstk) ;
      vl = (float) (dg->next->vstk * dg->next->vstk) ;
      tu = 0.001*(float) dg->t0 ;
      tl = 0.001*(float) dg->next->t0 ;
      vint2 = (vl*tl - vu*tu) / (tl-tu) ;
      dg->vint = vint2 > 0.0 ? (int) sqrt(vint2) : 0 ;
   }
   else if (dg)
      dg->vint = 0 ;
}
/*
** Draw picks after pick file loading or scale changes, new xy's, stacking and
** interval velocities are computed and stored in digitized structure 
*/

void draw_new_picks (sp)
Seisplot *sp ;
{
   int i, j ;
   float vint2, vu, vl, tu, tl ;
   Digits *dg ;
   Digrec *dr ;
   extern void clear_velocity_area(), draw_xy_picks(), draw_vfunc(),
               compute_vstk() ;

/*
   XCopyArea (display, sp->backup, sp->window, gc,
              0, 0, sp->width, sp->height, 0, 0) ;
   XCopyArea (display, sp->backup, sp->pixmap, gc,
              0, 0, sp->width, sp->height, 0, 0) ;
*/

   for (i = sp->st_rec ; i <= sp->end_rec ; i++) {
      sp->current_rec = i ;
      clear_velocity_area (sp, 0, 0) ;
   }
   sp->current_rec = -9999 ;

   dr = sp->accepted_digrec_head ;
   for (i = 0 ; dr != NULL ; i++) {
      if (dr->rec >= sp->st_rec && dr->rec <= sp->end_rec) {
         dg = dr->digits ;
         dg->x = ((dr->rec - sp->st_rec) * sp->ntr + dg->trc) *
                                           sp->pix_per_trace + sp->xorg ;
         dg->y = (float)(dg->t0 / sp->smpint) * sp->pix_per_sample +
                                                (float) sp->yorg + 0.5 ;
         compute_vstk (sp, dg) ;

         dg = dg->next ;
         for (j = 0 ; dg != NULL ; j++) {
            dg->x = ((dr->rec - sp->st_rec) * sp->ntr + dg->trc) *
                                              sp->pix_per_trace + sp->xorg ;
            dg->y = (float)(dg->t0 / sp->smpint) * sp->pix_per_sample +
                                                   (float) sp->yorg + 0.5 ;
            compute_vstk (sp, dg) ;
            if (dg->prev) {
               if (dg->vstk > 0 && dg->prev->vstk > 0) {
                  vu = (float) (dg->prev->vstk*dg->prev->vstk) ;
                  vl = (float) (dg->vstk*dg->vstk) ;
                  tu = 0.001*(float) dg->prev->t0 ;
                  tl = 0.001*(float) dg->t0 ;
                  vint2 = (vl*tl - vu*tu) / (tl-tu) ;
                  dg->prev->vint = (vint2>0.0) ? (int) sqrt(vint2) : 0 ;
               }
               else
                  dg->prev->vint = 0 ;
            }
            dg = dg->next ;
         }
         sp->current_rec = dr->rec ;
         draw_xy_picks (sp, dr->digits, black) ;
         draw_vfunc (sp, dr->digits, apcolor) ;
      }
      else
       return;
      dr = dr->next ;
   }
   sp->current_rec = -9999 ;
}
/*
** Set a clipping rectangle in the given gc over the current TP record
*/

void set_pclip (sp, gc)
Seisplot *sp;
GC gc ;
{
   int xoff, xwidth ;
   XRectangle xrect[1] ;
	int xck999 = -9999;

	if(sp->current_rec == xck999) return;
   xwidth = sp->ntr * sp->pix_per_trace ;
   xoff = (sp->current_rec - sp->st_rec) * xwidth + sp->xorg ;
   xrect[0].x      = 0 ;
   xrect[0].y      = 0 ;
   xrect[0].width  = xwidth ;
   xrect[0].height = sp->height ;
   XSetClipRectangles (display, gc, xoff, 0, xrect, 1, Unsorted) ;
}
/*
** Set a clipping rectangle in the given gc over the current velocity function
*/

void set_vclip (sp, gc)
Seisplot *sp;
GC gc ;
{
   int voff ;
   XRectangle xrect[1] ;
	int xck999 = -9999;

	if(sp->current_rec == xck999) return;

   voff = (sp->current_rec - sp->st_rec) * sp->velplot->width ;
   xrect[0].x      = 0 ;
   xrect[0].y      = 0 ;
   xrect[0].width  = sp->velplot->width ;
   xrect[0].height = sp->height ;
   XSetClipRectangles (display, gc, voff, 0, xrect, 1, Unsorted) ;
}
/*
** Get velocity panel parameters and redraw picks and velocity functions
*/

XtCallbackProc change_velocityCB (w, velch, call)
Widget w;
Velch *velch;
caddr_t call;
{
   String string ;
   int junk, i ;
   float width ;
   Arg args[1] ;
   extern void draw_new_picks(), draw_vfunc() ;
   extern void free_digits();

   XtSetArg(args[0], XmNvalue, &string);

   XtGetValues((velch->vtexts)[0], args, 1);
   sscanf(string,"%d", &(velch->seisplot->velplot->velmin));

   XtGetValues((velch->vtexts)[1], args, 1);
   sscanf(string,"%d", &(velch->seisplot->velplot->velmax));

   XtGetValues((velch->vtexts)[2], args, 1);
   sscanf(string,"%f", &width);
   velch->seisplot->velplot->width = width * 100.0 + 1.5 ;

   if (velch->seisplot->velplot->velmin > velch->seisplot->velplot->velmax) {
      junk = velch->seisplot->velplot->velmin ;
      velch->seisplot->velplot->velmin = velch->seisplot->velplot->velmax ;
      velch->seisplot->velplot->velmax = junk ;
   }
   if (velch->seisplot->velplot->velmin == 0 &&
      velch->seisplot->velplot->velmax == 0) {
      velch->seisplot->velplot->velmin = 1400;
      velch->seisplot->velplot->velmax = 5000;
   }
   if (velch->seisplot->velplot->width < 51)
      velch->seisplot->velplot->width = 51;

   initialize_velplot (velch->seisplot) ;
   draw_new_picks (velch->seisplot) ;
   if (velch->seisplot->new_digits) {
      free_digits (velch->seisplot->new_digits) ;
      velch->seisplot->new_digits = NULL ;
   }
}
/*
** Compute a stacking velocity given trace number and t0 
*/

float get_vstk (sp, trc, t0)
Seisplot *sp ;
int trc, t0 ;
{
   float s, tp ;
   float vstk;

   if (smode == 0 || smode == 1 || smode == 4)
         vstk = (sp->vbuf)[trc-1];
   else  if (smode == 2) {
      tp = (float) (sp->tpbuf)[trc-1] ;
      if (tp >= 0.0)
         vstk = v1 * 1000. * sqrt(tp/(float)t0) ;
      else
         vstk = -v1 * 1000. * sqrt(-tp/(float)t0) ;
   }
   else {
      vstk = (float)(sp->tpbuf)[trc-1]*sqrt((float)tofe/(float)t0) ;
   }
   
   return(vstk);
}
/*
**  If append is requested for standard pick file writes, then
**  have to read the file, creating new Digrec structure, and
**  append existing Digrec structure to it, then write the new
**  structure back to the file.
*/
int
merge_picks_and_file(sp, pfile)
Seisplot *sp ;
char *pfile;
{
	int no_color = 0;
	/*int no_color = -43;*/
	float a1,a2,a3,one1,one2;
	int numrd;
	char soff[10];
   int  m, i, j, nrecs, ntpr, nsamps, iseg ;
   int  hnrecs, hnsamps, hntpr;
   float one, dig_int, record, vstak, time, hdig_int; 
   /*float one, dig_int, record, trace, time, hdig_int; */
	char ccnt[15];
	int nsegs, mxpks;
   char   string[255], s1[15], s2[15], s3[15];
   char cmd[255], *tfile;
   char hs1[15], hs2[15], hs3[15];
   static char  *segment  ="Segment" ;
   int exists, in_segs, out_segs;
   Digits *dg, *hdg;
   Digrec *dr, *hdr, *digrec_tail, *gdr;
   FILE  *file;
   Arg args[3];

   extern void update_message();


   if(!pfile)return;
   in_segs = 0;
   out_segs = 0;
   tfile = (char *)calloc(L_tmpnam+1, sizeof(char));
   (void)tmpnam(tfile);
   
   if((file = fopen(pfile,"r")) == NULL) {
     sprintf(string, "Error opening %s for input", pfile);
     update_message (string) ;
     return (-1);
   }

/*..............file open to READ for input.....................*/
   nrecs = (sp->ntrace - 1)/sp->ntr + 1;
   ntpr = sp->ntr;
   nsamps = sp->nss;
   numrd = fscanf (file,"%s %f %f %f %d %d %d %s %f %f %f %s %d %d",
      hs1, &one1, &one2, &hdig_int, &hnrecs, &hntpr, &hnsamps,
	soff, &a1, &a2, &a3, ccnt, &nsegs, &mxpks) ;
   if(hntpr != ntpr || hnsamps != nsamps) {
    sprintf(string,
     "Original and appended data sets are not compatible");
    update_message (string) ;
    return (-1);
   }
   for (i = 0 ; fscanf(file,"%s %s %s",s1,s2,s3)!=EOF ; i++) {
    if (strncmp(s1,segment,7) == 0) {
     in_segs ++;
     if (i) {
      hdr->next = (Digrec *)malloc (sizeof(Digrec)) ;
      hdr->next->prev = hdr ;
      hdr->next->next = NULL ;
      hdr = digrec_tail = hdr->next ;
      j = 0 ;
     }
     else {
      gdr = (Digrec *) malloc(sizeof(Digrec)) ;
      hdr = digrec_tail = gdr;
      hdr->prev = hdr->next = NULL ;
     }
     j = 0 ;
    }
    else {
     if (j) {
      hdg->next = (Digits *) malloc (sizeof(Digits)) ;
      hdg->next->prev = hdg ;
      hdg->next->next = NULL ;
      hdg = hdg->next ;
     }
     else {
      hdg = hdr->digits = (Digits *) malloc(sizeof(Digits)) ;
      hdg->prev = hdg->next = NULL ;
      sscanf (s1,"%f",&record) ;
      hdr->rec = (int)record;
     }
     sscanf (s2,"%f",&vstak) ;
     /*sscanf (s2,"%f",&trace) ;*/
     hdg->vstk = (int) vstak ;
     /*hdg->trc = (int) trace ;*/
     sscanf (s3,"%f",&time) ;
     hdg->t0 = (int) time ;
	hdg->trc = get_trc(sp, hdg->vstk, hdg->t0);
     j++ ;
    }
   }
    
   hdr->next = sp->accepted_digrec_head;
   sp->accepted_digrec_head->prev = hdr;

   fclose(file);

   if ((file = fopen(tfile, "w")) == NULL) {
    sprintf(string, "Error opening %s for output", pfile);
    update_message (string) ;
    if(pfile) {
	(void) free((char *) pfile) ;
	pfile = NULL;
    }
    return;
   }

/*.........file open for WRITE..........................*/
   nrecs = (sp->ntrace - 1)/sp->ntr + 1 + hnrecs;
   one = 1.0 ;
/*...mam...9-26-94....for std pick file output...*/
   fprintf(file,
	"Units %12.6f %12.5f %12.5f %6d %6d %6d Offset %12.6f %12.6f %12.6f\n",
              (float)sp->recunit, (float)sp->trcunit, (float)sp->smpunit,
                nrecs, sp->ntr, sp->nss,
                sp->recoff, sp->trcoff, sp->smpoff ) ;
/*...............................................*/
   dr = gdr;
   for (i = 0 ; dr != NULL ; i++) {
    fprintf(file, "Segment = %5d ", i+1);
    fprintf(file,"Name %20s ","NO_PICK_NAME_HERE");
    fprintf(file," color = %5d",no_color);
    fprintf(file," picks = %5d\n",dr->nv);
    out_segs++;
    dg = dr->digits ;
    for (j = 0 ; dg != NULL ; j++) {
     if(out_segs<=in_segs)
      fprintf(file,"%12.6f %12.6f %12.6f\n",
         (float)dr->rec, (float)dg->vstk,(float)(dg->t0));
         /*(float)dr->rec, (float)dg->trc,(float)(dg->t0));*/
     else
      fprintf(file,"%12.6f %12.6f %12.6f\n",
         (float)sp->irec_buf[dr->rec],
         (float)dg->vstk,(float)(dg->t0));
         /*(float)dg->trc,(float)(dg->t0));*/
       dg = dg->next ;
    }
    dr = dr->next ;
   }
   fclose(file);
   strcpy(cmd,"mv ");
   strcat(cmd, tfile);
   strcat(cmd," ");
   strcat(cmd,pfile);
   memset(cmd+4+strlen(tfile)+strlen(pfile)+1,'\0',1);
   system(cmd);
   free(tfile);

   return(0);
}

XtCallbackProc copy_or_merge_picksCB (w, sp, call)
Widget w ;
Seisplot *sp ;
caddr_t call ;
{
   int  m, i, j, nrecs, from, to, ifrom, ito;
   int  icount,insert, irec, found_from;
	int found_to;
   String string;
   Digits *dg, *hdg;
   Digrec *dr, *hdr, *digrec_tail, *gdr;
   Arg args[3];

   extern void update_message(), draw_new_picks();
	extern void free_digrec();

   string=XmTextGetString(copy_text[0]);
   if(strlen(string))
     sscanf(string,"%d", &from);
   else
     from = 0;
   XtFree(string);

   string=XmTextGetString(copy_text[1]);
   if(strlen(string))
     sscanf(string,"%d", &to);
   else
     to = 0;
   XtFree(string);

   nrecs = (sp->ntrace - 1)/sp->ntr + 1;
   icount = 0;
   for (i=0; i< nrecs; i++) {
    irec = sp->irec_buf[i];
    if(irec == to ) {
     icount++;
     ito = i;
    }
   }
   if(icount == 0) {
     fprintf(stderr," Could not find 'to' record %d in displayed data\n", to);
     return;
   }

   icount = 0;
   for (i=0; i< nrecs; i++) {
    irec = sp->irec_buf[i];
    if(irec == from ){
     ifrom = i;
     icount++;
    }
   }
   if(icount == 0) {
     fprintf(stderr, "Could not find 'from' record %d in displayed data\n",from);
     return;
   }

    
   insert = 0;
   found_from = 0;
   found_to = 0;
   dr = sp->accepted_digrec_head;
   /*for (i=0; dr != NULL; i++) {*/
   for (i=0; dr != NULL && ((found_from + found_to) < 2); i++) {
/*..cmam...this was a REALLY stupid error...*/
   /*for (i=0; dr != NULL && ((found_from + found_to) < 1); i++) {*/
    irec = sp->irec_buf[dr->rec];
    /*if(irec > to ) insert = 1;
    if(irec == to) insert = 2;*/
    if(irec == from) {
     found_from = 1;
     hdr = (Digrec *)malloc(sizeof(Digrec));
     hdr->next = hdr->prev = NULL;
     hdg = hdr->digits = (Digits *)malloc(sizeof(Digits));
     hdg->next = hdg->prev = NULL;
     hdr->rec = ito;
     hdr->nv  = dr->nv;
     dg = dr->digits;
     for (j=0; dg != NULL; j++) {
      if(j) {
       hdg->next = (Digits *)malloc(sizeof(Digits));
       hdg->next->prev = hdg;
       hdg->next->next = NULL;
       hdg = hdg->next;
      }
      hdg->trc = dg->trc;
      hdg->t0  = dg->t0;
      hdg->vstk = dg->vstk;
      hdg->vint = dg->vint;
      dg = dg->next;
     }
    }
/*....added 2-3-95...cmam...*/
    /*else if (!found_to) {*/
    if (!found_to) {
	if(irec == to) {
		insert = 2;
		found_to = 1;
	}
	else if (irec > to) {
		insert = 1;
		found_to = 1;
	}
    }
/*..........................*/
    dr = dr->next;
   }
   if(!found_from) return;   /*..cmam..'from' record not found...*/
			     /*..nothing can be copied, so return*/

    switch (insert) {
     case 0:                 /*..cmam..add at tail end of list..*/
			     /*..no record found that is > to...*/
	dr = sp->accepted_digrec_tail;
	if(dr->next == NULL) {
		gdr = dr;
		dr->next = hdr;
		hdr->prev = gdr;
		hdr->next = NULL;
		sp->accepted_digrec_tail = hdr;
		break;
	}
       /*...dr = sp->accepted_digrec_head;
       for (i=0;dr != NULL; i++) {
        if(dr->next == NULL) {
         gdr = dr;
         dr->next = hdr;
         hdr->prev = gdr;
         hdr->next = NULL;
         sp->accepted_digrec_tail = hdr;
         break;
        }
        else
         dr = dr->next;
       }...*/
       break;
     case 1:                  /*..cmam..insert between two records or..*/
			      /*........insert at head of linked list..*/
       dr = sp->accepted_digrec_head;
       for (i=0; dr != NULL; i++) {
		/*...cmam...april 11, 1995................................*/
		/*...irec,to are actual record numbers; ito is an index...*/
	irec = sp->irec_buf[dr->rec];
	if(irec > to) {
	/*...cmam...see reason above...if(irec > ito) {*/
        /*if(dr->rec > ito) {*/
         if(i) {
	  /*..insert between two records..*/
          gdr = dr->prev;
          /*dr->prev->next = hdr;*/
	  gdr->next = hdr;
          dr->prev       = hdr;
          hdr->prev      = gdr;
          hdr->next      = dr;
          break;
         }
         else {
	  /*..insert at head of linked list..*/
          gdr = dr;
          dr->prev = hdr;
          /*..dr->next = gdr;...this does not look right...*/
	  hdr->next = gdr;
          hdr->prev = NULL;
          sp->accepted_digrec_head = hdr;
          break;
         }
        }
        dr = dr->next;
       }
       break;
     case 2:                   /*..cmam..replace a record with a copy..*/
       /* return; */
/*..cmam...added the following code to replace a record..*/
	dr = sp->accepted_digrec_head;
	for (i=0; dr!= NULL; i++) {
		irec = sp->irec_buf[dr->rec];
		if(irec == to) {

			hdr->prev = dr->prev;
			if(dr->prev != NULL) dr->prev->next = hdr;
			if(dr->next != NULL) dr->next->prev = hdr;
			hdr->next = dr->next;
			free_digrec(dr);
			dr = hdr;
			break;
		}
		dr = dr->next;
	}
/*.......................................................*/
       break;
     default:		/*..cannot figure out what to do, so do nothing..*/
       printf(" I don't know if this is insert or append\n");
       return;
       break;
    }
/*...need to clear the picks from the spectra display...*/
 
   XtSetArg (args[0], XmNwidth, sp->width) ;
   XtSetArg (args[1], XmNheight, sp->height) ;
   XtSetValues (sp->velplot->drawA, args, 2) ;
/*@@@ dr - leave the moveout plot intact @@@*/
   if( !done_moveout )
     done_moveout=0;
   XtUnmanageChild (seisplot[TP].velplot->drawA) ;
   XtManageChild   (seisplot[TP].velplot->drawA) ;
   XCopyArea (display, sp->backup, sp->window, gc,
              0, 0, sp->width, sp->height, 0, 0) ;
   XCopyArea (display, sp->backup, sp->pixmap, gc,
              0, 0, sp->width, sp->height, 0, 0) ;
 
   for (i = sp->st_rec ; i <= sp->end_rec ; i++) {
      sp->current_rec = i ;
      clear_velocity_area (sp, 0, 0) ;
   }
   sp->current_rec = -9999 ;
/*.......................................................*/

    draw_new_picks(sp);
}
/*
** Compute a trace number given stacking velocity and t0 
*/

int get_trc (sp, vstk, t0)
Seisplot *sp ;
int vstk, t0 ;
{
   float s, tp ,tp1,tp2, vtp, v2, mid_tp;
   int trc, m, i;
   int vel1, vel3, mid_v;

   trc = 1;
   v2 = (float)vstk*.001;
   switch (smode) {
	case 0:
	case 1:
	case 4:
    for(i=1;i<sp->ntr; i++) {
     vel1 = sp->vbuf[i-1];
     vel3 = sp->vbuf[i];
     mid_v = (vel3+vel1)/2;
     if(vel1 <= vstk && vel3 >= vstk) {
      if(vstk <= mid_v){
       trc = i;
   return(trc);
	break;
	}
      else {
       trc = i+1;
   return(trc);
	break;
	}
     }
    }
	break;
	case 2:
    vtp = v2/v1;
    vtp = vtp*vtp;
    tp = (float)t0 * vtp;
    for (i=1; i<sp->ntr; i++) {
     tp1 = sp->tpbuf[i-1];
     tp2 = sp->tpbuf[i];
     mid_tp = (tp1+tp2)/2.;
     if(tp1 <= tp && tp2 >= tp) {
     if(tp <= mid_tp){
      trc = i;
   return(trc);
	break;}
     else{
      trc = i+1;
   return(trc);
	break;}
     }
    }
	break;
	default:
    vtp = (float)vstk/(v1*1000.);
    tp = vtp*vtp;
    tp = (float)t0 * vtp;
    for (i=1; i<sp->ntr; i++) {
     tp1 = sp->tpbuf[i-1];
     tp2 = sp->tpbuf[i];
     mid_tp = (tp1+tp2)/2.;
     if(tp1 <= tp && tp2 >= tp) {
     if(tp <= mid_tp){
      trc = i;
   return(trc);
	break;}
     else{
      trc = i+1;
   return(trc);
	break;}
     }
    }
	break;
  }
}

XtCallbackProc read_save_picksCB(w, sp, call)
Widget w ;
Seisplot *sp ;
XmFileSelectionBoxCallbackStruct   *call ;
{
        int no_color = -43;
	int npicks, nsegments, maxpicks ;
   int  m, i, j, nrecs, ntpr, nsamps, iseg ,k;
	int ij;
/*...cmam...10-20-94...*/
	int ii, itemp, ik, ik1;
	Velrec *veltmp1, **velgood;
	Digrec **dig_array;
	int *pikrecs;
	int trcend;
	int kfirst;
/*.....................*/
/*..cmam...add for li,di values for vi3d format..*/
	int mm, lival, dival;
/*..cmam...4-26-96...place to hold last record saved..*/
	int ilrec;
/*..cmam...pik_type=6 values..*/
	int kt0, krec, kvstk;
   float one, dig_int, record, trace, time , vel_int, vel_min,local_vel;
   char   *pfile, string[255], s1[15], s2[15], s3[15];
   char *s, *as,*bs, *cs, sone[15];
	float s8, s9, s10;
	char soff[15];
   /*char *s, *as,*bs, *cs, sone[15], s8[15], s9[15], s10[15];*/
   static char   *segment  ="Segment" ;
   int exists, igo;
   extern int merge_picks_and_file();
   Digits *dg, *dgg ;
   Digrec *dr, *drr;
   float *velo, *v;
   int nvel, *time_arr, *t, rec,tdfn_9;
   int pik_type, tt, vv, rr, ls,l1,l2,l3;
   extern void wr_tdfn(), wr_handvel(), wr_tvpairs();
/*....cmam...added for vi3d format...*/
   extern void wr_vi3d();
/*...................................*/
   FILE  *file;
   Arg args[3];
   Velrec *vr, *velrec, *vrr;
   Velits *vs, *vss;
   extern XtCallbackProc manage_widgetCB();

   extern void update_message(), draw_new_picks() ;
   extern float get_vstk();
   extern int ascertain(), get_trc();
	extern void free_digrec(), free_all_digrec();

   XmStringGetLtoR (call->value, XmSTRING_DEFAULT_CHARSET, &pfile) ;

   if(!pfile)return;
   if (rw_picks == READP) {
      if ((file = fopen(pfile, "r")) == NULL) {
         sprintf(string, "Error opening %s for input", pfile);
         update_message (string) ;
         if(pfile) {
		(void) free((char *) pfile) ;
		pfile = NULL;
         }
         return ;
      }
      else {
         XtSetSensitive (apmo_button, True) ;
	 if (sp->accepted_digrec_head) {
	     free_all_digrec(sp->accepted_digrec_head);
            sp->accepted_digrec_head = sp->accepted_digrec_tail = NULL ;

/*...need to clear the picks from the spectra display...*/

   XtSetArg (args[0], XmNwidth, sp->width) ;
   XtSetArg (args[1], XmNheight, sp->height) ;
   XtSetValues (sp->velplot->drawA, args, 2) ;

/*@@@ dr - leave the moveout plot intact @@@*/
   if( !done_moveout )
     done_moveout=0; 

   XtUnmanageChild (seisplot[TP].velplot->drawA) ;
   XtManageChild   (seisplot[TP].velplot->drawA) ;
   XCopyArea (display, sp->backup, sp->window, gc,
              0, 0, sp->width, sp->height, 0, 0) ;
   XCopyArea (display, sp->backup, sp->pixmap, gc,
              0, 0, sp->width, sp->height, 0, 0) ;
 
   for (i = sp->st_rec ; i <= sp->end_rec ; i++) {
      sp->current_rec = i ;
      clear_velocity_area (sp, 0, 0) ;
   }
   sp->current_rec = -9999 ;
/*.......................................................*/

         }
         if((fgets (string, 132, file)) == NULL) {
          fprintf(stderr,"Input file contains no data!\n"); 
          return;
         }
         if((pik_type = ascertain(string)) == -1) {
          fprintf(stderr,"Unknown file type input \n");
          return;
         }
         /*if(pik_type && (pik_type < 4 || pik_type == 5))  {*/
         if(pik_type && (pik_type != 4 ))  {
          rewind(file);
          velrec = (Velrec *)malloc(sizeof(Velrec));
          if(pik_type == 1) {     /* rd_handv(velrec, file); */
           k = 0;
           s = (char *)calloc(82,sizeof(char));
           cs = (char *)calloc(9,sizeof(char));
           fgets(s, 82, file);
           for (i=0; fgets(s, 82, file) != NULL; i++) {
            if(!strncmp(s,"HANDVEL",7)) {
             if(i) {
              k=0;
              vr->next = (Velrec *)malloc(sizeof(Velrec));
              vr->next->prev = vr;
              vr->next->next = NULL;
              vr = vr->next;
              vr->nv = 0;
              strncpy(cs,s+8,8);
              vr->rec = atoi(cs);
              vs = vr->velits = (Velits *)malloc(sizeof(Velits));
              vs->next = vs->prev= NULL;
             }
             else  {
              k=0;
              vr = velrec;
              vr->nv = 0;
              strncpy(cs,s+8,8);
              vr->rec = atoi(cs);
              vr->prev = vr->next = NULL;
              vs = vr->velits = (Velits *)malloc(sizeof(Velits));
              vs->next = vs->prev = NULL;
             }
             continue;
            }
            else
             k++;
            as = s;
            for (m=0; m <4; m++) {
             if (m || (k >= 2)) {
              vs->next = (Velits *)malloc(sizeof(Velits));
              vs->next->next = NULL;
              vs->next->prev = vs;
              vs = vs->next;
             }
             strncpy(cs,as,8);
             tt = (int)atof(cs);
             as +=8;
             strncpy(cs,as,8);
             vv = (int)atof(cs);
             vs->t0 = tt;
             vs->vstk = vv;
             if(vv)
              vr->nv++;
             else
              vs->prev->next = NULL;
             as+=8;
            }
           }
           free(s);
           free(cs);
          }
          if(pik_type == 2) {   /*...TDFN format input...*/
/*..cmam...read velocity function from 1-9TDFN cards...*/
           tdfn_9 = 0;
           s = (char *)malloc(82*sizeof(char));
           bs = (char *)calloc(5,sizeof(char));
           cs = (char *)calloc(6,sizeof(char));
           for (i=0; fgets(s, 82, file) != NULL; i++) {
            if(!strncmp(s,"1TDFN",5) || !tdfn_9 ) {
             k=0;
             tdfn_9 = 1;
             if(i) {
              vr->next = (Velrec *)malloc(sizeof(Velrec));
              vr->next->prev = vr;
              vr->next->next = NULL;
              vr = vr->next;
              vr->nv = 0;
              vs = vr->velits = (Velits *)malloc(sizeof(Velits));
              vs->next = vs->prev= NULL;
              vr->rec = 0;
              strncpy(cs,s+75,5);
              vr->rec = atoi(cs);
             }
             else {
              vr = velrec;
              vr->nv = 0;
              vr->prev = vr->next = NULL;
              vs = vr->velits = (Velits *)malloc(sizeof(Velits));
              vs->next = vs->prev = NULL;
              vr->rec = 0;
              strncpy(cs,s+75,5);
              vr->rec = atoi(cs);
             }
            }
            else if (!strncmp(s,"9TDFN",5) && !tdfn_9) {
             k=0;
             if(i) {
              vr->next = (Velrec *)malloc(sizeof(Velrec));
              vr->next->prev = vr;
              vr->next->next = NULL;
              vr = vr->next;
              vr->nv = 0;
              vs = vr->velits = (Velits *)malloc(sizeof(Velits));
              vs->next = vs->prev= NULL;
              vr->rec = 0;
              strncpy(cs,s+75,5);
              vr->rec = atoi(cs);
             }
             else {
              vr = velrec;
              vr->nv = 0;
              vr->prev = vr->next = NULL;
              vs = vr->velits = (Velits *)malloc(sizeof(Velits));
              vs->next = vs->prev = NULL;
              vr->rec = 0;
              strncpy(cs,s+75,5);
              vr->rec = atoi(cs);
             }
            }
            else {
             k = 1;
            }
            if (!strncmp(s,"9TDFN",5) && tdfn_9) tdfn_9 = 0;
            as = s+5;
            for (m=0; m <7; m++) {
             if (m || k) {
              vs->next = (Velits *)malloc(sizeof(Velits));
              vs->next->next = NULL;
              vs->next->prev = vs;
              vs = vs->next;
             }
             strncpy(bs,as,4);
             tt = atoi(bs);
             as +=4;
             strncpy(cs,as,5);
             vv = atoi(cs);
             vs->t0 = tt;
             vs->vstk = vv;
             if(vv)
              vr->nv++;
             else
              vs->prev->next = NULL;
             as+=5;
            }
           }
           free(s);
           free(bs);
           free(cs);
          }
          if(pik_type == 5) {   /*...TDFN format input...*/
/*..cmam...for vi3d format, read 0TDFN card, then proceed like TDFN format...
...0TDFN card of function will contain li,di for this record..
...read velocity function from 1-9TDFN cards...*/
           s = (char *)malloc(82*sizeof(char));
           bs = (char *)calloc(5,sizeof(char));
           cs = (char *)calloc(6,sizeof(char));
	   tdfn_9 = 1;
           for (i=0; fgets(s, 82, file) != NULL; i++) {
            if(!strncmp(s,"0TDFN",5) ) {
/*..cmam...first card in function is 0TDFN -- only 1 per function...*/
	      k = 0;
	     if(tdfn_9) {
/*..cmam...first card -- first function..*/
              vr = velrec;   /*..this Velrec already allocated above..*/
              vr->nv = 0;
              vr->prev = vr->next = NULL;
/*..cmam...allocate first Velits for first point..*/
              vs = vr->velits = (Velits *)malloc(sizeof(Velits));
              vs->next = vs->prev = NULL;
              vr->rec = 0;
              strncpy(cs,s+5,5);
              vr->lival = (int)atoi(cs);
              strncpy(cs,s+10,5);
              vr->dival = (int)atoi(cs);
	      tdfn_9 = 0;
	      k = 1;
            }
            else {
/*..cmam...0TDFN card but this is not first function read...
...need to allocate a Velrec for this new function..*/
              vr->next = (Velrec *)malloc(sizeof(Velrec));
              vr->next->prev = vr;
              vr->next->next = NULL;
              vr = vr->next;
              vr->nv = 0;
/*..cmam..allocate first Velits for first point..*/
              vs = vr->velits = (Velits *)malloc(sizeof(Velits));
              vs->next = vs->prev= NULL;
              vr->rec = 0;
              strncpy(cs,s+5,5);
              vr->lival = (int)atoi(cs);
              strncpy(cs,s+10,5);
              vr->dival = (int)atoi(cs);
	      k = 1;
             }        /*..end of else..*/
            }         /*..end of if (!strncmp...*/

            else {
/*..not a 0TDFN card -- read up to 7 points from this card..
..first we get the record number..*/
	    strncpy (cs,s+75,5);
	    vr->rec = atoi (cs);

            as = s+5;
            for (m=0; m <7; m++) {
             if (k) {
	      k = 0;
             }
	     else {
/*..cmam..allocate next Velits for this function..*/
              vs->next = (Velits *)malloc(sizeof(Velits));
              vs->next->next = NULL;
              vs->next->prev = vs;
              vs = vs->next;
             }
             strncpy(bs,as,4);
             tt = atoi(bs);
             as +=4;
             strncpy(cs,as,5);
             vv = atoi(cs);
             vs->t0 = tt;
             vs->vstk = vv;
             if(vv)
              vr->nv++;
             else
              vs->prev->next = NULL;
             as+=5;
            }
           }     /*..end of else ..not a 0TDFN card..*/
           }
           free(s);
           free(bs);
           free(cs);
          }
/*......end of vi3d format stuff....*/

          if(pik_type == 3) {      /*rd_tvr(velrec, file); */
           k = 0;
           s = (char *)malloc(132*sizeof(char));
           as = (char *)calloc(82,sizeof(char));
           bs = (char *)calloc(82,sizeof(char));
           cs = (char *)calloc(82,sizeof(char));
           for (i=0; fgets(s, 132, file) != NULL; i++) {
            if(i && k) {
             vr->next = (Velrec *)malloc(sizeof(Velrec));
             vr->next->prev = vr;
             vr->next->next = NULL;
             vr = vr->next;
             vr->nv = 0;
             vs = vr->velits = (Velits *)malloc(sizeof(Velits));
             vs->next = vs->prev= NULL;
            }
            else if(!i){
             vr = velrec;
             vr->nv = 0;
             vr->prev = vr->next = NULL;
             vs = vr->velits = (Velits *)malloc(sizeof(Velits));
             vs->next = vs->prev = NULL;
            }
     
            ls = strlen(s);
            if(strchr(s,'-') == NULL) {
             l1 = ls - strlen(strchr(s,','));
             l2 = (ls - strlen(strrchr(s,','))) - l1-1;
             l3 = ls -(l1+2+l2);
             strncpy(as,s,l1); memset(as+l1,'\0',1);
             strncpy(bs,s+l1+1,l2); memset(bs+l2,'\0',1);
             strncpy(cs,s+l1+l2+2,l3); memset(cs+l3,'\0',1);
             vr->rec = atoi(cs);
             vs->t0 = atoi(as);
             vs->vstk = atoi(bs);
             vs->next = (Velits *)malloc(sizeof(Velits));
             vs->next->next = NULL;
             vs->next->prev = vs;
             vs = vs->next;
/*...cmam...keep running counter of no. vel for this rec...*/
	     vr->nv ++;
             k = 0;
            }
            else {
             k=1;
             vs->prev->next = NULL;
            }
           }
           free(s);
           free(as);
           free(bs);
           free(cs);
          }
/*....new format -- tvr without commas = pik_type = 6 ...*/
          if(pik_type == 6) {
           k = 0;
           s = (char *)malloc(132*sizeof(char));
           as = (char *)calloc(82,sizeof(char));
           bs = (char *)calloc(82,sizeof(char));
           cs = (char *)calloc(82,sizeof(char));
           for (i=0; fgets(s, 132, file) != NULL; i++) {
            if(i && k) {
             vr->next = (Velrec *)malloc(sizeof(Velrec));
             vr->next->prev = vr;
             vr->next->next = NULL;
             vr = vr->next;
             vr->nv = 0;
             vs = vr->velits = (Velits *)malloc(sizeof(Velits));
             vs->next = vs->prev= NULL;
            }
            else if(!i){
             vr = velrec;
             vr->nv = 0;
             vr->prev = vr->next = NULL;
             vs = vr->velits = (Velits *)malloc(sizeof(Velits));
             vs->next = vs->prev = NULL;
            }
 
            ls = strlen(s);
            if(strchr(s,'-') == NULL) {
/*..put this back in except check for blanks...*/
             l1 = ls - strlen(strchr(s,' '));
             l2 = (ls - strlen(strrchr(s,' '))) - l1-1;
             l3 = ls -(l1+2+l2);
             strncpy(as,s,l1); memset(as+l1,'\0',1);
             strncpy(bs,s+l1+1,l2); memset(bs+l2,'\0',1);
             strncpy(cs,s+l1+l2+2,l3); memset(cs+l3,'\0',1);
             vr->rec = atoi(cs);
             vs->t0 = atoi(as);
             vs->vstk = atoi(bs);
/*....
	     sscanf(s,"%d %d %d",kt0,kvstk,krec);
	     vr->rec = krec;
	     vs->t0 = kt0;
	     vs->vstk =kvstk;
....*/
             vs->next = (Velits *)malloc(sizeof(Velits));
             vs->next->next = NULL;
             vs->next->prev = vs;
             vs = vs->next;
/*...cmam...keep running counter of no. vel for this rec...*/
             vr->nv ++;
             k = 0;
            }
            else {
             k=1;
             vs->prev->next = NULL;
            }
           }
           free(s);
           free(as);
           free(bs);
           free(cs);
          }
/*....end of pik_type=6...*/
/*...cmam...here to put data from Velrec structures (read from the vel.file)
		into the Digrec structures corresponding to the displayed
		records in the CDP area....*/
/*...cmam...first, sort the Velrec structures so that all the records are
		in ascending order, with the lastest version of each record
		being the last in the list for that record...*/
	ik = 0;
	vr = velrec;
	for (i=0; vr != NULL; i++) {
/*...cmam...increment counter, go to next Velrec structure...*/
	   ik ++;
	   vr = vr->next;
	}
/*...cmam...ik = number of allocated, linked Velrec structures...*/
	pikrecs = (int *)calloc(ik, sizeof(int));
	velgood = (Velrec **)calloc(ik,sizeof(Velrec *));
	vr = velrec;
	for (i=0; vr != NULL; i++) {
/*...cmam...put rec no. in the array, go to next Velrec structure...*/
	   pikrecs[i] = vr->rec;
	   velgood[i] = vr;
	   vr = vr->next;
	}


for (ij=0; ij<ik; ij++) {
/*...cmam...ready to do the sort...*/
	/*..bug found by crider: last read record dropped during the sort..*/
	/*    for (j=0; j < ik; j++) {     */
	for (j=1; j < ik; j++) {
	  for (i=0; i < ik-j; i++) {
	   ii = i+1;
	   if(pikrecs[i] > pikrecs[ii]) {
/*...cmam...here we switch the two Velrec structures
	and the two "pointers" to records numbers ...*/
		itemp = pikrecs[i];
		pikrecs[i] = pikrecs[ii];
		pikrecs[ii] = itemp;
		veltmp1 = velgood[i];
		velgood[i] = velgood[ii];
		velgood[ii] = veltmp1;
	    }
	  }
	}
}

/*...cmam...Velrec structures sorted, now we need to build the
		Digrec structures for the displayed records...*/
/*...cmam...NOTE:  we will use the last instance of a record as
		the "good" velocity record...*/
/*...cmam...allocate  pointers to Digrec structs for all displayed recs...*/
	dig_array = (Digrec **)calloc(sp->nrecs,sizeof(Digrec *));
	for (i=0; i < sp->nrecs; i++) {
		dig_array[i] = NULL; }
/*..cmam...4-26-96...fix because last multiple record was never retrieved..*/
	ilrec = -999;
	ik1 = ik - 1;
	for (i=0; i<ik; i++) {
	  if( (i<ik1 && (pikrecs[i] != pikrecs[i+1])) ||
	      (i == ik1 && (pikrecs[i-1] != pikrecs[i])) ||
	      (i == ik1 && (pikrecs[i] > ilrec)) ){
/*..cmam..added above test to retrieve last record when mult occurances..*/
	      /* (i == ik1 && (pikrecs[i-1] != pikrecs[i])) ){ */
	    for (m=0; m < sp->nrecs; m++) {
		if(sp->irec_buf[m] == pikrecs[i]) {
		  dr = (Digrec *)malloc(sizeof(Digrec));
		  dr->rec = m;
		  vr = velgood[i];
		  dr->nv = vr->nv;
		  vs = vr->velits;
/*..get li,di values for this record..*/
		  mm = sp->li_di_ind[m];
		  dr->lival = sp->libuf[mm];
		  dr->dival = sp->dibuf[mm];
/*....................................*/
		  for (j=0; vs != NULL; j++) {
		    if (j) {
			dg->next = (Digits *)malloc(sizeof(Digits));
			dg->next->prev = dg;
			dg->next->next = NULL;
			dg = dg->next;
		    }
		    else {
			dg = dr->digits = (Digits *)malloc(sizeof(Digits));
			dg->prev = dg->next = NULL;
		    }
		    dg->vstk = vs->vstk;
		    dg->t0 = vs->t0;
		    dg->trc = get_trc(sp, dg->vstk, dg->t0);
		    vs = vs->next;
		  } /*..end of for (j=0...*/
		  dig_array[m] = dr;
		} /*..end of if(sp...*/
	    }  /*..end of for (m=0...*/
	  }   /*..end of if (i<ik...*/
	}     /*..end of for (i=0...*/
/*............................................................*/
          free(velrec);
          /*free_all_velrec(velrec);*/
/*.........free the allocated space......*/
	   free(pikrecs);
	   free(velgood);
         }
         else {  /*...file must be standard pick format..*/
		 /*...but it might be standard or non-standard in
			content:standard XSD-like = rec,vel,time
				non-standard = rec,trace,time.....*/
          rewind(file);
          if(fgets(string, 132,file) == NULL) {
           printf("Unable to read pick file \n");
           return;
          }
	trcend = sp->nss * sp->smpint;
/*...allocate pointers to Digrec structure pointers, initialize to NULL..*/
        dig_array = (Digrec **)calloc(sp->nrecs,sizeof(Digrec *));
	dr = NULL;
        for (i=0; i < sp->nrecs; i++) {
                dig_array[i] = NULL; }
/*........................................................................*/
          sscanf(string,"%s %f %s %f %d %d %d %s %f %f %f", s1,
                &one, sone, &dig_int, &nrecs, &ntpr, &nsamps,
                soff, &s8, &s9,&s10) ;
/*...read file until EOF (fgets returns a NULL)...*/
       j = 0;
	ik = 0;
          for (i = 0 ; fgets(string, 132,file) != NULL ; i++) {
           sscanf(string,"%s %s %s",s1,s2,s3);
           if (strncmp(s1,segment,7) == 0) {
	    dr = (Digrec *)malloc(sizeof(Digrec));
	    j = 0;
	   }		/*end of if(strncmp*/
	   else {
           if (j) {		/*NOT first digit of record*/
             dg->next = (Digits *) malloc(sizeof(Digits)) ;
             dg->next->prev = dg ;
             dg->next->next = NULL ;
             dg = dg->next ;
            }		/*end of if(j) */
	   else {		/*first digit of record*/
	     dr->digits = dg = (Digits *)malloc(sizeof(Digits));
	     dg->prev = dg->next = NULL;
	     sscanf(s1,"%f",&record);
	     dr->rec = -1;
	     for (m=0; m < sp->nrecs; m++) {
		if(sp->irec_buf[m] == (int)record) dr->rec = m;
	     }		/*end of for(m=...*/
	    }		/*end of else*/

	   if(dr->rec != -1) {
	     sscanf(s3,"%f",&time);
	     dg->t0 = (int)time;
	     if(dg->t0 > trcend) dg->t0 = trcend;
	     if(pik_type == 4) {
/*.....cmam....standard std pik file (has rec,vel,time values)...*/
		sscanf(s2,"%f",&local_vel);
		dg->vstk = (int)(local_vel + .5);
		dg->trc = get_trc(sp,dg->vstk,dg->t0);
	     }		/*end of if(pik_type */
	     else {
/*.....cmam....non-standard std pik file (has rec,tr,time values)...*/
		sscanf(s2,"%f",&trace);
		dg->trc = (int)trace;
		dg->vstk = 0;
	     }		/*end of else*/
	     if(!j) {
/*...cmam...if this record has already been read in, discard the previous
		record ( free the Digrec structure and its associated
		Digits structure before assigning the new record pointer...*/
		if(dig_array[dr->rec] != NULL) {
			free_digrec(dig_array[dr->rec]);
			dig_array[dr->rec] = NULL;
		}
		dig_array[dr->rec] = dr;
		ik ++;
	     }
      j = 1;
	   }		/*end of if(dr->rec */
	  }		/*end of else (if strncmp....*/
	}               /*end of for(i=0;..to read file..*/
	}		/*end of else for std pik file format */
/*...cmam...ik is actual number of records read in.  if more than
		one record is found with same number, the last one
		will replace the previous one(s). ...*/

/*...cmam...now we have to make the entries for a linked list...*/
	kfirst = 1;
	for (i=0; i < sp->nrecs; i++) {
		if (dig_array[i] != NULL) {
		   if (kfirst) {
			dr = dig_array[i];
			sp->accepted_digrec_head = dr;
			dr->prev = NULL;
			dr->next = NULL;
			kfirst = 0;
		   }
		   else {
			drr = dig_array[i];
			drr->prev = dr;
			drr->next = NULL;
			dr->next = drr;
			dr = drr;
		   }
		}
	}
	sp->accepted_digrec_tail = dr;
		  
	dr = sp->accepted_digrec_head;
	for (i=0; dr != NULL;i++ ) {
		dg = dr->digits;
		dr = dr->next;
	}

/*@@@----dr-*/
/*@@@----@@@*/

        draw_new_picks (sp) ;
        XtSetArg (args[0], XmNwidth, seisplot[TP].width) ;
        XtSetArg (args[1], XmNheight, seisplot[TP].height) ;
        XtSetValues (seisplot[TP].velplot->drawA, args, 2) ;
/*@@@ dr - leave the moveout plot intact @@@*/
        if( !done_moveout )
	   done_moveout = 0;
        XtUnmanageChild (seisplot[TP].velplot->drawA) ;
        XtManageChild   (seisplot[TP].velplot->drawA) ;
      }
   }
   else {
        exists = -1;
      file = fopen(pfile, "r");
      if(file != NULL) {
        if (save_picks_type) {
         exists = 1;
/*....here we need to read the first record to determine the type...*/
	 if((fgets (string, 132, file)) != NULL) {
	     if((pik_type = ascertain(string)) == -1) {
		sprintf(string,"Unknown file type on file to append to\n");
	 	update_message (string);
		return;
	     }
	 }
	 if(pick_format != pik_type) {
/*...pik_types 0 & 4 area both standard pik format...*/
	   if(pick_format != 0 && (pik_type == 0 || pik_type == 4)) {
	    sprintf(string,"Original and appended datasets are not compatible");
            update_message (string) ;
            return;
           }
	 }
	}
        else
         exists = 0;
        fclose(file);
      }
      else
       exists = 0;

      if(exists) {



/*....cmam....8-5-97....*/



       /*if(pick_format != 0) {*/  /*...NOT standard pick format...*/
       if(pick_format != 0 && pick_format !=6) {  /*...NOT standard pick format...*/
        if ((file = fopen(pfile, "a")) == NULL) {
         sprintf(string, "Error opening %s for output", pfile);
         update_message (string) ;
         if(pfile) {
	   (void) free((char *) pfile) ;
	   pfile = NULL;
	 }
         return;
        }
       }
       /*if(pick_format == 0) {*/   /*...stand pik format...*/
       if(pick_format == 0 || pick_format == 6) {   /*...stand pik format...*/
        igo = merge_picks_and_file(sp, pfile);
        return;
       }
      }
      else {
       if ((file = fopen(pfile, "w")) == NULL) {
         sprintf(string, "Error opening %s for output", pfile);
         update_message (string) ;
         if(pfile) {
		(void) free((char *) pfile) ;
		pfile = NULL;
	 }
         return;
       }
      }
      /*if(pick_format == 0) {*/ /*..standard pik file output (rec,vel,time)....*/
      if(pick_format == 0 || pick_format == 6) {/*..standard pik file output (rec,vel,time)....*/
/*...cmam..1-9-97...find max picks per segment..*/
	nsegments = 0;
	maxpicks = 0;
	dr = sp->accepted_digrec_head;
	for (i = 0; dr != NULL; i++ ) {
		nsegments = nsegments + 1;
		npicks = dr->nv;
		if(npicks > maxpicks) maxpicks = dr->nv;
		dr = dr->next;
	}
        nrecs = (sp->ntrace - 1)/sp->ntr + 1;
        one = 1.0 ;
        if(!exists) {
        /*if(!exists)fprintf(file,*/
/*...mam...9-26-94....for std pick file output...*/
  fprintf(file,"Units %12.6f %12.6f %12.6f ",
                seisplot[TP].recunit,seisplot[TP].trcunit,seisplot[TP].smpunit);
  fprintf(file,"%5d %5d %5d ",nrecs, seisplot[TP].ntr, seisplot[TP].nss);
  fprintf(file,"Offset %12.6f %12.6f %12.6f ",
          seisplot[TP].recoff,seisplot[TP].trcoff,seisplot[TP].smpoff );
  fprintf(file,"Count %5d %5d\n",nsegments,maxpicks);
	}
/*...............................................*/
        dr = sp->accepted_digrec_head ; 
        for (i = 0 ; dr != NULL ; i++) {
           fprintf(file, "Segment = %5d ", i+1);
    	   fprintf(file,"Name %20s ","NO_PICK_NAME_HERE");
           fprintf(file," color = %5d",no_color);
           fprintf(file," picks = %5d\n",dr->nv);
           dg = dr->digits ;
           for (j = 0 ; dg != NULL ; j++) {
               fprintf(file,"%12.6f %12.6f %12.6f\n",
                   (float)sp->irec_buf[dr->rec],
                   (float)dg->vstk,(float)(dg->t0));
               dg = dg->next ;
            }
            dr = dr->next ;
         }
        }
        else {
         velo = (float *)calloc(sp->nss, sizeof(float));
         time_arr = (int *)calloc(sp->nss, sizeof(float));
         dr = sp->accepted_digrec_head;
         for (i=0; dr != NULL ; i++) {
           v = velo;
           t = time_arr;
           nvel = 0;
           dg = dr->digits;
           for(j = 0; dg != NULL; j++) {
            *v = get_vstk(sp, dg->trc, dg->t0);
            *t = dg->t0;
             v ++; t ++;
             rec = (int)sp->irec_buf[dr->rec];
             nvel ++;
             dg = dg->next;
           }
/*..cmam..get li,di values..*/
	   if(pick_format == 5) {
	     /*lival = dr->lival;
	     dival = dr->dival;*/
/*...5-2-96...cmam...*/
	     mm = (int)sp->li_di_ind[dr->rec];
	     lival = (int)sp->libuf[mm];
	     dival = (int)sp->dibuf[mm];
	     /*  lival = (int)sp->libuf[dr->rec];
	     dival = (int)sp->dibuf[dr->rec];  */
	   }
           dr = dr->next;
           switch (pick_format) {
            case 1:    /*...DISCO format output...*/
             wr_handvel(velo, time_arr, nvel, rec, file);
             break;
            case 2:    /*...TDFN format output...*/
             wr_tdfn(velo, time_arr, nvel, rec, file);
             break;
            case 3:    /*...time/vel pairs output...*/
             wr_tvpairs(velo, time_arr, nvel, rec, file);
             break;
            case 5:    /*...vi3d format output...*/
             wr_vi3d(velo, time_arr, nvel, rec, file, lival, dival);
             break;
            default:
             sprintf(string,"Unknown pick format %d found",pick_format);
             update_error(string);
             return;
         } /*  end of switch */
       } /* end of for (i=0; dr != NULL...  loop) */
       free(velo);
       free(time_arr);
      }
   }
   fclose(file);
   if(pfile) free(pfile) ;
	pfile = NULL;
}
