/*********************************************************************
**
** Program name: handle_eventsCB 
**
** Languate:     C
**
** Author:       David Nelson
**
** Date written: May 21, 1991
**
**
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
**
** Abstract: X Toolkit event handler for digitizing, odometer, and
**           hyperbola drawing functions 
**
** Modification history: May 21, 1991 - Initial release
**
************************************************************************
**
*/

#include "xos.h"
#include "globals.h"

XtEventHandler handle_eventsCB (w, sp, event)
Widget w ;
Seisplot *sp ; /* pointer to both */
XEvent *event ;
{
   char   string[90] ;
/*...cmam....added 2-9-95....*/
	int irec, krec, insert, found, done;
	Digrec *hold_digrec, *dr;
/*...cmam....................*/
   int    iw, trc, rec, t0, ex, ey, isamp, rsamp, ntrcs,
          i, tindex, tx, si, vs, min_sq_dist, xleft ;
   float  s, val, rvel, tp, range, vi1, vi2, vint2, vu, vl, tu, tl ;
   float  delt;
   float  slow;
   double ss;

   static int xold1, yold1, xold2, yold2, xold3, yold3,
              xor=FALSE, xor_move1=FALSE, xor_move2=FALSE,
              xs1, xi1, xs2, xi2, xi2a, xs3, xi3, xs4, xi4, 
              clear, alot=99999, true_rec,
              xmove1, xmove2, ymove1, ymove2 ;
  static int xck999=-9999;

   static float vdiff, wm1, voff ;

/*......
   Digits *new_tail, *temp_digits, *accepted_digits_tail,
                 *nearest_digits ;

   Digrec *temp_digrec ,*new_digrec ;
........*/

   static Digits *new_tail, *temp_digits, *accepted_digits_tail,
                 *nearest_digits ;

   static Digrec *temp_digrec ;
	static Digrec *new_digrec ;

	Digrec *junk, *hold_prev_digrec, *hold_next_digrec;
   extern void update_odometer(), xy2rts(), clear_hyperbola(),
               clear_velocity_area(), draw_vfunc(),
               rubber_band_man(), clear_seismic_area(), draw_xy_picks(),
               free_digits(), free_digrec(), set_vclip(),
               find_nearest_neighbor(), compute_vint(), compute_vstk() ;



   switch (event->type) {

   case MotionNotify :
      ex = event->xmotion.x ;
      ey = event->xmotion.y ;

/*
**    Which window was the event detected in ???
*/

      for (i = CDP ; i <= TP ; i++)
         if (event->xmotion.window == sp[i].window) iw = i ;


      if (event->xmotion.window == sp[TP].velplot->window) iw = VEL ;
      if (iw == VEL && done_moveout) iw = MO;

/*
**    Handle odometer, hyperbola, digitizer rubber banding as needed
*/

      if (iw == CDP || iw == TP || iw == MO) {
         xy2rts (&sp[iw], ex, ey, &rec, &trc, &ntrcs, &t0, &isamp, &rsamp) ;
         true_rec = sp[iw].irec_buf[rec];

         if ((t0 >= 0) && (rsamp <= sp[iw].nss) &&
                        (ntrcs > 0) && (ntrcs <= sp[iw].ntrace)) {
            clear = TRUE ;
            if (iw == CDP || iw == MO) {
/*
**             Handle odometer
*/
             val = (sp[iw].data)[(ntrcs-1)*sp[iw].nss + (rsamp - 1)] ;
             sprintf(string,
             "Record: %-5d  Trace: %-4d  Time: %-5d  Amplitude: %-9.3f",
                                        true_rec, trc, t0, val) ;
               update_odometer(string) ;
            }
            else {
/*
**             Handle odometer
*/
               val = (sp[iw].data)[(ntrcs-1)*sp[iw].nss + (rsamp - 1)] ;
               if (smode == 0 || smode == 1 || smode == 4) {
                 vs = (float) (sp[iw].vbuf)[trc-1];
               }
               else if (smode == 2) {
                  tp = (float) (sp[iw].tpbuf)[trc-1] ;
                  if (tp >= 0.0 && t0 != 0)
                     vs = v1 * 1000. * sqrt(tp/(float)t0) ;
                  else if(tp < 0.0 && t0 != 0)
                     vs = -v1 * 1000. * sqrt(-tp/(float)t0) ;
                  else 
                     vs = v1;
               }
               else {
                  if(t0)
                  vs =  (float)(sp[TP].tpbuf)[trc-1] *
                                 sqrt((float)tofe/(float)t0) ;
                  else
                   vs = 0.0;
               }
               sprintf(string,
    "Record: %-5d  Trace: %-4d  Time: %-5d  Velocity: %-8d  Amplitude: %-9.3f",
                     true_rec, trc, t0, vs, val) ;
               update_odometer(string) ;

/*
**             Handle hyperbola
*/
               si = sp[CDP].smpint ;
               clear_hyperbola(&sp[CDP]) ;
               sp[CDP].hyperbola =
              (int *) malloc((unsigned)(2*sp[CDP].ntr)*sizeof(int)) ;
               XSetForeground (display, gc, hycolor) ;
               for (i = 0 ; i < sp[CDP].ntr ; i++) {
                  tindex = (rec - sp[CDP].st_rec) * sp[CDP].ntr + i ;
                  range = (float)(sp[CDP].xoffset)[tindex] ;
                  slow = (sp[CDP].slowbuf)[tindex] ;
                  if (smode == 0 || smode == 1 || smode == 4) {
                   if(smode == 0 || smode == 1) {
                     if (vs > 0.0) {
                        s = vs * .001 ;
                        tx = (int)sqrt(t0*t0+range*range/(s*s))/si ;
                     }
                   }
                   else {
                    if(vs > 0.0) {
                     ss = vs*slow;
                     if (fabs(ss) <= 1.0) {
                      ss = 1.0 - fabs(ss*ss);
                      tx = (int)((float)t0*(float)sqrt(ss));
                      tx /= si;
                     }
                     else
                      tx = 0;
                    }
                   }
                  }
                  else  if (smode == 2) {
                     if (tp > 0.0)
                        tx = (int)((t0 - tp +
                              sqrt(tp*tp+range*range/(v1*v1))+0.5*si)/si) ;
                     else if (tp < 0.0)
                        tx = (int)((t0 - tp -
                              sqrt(tp*tp+range*range/(v1*v1))+0.5*si)/si) ;
                     else
                        tx = t0/si ;
                  }
                  else {
                     s = vs * .001 ;
                     if (s > 0.0)
                        tx = (int)sqrt(t0*t0+range*range/(s*s))/si ;
                     else if (s < 0.0) {
                        if (range*range/(s*s) < t0*t0)
                           tx = (int)sqrt(t0*t0-range*range/(s*s))/si ;
                        else
                           tx = 0 ;
                     }
                     else
                        tx = t0/si ;
                  }

                  (sp[CDP].hyperbola)[2*i] = sp[CDP].xorg + tindex * 
                                             sp[CDP].pix_per_trace ;
                  (sp[CDP].hyperbola)[2*i+1] = sp[CDP].yorg + (tx) * 
                                               sp[CDP].pix_per_sample ;
                  if (i > 0) 
                     XDrawLine (display, sp[CDP].window, gc,
                                (sp[CDP].hyperbola)[2*i-2], 
                                (sp[CDP].hyperbola)[2*i-1],
                                (sp[CDP].hyperbola)[2*i],
                                (sp[CDP].hyperbola)[2*i+1]) ;
               }
/*
**             Handle draw on moveout 
*/
               if (done_moveout) {
                si = sp[MO].smpint ;
                clear_hyperbola(&sp[MO]) ;
                sp[MO].hyperbola =
                (int *) malloc((unsigned)(2*sp[MO].ntr)*sizeof(int)) ;
                XSetForeground (display, gc, hycolor) ;
                for (i = 0 ; i < sp[MO].ntr ; i++) {
                  tindex = (rec - sp[MO].st_rec) * sp[MO].ntr + i ;
                  range = (sp[MO].xoffset)[tindex] ;
                  tx = t0/si;

                  (sp[MO].hyperbola)[2*i] = sp[MO].xorg + tindex * 
                                             sp[MO].pix_per_trace ;
                  (sp[MO].hyperbola)[2*i+1] = sp[MO].yorg + (tx) * 
                                               sp[MO].pix_per_sample ;
                  if (i > 0) 
                     XDrawLine (display, sp[MO].window, gc,
                                (sp[MO].hyperbola)[2*i-2], 
                                (sp[MO].hyperbola)[2*i-1],
                                (sp[MO].hyperbola)[2*i],
                                (sp[MO].hyperbola)[2*i+1]) ;
                }
               }

/*
**             Handle rubber banding for digitizer
*/
               if (sp[iw].new_digits) {
                  if(ey > new_tail->y && vs > 0 && new_tail->vstk > 0){
                     vu = (float) (new_tail->vstk*new_tail->vstk) ;
                     vl = (float) (vs*vs) ;
                     tu = 0.001* (float) new_tail->t0 ;
                     tl = 0.001* (float) t0 ;
                     delt = tl-tu;
                     if(delt > 0.0)
                     vi1 = (vl*tl - vu*tu) / (tl-tu) ;
                     else
                     vi1 = 0.;
                     if(vi1 > 0.0) 
                       vi1 = (int)sqrt(vi1);
                     else
                       vi1 = 0.;
                  }
                  else
                     vi1 = 0.0 ;

                  if (xor) {
                     set_pclip (&sp[iw], gc_rubber) ;
                     rubber_band_man (sp[iw].window,
                                      xold1, yold1, xold2, yold2) ;

/*@@@ dr - do not draw on the moveout @@@*/
                     if( !done_moveout ) {
		       set_vclip (&sp[iw], gc_rubber) ;
                       rubber_band_man (sp[iw].velplot->window, 
					xs1, yold1, xs2, yold2) ;
		       if (sp[iw].new_digits && sp[iw].new_digits->next)
			 rubber_band_man (sp[iw].velplot->window, 
					  xi1, yold1, xi2, yold1) ;
		       rubber_band_man (sp[iw].velplot->window, 
					xi2, yold1, xi2, yold2) ;
		     }
                  }
                  xor = TRUE ;
                  set_pclip (&sp[iw], gc_rubber) ;
                  rubber_band_man (sp[iw].window,
                                   xold1 = new_tail->x, yold1 = new_tail->y,
                                   xold2 = ex, yold2 = ey) ;
/*@@@ dr - do not draw on the moveout @@@*/
		  if( !done_moveout ) {
		    vdiff=(float)(sp[iw].velplot->velmax-sp[iw].velplot->velmin);
		    wm1 = (float)(sp[iw].velplot->width-1) ;
		    voff = (sp[iw].current_rec - sp[iw].st_rec) * sp[iw].velplot->width + 0.5 ;
		    set_vclip (&sp[iw], gc_rubber) ;
		    rubber_band_man (sp[iw].velplot->window,
                                     xs1 = voff + wm1 * (float)(new_tail->vstk - 
                                     sp[iw].velplot->velmin) / vdiff, yold1,                
                                     xs2=voff+wm1*(float)(vs-sp[iw].velplot->velmin)/vdiff,yold2);
		    xi2 = voff + wm1 * (vi1-(float)sp[iw].velplot->velmin)/vdiff;
		    if (sp[iw].new_digits && sp[iw].new_digits->next)
		      rubber_band_man (sp[iw].velplot->window,
                                       xi1 = voff + wm1 * (float)(new_tail->prev->vint - 
                                       sp[iw].velplot->velmin) / vdiff,
                                       yold1, xi2, yold1) ;
		    rubber_band_man (sp[iw].velplot->window,xi2,yold1,xi2,yold2);
		  }
               }

               if (moving && nearest_digits->prev) {
                  if (ey > nearest_digits->prev->y &&
                      vs > 0 && nearest_digits->prev->vstk > 0) {
                     vu = (float)
                      (nearest_digits->prev->vstk*nearest_digits->prev->vstk) ;
                     vl = (float) (vs*vs) ;
                     tu = 0.001* (float) nearest_digits->prev->t0 ;
                     tl = 0.001* (float) t0 ;
                     vi1 = (vl*tl - vu*tu) / (tl-tu) ;
                     if (vi1 > 0.0)
                       vi1 = (int)sqrt(vi1);
                     else
                       vi1 = 0.;
/*
                     vi1 = (vi1>0.0) ? (int) sqrt(vi1) : 0 ;
*/
                  }
                  else
                     vi1 = 0.0 ;

                  if (xor_move1) {
                     set_pclip (&sp[iw], gc_rubber) ;
                     rubber_band_man (sp[iw].window,
                                      xmove1, ymove1, xold2, yold1) ;		      
/*@@@ dr - do not draw on the moveout @@@*/
                     if( !done_moveout ) {
		       set_vclip (&sp[iw], gc_rubber) ;
		       rubber_band_man (sp[iw].velplot->window,
                                        xs1, ymove1, xs2, yold1) ;
		       if (nearest_digits->prev->prev)
			 rubber_band_man (sp[iw].velplot->window,
                                          xi1, ymove1, xi2, ymove1) ;
		       rubber_band_man (sp[iw].velplot->window,
                                        xi2a = xi2, ymove1, xi2, yold1) ;
		     }
                  }
                  xor_move1 = TRUE ;
                  set_pclip (&sp[iw], gc_rubber) ;
                  rubber_band_man (sp[iw].window,
                                   xmove1, ymove1, xold1 = ex, yold1 = ey) ;
/*@@@ dr - do not draw on the moveout @@@*/
		  if( !done_moveout ) {
		    set_vclip (&sp[iw], gc_rubber) ;
		    rubber_band_man (sp[iw].velplot->window, xs1, ymove1, 
				     xs2=voff+wm1*(float)(vs-sp[iw].velplot->velmin)/vdiff,yold1);
		    xi2 = voff + wm1 * (vi1-(float)sp[iw].velplot->velmin)/vdiff;
		    if (nearest_digits->prev->prev)
		      rubber_band_man (sp[iw].velplot->window,
				       xi1, ymove1, xi2, ymove1) ;
		    rubber_band_man (sp[iw].velplot->window,xi2,ymove1,xi2,yold1);
		  }
               }

               if (moving && nearest_digits->next) {
                  if (ey < nearest_digits->next->y &&
                      vs > 0 && nearest_digits->next->vstk > 0) {
                     vu = (float) (vs*vs) ;
                     vl = (float)
                      (nearest_digits->next->vstk*nearest_digits->next->vstk) ;
                     tu = 0.001* (float) t0 ;
                     tl = 0.001* (float) nearest_digits->next->t0 ;
                     vi2 = (vl*tl - vu*tu) / (tl-tu) ;
                     if (vi2 > 0.0)
                       vi2 = (int)sqrt(vi2);
                     else
                       vi2 = 0.;
/*
                     vi2 = (vi2>0.0) ? (int) sqrt(vi2) : 0 ;
*/
                  }
                  else
                     vi2 = 0.0 ;

                  if (xor_move2) {
                     set_pclip (&sp[iw], gc_rubber) ;
                     rubber_band_man (sp[iw].window,
                                      xmove2, ymove2, xold2, yold2) ;
/*@@@ dr - do not draw on the moveout @@@*/
                     if( !done_moveout ) {
		       set_vclip (&sp[iw], gc_rubber) ;
		       rubber_band_man (sp[iw].velplot->window,
					xs3, ymove2, xs4, yold2) ;
		       if (nearest_digits->prev)
			 rubber_band_man (sp[iw].velplot->window,
					  xi2a, yold2, xi4, yold2) ;
		       rubber_band_man (sp[iw].velplot->window,
					xi4, yold2, xi4, ymove2) ;
		       rubber_band_man (sp[iw].velplot->window,
					xi4,ymove2,xi3,ymove2);
		     }
                  }
                  xor_move2 = TRUE ;
                  set_pclip (&sp[iw], gc_rubber) ;
                  rubber_band_man (sp[iw].window,
                                   xmove2, ymove2, xold2 = ex, yold2 = ey) ;
/*@@@ dr - do not draw on the moveout @@@*/
		  if( !done_moveout ) {
		    set_vclip (&sp[iw], gc_rubber) ;
		    rubber_band_man (sp[iw].velplot->window, xs3, ymove2, 
				     xs4=voff+wm1*(float)(vs-sp[iw].velplot->velmin)/vdiff,yold2);
		    xi4 = voff + wm1 * (vi2-(float)sp[iw].velplot->velmin)/vdiff;
		    if (nearest_digits->prev)
		      rubber_band_man (sp[iw].velplot->window,
				       xi2, yold2, xi4, yold2) ;
		    rubber_band_man(sp[iw].velplot->window,xi4,yold2,xi4,ymove2);
		    rubber_band_man(sp[iw].velplot->window,xi4,ymove2,xi3,ymove2);
		  }
               }
            }
         }
         else if (clear) {
/*
**          Cursor outside of data limits
*/
            update_odometer (" ") ;
            if (iw == TP)
               clear_hyperbola(&sp[CDP]) ;
               if(done_moveout)  clear_hyperbola(&sp[MO]) ;
            clear = FALSE ;
         }
      }
      else if (iw == VEL) {
         xy2rts (&sp[TP], ex, ey, &rec, &trc, &ntrcs, &t0, &isamp, &rsamp) ;
         true_rec = sp[TP].irec_buf[rec];
         if (t0 >= 0 && rsamp <= sp[TP].nss) {
/*
**          Handle odometer
*/
            clear = TRUE ;
            xleft = ex % sp[TP].velplot->width ;
            rec = sp[TP].st_rec + (ex - xleft) / sp[TP].velplot->width ;
            rvel = (float)sp[TP].velplot->velmin + ((float)xleft *
                   (float)(sp[TP].velplot->velmax - sp[TP].velplot->velmin) /
                   ((float)sp[TP].velplot->width - 1.0)) ;
            if (rvel > 0.0)
               vs = rvel + 0.5 ;
            else if (rvel < 0.0)
               vs = rvel - 0.5 ;
            else
               vs = 0 ;
            sprintf(string, "Record: %-5d  Time: %-5d  Velocity: %-6d",
                             rec + 1, t0, vs) ;
                             /*true_rec, t0, vs) ;*/
            update_odometer(string) ;
         }
         else if (clear) {
            update_odometer (" ") ;
            clear = FALSE ;
         }
      }
      break ;

   case ButtonPress :
/*
**    Digitizing functions
*/
      iw = TP ;
      xor = FALSE ;
      if(done_moveout)  clear_hyperbola(&sp[MO]) ;

/*@@@ dr - leave the moveout plot intact @@@*/
      if( !done_moveout )
	done_moveout = 0;

      ex = event->xbutton.x ;
      ey = event->xbutton.y ;
      xy2rts (&sp[iw], ex, ey, &rec, &trc, &ntrcs, &t0, &isamp, &rsamp) ;
      true_rec = sp[iw].irec_buf[rec];

      /*if (!moving) {*/
      if (!moving && (sp[iw].current_rec != xck999)) {
/*
**       Clear all picks and V funcs, move operation handles this by itself
*/
         clear_seismic_area  (&sp[iw], 0, 0) ;
         clear_velocity_area (&sp[iw], 0, 0) ;
      }

      if (event->xbutton.button==Button1 &&
               (digmode != MOVE || (digmode == MOVE && !moving))) {
         if (t0>0 && rsamp<=sp[iw].nss && ntrcs>0 && ntrcs<=sp[iw].ntrace) {
/*
**          Current record has changed, clean up previous record,
**          clear new record area, free previous digits, and search
**          for an accepted function a new record location 
*/
            if (sp[iw].current_rec != rec) {
               if (sp[iw].old_digrec) {
                  draw_xy_picks (&sp[iw], sp[iw].old_digrec->digits, black) ;
		  if(done_moveout == 0) 
		    draw_vfunc    (&sp[iw], sp[iw].old_digrec->digits, apcolor) ;
               }
               sp[iw].current_rec = rec ;

               clear_seismic_area  (&sp[iw], 0, 0) ;
               clear_velocity_area (&sp[iw], 0, 0) ;
               if(sp[iw].new_digits) {
		free_digits (sp[iw].new_digits) ;
	       }
               sp[iw].new_digits = nearest_digits = NULL ;

/*
	       if(sp[iw].old_digrec) {
		 fprintf(stderr,"Button1:clearing old_digrec, rec=%d\n",
			 sp[iw].old_digrec->rec);
		 free_digrec (sp[iw].old_digrec);
		 sp[iw].old_digrec = NULL ;
	       }
*/

               temp_digrec = sp[iw].accepted_digrec_head ; 
               for (i = 0 ; temp_digrec != NULL ; i++) {
                  if (temp_digrec->rec == sp[iw].current_rec) {
                     sp[iw].old_digrec = temp_digrec ;
                     temp_digrec = NULL ;
                  }
                  else
                     temp_digrec = temp_digrec->next ;
               }
            }

/*
**          Some modes require a search for the nearest digitized point
**          in the accepted function at the current record location
*/
            if (digmode != NEW && sp[iw].old_digrec) {
               if (digmode == EDIT)
                  min_sq_dist = 1280*1280 + 1024*1024 ;
               else
                  min_sq_dist = 2*50*50 ;
               find_nearest_neighbor (sp[iw].old_digrec->digits,
                                      &nearest_digits, ex, ey, min_sq_dist) ;
            }

/*
**          Allocate the first or next link in the newly digitized chain
*/
            if (digmode == NEW &&
                       (sp[iw].new_digits == NULL || new_tail->y < ey)) {
               if (sp[iw].new_digits) {
                  new_tail->next = (Digits *) malloc (sizeof(Digits)) ;
                  new_tail->next->prev = new_tail ;
                  new_tail->next->next = NULL ;
                  new_tail = new_tail->next ;
               }
               else {
                  new_tail=sp[iw].new_digits=(Digits *)malloc(sizeof(Digits));
                  new_tail->prev = new_tail->next = NULL ;
               }

               new_tail->trc  = trc ;
               new_tail->t0   = t0 ;
/*....cmam....save sample number of pick for xsd std pik file output...*/
               new_tail->tsamp   = rsamp ;
               new_tail->x    = ex ;
               new_tail->y    = ey ;
               compute_vstk (&sp[iw], new_tail) ;
               new_tail->vint = NULL ;
               compute_vint (new_tail->prev) ;
            }

/*
**          Allocate a new link in the accepted function chain
*/
            else if (digmode == EDIT && nearest_digits) {
               if (ey == nearest_digits->y)
                  temp_digits = nearest_digits ;
               else {
                  temp_digits = (Digits *) malloc (sizeof(Digits)) ;
                  if (ey < nearest_digits->y) {
                     if (nearest_digits->prev)
                        nearest_digits->prev->next = temp_digits ;
                     else 
                        sp[iw].old_digrec->digits = temp_digits ;
                     temp_digits->prev = nearest_digits->prev ;
                     temp_digits->next = nearest_digits ;
                     nearest_digits->prev = temp_digits ;
                  }
                  else if (ey > nearest_digits->y) {
                     if (nearest_digits->next)
                        nearest_digits->next->prev = temp_digits ;
                     temp_digits->next = nearest_digits->next ;
                     temp_digits->prev = nearest_digits ;
                     nearest_digits->next = temp_digits ;
                  }
               }
               temp_digits->x    = ex ;
               temp_digits->y    = ey ;
               temp_digits->t0   = t0 ;
/*....cmam ..save sample number of pick for xsd std pik file output..*/
               temp_digits->tsamp   = rsamp ;
               temp_digits->trc  = trc ;
               compute_vstk (&sp[iw], temp_digits) ;
               compute_vint (temp_digits->prev) ;
               compute_vint (temp_digits) ;
            }

/*
**          Grab a link in the accepted function chain and prepare for
**          rubber banding and changing this links contents
*/
            else if (digmode == MOVE && nearest_digits) {
               moving = TRUE ;
               xor_move1 = xor_move2 = FALSE ;
               draw_xy_picks (&sp[iw], sp[iw].old_digrec->digits, black) ;
	       if(done_moveout == 0) 
		 draw_vfunc    (&sp[iw], sp[iw].old_digrec->digits, apcolor) ;
               vdiff=(float)(sp[iw].velplot->velmax-sp[iw].velplot->velmin);
               wm1 = (float)(sp[iw].velplot->width-1) ;
               voff = (sp[iw].current_rec - sp[iw].st_rec) * 
                          sp[iw].velplot->width + 0.5 ;
               xmove1 = xmove2 = nearest_digits->x ;
               ymove1 = ymove2 = nearest_digits->y ;
               if (nearest_digits->prev) {
                  xmove1 = nearest_digits->prev->x ;
                  ymove1 = nearest_digits->prev->y ;
                  xs1 = voff + wm1 * (float)(nearest_digits->prev->vstk - 
                        sp[iw].velplot->velmin) / vdiff ;              
                  if (nearest_digits->prev->prev)
                     xi1=voff+wm1*(float)(nearest_digits->prev->prev->vint - 
                           sp[iw].velplot->velmin) / vdiff ;
               }
               if (nearest_digits->next) {
                  xmove2 = nearest_digits->next->x ;
                  ymove2 = nearest_digits->next->y ;
                  xs3 = voff + wm1 * (float)(nearest_digits->next->vstk - 
                        sp[iw].velplot->velmin) / vdiff ;
                  xi3 = voff + wm1 * (float)(nearest_digits->next->vint - 
                        sp[iw].velplot->velmin) / vdiff ;            
               }
               clear_seismic_area  (&sp[iw], ymove1, ymove2) ;
               clear_velocity_area (&sp[iw], ymove1, ymove2) ;
            }
         }
      }

      else if (event->xbutton.button == Button2 &&
              ((digmode == NEW && sp[iw].new_digits) ||
               (digmode == EDIT) ||
               (digmode == MOVE && moving))) {

/*
**       Delete the most recent link in the new digitized function chain
*/
         if (digmode == NEW) {
            temp_digits = new_tail->prev ;
            /*free_digits (new_tail) ;*/
            (void) free (new_tail) ;
            new_tail = temp_digits ;
            if (new_tail)
               new_tail->next = NULL ;
            else
               sp[iw].new_digits = NULL ;
         }

/*
**       Delete the selected link in the accepted function chain
*/
         else if (digmode == EDIT) {
            if (sp[iw].current_rec != rec) {
               if (sp[iw].old_digrec) {
                  draw_xy_picks (&sp[iw], sp[iw].old_digrec->digits, black) ;
/*printf ("done_moveout=%d\n", done_moveout);*/
	if(done_moveout == 0) 
                  draw_vfunc    (&sp[iw], sp[iw].old_digrec->digits, apcolor) ;
               }
               sp[iw].current_rec = rec ;

               clear_seismic_area  (&sp[iw], 0, 0) ;
               clear_velocity_area (&sp[iw], 0, 0) ;
               nearest_digits = NULL ;
               sp[iw].old_digrec = NULL ;
               temp_digrec = sp[iw].accepted_digrec_head ; 
               for (i = 0 ; temp_digrec != NULL ; i++) {
                  if (temp_digrec->rec == sp[iw].current_rec) {
                     sp[iw].old_digrec = temp_digrec ;
                     temp_digrec = NULL ;
                  }
                  else
                     temp_digrec = temp_digrec->next ;
               }
            }

            if (sp[iw].old_digrec)
               find_nearest_neighbor (sp[iw].old_digrec->digits,
                                      &nearest_digits, ex, ey, 2*50*50) ;
            if (nearest_digits) {
               if (nearest_digits->prev)
                  nearest_digits->prev->next = nearest_digits->next ;
               else 
                  sp[iw].old_digrec->digits = nearest_digits->next ;
               if (nearest_digits->next)
                  nearest_digits->next->prev = nearest_digits->prev ;
               compute_vint (nearest_digits->prev) ;
               /*free_digits (nearest_digits) ;*/
               (void) free (nearest_digits) ;
			nearest_digits = NULL;

               if (sp[iw].old_digrec->digits == NULL) {
                  if (sp[iw].old_digrec->prev)
                     sp[iw].old_digrec->prev->next = sp[iw].old_digrec->next ;
                  else
                     sp[iw].accepted_digrec_head = sp[iw].old_digrec->next ;
                  if (sp[iw].old_digrec->next)
                     sp[iw].old_digrec->next->prev = sp[iw].old_digrec->prev ;
                  else
                     sp[iw].accepted_digrec_tail = sp[iw].old_digrec->prev ;
                  free_digrec (sp[iw].old_digrec) ;
                  sp[iw].old_digrec = NULL ;
               }
            }
         }

/*
**       Cancel to move operation and clear seismic picks and V func 
*/
         else if (digmode == MOVE) {
            clear_seismic_area  (&sp[iw], 0, 0) ;
            clear_velocity_area (&sp[iw], 0, 0) ;
            nearest_digits = NULL ;
            moving = FALSE ;
         }
      }

      else if (event->xbutton.button == Button3 &&
              ((digmode == NEW && sp[iw].new_digits) ||
               (digmode == MOVE && moving))) {

/*
**       Accept the newly digitized function, create or replace an
**       accepted chain link, free the newly digitized chain
*/

/*.....here we have to insert the new digitized record in the proper
		place to keep records in order...........*/

         if (digmode == NEW) {
/*......test not freeing these digits....
            if (sp[iw].old_digrec) {
               free_digits (sp[iw].old_digrec->digits) ;
		sp[iw].old_digrec->digits = NULL;
            }
.......................................*/
/*.cmam....test removing this else...
            else {
...................................*/
/*....find out where to put the new record....*/
		irec = sp[iw].current_rec;
		done = 0;

		new_digrec = (Digrec *) malloc (sizeof(Digrec)) ;
/*...cmam...try this....*/
		new_digrec->rec = irec;
              XtSetSensitive(apmo_button, True);

		/*..find out if this is the first record to be digitized..*/
		if(sp[iw].accepted_digrec_head) {

		   /*...NOT the first record, since head exists...*/
		   if (irec > sp[iw].accepted_digrec_head->rec) {

			/*..NOT the head, is it the tail?..*/
			if(irec < sp[iw].accepted_digrec_tail->rec) {

			   /*..NOT the tail either..*/
		/*.....should start at the head record, not the next record..
			   dr = sp[iw].accepted_digrec_head->next;
		...........................................................*/
			   dr = sp[iw].accepted_digrec_head;
			   for (i=0; dr != NULL && done == 0; i++) {

				if(irec == dr->rec) {
				   /*..REPLACE this digitized record..*/
				   hold_digrec = dr;
				   dr = new_digrec;
/*...cmam...set the prev & next ptrs....*/
				   dr->next = hold_digrec->next;
				   dr->prev = hold_digrec->prev;
/*......................................*/
				   free_digrec(hold_digrec);
				   hold_digrec = NULL;
				   dr->rec = sp[iw].current_rec;
				   done = 1;
junk = sp[iw].accepted_digrec_head;
for(;junk != NULL; ) {
junk = junk->next;
}
				}
				else if (dr->rec > irec) {
				   /*..insert between dr->prev & dr..*/
				   /*hold_digrec = dr->prev;
				   hold_digrec->next = new_digrec;
				   new_digrec->prev = hold_digrec;
				   new_digrec->next = dr;
				   dr->prev = new_digrec;
				   new_digrec->rec = irec;*/
	new_digrec->rec = irec;
	/*hold_digrec = dr->prev;
	new_digrec->prev = dr->prev;
	new_digrec->next = dr;
	dr->prev = new_digrec;
	hold_digrec->next = new_digrec;*/
	hold_prev_digrec = dr->prev;
	hold_next_digrec = dr;
	new_digrec->prev = hold_prev_digrec;
	new_digrec->next = hold_next_digrec;
	hold_prev_digrec->next = new_digrec;
	hold_next_digrec->prev = new_digrec;
				   done = 1;
junk = sp[iw].accepted_digrec_head;
for(;junk != NULL; ) {
junk = junk->next;
}
				}
		/*.....need to bump up to next record if not fall into
			one of the above cases......................*/
				else {
				   dr = dr->next;
				}

			   }		/* end of for(i=0...*/

			}		/* end of if(irec <...*/

			else if (irec > sp[iw].accepted_digrec_tail->rec) {
			   /*..add new record after old tail..*/
			   dr = sp[iw].accepted_digrec_tail;
			   dr->next = new_digrec;
			   new_digrec->prev = dr;
			   new_digrec->next = NULL;
			   sp[iw].accepted_digrec_tail = new_digrec;
			}
			else {
			   /*..replace the tail record..*/
			   /*..just determine if this is the ONLY
				digitized record at this time...*/
			   if(sp[iw].accepted_digrec_head ==
			   sp[iw].accepted_digrec_tail) {
				free_digrec(sp[iw].accepted_digrec_head);
				new_digrec->prev = new_digrec->next = NULL;
				sp[iw].accepted_digrec_head =
				    sp[iw].accepted_digrec_tail = new_digrec;
			   }
			   else {
			       hold_digrec = sp[iw].accepted_digrec_tail;
			       dr = hold_digrec->prev;
			       dr->next = new_digrec;
			       new_digrec->prev = dr;
			       new_digrec->next = NULL;
			       sp[iw].accepted_digrec_tail = new_digrec;
			       free_digrec (hold_digrec);
			       hold_digrec = NULL;
			   }
			}

		   }			/* end of if(irec >...*/

		   else if (irec < sp[iw].accepted_digrec_head->rec) {
			/*..add new record before old head..*/
			dr = sp[iw].accepted_digrec_head;
			dr->prev = new_digrec;
			new_digrec->next = dr;
			new_digrec->prev = NULL;
			sp[iw].accepted_digrec_head = new_digrec;
		   }

		   else {
			/*..replace the head record..*/
			/*...must determine if this is the ONLY
				digitized record at this time...*/
			if(sp[iw].accepted_digrec_head == 
			sp[iw].accepted_digrec_tail) {
			   free_digrec(sp[iw].accepted_digrec_head);
			   new_digrec->prev = new_digrec->next = NULL;
			   sp[iw].accepted_digrec_head = 
				sp[iw].accepted_digrec_tail = new_digrec;
			}
			else {
			  hold_digrec = sp[iw].accepted_digrec_head;
			  dr = hold_digrec->next;
			  dr->prev = new_digrec;
			  new_digrec->prev = NULL;
			  new_digrec->next = dr;
			  sp[iw].accepted_digrec_head = new_digrec;
			  free_digrec (hold_digrec);
			  hold_digrec = NULL;
			}
		   }

		}			/* end of if(sp[iw}...*/

               else {
		  /*...this is the first digitized record...*/
                  sp[iw].accepted_digrec_tail = sp[iw].accepted_digrec_head =
					new_digrec;
                  /*sp[iw].accepted_digrec_tail->prev =*/
                  sp[iw].accepted_digrec_head->prev =
                                    sp[iw].accepted_digrec_tail->next = NULL ;
               }
               sp[iw].old_digrec = new_digrec;
/*..cmam...test removing this else....
            }
....................................*/

            sp[iw].old_digrec->rec = sp[iw].current_rec ;
            temp_digits = sp[iw].new_digits ;
            for (i = 0 ; temp_digits != NULL ; i++) {
               if (i) {
                  accepted_digits_tail->next =
                                   (Digits *) malloc(sizeof(Digits)) ;
                  accepted_digits_tail->next->prev = accepted_digits_tail ;
                  accepted_digits_tail->next->next = NULL ;
                  accepted_digits_tail = accepted_digits_tail->next ;
               }
               else {
                  sp[iw].old_digrec->digits = accepted_digits_tail =
                                   (Digits *) malloc(sizeof(Digits)) ;
                  accepted_digits_tail->prev = NULL ;
                  accepted_digits_tail->next = NULL ;
               }
               accepted_digits_tail->x    = temp_digits->x ;
               accepted_digits_tail->y    = temp_digits->y ;
               accepted_digits_tail->t0   = temp_digits->t0 ;
/*...cmam..sample number of pick for xsd std pik file output...*/
               accepted_digits_tail->tsamp   = temp_digits->tsamp ;
               /*accepted_digits_tail->tsamp   = temp_digits->rsamp ;*/
               accepted_digits_tail->trc  = temp_digits->trc ;
               accepted_digits_tail->vstk = temp_digits->vstk ;
               accepted_digits_tail->vint = temp_digits->vint ;
               temp_digits = temp_digits->next ;
            }
            free_digits (sp[iw].new_digits) ;
            sp[iw].new_digits = NULL ;
         }

/*
**       Accept the new position during a move operation
*/
         else if (digmode == MOVE &&
                  (!nearest_digits->prev || ey > nearest_digits->prev->y) &&
                  (!nearest_digits->next || ey < nearest_digits->next->y)) {

            nearest_digits->x = ex ;
            nearest_digits->y = ey ;
            nearest_digits->t0 = t0 ;
/*...cmam..sample number of pick for xsd std pik file output...*/
            nearest_digits->tsamp = rsamp ;
            nearest_digits->trc = trc ;
            compute_vstk (&sp[iw], nearest_digits) ;
            compute_vint (nearest_digits->prev) ;
            compute_vint (nearest_digits) ;

            clear_seismic_area  (&sp[iw], 0, 0) ;
            clear_velocity_area (&sp[iw], 0, 0) ;
            moving = FALSE ;
         }
      }


/*
**    Redraw picks and V funcs, move operation handles this itself
*/
      if (!moving) {
	if (sp[iw].old_digrec) {
	  draw_xy_picks (&sp[iw], sp[iw].old_digrec->digits, black) ;
	  if(done_moveout == 0) 
	    draw_vfunc    (&sp[iw], sp[iw].old_digrec->digits, apcolor) ;
	}
	draw_xy_picks (&sp[iw], sp[iw].new_digits, black) ;
	if(done_moveout == 0) 
	  draw_vfunc    (&sp[iw], sp[iw].new_digits, npcolor) ;
      }

      break ;

   case LeaveNotify :
/*
**    Blank out odometer and clear hyperbola if we just left the TP window
*/
      update_odometer (" ") ;
      for (i = CDP ; i <= TP ; i++)
         if (event->xcrossing.window == sp[i].window) iw = i ;
      if (event->xcrossing.window == sp[TP].velplot->window) iw = VEL ;
      if (iw == TP) {
         clear_hyperbola(&sp[CDP]) ;
         if(done_moveout) clear_hyperbola(&sp[MO]) ;
      }
      break ;
   default :
/*
**    This should never happen !!!!!
*/
      printf("\nunknown event received in handle_eventsCB") ;
      break ;
   }
}
