C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine shynmo(x,nsamp,ntr,dx,vdata,tarr,sr,ierr,yout)
c +==================================================================+ c
c | Subroutine to apply Castle's (Geophysics, 6/94) shifted hyperbola
c | moveout to a CDP of data.
c | 
c | Input:
c |    x    - R*4(*) - Matrix of data to be corrected (nsamp * ntr)
c |                      (NOT Destroyed by the program)
c |  nsamp  - I*4    - Length of a trace
c |   ntr   - I*4    - Number of traces
c |    dx   - R*4(*) - Vector of offsets for this CDP
c |           I*4(*)
cmam......this is stored as integer in the seisplot structure.........
c |  vdata  - R*4(*) - Velocity vector for this CDP (destroyed herein)
c |   tarr  - R*4(*) - Vector of times corresponding to velocities
c |   sr    - R*4    - Sample interval, in sec.
c |
c | Output:
c |   yout  - R*4(*) - Matrix of nmo corrected data
c |   ierr  - I*4    - Error flag 
c +==================================================================+ c
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      real x(*),vdata(*),tarr(*),sr
	integer dx(*)
cmam  real x(*),vdata(*),tarr(*),dx(*),sr
	real yout(*)
      integer nsamp,ntr
      real mu2(1),mu4(1),mu6(1),mu26(1),mu25(1),s(1),mu44(1)
      real v(1),sx(1),work(1)
      POINTER (pmu2,mu2),(pmu4,mu4),(pmu6,mu6),(pv,v),(psx,sx)
      POINTER (pmu26,mu26),(pmu25,mu25),(ps,s),(pmu44,mu44)
      POINTER (pwork,work)
      logical reverse

	reverse = .false.
cmam	reverse = .true.
      ierr = 0
      ner = 0
      ier = 0
      iget = nsamp*ISZBYT
      call galloc(pmu2  , iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pmu4  , iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pmu6  , iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pmu26 , iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pmu25 , iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pmu44 , iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(ps    , iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pv    , iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(psx   , iget,ier,0)
      iget = (nsamp+4)*iszbyt
      call galloc(pwork , iget,ier,0)
      if(ier.ne.0)ner=ner+1
      if(ner.ne.0)then
       ierr = 1
       return
      endif

cmam....clear work array to zeroes....
	call vclr(work,1,nsamp+4)

      call rmsint(vdata,tarr,nsamp,v)
cmam  do i=1,nsamp
cmam   v(i)=v(i)*sr
cmam   vdata(i)=vdata(i)*sr
cmam  end do
	call vsmul(v,1,sr,v,1,nsamp)
	call vsmul(vdata,1,sr,vdata,1,nsamp)
c +=======================================+
c | create the (interval) velocity norms  |
c | for the function                      |
c +=======================================+
      mu2(1)=v(1)*v(1)
      mu4(1)=mu2(1)*mu2(1)
      mu6(1)=mu4(1)*mu2(1)
      do i=2,nsamp
       a =  v(i)
       a2 = a*a
       a4 = a2*a2
       a6 = a2*a4
       mu2(i)=mu2(i-1)+a2
       mu4(i)=mu4(i-1)+a4
       mu6(i)=mu6(i-1)+a6
      end do
      do i=1,nsamp
        xy = i
       mu2(i)=mu2(i)/xy
       mu4(i)=mu4(i)/xy
       mu6(i)=mu6(i)/xy
       mu26(i)=mu2(i)*mu6(i)
       mu44(i)=mu4(i)*mu4(i)
       g = mu2(i)
       g2 = g*g
       g4 = g2*g2
       mu25(i)= g*g4
       s(i)=mu4(i)/g2
      end do
      do i=1,ntr
       offset = dx(i)
       offset = offset*offset
       ndx = (i-1)*nsamp+1
       do j=1,nsamp
        rx = j
        rx = rx*rx
        a1 = (mu26(j)-2.*mu44(j))/(2.*mu25(j)*rx)
        a2 = -0.5*(s(j)/(rx*mu2(j)))
        sx(j)=(s(j)+a1*offset)/(1.+a2*offset)
       end do
       call canmo(x(ndx),vdata,offset,nsamp,work,reverse,
     : sx,ier)
       if(ier.ne.0)then
        write(LER,*)'CANMO Unable to allocate work space. Fatal!'
        ierr = 1
        call gfree(pmu2)
        call gfree(pmu4)
        call gfree(pmu6)
cmam    call gfree(pum6)
        call gfree(pv)
        call gfree(psx)
        call gfree(pmu26)
        call gfree(pmu25)
        call gfree(ps)
        call gfree(pmu44)
        call gfree(pwork)
        return
       endif
       call vmov(work,1,yout(ndx),1,nsamp)
      end do
      ierr = 0
      call gfree(pmu2)
      call gfree(pmu4)
cmam  call gfree(pum6)
      call gfree(pmu6)
      call gfree(pv)
      call gfree(psx)
      call gfree(pmu26)
      call gfree(pmu25)
      call gfree(ps)
      call gfree(pmu44)
      call gfree(pwork)
      return
      end
      subroutine canmo(x,v,offset,ns,y,R,psx,ier)
************************************************************************
*                                                                      *
*    SUBROUTINE TO PERFORM HYPERBOLIC MOVEOUT CORRECTION.              *
*      INPUTS ARE:                                                     *
*           X = DATA TO BE CORRECTED                                   *
*           V = SQURARED VELOCITY ARRAY                                *
*          PT = ARRAY TO TP's                                          *
*      OFFSET = OFFSET FOR X                                           *
*          NS = NUMBER SAMPLES PER TRACE                               *
*          SR = SAMPLE INTERVAL IN SECONDS                             *
*           Y = CORRECTED DATA                                         *
*          V0 = VELOCITY OF RECORDING MEDIUM FORM IMAGE POINT COMPS    *
*                                                                      *
************************************************************************
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
      real X(*),Y(*),v(*),psx(*)
      real work(1),nu,sx
cmam  real work(1),temp(1),nu,sx
cmam  POINTER (pw,work),(adrtemp,temp)
	POINTER (pw,work)
      logical R

cmam...........      iget = (ns*2 +3) * ISZBYT
      iget = (ns+3) * ISZBYT
      ierr = 0
      ner = 0
      call galloc(pw,iget,ierr,0)
      ner = ner+ierr
cmam  call galloc(adrtemp,iget,ierr,0)
cmam  ner = ner + ierr
      if(ner.ne.0)then
       ier = 1
       return
      endif
cmam....clear work array to zeroes
	call vclr(work,1,ns+3)
cmam..	call vclr(work,1,ns*2+3)
      if(.not.R)then
       work(1)=0.
       call vmov(x,1,work(2),1,ns)
      else
       do i=1,ns
        work(i)=x(i)
       end do
      endif
      work(ns+2)=0.
      work(ns+3)=0.
      if(.not.R)then
       do i=1,ns
        q = i
        sx=psx(i)
        if(sx.lt.0)sx=1.
        ts = q*(1.- 1./sx)
        t0 = q/sx
        nu = v(i)
        nu = nu*nu
        nu = nu*sx
        g = t0*t0+ offset/nu
        g = sqrt(g)
        t = ts + g
        shft = t - q
        if(shft.le.ns-2)then
          if(shft.gt.0)then
            tj = q + shft
            it=int(tj)
            if(it.eq.0)it=1
cmam.................
cmam	if(it.le.ns-2) then
	if((it.le.ns-2).and.(it.ge.0)) then
             f=tj-aint(tj)
             fs=f*f
             c1 = fs-f
             c2 = 2.0 - 2.0*fs
             c3 = fs+f
             y(i)=0.5 *(
     :           work(it)*c1 +
     :           work(it+1)*c2 +
     :           work(it+2)*c3
     :                 )
	else
		y(i) = 0.
	endif
cmam...........
          else
            y(i)=work(i)
          endif
        else
          y(i)=0
        endif
       end do
      else
       do i=1,ns
        y(i)=0. 
       end do
       do i=1,ns
        sx = psx(i)
        if(sx.lt.0)sx=1.
        q = i
        ts = q*(1.- 1./sx)
        t0 = q/sx
        nu = sqrt(sx)*v(i)
        nu = nu*nu
        g = t0*t0+ offset/nu
        g = sqrt(g)
        t = ts + g
        shft = t - q
        if(sx.lt.0)shft=0.
        tj = q+shft
        it = int(tj)
        if(it.ge.0)then
         if(it.eq.0)it=1
cmam..............
	if(it.le.ns+3) then
cmam..............
         f=tj-aint(tj)
         fs=f*f
         c1 = fs-f
         c2 = 2.0 - 2.0*fs
         c3 = fs+f
         if(i.gt.1)then
         y(it) = 0.5 *   (
     :          work(i-1)*c3 +
     :          work(i)*c2 +
     :          work(i+1)*c1
     :                   )
        else
         y(it)=0.5 * (work(i)*c2+work(i+1)*c1*2)
        endif
cmam..............
	endif
cmam..............
        endif
       end do
      endif
      call gfree(pw)
      RETURN
      END
      subroutine rmsint (v,t,n,vi)
C ********************************************************************
C |                                                
C |    Subroutine to compute interval velocity from RMS 
C |    velocity using Dix's equation.                   
C |                                                    
C |    Input:                                         
C |    V   - R*4() - Vector of RMS velocities, in ft/m per sec.
C |    t   - R*4() - Vector of times for the V vector, in sec.
C |    n   - I*4   - Length of the V vector.        
C |                                               
C |    OUTPUT:                                      
C |    vi  - R*4() - Vector of inteval velocities.     
C |                                                  
C ********************************************************************
      DIMENSION V(*),T(*),vi(*)

      vi(1)=v(1)
      DO I=2,N
         T2=T(I)
         T1=T(I-1)
         TDEL=T2-T1
         vi(I)=V(I)*V(I)*T2-V(I-1)*V(I-1)*T1
         vi(I)=vi(I)/TDEL
         if(vi(i).le.0.0)then
           vi(i)=vi(i-1)
         else
          vi(I)=SQRT(vi(I))
         endif
      end do
      RETURN
      END
