/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "xos.h"

#define EXTERN_KEY

#include "globals.h"
#include "resources.h"
#include "cross1.h"
    
Colormap AppCmap;
Cursor cursor;

/*---------- FUNCTION PROTOTYPES --------------------------------------------*/
int 
CopyColormapToPrivate(Display *d, Colormap DCmap, Colormap *NCmap,int NCmin );
/*---------------------------------------------------------------------------*/
              
main (argc,argv)
unsigned int  argc ;
char         *argv[] ;
{
   extern Visual *visual;

   XtAppContext app_context ;
   int i, n ;
   Pixmap mask,pixmap;
   unsigned int x_hot, y_hot;
   XColor fore, back;
   GC gcl;
   XGCValues gclv;
   Widget mainw, menu_bar, draw[MAX_DRAWING_AREA_PLUS];
   Arg args[5] ;
   char  title[255];
   extern Widget create_mostly_widgets() ;

/***********************************************************************/
   toplevel = XtAppInitialize(&app_context, "Vxos", NULL, 0,
                              (int *)&argc, argv, app_defs, NULL, 0);
   n=0;
   sprintf(title,"Optical Stack Analysis     %s",argv[0]);
   for (n=strlen(argv[0])-1; n>=0; n--) {
        if (memcmp(argv[0]+n,"/",1) == 0) {
            sprintf(title,"Optical Stack Analysis        %s",argv[0]+(n+1));
            break;
        }
    }

  /*--------------------------------------------------------------------*/
  /* Allocate Private application color map & copy other's apps colors  */
  /* We request at least 64 free R/W color cells to be free             */
  /*--------------------------------------------------------------------*/
   {
     int      ncfree;                      /* Number of free r/w colors */
     Display *dpy     = XtDisplay( toplevel );
     int      scrnum  = DefaultScreen( dpy );
     Window   win     = RootWindow( dpy, scrnum );

     Visual * visual = DefaultVisual(dpy, scrnum);

     AppCmap = DefaultColormap( dpy, scrnum );

     if(visual->class == PseudoColor)  {
       ncfree  = CopyColormapToPrivate( dpy, AppCmap, &AppCmap, 64 );
       printf("Created a private colormap with %d free colors...\n", ncfree);
     }
   }

   n = 0;
   XtSetArg(args[n], XmNtitle,    title  ); n++;
   XtSetArg(args[n], XtNcolormap, AppCmap); n++;
   XtSetValues (toplevel, args, n) ;

   n = 0;
   XtSetArg(args[n], XmNshadowThickness, 0); n++;
   mainw = XmCreateMainWindow (toplevel, "mainw", args, n);
   XtManageChild(mainw);
 
   allow_moveout = True;
   mo_type = 0;

   display = XtDisplay (toplevel) ;
   menu_bar = create_mostly_widgets (mainw, draw);

   XtRealizeWidget(toplevel);

/* ** Install cursor in the drawing areas */

   gclv.background = WhitePixel(display, DefaultScreen(display));
   gclv.foreground = BlackPixel(display, DefaultScreen(display));

   if(visual->class == PseudoColor)  {
     if ( XAllocNamedColor(display,AppCmap,"black",&fore,&back) == 0 ) {
   	  fore.red = 0; fore.green = 0; fore.blue = 0;
	  fore.pixel = BlackPixel(display, DefaultScreen(display));
	  fore.flags = DoRed | DoGreen | DoBlue;
     }
   }
   else {
     if ( XLookupColor(display,AppCmap,"black",&back,&fore) == 0 ) {
   	  fore.red = 0; fore.green = 0; fore.blue = 0;
	  fore.pixel = BlackPixel(display, DefaultScreen(display));
	  fore.flags = DoRed | DoGreen | DoBlue;
     }
   }

   x_hot = cross1_x_hot; y_hot = cross1_y_hot;
   cursor = XCreatePixmapCursor(display,
	XCreateBitmapFromData(display,XtWindow(draw[TP]),
		(char*)cross1_bits,cross1_width,cross1_height),
	XCreateBitmapFromData(display,XtWindow(draw[TP]),
		(char*)cross1_bits,cross1_width,cross1_height),
	&fore,&fore,cross1_x_hot,cross1_y_hot);
 
   XDefineCursor(display, XtWindow(draw[TP]), cursor) ;

/* added these to use the same cursor in all three windows - 
Joe M. Wade 1/28/00 */
   XDefineCursor(display, XtWindow(draw[CDP]), cursor);
   XDefineCursor(display, XtWindow(draw[VEL]), cursor);

/*
** Initialize critical seismic and velocity plotting information
*/
 
   seisplot[CDP].drawA          = draw[CDP] ;
   seisplot[CDP].window         = XtWindow (draw[CDP]) ;
   seisplot[CDP].data           = NULL ;
   seisplot[CDP].file           = NULL ;
   seisplot[CDP].irec_buf       = NULL ;
   seisplot[CDP].tpbuf          = NULL ;
   seisplot[CDP].xoffset        = NULL ;
   seisplot[CDP].slowbuf        = NULL ;
   seisplot[CDP].hyperbola      = NULL ;

/*...maybe we need to clear this also...*/
    seisplot[CDP].libuf         = NULL ;
    seisplot[CDP].dibuf         = NULL ;

/*...initialize this....*/
   seisplot[CDP].current_rec      = -9999;

   seisplot[TP].drawA           = draw[TP] ;
   seisplot[TP].window          = XtWindow (draw[TP]) ;
   seisplot[TP].data            = NULL ;
   seisplot[TP].file            = NULL ;
   seisplot[TP].irec_buf        = NULL ;
   seisplot[TP].tpbuf           = NULL ;
   seisplot[TP].xoffset         = NULL ;
   seisplot[TP].slowbuf         = NULL ;
   seisplot[TP].hyperbola       = NULL ;
   seisplot[TP].new_digits      = NULL ;
   seisplot[TP].old_digrec      = NULL ;
   seisplot[TP].accepted_digrec_head  = NULL ;
   seisplot[TP].accepted_digrec_tail  = NULL ;

/*...initialize this....*/
   seisplot[TP].current_rec      = -9999;

   seisplot[MO].drawA          = draw[VEL] ;
   seisplot[MO].window         = XtWindow (draw[VEL]) ;
   seisplot[MO].data           = NULL ;
   seisplot[MO].file           = NULL ;
   seisplot[MO].irec_buf       = NULL ;
   seisplot[MO].tpbuf          = NULL ;
   seisplot[MO].xoffset        = NULL ;
   seisplot[MO].slowbuf        = NULL ;
   seisplot[MO].hyperbola      = NULL ;

/*...initialize this....*/
   seisplot[MO].current_rec      = -9999;
   velplot.drawA                = draw[VEL] ;
   velplot.window               = XtWindow (draw[VEL]) ;

   XtAppMainLoop(app_context);
}
