C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Get_Median(tri, space, N, start, end, 
     :     Number_Windows, iwin_sample, run)

c variables passed from calling routine

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer N, start, end

      real tri(N), space(N)
      real tempin(SZLNHD)
      real tempout(SZLNHD)

      logical run


c     process data
     
c=====================================================================
c Windows in series 
     
      if (.not. run) then
         Do j = 1, Number_Windows
            space(j) = 0.
            
            DO  i= (j-1)*iwin_sample + start,
     :           ((j-1)*iwin_sample+start+iwin_sample)-1
               
               tempin(i - ((j-1)*iwin_sample +start) +1) = tri(i)

            ENDDO

               call heapsort(iwin_sample,tempin,tempout)
               
               if ((iwin_sample/2)*2 .eq. iwin_sample) then
                  space(j) = 0.5*((tempout(iwin_sample/2)) +
     :                 tempout((iwin_sample/2)+1))
               else
                  space(j) = tempout((iwin_sample/2)+1)
               endif
         enddo
      endif
c=====================================================================
c Running Window
      if(run) then
         do j = start-start+1, end-start+1
            space(j) = 0.

c do this like a role-in / role-out

            istart =  (j - (iwin_sample/2)) + start - 1
            iend   =  (j + (iwin_sample/2)) + start - 1
           
 
            if (istart .lt. start) istart = start
            if (iend .gt. end) iend = end
          
            do i = istart, iend
               tempin(i - istart + 1 ) = tri(i)
           
            enddo
            call heapsort(iwin_sample,tempin,tempout)
            
            if (((iend-istart)/2)*2 .eq. iwin_sample) then
               space(j) = 0.5*((tempout((iend-istart)/2)) +
     :              tempout(((iend-istart)/2)+1))
            else
               space(j) = tempout(((iend-istart)/2)+1)
            endif
       
         enddo
      endif
c=====================================================================
      return
      end
