C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       RPHS                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TO CALCULATE RESPONSE PHASE.                              *
C  ENTRY POINTS:                                                       *
C      RPHS  (PHASE,A,NPT)
C  ARGUMENTS:                                                          *
C      PHASE   REAL         U*  (1) - WORKING ARRAY CONTAINS INST PHAS *
C      A       REAL         U*  (1) - COMPLEX ENVELOPE ARRAY ON INPUT  *
C                                   - RESPONSE PHASE ON OUTPUT         *
C      NPT     INTEGER      I*      - NUMBER OF SAMPLE POINTS          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J. BODINE                          ORIGIN DATE: 81/09/02  *
C  LANGUAGE: FORTRAN 77/IV               DATE LAST COMPILED: 83/06/03  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      MNMX         - TO FIND RELATIVE MAXIMA/MINIMA IN AMPLITUDE ARRAY*
C      UNWRAP       - TO UNWRAP PHASE                                  *
C      FPEAK   REAL - TO FIND MAXIMUM VALUE ARRAY POSITION             *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:                                                              *
C      6  ( OUTPUT SEQUENTIAL ) - DEBUG OUTPUT                         *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  NONE                                               *
C  GENERAL DESCRIPTION:                                                *
C       ROUTINE TO SET ANALYTIC SIGNAL ENVELOPE LOBES TO VALUE OF      *
C       THE INSTANTANEOUS PHASE AT THE POINT WHERE THE ENVELOPE        *
C       IS A MAXIMUM.                                                  *
C       THE VALUE OF THE ENVELOPE IS SET TO THAT OF THE INSTANTANEOUS P*
C       FROM TROUGH TO TROUGH. THE RESULTING "ENVELOPE" MAY BE         *
C       CONSIDERED TO BE A MEASURE OF THE PHASE OF AN ASSUMED NON-DISPE*
C       SEISMIC RESPONSE CONTAINED WITHIN THE ENVELOPE.                *
C       SEE TANER ET AL., 1979, GEOPHYSICS, V.44, #6,P.1041.           *
C                                                                      *
C       PROGRAM ASSUMES THE FIRST POINT IN THE SIGNAL IS A TROUGH      *
C       AND THE FIRST POINT OF ZERO SLOPE IS A PEAK. IF THIS POINT     *
C       IS A TROUGH IT WILL BE SKIPPED IN MNMX.                        *
C                                                                      *
C       NOTE FOR USERS:                                                *
C     THIS ROUTINE WILL FIND EVERY ENVELOPE PEAK REGARDLESS            *
C     OF RELATIVE AMPLITUDE. DISPLAY OF RESPONSE PHASE OF NOISY        *
C     DATA IS THUS MOST EFFECTIVE WITH A COLOR PLOT WHERE COLOR        *
C     INTENSITY IS AMPLITUDE MODULATED AND A COLOR WHEEL IS USED       *
C     FOR PHASE (0-360 DEGREES).                                       *
C                                                                      *
C  REVISED BY:  J. NORRIS                     REVISION DATE: 83/06/01  *
C       MODIFY MIN/MAX LOCATOR LOGIC TO BE SUBROUTINE CALL.            *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NON-STANDARD FEATURES:  NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE RPHS (PHASE,A,NPT)
      DIMENSION A(1), PHASE(1), ITRF(2000), IPEAK(2000), P(3)
C***********************************************************************
C       FIND ARRAY POSITIONS OF MAXIMA AND MINIMA. THEN
C       SET IPEAK VALUES TO INTEGER VALUE OF INSTANTANEOUS
C       PHASE AT IPEAK(I) + FRACTION ARRAY POSITIONS.
C***********************************************************************
      CALL MNMX (A,NPT,IPEAK,JP,ITRF,JT)
C
	
      DO 100 I=1,JP
         K = IPEAK(I)
         DO 50 M=1,3
         P(M) = PHASE(K-2+M)
         IF( ABS(P(M)) .GT. 1.0E20 ) P(M)=0.0
	 if (abs(p(m)) .lt. 1.e-10 ) then
		p(m) = 0.0
		go to 50
	 endif
         IF( 1/ABS(P(M)) .GT. 1.0E20 ) P(M)=0.0

   50    CONTINUE
         CALL UNWRAP(P)
         FP = FPEAK(A,K)
         TK = FLOAT(K)
         IF(FP.LT.TK)IPEAK(I) = P(2)+(TK-FP)*(P(1)-P(2))
         IF(FP.GE.TK)IPEAK(I) = P(2)+(TK-FP)*(P(2)-P(3))
         IF(IPEAK(I).GT.180)IPEAK(I) = IPEAK(I)-360
C        WRITE (6,*) K,IPEAK(I),ITRF(I),PHASE(K)
  100 CONTINUE
      if (ITRF(JP) .ne. NPT) ITRF(JP) = NPT
C***********************************************************************
C       SET ENVELOPE LOBES TO IPEAK VALUES
C***********************************************************************
      J = 1
      ISTRT = 1
  150 IEND = ITRF(J)
      PEAK = FLOAT(IPEAK(J))
      DO 200 I=ISTRT,IEND
		a(i) = peak
  200 continue
C
      J = J+1
      IF (IEND.EQ.NPT) GO TO 250
      ISTRT = IEND
      GO TO 150
C
  250 CONTINUE
C
      RETURN
C
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       MNMX                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TO PICK RELATIVE MINIMA AND MAXIMA FOR INPUT FUNCTION.    *
C  ENTRY POINTS:                                                       *
C      MNMX  (A,NPT,IPEAK,JP,ITRF,JT)                                  *
C  ARGUMENTS:                                                          *
C      A       REAL         I*  (1) - INPUT ARRAY TO SCAN FOR MIN/MAX  *
C      NPT     INTEGER      I*      - NUMBER OF SAMPLES IN ARRAY 'A'   *
C      IPEAK   INTEGER      O*  (1) - INDEX  ARRAY OF RELATIVE PEAKS   *
C      JP      INTEGER      O*      - NUMBER OF RELATIVE PEAKS IN IPEAK*
C      ITRF    INTEGER      O*  (1) - INDEX  ARRAY OF RELATIVE TROUGHS *
C      JT      INTEGER      O*      - NUMBER OF REL TROUGHS IN ITRF    *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J. NORRIS                          ORIGIN DATE: 83/06/03  *
C  LANGUAGE: FORTRAN 77/IV               DATE LAST COMPILED: 83/06/03  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  IF NPT <=1, SUBROUTINE IS NOT EXECUTED.            *
C  GENERAL DESCRIPTION:  EVERY PEAK OR TROUGH IS FOUND REGARDLESS OF   *
C       AMPLITUDE.  THIS CODE ADAPTED FROM PKDT AND RPHS BY J.H.BODINE.*
C       +------------------------------------------------------+       *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NON-STANDARD FEATURES:  NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE MNMX(A,NPT,IPEAK,JP,ITRF,JT)
      DIMENSION A(1), ITRF(1), IPEAK(1)
C
      JT = 0
      JP = 0
      SLOP = 0.
      ILAST=0
C***********************************************************************
C ***** FIND ARRAY POSITIONS OF MAXIMA AND MINIMA AFTER CHECKING VALID
C ***** LOOP INDEX.
C***********************************************************************
      NPT1 = NPT-1
      IF(NPT1.LE.0) GO TO 150
      DO 100 I=1,NPT1
         SLAST = SLOP
         SLOP = A(I+1)-A(I)
         CHNG = SLAST*SLOP
         IF (CHNG.GT.0.) GO TO 100
         IF (SLOP.EQ.0..AND.SLAST.EQ.0.) GO TO 100
         IF (SLAST.LE.0..AND.SLOP.GE.0.) GO TO 50
C***********************************************************************
C ******* HERE FOR A PEAK.
C ******* CHECK FOR TWO CONSECUTIVE PEAKS. IGNORE SUBSEQUENT PEAKS UNTIL
C ******* A TROUGH IS FOUND.  ILAST=1 FOR PEAK.
C***********************************************************************
         IF(ILAST.EQ.1)GO TO 100
         JP = JP+1
         IPEAK(JP) = I
         ILAST=1
         GO TO 100
C***********************************************************************
C ******* HERE FOR A TROUGH. SEE IF PEAK ALREADY PICKED FIRST.
C ******* CALLING ROUTINES EXPECT FIRST POINT OF ZERO SLOPE TO BE PEAK.
C ******* CHECK FOR TWO CONSECUTIVE TROUGHS. IGNORE SUBSEQUENT TROUGHS
C ******* UNTIL A PEAK IS FOUND.ILAST=-1 FOR TROUGH.
C***********************************************************************
   50    IF (JP.EQ.0) GO TO 100
         IF(ILAST.EQ.-1)GO TO 100
         JT = JT+1
         ITRF(JT) = I
         ILAST=-1
  100 CONTINUE
C***********************************************************************
C ******* ASSIGN LAST POINT OF TROUGH ARRAY TO BE LAST SAMPLE. IF NO
C ******* PEAKS FOUND, DEFAULT SET JP TO ONE POINT.
C***********************************************************************
      ITRF(JT+1) = NPT
C
  150 CONTINUE
c*
c  modified this to also set the first element of IPEAK to first sample
c						- j.m.wade 4/23/96
c*
      IF(JP.EQ.0) then
	JP=1
	IPEAK(JP) = 1
      endif
      RETURN
      END

C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       UNWRAP                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C      ROUTINE TESTS FOR CONDITIONS REQUIRING UNWRAPPING OF PHASE      *
C      TO PERMIT INTERPOLATION ACROSS DISCONTINUITIES AT +/-180 DEG.   *
C  ENTRY POINTS:                                                       *
C      UNWRAP  (P)                                                     *
C  ARGUMENTS:                                                          *
C      P       REAL      U*  (1) - VALUES TO UNWRAP                    *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J.H. BODINE                        ORIGIN DATE: 82/10/17  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 83/06/03  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  NONE                                               *
C  GENERAL DESCRIPTION:  NONE                                          *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NON-STANDARD FEATURES:  NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE UNWRAP(P)
      DIMENSION P(3)
C
      DIS = 0.
C
      DIFL = ABS(P(1)-P(2))
      DIFH = ABS(P(2)-P(3))
C
      IF (DIFL.LT.180..AND.DIFH.LT.180.) RETURN
C
      DO 50 I=1,3
   50 IF(P(I).LT.0.)P(I) = P(I)+360.
C
      RETURN
      END
      FUNCTION FPEAK (A,K)
      DIMENSION A(1)
C
      TK = FLOAT(K)
      DAL = ABS(A(K)-A(K-1))
      DAH = ABS(A(K)-A(K+1))
C
      TEST = DAL-DAH
      IF(TEST.GT.0.)FPEAK = TK+(1.-DAH/DAL)*.5
      IF(TEST.LT.0.)FPEAK = TK-(1.-DAL/DAH)*.5
      IF(TEST.EQ.0.)FPEAK = TK
C
      RETURN
      END
