C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  wind - user defined data windowing
C
C**********************************************************************C
C
c changes: 
c
c May 5, 2003: fixed bug in end sample determination when -hw
c              used on command line.  If -e[] was negative the
c              routine would abend without checking to see if
c              the nsampo was still positive.  This allows the user
c              to grab data from above the header definied start
c              time.  Reported by Linda Hodgson[Dyce]
c Garossino 
c
c June 27, 2001: fixed bug in start sample determination when -F and -hw
c                used on command line.  
c Garossino 
c
c Aug 98: Major refit
c
c           I partitioned the code to handle apply and restore options
c           separately.  The previous version worked only on the simplest
c           cases but would often be several samples off when the -R option
c           was invoked [with or without the original parameters on the 
c           command line]. 
 
c         - now recognizes the fact that nothing is on the command line
c           and will do nothing to the data if that is the case.  In the
c           previous incarnation the default -s would be zero and data
c           start would be set to zero.  This caused problems for Joe Burnam
c           and the coherency flowmaker stuff so it was changed.
c
c         - no longer need -s and -e parameters when using -R [as long as only
c           undoing the LAST windowing operation]
c
c         - fixed parsing of -I, also if -I then TmMsFs set to zero as it will
c           be incorrect in any case.
c
c         * it is required that when using -R with -v or -v, -H that any 
c           -s, -e information be resupplied on the command line.  When the
c           input TmMsFS = -s things work out fine.  Whenever -s is such that
c           given the sample interval of the data the first windowed sample
c           is not exactly -s then the input TmMsFS is also not exactly -s
c           and if the default -R is used you may see some jitter on the output.
c
c         - added verbal[] subroutine.
c
c Garossino
c        
c Mar 97: Major refit to fix several bugs:
c
c         - multiple simple windowing resulted in incorrect TmMsFS in output
c         - -R option failed to consider sample 1 as time zero
c         - sample / time indexing in this code was not consistent
c         - hyperbolic option was turned off
c         - -Z, -P, -v options resulted in incorrect TmMsFS in output
c         - -Z and -v simultaneously resulted in loss of mute restore [array
c           not being cleared between records correctly]
c         - man page information and code action not in sync
c         - combination runs would fail due to foul up in cmdln parsing order
c
c         I rewrote a lot of this code using a new terminology in the place
c         of the old ist, ista, isth, ss0, etc.  The new code uses the 
c         referrence _sample for sample indexing and _time for time 
c         indexing.  I rewrote the help subroutine and man page to bring it
c         all in sync as well as expound on the actual action that the program
c         takes in each option.  I also added several more examples.
c
c         Needless to say I fixed all the above so that Steve Farmer et al can
c         now window data coming from Landmark and not get some bogus windowing
c         taking place.  I tested this version thoroughly through every option
c         forward and back as well as combinations of options.  Any combination
c         that would not work I added policemen to catch and either warn or
c         prevent the user from going on.
c
c         I left the overall structure of the code the same [i.e. no verbal 
c         subroutine etc] but will probably upgrade that next time.
c
c Garossino
c         
c
c Feb 96: fixed the -R option and made taper an option instead of 
c          a default.  
c
c Garossino
c
C     Declare Machine Dependant Variables
C
C Wade
c
C     add block to check for computed end sample <= 0

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

c declare standard USP variables

      integer  itr ( 2*SZLNHD )
      integer  nsamp, nsampo, nsi, ntrc, ntrco, nrec, nreco, iform
      integer  irs, ire, ns, ne
      integer  luin, lbytes, nbytes, obytes, lbyout
      integer  argis

      real     tri(2*SZLNHD)

      character   name*4, ntap*255, otap*255
      character   HdrWrd*6

      logical     flt
      logical     verbos

c declare program specific variables

      integer DstSgn, ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer StaCor, ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_HdrWrd, l_HdrWrd, ln_HdrWrd, OrNSMP
      integer header_start_time
      integer iramp, dist
      integer iTmMsFS_out 
      integer start_time, start_sample
      integer end_time, end_sample
      integer header_sample
      integer absolute_start_sample
 
      real ramp_trace(2*SZLNHD), xtrace(2*SZLNHD)
      real x2, real_velocity_sample, veldt, v2, dt, vel
      real TmMsFS, TmMsFS_out, TmMsFS_vel, UnitSc, diff
      real real_start_time, real_start_sample
      real real_hyper_sample, real_header_sample, real_vel_sample

      logical  zero, pass, header, restore, hyperb, ignore

c initialize variables

      data name /'WIND'/
      data luin / 1 /
      data lbytes / 0 /
      data nbytes / 0 /
      data header /.false./

c  get online help if necessary

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
         call help  ()
         stop
      endif

c  open printout file

#include <f77/open.h>

c  get command line parameters

      call cmdln ( ntap, otap, vel, iramp, start_time, end_time, HdrWrd,
     :     ns, ne, irs, ire, verbos, zero, pass, header, restore, 
     :     hyperb, ignore, flt )

c  open input and output datasets

      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

c read input line header

      lbytes=0
      call rtape  ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
        write(LERR,*)' '
        write(LERR,*)'WIND: no line header read on unit ',ntap
        write(LERR,*)'      Check existence of file & rerun'
        write(LERR,*)'FATAL'
        write(LERR,*)' '
        write(LER,*)' '
        write(LER,*)'WIND: no line header read on unit ',ntap
        write(LER,*)'      Check existence of file & rerun'
        write(LER,*)'FATAL'
        write(LER,*)' '
        stop
      endif

c print historical line header to print out file

      call hlhprt ( itr, lbytes, name, 4, lerr )

c  build pointers to trace header entries
 
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if (header)
     :     call savelu ( HdrWrd, ifmt_HdrWrd, l_HdrWrd, ln_HdrWrd, 
     :     TRACEHEADER )

c  save key header values

      call saver(itr, 'NumSmp', nsamp , LINHED)
      call saver(itr, 'SmpInt', nsi   , LINHED)
      call saver(itr, 'NumTrc', ntrc  , LINHED)
      call saver(itr, 'NumRec', nrec  , LINHED)
      call saver(itr, 'Format', iform , LINHED)
      call saver(itr, 'UnitSc', UnitSc, LINHED)
      call saver(itr, 'OrNSMP', OrNSMP, LINHED)

c POLICEMAN: make sure input trace is not longer than maximum array size

      if(nsamp .gt. 2*SZLNHD) nsamp = 2 * SZLNHD

c POLICEMAN: check header for units scaling.  Using UnitSc, remember
c that UnitSc default is milliseconds [i.e. 0.001] and UnitSc
c is a floating point variable.  A UnitSc entry of 1.0 would
c mean units are in seconds.  A UnitSc entry of 0 indicates that
c the unit was not defined.  In this case milliseconds are 
c assumed and loaded to the header for further processing.

      if ( UnitSc .eq. 0.0 ) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         UnitSc = 0.001
         call savew ( itr, 'UnitSc', UnitSc, LINHED)
      endif

c compute delta T in seconds

      dt = real (nsi) * UnitSc

c  check defaults

      call cmdchk ( ns, ne, irs, ire, ntrc, nrec )

c calculate number of traces per record and number of records to process

      if (pass) then

c will pass all the data with the windowing applied only inside the limits
c specified on the command line

         ntrco = ntrc
         nreco = nrec
      else
         ntrco  = ne - ns + 1
         nreco = ire - irs + 1
      endif

c In order to calculate the number of samples out we first need to determine
c the start and end samples which are a function of what type of windowing is
c being done.  For instance padding above may involve a negative start time
c which involves going past the zero time sample and complicates the relationship
c between time and sample.  Also we may be removing the window or doing the intial
c windowing etc. etc. etc.


c determine the current time associated with the first sample of the input dataset.
c If the -I flag has been put on the command line this will be zero by definition
c otherwise we will get this information from the lineheader entry TmMsFS.  We assume
c the data stored there is time [or depth] in the units of the dataset so that 
c a simple division by the sample interval will be sufficient to compute sample
c locations

      if ( ignore ) then
         TmMsFS = 0
      else
         call saver( itr, 'TmMsFS', TmMsFS , LINHED)
      endif

      IF ( .not. restore ) then

c-----------------------------------------------------------------------
c Applying Window Parameters
c-----------------------------------------------------------------------

c Determine the ZERO OFFSET START SAMPLE to be used

         real_start_time = float( start_time )

         if ( start_time .eq. 99999 )then

c no -s entry on command line so use lineheader value and assume it
c to be correct

            start_time = TmMsFs
            start_sample = 1
            real_start_time = float ( start_time )

         elseif ( start_time .lt. TmMsFs ) then

c -s on command line is prior to start of data

            real_start_sample =  ( real_start_time - TmMsFS )
     :           / float(nsi)
            start_sample  = nint( real_start_sample )

         else

c -s on command line is within data, need to find the closest sample
c to the one requested.

            real_start_sample =  ( real_start_time - TmMsFS )
     :           / float(nsi) + 1.
            start_sample  = nint( real_start_sample )

         endif

c Determine the ZERO OFFSET END SAMPLE to be used

         if ( end_time .eq. 99999 ) then

c no -e on the command line.  Assume that the user wants all the data
c from -s through the end of the trace.  Here we also assume that TmMsFS
c is in the units of the data so we can work with nsi.  If -e is used on
c the command line then we will also assume that it was given in units of
c this dataset and use it verbatum

            end_time = ( nsamp - 1 ) * nsi + TmMsFS
         endif

         end_sample  = ( end_time - TmMsFS ) / nsi + 1
c
c - added check to see if end time is before start window of data
c
	if (end_sample .le. 0) then

           if ( .not. header ) then
              write(LER,*) 'WIND: Error computing end sample'
              write(LERR,*) 'WIND: Error computing end sample'
              write(LER,*) '      Specified end time = ',end_time
              write(LERR,*) '      Specified end time = ',end_time
              if ( .not. ignore ) then
                 write(LER,*) 'Time of first sample from TmMsFS = ',
     :                TmMsFS
                write(LERR,*) 'Time of first sample from TmMsFS = ',
     :               TmMsFS
              endif
              stop 100
           endif
        endif

c Determine the NUMBER OF SAMPLES in the output dataset

         if ( .not. pass .and.
     :        .not. zero ) then

            if ( start_sample .lt. 0 ) then

c we are adding a pad and since zero only appears once we do not need
c add 1 to the output number of samples
            
               nsampo = end_sample - start_sample
            else
               
               nsampo = end_sample - start_sample + 1
            endif  

c policeman:  watch for bad windowing parameters, such as might be
c             entered with the -hw[] parameter.  Some users have been
c             confused by the option when using -s[] and -e[] to
c             define the window size to hang off the header defined
c             start time.  If they want to move the start time up they
c             require a negative start time.  To define the window length
c             then requires a little thought.  Some users are defining the
c             -e[] to be less than -s[], that is still using the negative
c             which results in a zero length or negative number of samples
c             per trace.  It is tough to know what they are up to so I will
c             just check for nsamp less than or equal to zero and crash out
c             if that is the case.

            if ( nsampo .le. 0 ) then

               write(LERR,*)' '
               write(LERR,*)' Something fishy with your windowing'
               write(LERR,*)' parameters.  It seems your end time'
               write(LERR,*)' is less than or equal to your start '
               write(LERR,*)' time.  This results in a negative or '
               write(LERR,*)' zero number of output samples.  check'
               write(LERR,*)' your -s[] and -e[] entries and try again'
               write(LERR,*)'FATAL'

               write(LER,*)'WIND: '
               write(LER,*)' Something fishy with your windowing'
               write(LER,*)' parameters.  It seems your end time'
               write(LER,*)' is less than or equal to your start '
               write(LER,*)' time.  This results in a negative or '
               write(LER,*)' zero number of output samples.  check'
               write(LER,*)' your -s[] and -e[] entries and try again'
               write(LER,*)'FATAL'
               write(LER,*)' '

               stop

            endif

            obytes = SZTRHD + SZSMPD * nsampo

         else

c using any of -hw, -P or -Z will result in the number of samples
c per trace passing unchanged
         
            obytes = SZTRHD + SZSMPD * nsamp

            if ( .not. header ) then
               nsampo = end_sample - start_sample + 1
            else
               nsampo = end_sample
            endif

c POLICEMAN: you cannot use -pass if the window is padding the record to be 
c            larger than the input nsamp

            if ( pass .and. ( nsampo .gt. nsamp ) ) then
               write(LERR,*)' '
               write(LERR,*)'  you cannot use -P when the output'
               write(LERR,*)'  samples per trace is greater than '
               write(LERR,*)'  the rest of the dataset to be passed'
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'WIND: '
               write(LER,*)'  you cannot use -P when the output'
               write(LER,*)'  samples per trace is greater than '
               write(LER,*)'  the rest of the dataset to be passed'
               write(LER,*)'FATAL'
               goto 999
            endif

         endif

c UPDATE the TmMsFS lineheader entry

         if  ( ignore ) then

c Since we are about to ignore whatever has been done before it 
c can be assumed that whatever is out in TmMsFS is going to be 
c bogus.  Here we assign it to be zero.

            TmMsFS_out = 0.0

         elseif ( .not. header .and. 
     :           .not. pass .and. 
     :           .not. zero ) then

c update TmMsFS for the current commandline parameters.  Find the
c time associate with the output sample one.  It may not be what you
c asked for depending on the relationship between -s and nsi.

            TmMsFS_out = float ( start_time ) / float( nsi )
            iTmMsFS_out = start_time / nsi
            diff = abs ( TmMsFS_out - float(iTmMsFS_out) )

            if ( diff .ge. 0.5 ) then
               if ( start_time .lt. 0 ) then
                  TmMsFS_out = float( ( iTmMsFS_out - 1 ) * nsi )
               else
                  TmMsFS_out = float( ( iTmMsFS_out + 1 ) * nsi )
               endif
            else
               TmMsFS_out = float(iTmMsFS_out * nsi)
            endif
         else

c if the user has requested -Z, -P or windowing based on some header
c entry then make no attempt to modify TmMsFS, simply pass whatever came in.

            TmMsFs_out = TmMsFS
         endif

c fill out OrNSMP for future use in undoing windowing parameters 

         if (zero) then            
            if ( OrNSMP .eq. 0 ) then
               call savew( itr, 'OrNSMP', nsamp , LINHED)
            elseif ( OrNSMP .ne. nsamp ) then
               write(LERR,*) 'The orgininal number of samples'
               write(LERR,*) 'in the lineheader is not equal'
               write(LERR,*) 'to the number of samples in the input'
               write(LERR,*) 'dataset.  This must be at least the'
               write(LERR,*) 'second time this data has been '
               write(LERR,*) 'windowed or you have a problem'
               write(LERR,*) 'WARNING'
            endif

c install a character Z in the lineheader entry OACUFO if the -z option
c has been used

            call savew( itr, 'OACUF0', 'Z'   , LINHED)

         elseif (pass) then
            
            if ( OrNSMP .eq. 0 ) then
               call savew( itr, 'OrNSMP', nsamp , LINHED)
            elseif ( OrNSMP .ne. nsamp ) then
               write(LERR,*) 'The orgininal number of samples'
               write(LERR,*) 'in the lineheader is not equal'
               write(LERR,*) 'to the number of samples in the input'
               write(LERR,*) 'dataset.  This must be at least the'
               write(LERR,*) 'second time this data has been '
               write(LERR,*) 'windowed or you have a problem'
               write(LERR,*) 'WARNING'
            endif
          
         else
          
            if ( OrNSMP .eq. 0 ) then
               call savew( itr, 'OrNSMP', nsamp , LINHED)
            elseif ( OrNSMP .ne. nsamp ) then
               write(LERR,*) 'The orgininal number of samples'
               write(LERR,*) 'in the lineheader is not equal'
               write(LERR,*) 'to the number of samples in the input'
               write(LERR,*) 'dataset.  This must be at least the'
               write(LERR,*) 'second time this data has been '
               write(LERR,*) 'windowed or you have a problem'
               write(LERR,*) 'WARNING'
            endif
          
         endif

c update output lineheader

         call savew( itr, 'NumTrc', ntrco  , LINHED)
         call savew( itr, 'NumRec', nreco , LINHED)
         call savew( itr, 'TmMsFS', TmMsFS_out , LINHED)

c         if ( zero .or. pass .or. header ) then
         if ( zero .or. pass ) then
            call savew( itr, 'NumSmp', nsamp, LINHED)
         else
            call savew( itr, 'NumSmp', nsampo, LINHED)
         endif

c update historical line header

         call savhlh ( itr, lbytes, lbyout )

c write output lineheader       

         call wrtape( luout, itr, lbyout )

c determine ramp parameters and fill out trace weights array ramp_trace[]

         call vclr  (ramp_trace, 1, nsamp)

         iramp  = iramp / nsi
         if ( iramp .le. 0 ) iramp = 1
         if ( iramp .gt. nsampo / 2 ) then

            write(LERR,*)' '
            write(LERR,*)'Ramp length [',iramp,
     :           '] > 1/2 output trace length...'
            write(LERR,*)'resetting ramp to 1/2 output trace'
            iramp = nsampo/2
         endif

         call vfill (1.0, ramp_trace, 1, nsampo)

         if (iramp .gt. 1) then
            do i = 1, iramp
               ramp_trace(i) = float(i) / float(iramp)
               ramp_trace ( nsampo - iramp + i ) = 
     :              float(iramp-i+1) / float(iramp)
            enddo
         endif

         if (verbos) then
            write(LERR,*)' '
            write(LERR,*)'Window Taper Function'
            if (zero) then
               write(LERR,*)(ramp_trace(ii),ii=1,nsamp)
            else
               write(LERR,*)(ramp_trace(ii),ii=1,nsampo)
            endif
            write(LERR,*)' '
         endif

c precompute velocity parameters to be used in windowing

         veldt = vel * dt

         if (hyperb .and. vel .lt. 1.e20) then
            v2 = veldt * veldt
         else
            v2 = 1.e20
         endif

c echo control data to printout file

         call verbal( ntap, otap, irs, ire, ns, ne, nsamp, nsampo, nsi, 
     :        ntrc, ntrco, nrec, nreco, start_time, end_time, ignore, 
     :        hyperb, header, HdrWrd, iramp, vel, zero, pass, verbos, 
     :        flt )

c  skip [or pass if -P] to START RECORD 

         if (pass) then
            nbytes = obytes
            call recrw (1,irs-1,luin,ntrc,itr,luout, nbytes)
         else
            call recskp(1,irs-1,luin,ntrc,itr)
         endif

         DO JJ = irs, ire

c  skip [or pass if -P] to START TRACE 

            if (pass) then
               nbytes = obytes
               call trcrw (JJ, 1, ns-1,luin,ntrc,itr,luout,nbytes)
            else
               call trcskp(jj,1,ns-1,luin,ntrc,itr)
            endif

            DO KK = ns, ne

c clear input trace buffer making sure to not leave anything in the array from
c the last trace.  Hence the max of nsamp or nsampo.

               call vclr (tri, 1, max(nsamp,nsampo) )

c read next trace

               nbytes = 0
               call rtape  ( luin , itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )

c retrieve trace distance and dead trace flag
     
               call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     1              DstSgn , TRACEHEADER)
               dist = iabs(DstSgn)

               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor,
     1              StaCor , TRACEHEADER)

c clear working trace buffer

               call vclr ( xtrace, 1, max(nsamp,nsampo) )

c window live traces only

               IF ( StaCor .ne. 30000 ) then

                  if (header) then

c  read header time and convert to samples

                    if (flt) then

                     call saver2(itr,ifmt_HdrWrd,l_HdrWrd, ln_HdrWrd, 
     :                    real_header_sample, TRACEHEADER)
                     header_start_time = nint ( real_header_sample )
                     
                    else

                     call saver2(itr,ifmt_HdrWrd,l_HdrWrd, ln_HdrWrd, 
     :                    header_start_time, TRACEHEADER)
                     
                    endif

                    real_header_sample = float(header_start_time) / 
     :                    float(nsi)
                    header_sample = nint ( real_header_sample )
                    start_sample = nint(real_start_sample) + 
     :                    header_sample
                  else
                     header_sample = 0
                  endif

                  if (hyperb) then

c -H on command line, compute the closest integer sample to the
c floating point window start sample.

                     x2 = dist * dist
                     real_hyper_sample = 
     :                    ( real_start_time - TmMsFS ) / float(nsi) + 
     :                    header_sample + 1.
                     start_sample  = nint( sqrt (real_hyper_sample * 
     :                    real_hyper_sample + x2 / v2) )

                  elseif ( vel .lt. 1e20 ) then

c -v on commandline without -H, compute closest integer start 
c sample to the floating point sample predicted by the velocity
c used

                     real_velocity_sample = dist / veldt

                     real_vel_sample = ( real_start_time - TmMsFS )
     :                    / float(nsi) + float(header_sample) + 1.
                     
                     start_sample = nint (real_vel_sample + 
     :                    real_velocity_sample)

                  endif

c watch out for walking off the end of the input dataset, if you do then 
c should probably put out a dead trace at this location

                  if ( start_sample .gt. nsamp) start_sample = nsamp

c extract data from start time to end time as computed above
c apply ramp taper weights to window.
c if "zero" or "pass" mode then simply place the original or windowed data 
c into it's original time position but with rest of trace zeroed out

                  if (start_sample .lt. 0) then

c watch for adding a pad before the data [negative start time]

                     absolute_start_sample = iabs (start_sample) + 1
                     call vmov ( tri, 1, xtrace(absolute_start_sample),  
     :                    1, nsamp )

                  else
                  
                     if (start_sample .eq. 0) start_sample = 1

                     if ( zero .or. pass ) then
                        call vmul ( ramp_trace, 1, tri(start_sample), 1, 
     :                       xtrace(start_sample), 1, nsamp )
                     else
                        call vmul ( ramp_trace, 1, tri(start_sample), 1,
     :                       xtrace, 1, nsampo )
                     endif

                  endif

               ENDIF

c output data: if not in zero or pass modes then it will be an 
c              adjusted trace otherwise it will be original length trace

c               if ( zero .or. pass .or. header ) then
               if ( zero .or. pass ) then
                   call vmov ( xtrace, 1, itr(ITHWP1),1, nsamp )
               else
                  call vmov ( xtrace, 1, itr(ITHWP1),1, nsampo )
               endif

               call wrtape( luout, itr, obytes )
               
            ENDDO
 
c  skip [or pass if -P] to END OF RECORD

            if (pass) then
               nbytes = obytes
               call trcrw (JJ, ne+1, ntrc,luin,ntrc,itr,luout,nbytes)
            else
               call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
            endif
         
         ENDDO

c  pass data to end of data set if PASS

         if (pass) then
            nbytes = obytes
            call recrw (ire+1, nrec, luin, ntrc, itr, luout, nbytes)
         endif

c normal termination

         call lbclos(luin)
         call lbclos(luout)

         write(LERR,*)' '
         write(LERR,*)' processed ',nreco,' records of ',ntrco,' traces'
         write(LERR,*)' '
         write(LERR,*)'Normal Termination'
         write(LER,*)'wind: Normal Termination'
         stop

      ELSE

c-----------------------------------------------------------------------
c Undoing Previous Window Parameters
c-----------------------------------------------------------------------


c Determine the ZERO OFFSET START SAMPLE to be used

         real_start_time = float( start_time )

         if ( start_time .eq. 99999 )then

c no -s entry on command line so use lineheader value and assume it
c to be correct

            start_time = TmMsFs
            real_start_time = TmMsFs

            if ( start_time .lt. 0 ) then
               real_start_sample = -start_time /
     :              float(nsi) + 1.0
            else
               real_start_sample = -start_time /
     :              float(nsi)
            endif

            start_sample = nint (real_start_sample )
 
         else

c -s on command line is within data

            if ( start_time .lt. 0 ) then
               real_start_sample =  ( real_start_time )
     :              / float(nsi) - 1.0
               start_sample  = nint( - real_start_sample )
            else
               real_start_sample =  ( real_start_time )
     :              / float(nsi)
               start_sample  = nint( - real_start_sample )
            endif

         endif

         if ( start_sample .lt. 0 )
     :        absolute_start_sample = iabs (start_sample) + 1

c determine NUMBER OF SAMPLES in output dataset

c I think that for -R you will always be wanting to get back
c your original datasize so nsampo should always be OrNMSP

         nsampo = OrNSMP

c calculate number of bytes in each output trace

         obytes = SZTRHD + SZSMPD * nsampo

c UPDATE the TmMsFS lineheader entry
         
         if ( ignore ) then
           TmMsFS_out = 0.0
         elseif ( .not. header .and.
     :           .not. pass .and.
     :           .not. zero ) then
            if ( start_time .lt. 0 ) then
               iTmMsFS_out = TmMsFS +  (iabs(start_sample - 1) * nsi)
            else
               iTmMsFS_out = TmMsFS -  (iabs(start_sample) * nsi)
            endif
            TmMsFS_out = float(iTmMsFS_out)
         else
            TmMsFS_out = TmMsFS
         endif

         TmMsFS_vel = TmMsFS_out

c update the output lineheader

         call savew( itr, 'NumTrc', ntrco  , LINHED)
         call savew( itr, 'NumRec', nreco , LINHED)
         call savew( itr, 'TmMsFS', TmMsFS_out , LINHED)
         call savew( itr, 'NumSmp', nsampo, LINHED)

c update historical line header

         call savhlh ( itr, lbytes, lbyout )

c write output lineheader       

         call wrtape( luout, itr, lbyout )

c precompute velocity parameters to be used in windowing

         veldt = vel * dt

         if (hyperb .and. vel .lt. 1.e20) then
            v2 = veldt * veldt
         else
            v2 = 1.e20
         endif

         call verbal( ntap, otap, irs, ire, ns, ne, nsamp, nsampo, nsi, 
     :        ntrc, ntrco, nrec, nreco, start_time, end_time, ignore, 
     :        hyperb, header, HdrWrd, iramp, vel, zero, pass, verbos )


c  skip [or pass if -P] to START RECORD 

         if (pass) then
            nbytes = obytes
            call recrw (1,irs-1,luin,ntrc,itr,luout, nbytes)
         else
            call recskp(1,irs-1,luin,ntrc,itr)
         endif

         DO JJ = irs, ire

c  skip [or pass if -P] to START TRACE 

            if (pass) then
               nbytes = obytes
               call trcrw (JJ, 1, ns-1,luin,ntrc,itr,luout,nbytes)
            else
               call trcskp(jj,1,ns-1,luin,ntrc,itr)
            endif
            
            DO KK = ns, ne

c clear input trace buffer making sure to not leave anything in the array from
c the last trace.  Hence the max of nsamp or nsampo.

               call vclr (tri, 1, max(nsamp,nsampo) )

c read next trace

               nbytes = 0
               call rtape  ( luin , itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
               
c retrieve trace distance and dead trace flag
     
               call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     1              DstSgn , TRACEHEADER)
               dist = iabs(DstSgn)
               
               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor,
     1              StaCor , TRACEHEADER)
               
c clear working trace buffer

               call vclr ( xtrace, 1, max(nsamp,nsampo) )

c window live traces only

               IF ( StaCor .ne. 30000 ) then
                  
                  if (header) then

c  read header time and convert to samples

                     call saver2(itr,ifmt_HdrWrd,l_HdrWrd, ln_HdrWrd, 
     :                    header_start_time, TRACEHEADER)
                     
                     real_header_sample = float(header_start_time) 
     :                    / float(nsi)
                     header_sample = nint(real_header_sample )
                     start_sample = nint(real_start_sample) +
     :                    header_sample
                     start_sample = - start_sample
                     if ( start_sample .lt. 0 ) 
     :                    absolute_start_sample =  -start_sample
                  else
                     header_sample = 0
                  endif

                  if (hyperb) then

c -H on command line, compute the closest integer sample to the
c floating point window start sample.

                     x2 = dist * dist
                     real_hyper_sample = 
     :                    ( real_start_time - TmMsFS_vel ) / float(nsi) 
     :                    + header_sample + 1.
                     start_sample = nint( sqrt (real_hyper_sample * 
     :                    real_hyper_sample + x2 / v2) )

c since this is the restore loop take the negative of the start_sample 

                     start_sample = -start_sample
                     if ( start_sample .lt. 0 )
     :                    absolute_start_sample =  -start_sample

                  elseif ( vel .lt. 1.e20 ) then

c -v on commandline without -H, compute closest integer start 
c sample to the floating point sample predicted by the velocity
c used

                     real_velocity_sample = dist / veldt


                     real_vel_sample = ( real_start_time - TmMsFS_vel)
     :                    / float(nsi) + float(header_sample) + 1.
                     start_sample = nint (real_vel_sample + 
     :                    real_velocity_sample)

c since this is the restore option take the negative of the sample predicted

                     start_sample = - start_sample
                     if ( start_sample .lt. 0 )
     :                    absolute_start_sample =  -start_sample
                     
                  endif

c  extract data from start time to end time as computed above
c  apply weight to window.
c  if "zero" or "pass" mode then simply place the original or windowed data 
c into it's original time position but with rest of trace zeroed out


                  if (start_sample .lt. 0) then

c watch for existence of a pad before the data [negative start time]

                     call vmov ( tri, 1, xtrace(absolute_start_sample), 
     :                    1,  nsamp )
                     
                  else
                     
                     if (start_sample .eq. 0) start_sample = 1
                     
                     call vmov ( tri(start_sample), 1, xtrace, 1, 
     :                    nsampo )
                     
                  endif

               ENDIF

c  output data: 

               call vmov ( xtrace, 1, itr(ITHWP1),1, nsampo )
               call wrtape( luout, itr, obytes )
                  
            ENDDO

c  skip  [or pass if -P] to END OF RECORD

            if (pass) then
               nbytes = obytes
               call trcrw (JJ, ne+1, ntrc,luin,ntrc,itr,luout,nbytes)
            else
               call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
            endif
    
         ENDDO

c  pass data to end of data set if PASS

         if (pass) then
            nbytes = obytes
            call recrw (ire+1, nrec, luin, ntrc, itr, luout, nbytes)
         endif

c normal termination

         call lbclos(luin)
         call lbclos(luout)
            
         write(LERR,*)' '
         write(LERR,*)' processed ',nreco,' records of ',ntrco,' traces'
         write(LERR,*)' '
         write(LERR,*)'Normal Termination'
         write(LER,*)'wind: Normal Termination'
         stop

      ENDIF

c abnormal termination

  999 continue

      call lbclos(luin)
      call lbclos(luout)
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'Abnormal Termination'
      write(LER,*)'wind: Abnormal Termination'
      stop

      END


c SUBROUTINES

c--------------------------------------------------
c commandline help, flagged using -h '-?' or -help
c--------------------------------------------------

      subroutine  help

#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for WIND: window data'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[]   -- input data set                   (stdin)'
        write(LER,*)'-O[]   -- output data set                 (stdout)'
        write(LER,*)'-s[]   -- start time (units of data)      (TmMsFS)'
        write(LER,*)'-e[]   -- end time (units of data)     (last samp)'
        write(LER,*)'-ns[]  -- start trace number               (first)'
        write(LER,*)'-ne[]  -- end trace number                  (last)'
        write(LER,*)'-rs[]  -- start record                     (first)'
        write(LER,*)'-re[]  -- end record                        (last)'
        write(LER,*)' '
        write(LER,*)'-t[]   -- start/end window ramp (units of data)(0)'
        write(LER,*)' '
        write(LER,*)'-hw[]  -- start time header mnemonic    (not used)'
        Write(LER,*)'-F     -- header word is floating point value'
        Write(LER,*)'          else it is integer'
        write(LER,*)' '
        write(LER,*)'-v[]   -- window start adjustment velocity  (flat)'
        write(LER,*)' '
        write(LER,*)'-I     -- ignore TmMsFS from input lineheader'
        write(LER,*)' '
        write(LER,*)'-H     -- use hyperbolic window start'
        write(LER,*)'          [requires -v[] above ]  '
        write(LER,*)' '
        write(LER,*)'-R     -- undo previous window'
        write(LER,*)' '
        write(LER,*)'-Z     -- zero trace except for window'
        write(LER,*)' '
        write(LER,*)'-P     -- pass whole dataset, window within'
        write(LER,*)'          limits [ -ns,-ne,-rs,-re ] only'
        write(LER,*)' '
        write(LER,*)'-V     -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        wind -N[] -O[] -ns[] -ne[] -rs[] -re[] '
        write(LER,*)'             -v[] -t[] -s[] -e[] -hw[] [ -F ]'
        write(LER,*)'             [-P -Z -H -R -I -V]'
        write(LER,*)' '

      return
      end


c--------------------------------------------------
c parse commandline parameters
c--------------------------------------------------

      subroutine cmdln ( ntap, otap, vel, iramp, start_time, end_time, 
     :     HdrWrd, ns, ne, irs, ire, verbos, zero, pass, header, 
     :     restore, hyperb, ignore, flt )

#include <f77/iounit.h>

      integer     argis, start_time, end_time, ns, ne, irs, ire, iramp

      real        vel

      character   ntap*(*), otap*(*), HdrWrd*6

      logical     verbos, zero, pass, header, restore, hyperb, ignore
      logical     flt

c parse command line entries in alphabetical order, longest to shortest
c to prevent parsing errors

      call argi4 ('-e',end_time,99999,99999)

      call argstr ('-hw', HdrWrd ,' ',' ') 
      header = .false.
      if (HdrWrd .ne. ' ') header = .true.

      flt     = (argis('-F') .gt. 0)

      hyperb  = (argis('-H') .gt. 0)
          
      ignore   = (argis('-I') .gt. 0)

      call argi4 ('-ne',ne,0,0)
      call argi4 ('-ns',ns,0,0)
      call argstr ('-N',ntap,' ',' ') 

      call argstr ('-O',otap,' ',' ') 

      pass    = (argis('-P') .gt. 0)

      call argi4 ('-re',ire,0,0)
      call argi4 ('-rs',irs,1,1)
      restore = (argis('-R') .gt. 0)

      call argi4 ('-s',start_time,99999,99999)

      call argi4 ('-t',iramp,0,0)

      call argr4 ('-v',vel,999999.,999999.)
      if (vel .ge. 999999.) vel = 1.e20
      verbos  = (argis('-V') .gt. 0)

      zero    = (argis('-Z') .gt. 0)

c Policemen

      if (start_time .lt. 0 .and. zero) then
         write(LERR,*)' '
         write(LERR,*)' you canot use the -Z option with negative start'
         write(LERR,*)' times. Fix command line had resubmit'
         write(LER ,*)'FATAL'
         write(LER ,*)' '
         write(LER ,*)'WIND: '
         write(LER ,*)' you canot use the -Z option with negative start'
         write(LER ,*)' times. Fix command line had resubmit'
         write(LER ,*)'FATAL'
         stop
      endif

      if ( restore .and. zero ) then
         write(LERR,*)' '
         write(LERR,*)' You canot use the -R option with the'
         write(LERR,*)' -Z option as your data alread occupies'
         write(LERR,*)' the original time position'
         write(LER ,*)'FATAL'
         write(LER ,*)' '
         write(LER ,*)'WIND: '
         write(LER,*)' You canot use the -R option with the'
         write(LER,*)' -Z option as your data already occupies'
         write(LER,*)' its original time position'
         write(LER ,*)'FATAL'
         write(LER ,*)' '
         stop
      endif

      return
      end
      

c--------------------------------------------------
c report parameters to printout file
c--------------------------------------------------

      subroutine verbal ( ntap, otap, irs, ire, ns, ne, nsamp, nsampo, 
     :     nsi, ntrc, ntrco, nrec, nreco, start_time, end_time, ignore, 
     :     hyperb, header, HdrWrd, iramp, vel, zero, pass, verbos, flt )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer irs, ire, ns, ne, nsamp, nsampo, nsi, ntrc, ntrco, nrec
      integer nreco, start_time, end_time, iramp

      real vel

      character ntap*255, otap*255, HdrWrd*6

      logical ignore, hyperb, header, zero, pass, verbos, flt

c declare local variables

      integer length

c input dataset

      length = lenth(ntap)

      write(LERR,*)' '
      if (length .gt. 0) then
        write(LERR,*)' Input dataset: ',ntap(1:length)
      else
        write(LERR,*)' Input dataset: stdin'
      endif
      write(LERR,*)' '
      write(LERR,*)' Values read from line header'
      write(LERR,*)' '
      write(LERR,*)' Samples/Trace      =  ', nsamp
      write(LERR,*)' Sample Interval    =  ', nsi  
      write(LERR,*)' Traces per Record  =  ', ntrc 
      write(LERR,*)' Records per Line   =  ', nrec
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '

      length = lenth(otap)

      if (length .gt. 0) then
        write(LERR,*)' Output dataset: ',otap(1:length)
      else
        write(LERR,*)' Output dataset: stdout'
      endif
      write(LERR,*)' '
      write(LERR,*)' Start time       =  ', start_time
      write(LERR,*)' End time         =  ', end_time
      write(LERR,*)' Window Ramp      =  ', iramp,' samples'

      if (zero .or. pass) then
         write(LERR,*)' Output # samples   =  ',nsamp 
      else
         write(LERR,*)' Output # samples   =  ',nsampo
      endif

      if (vel .lt. 1e20) then
         write(LERR,*) ' Velocity           =  ',vel

         if (hyperb) then
            write(LERR,*) ' using hyperbolic Velocity '
         else
            write(LERR,*) ' using linear Velocity'
         endif
      endif

      if (zero)write(LERR,*) ' Zero trace except for window'

      if (pass) write(LERR,*) ' using pass option'

      if (ignore) write(LERR,*) ' Ignore any previous wind'

      if (header) then
         write(LERR,*) ' Start window header word = ', HdrWrd
         if (flt) then
           write(LERR,*) ' Use floating point header values'
         else
           write(LERR,*) ' Use integer point header values'
         endif
      endif
  
      if (verbos) write(LERR,*) ' verbose printout requested'

      return
      end
