C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine chkfile(attribute_number,description,keyword,
     1                   calcfile,wrfile,lufile,all,hdrs,
     2                   nstream,nfile,luout,lerr,sheader,
     3                   IKP,pipelen,pipenum,nsamp_out,lbyout)
c_______________________________________________________________
c     check on how to open a USP format file.
c_______________________________________________________________
      character*(*) keyword,description
      logical       calcfile,wrfile
      integer       lufile,luout
      integer       hdrs(*)
      integer       hdrs2(3)
      real          sheader(*)
#include <save_defs.h>
      integer       attribute_number
      character*256 filename

      logical IKP, all
      integer pipelen, pipenum, nsamp_out
      integer idx

      character*1   quote
      data          quote/'"'/

      if (all) then
c_______________________________________________________________
c        We want all options computed.  Don't check for the option.
c        Assume output is a data stream.
c_______________________________________________________________
         filename = 'DATA_STREAM'
      else
c_______________________________________________________________
c        Read the command line argument.  Note that some of the
c        options do not contain a full 4 characters.  Only pass the
c        needed amount of keyword to argstr in order for it to work.
c_______________________________________________________________
         idx = LEN(keyword)
 1       if (keyword(idx:idx) .eq. ' ' .and. idx .gt. 1) then
            idx = idx - 1
            goto 1
         endif
         call argstr(keyword(1:idx),filename,'DATA_STREAM',' ') 
      endif

      if(filename .eq. ' ') then
c_______________________________________________________________
c        No keyword detected on the command line. 
c        Do not calculate the attribute.
c        Do not generate additional output.
c_______________________________________________________________
         calcfile=.false.
         wrfile=.false.
         write(lerr,'(a60,5x,a)') description,'Not Calculated'
      else if(filename .eq. 'DATA_STREAM' .and. .not. IKP) then
c_______________________________________________________________
c        Keyword detected on command line without an explicit filename. 
c        Calculate the attribute.
c        Add output to the multiattribute data stream 'file' luout.
c        Update the component lineheader word.
c_______________________________________________________________
         calcfile=.true.
         wrfile=.false.
         lufile=luout
         nstream=nstream+1

c        Encode this attribute value in the header word for later use.
         call sethdrs(attribute_number, hdrs)

         write(lerr,'(a60,i5,1x,a)') description,lufile,'(Data Stream)'
      else
c_______________________________________________________________
c        Keyword detected on command line with an explicit filename.
c        Calculate the attribute.
c        Open the file for the output data.
c        Update the lineheader and write it out.
c_______________________________________________________________
         wrfile=.true.
         calcfile=.true.
         if (IKP) then
c           Connect this output to the IKP pipe
            call sisfdfit(lufile,pipenum)
         else
c           Open the file
            call lbopen(lufile,filename,'w')
         endif
         nfile=nfile+1
         write(lerr,'(a60,i5,1x,a)') description,lufile,filename
c Reductions will have only 1 sample per output trace.  Attributes
c will have the same number of samples as the input trace.
         call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)

c        Encode this attribute value in the header word for later use.
         hdrs2(1) = 0
         hdrs2(2) = 0
         hdrs2(3) = 0
         call sethdrs(attribute_number, hdrs2)
         call savew(sheader,'MCLE01',hdrs2(1),LINEHEADER)
         call savew(sheader,'MCLE02',hdrs2(2),LINEHEADER)
         call savew(sheader,'MCLE03',hdrs2(3),LINEHEADER)

         call wrtape(lufile,sheader,lbyout)
      endif
c
      return
      end

      subroutine sethdrs(i, hdrs)
      integer i, hdrs(*)
c     Encode the reduction type in the line header.  Note that
c     when we get more than 45 reduction functions we will need
c     to add another header word (because hdrs is currently of size 3).
c     We encode the values into three header words (16 bits each),
c     using 15 bits, right to left, as powers of two on i.  This
c     way we can decode them by extracting the bits from the header
c     words later, and use the bit index as an index into the
c     description array.
      if (i .le. 15) then
         hdrs(1) = hdrs(1) + 2**(i-1)
      elseif ( i .gt. 15 .and. i .le. 30 ) then
         hdrs(2) = hdrs(2) + 2**(i-16)
      elseif ( i .gt. 30 ) then
         hdrs(3) = hdrs(3) + 2**(i-31)
      endif
      end
