C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine initproc(pipelen, quadrature,
     1                    available, keyword, description)

      implicit logical (a-z)

      integer pipelen
      logical quadrature(pipelen), available(pipelen)
      character*(*) keyword(pipelen)
      character*(*) description(pipelen)

      integer counter

c Grab the declarations for the process identifiers
#include "initproc.h"

c_______________________________________________________________
c     The number of settings in this file should be <= to the
c     value of pipelen!
c_______________________________________________________________
c     Initialize all process information
c     set the index
c        set the number of samples (1 for reductions, nsamp_in otherwise)
c        has the code been written?
c        set the keyword
c        set the text description
c_______________________________________________________________

c           0 average (-AVA)
c           1 average of absolute values (-AAA)
c           2 largest positive (> 0) value (-LPV)
c           3 largest negative (< 0) value (-LNV)
c           4 average of positive (> 0) values (-APV)
c           5 average of negative (< 0) values (-ANV)
c           6 angle of phase vector sum; +360 if negative (-A36)
c           7 angle of phase vector sum; +180 (-A18)
c           8 phase magnitude (-PMG)
c           9 average of absolute sample to sample difference (-AAD)
c          10 sum of absolute sample to sample difference (-SAD)
c          11 energy, sum of sample*sample (-ESS)
c          12 time of largest positive (> 0) value (-TLP)
c          13 time of largest negative (< 0) value (-TLN)
c          14 -TLP with parabola fit (-P12)
c          15 -TLN with parabola fit (-P13)
c          16 sum of absolute values (-SAV)
c          17 decay of absolute values (-DAV)
c          18 largest peak/trough amplitude difference (-LAD)
c          19 largest peak/trough time difference (-LTD)
c          20 standard deviation (-STD)
c          21 standard deviation of positive (> 0) values (-SDP)
c          22 standard deviation of negative (< 0) values (-SDN)
c          23 standard deviation of absolute values (-SDA)
c          24 median (-MED)
c          25 median of positive (> 0) values (-MDP)
c          26 median of negative (< 0) values (-MDN)
c          27 median of absolute values (-MDA)
c          28 maximum of absolute values (-MAA)
c          29 time of maximum absolute value (-TMA)
c          30 copy horizon (-CPH)
c          31 number of samples between thresholds (-CBT) - was -NBT

      counter = 1
      pmava = counter
         quadrature(pmava) = .FALSE.
         available(pmava) = .TRUE.
         keyword(pmava) = '-AVA'
         description(pmava) = 'Average'

      counter = counter + 1
      pmaaa = counter
         quadrature(pmaaa) = .FALSE.
         available(pmaaa) = .TRUE.
         keyword(pmaaa) = '-AAA'
         description(pmaaa) = 'Average of absolute values'

      counter = counter + 1
      pmlpv = counter
         quadrature(pmlpv) = .FALSE.
         available(pmlpv) = .TRUE.
         keyword(pmlpv) = '-LPV'
         description(pmlpv) = 'Largest positive (> 0) value'

      counter = counter + 1
      pmlnv = counter
         quadrature(pmlnv) = .FALSE.
         available(pmlnv) = .TRUE.
         keyword(pmlnv) = '-LNV'
         description(pmlnv) = 'Largest negative (< 0) value'

      counter = counter + 1
      pmapv = counter
         quadrature(pmapv) = .FALSE.
         available(pmapv) = .TRUE.
         keyword(pmapv) = '-APV'
         description(pmapv) = 'Average of positive (> 0) values'

      counter = counter + 1
      pmanv = counter
         quadrature(pmanv) = .FALSE.
         available(pmanv) = .TRUE.
         keyword(pmanv) = '-ANV'
         description(pmanv) = 'Average of negative (< 0) values'

      counter = counter + 1
      pma36 = counter
         quadrature(pma36) = .FALSE.
         available(pma36) = .TRUE.
         keyword(pma36) = '-A36'
         description(pma36) =
     1      'Angle of phase vector sum (+360 if negative)'

      counter = counter + 1
      pma18 = counter
         quadrature(pma18) = .FALSE.
         available(pma18) = .TRUE.
         keyword(pma18) = '-A18'
         description(pma18) = 'Angle of phase vector sum (+180)'

      counter = counter + 1
      pmpmg = counter
         quadrature(pmpmg) = .FALSE.
         available(pmpmg) = .TRUE.
         keyword(pmpmg) = '-PMG'
         description(pmpmg) = 'Phase magnitude'

      counter = counter + 1
      pmaad = counter
         quadrature(pmaad) = .FALSE.
         available(pmaad) = .TRUE.
         keyword(pmaad) = '-AAD'
         description(pmaad) =
     1      'Average of absolute sample to sample difference'

      counter = counter + 1
      pmsad = counter
         quadrature(pmsad) = .FALSE.
         available(pmsad) = .TRUE.
         keyword(pmsad) = '-SAD'
         description(pmsad) =
     1     'Sum of absolute sample to sample difference'

      counter = counter + 1
      pmess = counter
         quadrature(pmess) = .FALSE.
         available(pmess) = .TRUE.
         keyword(pmess) = '-ESS'
         description(pmess) = 'Energy (sum of sample*sample)'

      counter = counter + 1
      pmtlp = counter
         quadrature(pmtlp) = .FALSE.
         available(pmtlp) = .TRUE.
         keyword(pmtlp) = '-TLP'
         description(pmtlp) = 'Time of largest positive (> 0) value'

      counter = counter + 1
      pmtln = counter
         quadrature(pmtln) = .FALSE.
         available(pmtln) = .TRUE.
         keyword(pmtln) = '-TLN'
         description(pmtln) = 'Time of largest negative (< 0) value'

      counter = counter + 1
      pmp12 = counter
         quadrature(pmp12) = .FALSE.
         available(pmp12) = .TRUE.
         keyword(pmp12) = '-P12'
         description(pmp12) = '-TLP with parabola fit'

      counter = counter + 1
      pmp13 = counter
         quadrature(pmp13) = .FALSE.
         available(pmp13) = .TRUE.
         keyword(pmp13) = '-P13'
         description(pmp13) = '-TLN with parabola fit'

      counter = counter + 1
      pmsav = counter
         quadrature(pmsav) = .FALSE.
         available(pmsav) = .TRUE.
         keyword(pmsav) = '-SAV'
         description(pmsav) = 'Sum of absolute values'

      counter = counter + 1
      pmdav = counter
         quadrature(pmdav) = .FALSE.
         available(pmdav) = .TRUE.
         keyword(pmdav) = '-DAV'
         description(pmdav) = 'Decay of absolute values'

      counter = counter + 1
      pmlad = counter
         quadrature(pmlad) = .FALSE.
         available(pmlad) = .TRUE.
         keyword(pmlad) = '-LAD'
         description(pmlad) = 'Largest peak/trough amplitude difference'

      counter = counter + 1
      pmltd = counter
         quadrature(pmltd) = .FALSE.
         available(pmltd) = .TRUE.
         keyword(pmltd) = '-LTD'
         description(pmltd) = 'Largest peak/trough time difference'

      counter = counter + 1
      pmstd = counter
         quadrature(pmstd) = .FALSE.
         available(pmstd) = .TRUE.
         keyword(pmstd) = '-STD'
         description(pmstd) = 'Standard deviation'

      counter = counter + 1
      pmsdp = counter
         quadrature(pmsdp) = .FALSE.
         available(pmsdp) = .TRUE.
         keyword(pmsdp) = '-SDP'
         description(pmsdp) = 'Standard deviation of positive values'

      counter = counter + 1
      pmsdn = counter
         quadrature(pmsdn) = .FALSE.
         available(pmsdn) = .TRUE.
         keyword(pmsdn) = '-SDN'
         description(pmsdn) = 'Standard deviation of negative values'

      counter = counter + 1
      pmsda = counter
         quadrature(pmsda) = .FALSE.
         available(pmsda) = .TRUE.
         keyword(pmsda) = '-SDA'
         description(pmsda) = 'Standard deviation of absolute values'

      counter = counter + 1
      pmmed = counter
         quadrature(pmmed) = .FALSE.
         available(pmmed) = .TRUE.
         keyword(pmmed) = '-MED'
         description(pmmed) = 'Median'

      counter = counter + 1
      pmmdp = counter
         quadrature(pmmdp) = .FALSE.
         available(pmmdp) = .TRUE.
         keyword(pmmdp) = '-MDP'
         description(pmmdp) = 'Median of positive values'

      counter = counter + 1
      pmmdn = counter
         quadrature(pmmdn) = .FALSE.
         available(pmmdn) = .TRUE.
         keyword(pmmdn) = '-MDN'
         description(pmmdn) = 'Median of negative values'

      counter = counter + 1
      pmmda = counter
         quadrature(pmmda) = .FALSE.
         available(pmmda) = .TRUE.
         keyword(pmmda) = '-MDA'
         description(pmmda) = 'Median of absolute values'

      counter = counter + 1
      pmmaa = counter
         quadrature(pmmaa) = .FALSE.
         available(pmmaa) = .TRUE.
         keyword(pmmaa) = '-MAA'
         description(pmmaa) = 'Maximum of absolute values'

      counter = counter + 1
      pmtma = counter
         quadrature(pmtma) = .FALSE.
         available(pmtma) = .TRUE.
         keyword(pmtma) = '-TMA'
         description(pmtma) = 'Time of maximum absolute value'

      counter = counter + 1
      pmcph = counter
         quadrature(pmcph) = .FALSE.
         available(pmcph) = .TRUE.
         keyword(pmcph) = '-CPH'
         description(pmcph) = 'Copy horizon'

      counter = counter + 1
      pmnbt = counter
         quadrature(pmnbt) = .FALSE.
         available(pmnbt) = .TRUE.
         keyword(pmnbt) = '-CBT'
         description(pmnbt) = 'Number of samples between thresholds'

c     Double check the programmer!
      if (pipelen .lt. counter) then
         print*,'Error!  Not enough memory allocated for pipe info!'
         call exitfu(1234)
      endif

      end
