C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdtrace(tracebuf,uin,uquad,
     1                   calcquad,live,luin,maxtracebuf,
     2                   l_StaCor,ifmt_StaCor,ln_StaCor,
     3                   eof,lenhed,nt,nfft,lerr,
     4                   rtabf,itabf,rtabi,
     5                   itabi,work,
     6                   lenrtab,lenitab,lenwork,initfftf,
     7                   cputim,waltim)

c
#include <save_defs.h>
c
      integer   maxtracebuf
      real      tracebuf(-lenhed:maxtracebuf)
      real      uin(0:nfft-1)  
      complex   uquad(0:nfft/2-1)  
      complex   ci
      integer   l_StaCor,ifmt_StaCor,ln_StaCor
      logical   eof, forward, calcquad
      parameter (ci=(0.,1.))
      real      cputim(*),waltim(*)
      logical   live
      integer   istatic

c_______________________________________________________________
c     fourier transform table and work arrays.
c_______________________________________________________________
      real       rtabf(lenrtab)
      integer    itabf(lenitab)
      real       rtabi(lenrtab)
      integer    itabi(lenitab)
      real       work(lenwork)
c_______________________________________________________________________
c     read in the next trace.
c_______________________________________________________________________
      call timstr(v1,w1)
      eof=.false.
      nbytes_in=0

c_______________________________________________________________________
c     Replaced rtape with srtape.  Srtape automatically skips records
c     and traces when initialized with the record and trace ranges.
c     call rtape(luin,tracebuf(-lenhed),nbytes_in)
c_______________________________________________________________________

      call srtape(luin,tracebuf(-lenhed),nbytes_in)

      if(nbytes_in .le. 0) then
         eof=.true.
         return
      endif
c
      call saver2(tracebuf(-lenhed),ifmt_StaCor,l_StaCor,ln_StaCor,
     1            istatic,TRACEHEADER)

      if ( istatic .eq. 30000 ) then
         live = .false.
         call vclr(uin(0),1,nfft)
      else
         live = .true.
         call vmov(tracebuf(0),1,uin(0),1,nt+1) 
         call vclr(uin(nt+1),1,nfft-1-nt)
      endif          

      if ( calcquad ) then
        
         if(istatic .eq. 30000) then
            call vclr(uquad(0),1,nfft)
         else
            call vmov(uin(0),1,uquad(0),1,nfft)         
         endif

      endif

      call timend(cputim(1),v1,v2,waltim(1),w1,w2)

      if ( calcquad ) then
c___________________________________________________________________
c     take fourier transform from t-x into omega-x space.
c___________________________________________________________________
         call timstr(v1,w1)
         forward=.true.
         call rmmfft(uquad(0),work,itabf,rtabf,forward,
     1        nfft,lenwork,lenitab,lenrtab,
     2        nfft,1,initfftf,lerr)
         initfftf=0
c___________________________________________________________________
c     multiply by sqrt(-1.)
c___________________________________________________________________
 
         do 50000 kfreq=0,nfft/2-1
            uquad(kfreq)=ci*uquad(kfreq)
50000    continue   
c___________________________________________________________________
c     take fourier transform from omega-x space into t-x space.
c     this will be the quadrature trace.
c___________________________________________________________________
         forward=.false.
         call rmmfft(uquad(0),work,itabf,rtabf,forward,
     1        nfft,lenwork,lenitab,lenrtab,
     2        nfft,1,initfftf,lerr)
         
      endif

      call timend(cputim(2),v1,v2,waltim(2),w1,w2)
c
      return
      end 
