C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c  quick boutiqe code to do header word swap between 
c  headers of different types
c     Program Changes:
c
c     April 30/99 - added -abs option for Richard Crider and the 
c                   MonArb project
c     Garossino

c      - original written: nov 7 1997

c     Program Description:

c      - for Gupco

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     ist, iend, irs, ire, ns, ne, argis

      character   ntap*255, otap*255, name*9

      logical     verbos

c Program Specific _ dynamic memory variables

      integer TraceSize, errcd1, abort

      real    Trace_WorkSpace

      pointer ( mem_Trace_WorkSpace, Trace_WorkSpace(200000))

c Program Specific _ static memory variables

      integer ifmt_Wrd1,l_Wrd1,ln_Wrd1, i_Wrd1
      integer ifmt_Wrd2,l_Wrd2,ln_Wrd2

      real r_Wrd1, amp, bias

      character c_Wrd1*6, c_Wrd2*6

      logical absolute

c Initialize variables

      data abort/0/
      data name/"WORD_SWAP"/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     c_Wrd1, c_Wrd2, amp, bias, name, absolute, verbos )

c POLICEMAN check to make sure both header entries are present

      if ( c_Wrd1 .eq. ' ' .or. c_Wrd2 .eq. ' ' ) then
         write(LERR,*)' '
         write(LERR,*)' you must enter a mnemonic for both '
         write(LERR,*)'  -hw1 and -hw2'
         write(LERR,*)' command line entries, fix and resubmit'
         write(LERR,*)' '
         write(LERR,*)'FATAL '
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'WORD_SWAP: '
         write(LER,*)' you must enter a mnemonic for both '
         write(LER,*)'  -hw1 and -hw2'
         write(LER,*)' command line entries, fix and resubmit'
         write(LER,*)' '
         write(LER,*)'FATAL '
         write(LER,*)' '
         stop
      endif

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'WORD_SWAP: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu(c_Wrd1,ifmt_Wrd1,l_Wrd1,ln_Wrd1,TRACEHEADER)
      call savelu(c_Wrd2,ifmt_Wrd2,l_Wrd2,ln_Wrd2,TRACEHEADER)

c historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 9, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the sample limits ist and iend are used to 
c       limit processing only.   All data samples are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, c_Wrd1, c_Wrd2, amp, bias, 
     :     absolute, verbos)

c dynamic memory allocation:  

      TraceSize = nsamp 
      call galloc (mem_Trace_WorkSpace, TraceSize * SZSMPD, errcd1, 
     :     abort)
    
      if ( errcd1 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) TraceSize * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Trace_WorkSpace, 1, TraceSize )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c do header word swap


            if ( 
     :           ( ifmt_Wrd1 .eq. SAVE_FLOAT_DEF .and. 
     :           ifmt_Wrd2 .eq. SAVE_FLOAT_DEF ) 
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_FLOAT_DEF .and. 
     :              ifmt_Wrd2 .eq. SAVE_FKFLT_DEF ) 
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_FKFLT_DEF .and. 
     :              ifmt_Wrd2 .eq. SAVE_FKFLT_DEF ) 
     :           .or.
     :             ( ifmt_Wrd1 .eq. SAVE_FKFLT_DEF .and. 
     :              ifmt_Wrd2 .eq. SAVE_FLOAT_DEF ) 
     :           )then

c  float --> float
c  float --> fake float
c  fake float --> fake float
c  fake float --> float
               
               call saver2( itr, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :              r_Wrd1, TRACEHEADER )

               if ( absolute ) then
                  r_Wrd1 = abs(r_Wrd1) * amp + bias
               else
                  r_Wrd1 = r_Wrd1 * amp + bias
               endif

               call savew2( itr, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :              r_Wrd1, TRACEHEADER )

            endif

            if ( 
     :           (ifmt_Wrd1 .eq. SAVE_FLOAT_DEF .and. 
     :              ifmt_Wrd2 .eq. SAVE_SHORT_DEF )
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_FLOAT_DEF .and. 
     :              ifmt_Wrd2 .eq. SAVE_LONG_DEF ) 
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_FKFLT_DEF .and. 
     :              ifmt_Wrd2 .eq. SAVE_SHORT_DEF ) 
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_FKFLT_DEF .and. 
     :           ifmt_Wrd2 .eq. SAVE_LONG_DEF ) 
     :           )then

c  float --> short int
c  float --> long int
c  fake float --> short int
c  fake float --> long int
 
               call saver2( itr, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :              r_Wrd1, TRACEHEADER )

               if ( absolute ) then
                  i_Wrd1 = nint( abs(r_Wrd1) * amp + bias )
               else
                  i_Wrd1 = nint( r_Wrd1 * amp + bias )
               endif
               
               call savew2( itr, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :              i_Wrd1, TRACEHEADER )

            endif

            if (
     :           ( ifmt_Wrd1 .eq. SAVE_SHORT_DEF .and. 
     :              ifmt_Wrd2 .eq. SAVE_FKFLT_DEF ) 
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_SHORT_DEF .and. 
     :           ifmt_Wrd2 .eq. SAVE_FLOAT_DEF )
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_LONG_DEF .and. 
     :           ifmt_Wrd2 .eq. SAVE_FKFLT_DEF )
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_LONG_DEF .and. 
     :           ifmt_Wrd2 .eq. SAVE_FLOAT_DEF ) 
     :           ) then

c  short int --> fake float
c  short int --> float
c  long int --> fake float
c  long int --> float

               call saver2( itr, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :              i_Wrd1, TRACEHEADER )

               if (absolute) then
                  r_Wrd1 = abs ( float( i_Wrd1 ) ) * amp + bias
               else
                  r_Wrd1 = float( i_Wrd1 ) * amp + bias
               endif

               call savew2( itr, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :              r_Wrd1, TRACEHEADER )

            endif
            
            if ( 
     :           ( ifmt_Wrd1 .eq. SAVE_SHORT_DEF .and. 
     :              ifmt_Wrd2 .eq. SAVE_SHORT_DEF )
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_SHORT_DEF .and. 
     :           ifmt_Wrd2 .eq. SAVE_LONG_DEF )
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_LONG_DEF .and. 
     :           ifmt_Wrd2 .eq. SAVE_SHORT_DEF )
     :           .or.
     :           ( ifmt_Wrd1 .eq. SAVE_LONG_DEF .and. 
     :           ifmt_Wrd2 .eq. SAVE_LONG_DEF ) 
     :           ) then
c  short int --> short int
c  short int --> long int
c  long int --> short int
c  long int --> long int

               call saver2( itr, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :              i_Wrd1, TRACEHEADER )

               if ( absolute ) then
                  i_Wrd1 = nint ( abs ( float( i_Wrd1 )) * amp + bias )
               else
                  i_Wrd1 = nint ( float( i_Wrd1 ) * amp + bias )
               endif

               call savew2( itr, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :              i_Wrd1, TRACEHEADER )

            endif

c write output data

            call wrtape (luout, itr, obytes)
 
         ENDDO
 
c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'word_swap: Normal Termination'
      write(LER,*)'word_swap: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'word_swap: ABNORMAL Termination'
      write(LER,*)'word_swap: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for word_swap: USP template'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-ns[]  -- start trace number                  (1)'
      write(LER,*)'-ne[]  -- end trace number           (last trace)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-hw1[] -- source trace header mnemonic (required)'
      write(LER,*)'-hw2[] -- target trace header mnemonic (required)'
      write(LER,*)'-amp[]  -- header value multiplier          (1.0)'
      write(LER,*)'-bias[] -- header value bias                (0.0)'
      write(LER,*)'-abs   -- absolute value of hw1 will be taker '
      write(LER,*)'          prior to multiplication by -amp[] '
      write(LER,*)'          and / or addition of any -bias[] '
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)' equation is hw2 = hw1 * amp + bias'
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'    word_swap -N[] -O[]  -ns[] -ne[] -rs[]'
      write(LER,*)'              -re[] -hw1[] -hw2[] -amp[] -bias[] '
      write(LER,*)'              -abs -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     c_Wrd1, c_Wrd2, amp, bias, name, absolute, verbos )

#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis

      real amp, bias

      character  ntap*(*), otap*(*), name*(*), c_Wrd1*6, c_Wrd2*6

      logical    verbos, absolute

           absolute = (argis('-abs') .gt. 0)

           call argr4 ( '-amp', amp, 1., 1. )

           call argr4 ( '-bias', bias, 0., 0. )

           call argi4 ( '-e', iend, 0, 0 )

           call argi4 ( '-ne', ne, 0, 0 )
           call argi4 ( '-ns', ns, 0, 0 )
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )

           call argi4 ( '-s', ist, 1, 1 )

           verbos = (argis('-V') .gt. 0)

           call argstr ( '-hw1', c_Wrd1, ' ', ' ' ) 
           call argstr ( '-hw2', c_Wrd2, ' ', ' ' ) 

c check for extraneous arguments and abort if found to
c catch all manner of user typo's (eat,die)

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, ns, ne, c_Wrd1, c_Wrd2, amp, bias, 
     :     absolute, verbos)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, ns, ne, nsi

      real amp, bias

      character  ntap*(*), otap*(*), c_Wrd1*6, c_Wrd2*6

      logical    verbos, absolute

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' Input header word       = ', c_Wrd1
      write(LERR,*) ' Output header word      = ', c_Wrd2
      write(LERR,*) ' header word Multiplier  = ', amp
      write(LERR,*) ' header word Bias        = ', bias
      if ( absolute )  write(LERR,*) ' absolute value taken '
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end
