C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE write trace distances
C
C**********************************************************************C
C
C WRDT READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C puts user specified trace distances and outputs the results
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , lbytes, nbytes
      integer     argis

      integer  DstSgn, l_DstSgn, ln_DstSgn, ifmt_DstSgn
      integer  DstUsg, l_DstUsg, ln_DstUsg, ifmt_DstUsg
      integer  SoPtNm, l_SoPtNm, ln_SoPtNm, ifmt_SoPtNm
      integer  SrcLoc, l_SrcLoc, ln_SrcLoc, ifmt_SrcLoc
      integer  RecInd, l_RecInd, ln_RecInd, ifmt_RecInd

      real     dists
      pointer  (wkdists, dists (1))

      real        cdpint, scl

      character   name * 4, ntap * 255, otap * 255
      character   dtap * 255, card * 80

      logical     verbos, query, srceq1, newx, heap, EOF, irreg

c initialize variables
 
      data name     /'WRDT'/
      data luin / 1 /
      data lbytes / 0 /
      data nbytes / 0 /
      data EOF /.false./
      data irreg /.false./

c-----------------------------------------
c  get online help if necessary
c-----------------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif

c-----------------------------------------
c  open printout file
c-----------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      call cmdln (ntap,otap,dx,x0,verbos,srceq1,newx,cdpint,
     1            scl,dtap,irreg,iunit)

c set up pointers to header mnemonics

      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
      lbytes = 0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'WRDT: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      call hlhprt ( itr , lbytes, name, 4, lerr  )

c--------------------------
c  save key header values
#include <f77/saveh.h>

c-----------------------------------
c  verbos printout
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Format of Data     =  ', iform

        if (irreg) then

        write(LERR,*) ' Input distance file=  ', dtap

        else

        if (newx) then
           write(LERR,*) ' Group interval     =  ', dx
           write(LERR,*) ' Near trace offset  =  ', x0
        endif

        endif

        if (srceq1) then
           write(LERR,*) ' Recalculate src pt numbers based on:'
           write(LERR,*) ' grp# + (offset/cdp_interval)'
           write(LERR,*) ' cdp interval       =  ', cdpint
           write(LERR,*) ' SP scale factor    =  ', scl
        endif

      heap = .true.
      if (irreg) then
         item = ntrc
      else
         item = 1
      endif
      call galloc (wkdists, item*SZSMPD, ierr, iabort)
      if (ierr .ne. 0) heap = .false.
      if (.not. heap) then
          write(LERR,*)' '
          write(LERR,*)'wrdt: Unable to allocate memory:'
          write(LERR,*) item*SZSMPD,'  bytes'
          write(LER ,*)' '
          write(LER ,*)'wrdt: Unable to allocate memory:'
          write(LER ,*) item*SZSMPD,'  bytes'
          go to 999
      else
          write(LERR,*)' '
          write(LERR,*)'Allocating memory'
          write(LERR,*) item*SZSMPD,'  bytes'
          write(LERR,*)' '
      endif

      IF ( irreg ) THEN

         j = 0
         do  while (1.eq.1)

             read (iunit, '(a80)', end=33,err=666) card
             go to 34
33           EOF = .true.
             go to 35
34           continue

             j = j + 1
             call fsscnf (card, '%f', dists (j) )

         enddo
35       continue

         if (j .eq. 0) then
            write(LERR,*)' '
            write(LERR,*)'wrdt: FATAL ERROR'
            write(LERR,*)'No entries in distance file -D[]. Check file'
            write(LERR,*)'for valid distances - one per line'
            write(LER ,*)' '
            write(LER ,*)'wrdt: FATAL ERROR'
            write(LER ,*)'No entries in distance file -D[]. Check file'
            write(LER ,*)'for valid distances - one per line'
            stop 666
         elseif (j .lt. ntrc) then
            write(LERR,*)' '
            write(LERR,*)'wrdt: FATAL ERROR'
            write(LERR,*)'# entries in distance file < ',ntrc,' the #'
            write(LERR,*)'traces per record'
            write(LER ,*)' '
            write(LER ,*)'wrdt: FATAL ERROR'
            write(LER ,*)'# entries in distance file < ',ntrc,' the #'
            write(LER ,*)'traces per record'
            stop 666
         endif
         go to 36
666      continue
            write(LERR,*)' '
            write(LERR,*)'wrdt: FATAL ERROR'
            write(LERR,*)'Error reading distance file -D[]'
            write(LER ,*)' '
            write(LER ,*)'wrdt: FATAL ERROR'
            write(LER ,*)'Error reading distance file -D[]'
            stop 666

      ENDIF

36    continue
c---------------------------------------------------
c  update historical line header & write out header
      call savhlh ( itr, lbytes, lbyout )
      call wrtape(luout,itr,lbyout)
 
C**********************************************************************C
C
C     READ TRACE, put in trace distances
C
C**********************************************************************C
 
      DO JJ = 1, NREC

c-------------------------
c  initialize distance
         if (newx) x = x0 - dx
         DO KK = 1, NTRC

            nbytes = 0
            CALL RTAPE  ( LUIN , ITR, NBYTES         )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif

c-----------------
c  update distance
c  or read current
c  header value
            IF (irreg) THEN
               x = dists (kk)
            ELSE
               if (newx) then
                  x = x + dx
               else
                  call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     :                 DstSgn, TRACEHEADER )
                  x = float(DstSgn)
               endif
            ENDIF

c-----------------
c  recalculate src
c  pt numbers
            IF (srceq1) THEN
               call saver2( itr, ifmt_RecInd, l_RecInd, ln_RecInd,
     :              RecInd, TRACEHEADER )
               sp = float(RecInd) + x / cdpint + 0.001
               SoPtNm = ifix (sp)
               call savew2( itr, ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm,
     :              SoPtNm, TRACEHEADER ) 
               SrcLoc = ifix ( scl * sp )
               call savew2( itr, ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc,
     :              SrcLoc, TRACEHEADER ) 
            ENDIF

c------------------------
c   put in trace distance
c   either old or new
            DstUsg = iabs(ifix(x))
            DstSgn = ifix(x)
            call savew2( itr, ifmt_DstUsg, l_DstUsg, ln_DstUsg,
     :           DstUsg, TRACEHEADER ) 
            call savew2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     :           DstSgn, TRACEHEADER ) 
            
            if(verbos) then
               write(LERR,*)' Record= ',jj,' Trace= ',kk,' dist= ',x
            endif
            
            call wrtape(luout,itr,nbytes)
            
         ENDDO
      ENDDO

 999  continue
      call lbclos(luin)
      call lbclos(luout)
      END
      
c------------------------------------------
c  online help section
c------------------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for WRDT: write trace dista
     &nce; recalc src pt #s'              
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)' '
        write(LER,*)'Input irregular offset file ...'
        write(LER,*)'-D[dtap]   -- file of offsets, one per line'
        write(LER,*)'... Regular offset specification'
        write(LER,*)'-gi[dx]    -- group interval'
        write(LER,*)'-x0[x0]    -- near trace offset for single end'
        write(LER,*)'              most negative offset for split sprd'
        write(LER,*)' '
        write(LER,*)'-S1        -- recalculate src pt #s based on eqn1:'
        write(LER,*)'              SP = group# + (offset/cdpint)'
        write(LER,*)'-cdp[cdpint]- cdp interval (ft,m)  (no def if -S1)'
        write(LER,*)'-s[scl]    -- factor to scale SP numbers (def= 10)'
        write(LER,*)'              This value is put in SrcLoc. The'
        write(LER,*)'              unscaled SP is put in SpPtNm'
        write(LER,*)' '
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        wrdt -N[] -O[] [ -D[] -gi[] -x0[] ]'
        write(LER,*)'               -s[] -cdp [-S1,-V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     dx    - R      group interval
c     x0    - R      near offset
c    ntpr   - I      number traces per rec on output
c    cdpint - R      cdp interval
c    scl    - R      factor to scale src pts
c    norm   - L      normalize stacked trace by # live traces
c    newx   - L      recalculate trc dists
c    srceq1 - L      recalculate src pt #'s based on equation1
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,dx,x0,verbos,srceq1,newx,cdpint,
     1                  scl,dtap,irreg,lupik)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*), dtap*(*)
      real       dx, x0, cdpint, scl
      integer    argis
      logical    verbos, srceq1, newx, irreg

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argstr('-D',dtap,' ',' ') 
          call argr4('-gi',dx,0.,0.)
          call argr4('-x0',x0,0.,0.)


         IF (dtap(1:1) .ne. ' ') THEN

           call alloclun ( lupik )
           ln = lenth ( dtap )
 
           open (lupik, file = dtap(1:ln),status = 'old',iostat = ierr)
           if(ierr .ne. 0) then
              write(LER,*)'wrdt: Could not open input pick file ',dtap
              write(LER,*)'      Check permissions/spelling and rerun '
              write(LER,*)'FATAL'
              stop
           endif
           irreg = .true.
         ELSE

           irreg = .false.
         ENDIF


          srceq1 = (argis('-S1') .gt. 0)
          if (srceq1) then
             call argr4('-s',scl,10.,10.)
             call argr4('-cdp',cdpint,0.,0.)

             if (cdpint .eq. 0.) then
                write(LERR,*)'Must input cdp interval (ft,m)'
                write(LERR,*)'Rerun with -cdp[] properly entered'
                stop 911
             endif
          endif

          verbos = (argis('-V') .gt. 0)
          if (dx .eq. 0.) then
             newx = .false.
          else
             newx = .true.
          endif

      return
      end

