/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* - modified to ignore broken pipe signals in case on of the object processes
     finishes earlier than the others. Warning message is issued only.
						- j.m.wade 7/14/95
*/
   
#include <stdio.h>
#include <signal.h>

int broken_pipe = 0;

main(argc, argv)
int argc;
char *argv[];
{
	FILE *fp[10], *popen();
	int narg, i, status;
	void sigpipe_hook();
	void filecopy();

	if ( (argc-1) == 0 ) {
		fprintf( stderr,"Usage: \n" );
		fprintf( stderr,"       process1 | wye process2 process3 ... \n");
		fprintf( stderr," \n");
		fprintf( stderr,"where process2, process3, etc are script files or command \n");
		fprintf( stderr,"lines enclosed in double or single quotes.  process1 can \n");
		fprintf( stderr,"be either a script or command line sequence (no quotes necessary) \n");
		exit (0);
	}
	if ( (argc-1) > 10 ) {
		fprintf( stderr, "Number of Command Line Args Must Be L.E. 10 \n" );
		fprintf( stderr, "Number arguments found %d\n", argc-1);
		exit (1);
	}
	narg = 0;
	while(--argc > 0)
		if( (fp[narg++] = popen(*++argv, "w")) == NULL){
			fprintf(stderr,"wye: can't find %s\n",*argv);
			narg--;
		}

	signal(SIGPIPE,sigpipe_hook);

	for ( i=0; i < narg; i++ )
		filecopy(fp,narg);

	for ( i=0; i < narg; i++ ) {
		status = pclose ( fp[i] );
	}
	
	if (broken_pipe != 0)
	  fprintf(stderr,"wye: WARNING - an attempt was made to write data to a broken pipe\n");

	exit(0);
}

#ifdef CRAYSYSTEM
#define BFRSIZE 500000
#else
#define BFRSIZE 50000
#endif

void filecopy(fp,narg)

FILE *fp[];
int narg;
{
	int i, nread, nwrite;
	char buffer [BFRSIZE];

	while ( ( nread = read( 0, buffer, BFRSIZE ) ) > 0){
		for ( i=0; i < narg; i++ )
			nwrite = write( fileno( fp[i] ), buffer, nread );
	}
}
void sigpipe_hook(sig)
int sig;
{
	broken_pipe = 1;
/* we have to re-set this for some systems (System 5 Unix?) */
	signal(SIGPIPE,sigpipe_hook);
	return;
}
