/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

void dialog_at_cursor(dialog)
Widget dialog;
{
	Window root_window,child_window,virtual_window;
	Dimension default_child_width,default_child_height;
	unsigned int keys_buts;
	Position apply_x,apply_y;
	unsigned char default_child;
	int root_x,root_y,win_x,win_y;
	short new_x,new_y,wm_x,wm_y;

	fprintf(stderr,"entering dialog_at_cursor\n");

	if (!XtIsComposite(dialog)) return;

	XtManageChild(dialog);
	XmUpdateDisplay(dialog);

	XtVaGetValues(dialog,
		XmNdefaultButtonType, &default_child,
		NULL);

	XtVaGetValues((Widget) XmMessageBoxGetChild(dialog,default_child),
		XmNx,		&apply_x,
		XmNy,		&apply_y,
		NULL);
	fprintf(stderr,"default dialog location\n");
	fprintf(stderr,"\tx=%d y=%d\n\n",
		apply_x,apply_y);

	XtVaGetValues((Widget) XmMessageBoxGetChild(dialog,default_child),
		XmNx,		&apply_x,
		XmNy,		&apply_y,
		XmNwidth,	&default_child_width,
		XmNheight,	&default_child_height,
		NULL);
	fprintf(stderr,"default child button location:\n");
	fprintf(stderr,"\tx=%d y=%d width=%d height=%d\n\n",
		apply_x,apply_y,default_child_width,default_child_height);

	XtUnmanageChild(dialog);

/* if a virtual window manager is running, root window isn't good enough */

	virtual_window =
	  GetVRoot(XtDisplay(dialog),DefaultScreen(XtDisplay(dialog)));

	XQueryPointer(XtDisplay(dialog),virtual_window,
		&root_window,&child_window,
		&root_x,&root_y,&win_x,&win_y,&keys_buts);

	fprintf(stderr,"pointer location:\n");
	fprintf(stderr,"\twindow x=%d window y=%d root x =%d root y =%d\n\n",
		win_x,win_y,root_x,root_y);

	XtTranslateCoords(dialog,apply_x,apply_y,&wm_x,&wm_y);

	fprintf(stderr,"translated coordinates:\n");
	fprintf(stderr,"\tx=%d y=%d\n\n",wm_x,wm_y);

	new_x = win_x - apply_x - (default_child_width / 2);
	new_y = win_y - apply_y - (default_child_height / 2);

	fprintf(stderr,"new dialog  coordinates:\n");
	fprintf(stderr,"\tnew_x=%d new_y=%d\n\n",new_x,new_y);

	XtVaSetValues(dialog,
		XmNx,	(Position) new_x,
		XmNy,	(Position) new_y,
		XmNmappedWhenManaged,	TRUE,
		NULL);
	XtManageChild(dialog);
}
