/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/List.h>
#include <globs.h>

void listDrives(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	int drive,unit,arg,den,phys,stat;
	char identifier[32],vol[64];
	int  chd_status;
	int list_pos = 1;
	int  found = 0;
	char list_item[80];
	XmString item;
	char *chd_line;

	if (data.verbose >= 3)
	  fprintf(tattle,"*-/- listDrives -/-*\n");

	chd_cmd("query all");

	do {
/*
	  while ( fscanf(stdin,"%d",&chd_status) <= 0 ) {
           system("sleep 1");
           }
*/
	  chd_status = chd_stat(FALSE,FALSE);

	  if (chd_status < 400) {
	    chd_line = get_chd_line(FALSE);
	    sscanf(chd_line,"%s",identifier);
	    
	    if (strcmp(identifier,"Drive") == 0) {
	      sscanf(chd_line+strlen(identifier),
		"%d Unit %d Arg %d Den %d Phys %d Stat %d Vol %s",
		&drive,&unit,&arg,&den,&phys,&stat,vol);
/*
	      if ( data.verbose >= 2 ) 
	        fprintf(tattle,"%d Drive %d Unit %d Arg %d Den %d Phys %d Stat %d Vol %s\n",chd_status,drive,unit,arg,den,phys,stat,vol);
*/
	      sprintf(list_item," %2d       %d       %d      %d      %d    %3d    %-16s",drive,unit,arg,den,phys,stat,vol);
	      item = XmStringCreateLtoR(&list_item[0],XmSTRING_DEFAULT_CHARSET);
	      XmListAddItem(drive_list,item,list_pos);

	      XmUpdateDisplay(drive_list);
	      XmStringFree(item);
	    }
	    XtFree(chd_line);
	    }
	  else {
	    chd_response(FALSE);
	    }

	  list_pos++;
	  } while (chd_status != 285);
	return;
}
