/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <signal.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/MessageB.h>
#include "HelpObject.h"
#include "globs.h"

Boolean loader(flag)
XtPointer flag;
{
	static int i=-1;
	static XmStringTable selected_items;
	static int num_selected_items;
	int j;
	char *cgdate(),*cgtime();

	Widget retry_dialog;
	int scratch = 0;
	int status,drive,selection_num = 0;
	char *slot_selection;
	int arg,den,phys;
	char stat[32],vol[32];
	XmString label,dialog_label;
	char *chd_line;

	if (data.verbose >= 3)
	  fprintf(tattle,"*-/- loader -/-*\n");

	WorkProcID = NULL;

	  XtVaGetValues(selected_list,
		XmNitems, &selected_items,
		XmNitemCount, &num_selected_items,
		NULL);

	if ((int)flag == CHD_INITIAL_LOAD) {
/*
	  XtVaGetValues(selected_list,
		XmNitems, &selected_items,
		XmNitemCount, &num_selected_items,
		NULL);
*/

	  if (num_selected_items == 0) {
	    ok_enable();
	    if ( data.totape ) {
	      XmTextSetString(chd_stat_text,
		"no tapes specified - using tapes designated SCRATCH");
	      XtVaGetValues(slot_list,
		XmNitems, &selected_items,
		XmNitemCount, &num_selected_items,
		NULL);
	      for (i=0; i<num_selected_items; i++) {
		if ( XmStringGetLtoR(*(selected_items+i),
	   		XmSTRING_DEFAULT_CHARSET, &slot_selection) ) {
	    	  sscanf(slot_selection,"%d %d %d %d %d %s %s",
			&slot, &drive, &arg, &den, &phys, stat, vol);
		  XtFree(slot_selection);
		  if (strcmp(stat,"Scratch") == 0) {
		    scratch++;
		    XmListAddItem(selected_list,*(selected_items+i),0);
		    }
		  }
		}
	      if (scratch == 0) {
	        XmTextSetString(chd_stat_text,"no SCRATCH tapes found");
		return(TRUE);
		}
	      else return(FALSE);	/* we want to come back in this case */
	      }
	    else {
	      XmTextSetString(chd_stat_text,"error: no tapes specified");
	      return TRUE;
	      }
	    }
	  blen = data.blockSize;
	  iobuffer = malloc(data.blockSize);
	  if (iobuffer == NULL) {
	    sprintf(msg_text,"XCRAM10: buffer allocation failure ( %d bytes)",
		data.blockSize);
	    XmTextSetString(chd_stat_text,msg_text);
	    fprintf(tattle,"%s\n",msg_text);
	    return(TRUE);
	    }
	  bgood = 0;
	  i = 0;
	  }
	else if ((int)flag != CHD_RELOAD) {
	  unloadSlot(slot);
	  updateSlotItem(*(selected_items+i));
	  sprintf(msg_text,
	    "%.0f total bytes transferred ", totalBytes);
	  if (data.verbose != 0)
	    fprintf(tattle,"\n%s",msg_text);
	  XmTextSetString(chd_stat_text,msg_text);
	  XmTextInsert(history_text1,
	    XmTextGetLastPosition(history_text1), msg_text);
	  XmTextInsert(history_text1,
	    XmTextGetLastPosition(history_text1), "\n");
	  if ((int)flag == EOF) {
	    XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),
		" - hit EOF");
	    XmTextInsert(history_text1,
	      XmTextGetLastPosition(history_text1), " - EOF");
	    return TRUE;
	    }
	  i++;
	  if (i == num_selected_items) {
	    sprintf(msg_text,"%s\n",
	      data.totape ? " - out of tapes" : " - all tapes read");
	    if (data.verbose != 0)
	       fprintf(tattle,"%s",msg_text);
	    XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),
		msg_text);
	    XmTextInsert(history_text1,
	      XmTextGetLastPosition(history_text1), msg_text);

	    if ( data.totape ) {
/*
	if we're writing tapes, this means we have data waiting, but no
	tape to write to. Go ahead and load up a scratch tape automatically
	if one is available. Otherwise, give the user the option to pick
	another tape if they want.
*/
	      XmTextSetString(chd_stat_text,
		"Out of tapes - using tapes designated SCRATCH");
	      XtVaGetValues(slot_list,
		XmNitems, &selected_items,
		XmNitemCount, &num_selected_items,
		NULL);
	      for (j=0; j<num_selected_items; j++) {
		if ( XmStringGetLtoR(*(selected_items+j),
	   		XmSTRING_DEFAULT_CHARSET, &slot_selection) ) {
	    	  sscanf(slot_selection,"%d %d %d %d %d %s %s",
			&slot, &drive, &arg, &den, &phys, stat, vol);
		  XtFree(slot_selection);
		  if (strcmp(stat,"Scratch") == 0) {
		    scratch++;
		    XmListAddItem(selected_list,*(selected_items+j),0);
		    }
		  }
		}
	      if (scratch != 0) 
		WorkProcID = XtAppAddWorkProc(app_con,loader,
			(XtPointer) CHD_RELOAD);
	      else {
		dialog_label = XmStringCreateLtoR("XCRAM10: EOF Dialog",
			XmSTRING_DEFAULT_CHARSET);
		retry_dialog = XmCreateWarningDialog(toplevel,"retry",
			NULL,0);
		label = XmStringCreateLtoR(
		"Out of tapes: select more tapes and\nhit OK to continue or\npress Cancel to terminate",
			XmSTRING_DEFAULT_CHARSET);
		XtVaSetValues(retry_dialog,
			XmNmessageString,		label,
			XmNdialogTitle,			dialog_label,
			NULL);

		XtAddCallback(retry_dialog,XmNokCallback,doit,
			(XtPointer) CHD_RELOAD);
		XtAddCallback(retry_dialog,XmNcancelCallback,
			confirm_quit,quit_dialog);
		XtAddCallback(retry_dialog,XmNhelpCallback,
			(XtCallbackProc) XuHelper,(XtPointer) "Add_Tapes.help");

		XtAddCallback(retry_dialog,XmNokCallback,
			destroy_dialog,retry_dialog);
		XtAddCallback(retry_dialog,XmNcancelCallback,
			destroy_dialog,retry_dialog);

		XtManageChild(retry_dialog);
		XmStringFree(dialog_label);
		XmStringFree(label);
		}
	      }
	    return TRUE;
	    }
	  }
	else if ((int)flag == CHD_RELOAD) {
/*
   it is possible to add tapes, so we need to rebuild the list
*/
	  XtVaGetValues(selected_list,
		XmNitems, &selected_items,
		XmNitemCount, &num_selected_items,
		NULL);
	  if (i >= num_selected_items) {
	    sprintf(msg_text,"Error: no new tapes specified");
	    if (data.verbose) 
	      fprintf(tattle,"%s\n",msg_text);
	    XmTextSetString(chd_stat_text,msg_text);
	    label = XmStringCreateLtoR(
		"Error: No new tapes were selected; make\n  selections and hit OK to continue processing\n  or press Cancel to terminate program",
		XmSTRING_DEFAULT_CHARSET);
	    dialog_label = XmStringCreateLtoR("XCRAM10: Tape Load Retry Dialog",
		XmSTRING_DEFAULT_CHARSET);
	    retry_dialog = XmCreateErrorDialog(toplevel,"retry",
			NULL,0);
	    XtVaSetValues(retry_dialog,
			XmNmessageString,		label,
			XmNdialogTitle,			dialog_label,
			NULL);
	    XtAddCallback(retry_dialog,XmNokCallback,doit,
			(XtPointer) CHD_RELOAD);
	    XtAddCallback(retry_dialog,XmNcancelCallback,
                confirm_quit,quit_dialog);
	    XtAddCallback(retry_dialog,XmNhelpCallback,
		(XtCallbackProc) XuHelper,(XtPointer) "Add_Tapes.help");

	    XtAddCallback(retry_dialog,XmNokCallback,
		destroy_dialog,retry_dialog);
	    XtAddCallback(retry_dialog,XmNcancelCallback,
		destroy_dialog,retry_dialog);

	    XtManageChild(retry_dialog);
	    XmStringFree(dialog_label);
	    XmStringFree(label);
	    return TRUE;
	    }
	  }

	if ( XmStringGetLtoR(*(selected_items+i),
	    XmSTRING_DEFAULT_CHARSET, &slot_selection) ) {
	  sscanf(slot_selection,"%d %d %d %d %d %s %s",
		&slot, &drive, &arg, &den, &phys, stat, vol);

	  XtFree(slot_selection);
	  if (i != 0) {
	    if (data.segy) segy_skip = TRUE;
	    else if (data.mvs) mvs_skip = TRUE;
	    else if (data.green) hdr_skip = TRUE;
	    }

	  sprintf(msg_text,"%s %s - ",cgdate(),cgtime());

	  if (strcmp(stat,"Loaded") == 0) {
	    if (! findLoaded(slot)) {
	      XmTextSetString(chd_stat_text,
		  "Unable to determine device for selected slot");
	      return(TRUE);
	      }
	    if (fileIsOk()) {
	      XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		msg_text);
	      sprintf(msg_text,"slot %d previously loaded",slot);
	      XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		msg_text);
	      XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		"\n");

	      WorkProcID = data.totape ? 
	        XtAppAddWorkProc(app_con,IOtoTape,NULL) :
	        XtAppAddWorkProc(app_con,IOfromTape,NULL);
	      return TRUE;
	      }
	    else {
	      if (!data.totape) {
	        system("xalert -C XCram10 OK 'Error opening device for reading' &");
	        return TRUE;
		}
	      else {
	        system("xalert -C XCram10 OK 'Error opening device for writing;' 'proceeding to next tape' &");
	        ok_enable();
	        updateSlotItem(*(selected_items+i));
		return FALSE;
		}
	      }
	    }

	  if ( data.verbose )
	      fprintf(tattle,"%s",msg_text);

	  XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		msg_text);

	  sprintf(msg_text," - loading slot %d",slot);
	  XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),
		msg_text);

	  sprintf(msg_text,"load slot %d",slot);
	  XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		msg_text);
	  XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		"\n");
	  chd_cmd(msg_text);

	  if (chd_stat(TRUE,FALSE) == 260) {
	    chd_line = get_chd_line(TRUE);
	    sscanf(chd_line,
		"Load Vol %s Slot %d Drive %d Den %d Unit %d Device %s",
		volume,&slot,&deviceNumber,&den,&unit,deviceName);
/*
	    sprintf(msg_text,
		"Vol %s Slot %d Drive %d Den %d Unit %d Device %s",
		volume,slot,deviceNumber,den,unit,deviceName);
	    XmTextInsert(chd_stat_text,
		XmTextGetLastPosition(chd_stat_text),msg_text);
	    if (data.verbose)
		fprintf(tattle,"%s",msg_text);
*/
	    XtFree(chd_line);

	    if (determine_device() == (int) NULL) {
		ok_enable();
		return TRUE;
		}

	    sprintf(msg_text," (%s)",deviceName);
	    XmTextInsert(chd_stat_text,
		XmTextGetLastPosition(chd_stat_text),msg_text);
	    if (data.verbose)
		fprintf(tattle,"%s\n",msg_text);

	    updateSlotItem(*(selected_items+i));

	    if (fileIsOk()) {
	      WorkProcID = data.totape ? 
		XtAppAddWorkProc(app_con,IOtoTape,NULL) :
		XtAppAddWorkProc(app_con,IOfromTape,NULL);
	      return TRUE;
	      }
	    else {
	      if (!data.totape) {
	        system("xalert -C XCram10 OK 'Error opening device for reading' &");
		return TRUE;
		}
	      else {
	        system("xalert -C XCram10 OK 'Error opening device for writing;' 'proceeding to next tape' &");
/* - this caused an endless loop if first tape was not writeable
	        ok_enable();
	        updateSlotItem(*(selected_items+i));
	        return FALSE;
*/
	        WorkProcID = XtAppAddWorkProc(app_con,loader,(XtPointer) NULL);
		return TRUE;
		}
	      }
	    }
	  else {
	    chd_response(TRUE);
	    updateSlotItem(*(selected_items+i));
	    finishDrive();
	    label = XmStringCreate("Would you like to try again?",
		  XmSTRING_DEFAULT_CHARSET);
	    dialog_label = XmStringCreateLtoR("XCRAM10: Tape Load Retry Dialog",
		XmSTRING_DEFAULT_CHARSET);
	    retry_dialog = XmCreateQuestionDialog(toplevel,"retry",
			NULL,0);
	    XtVaSetValues(retry_dialog,
			XmNmessageString,		label,
			XmNdialogTitle,			dialog_label,
			NULL);
	    XtAddCallback(retry_dialog,XmNokCallback,doit,
			(XtPointer) CHD_RELOAD);
	    XtAddCallback(retry_dialog,XmNcancelCallback,ok_enable,NULL);
	    XtAddCallback(retry_dialog,XmNhelpCallback,
		(XtCallbackProc) XuHelper,(XtPointer) "Tape_Retry.help");

	    XtAddCallback(retry_dialog,XmNokCallback,
		destroy_dialog,retry_dialog);
	    XtAddCallback(retry_dialog,XmNcancelCallback,
		destroy_dialog,retry_dialog);

	    XtManageChild(retry_dialog);
	    XmStringFree(dialog_label);
	    XmStringFree(label);
	    return TRUE;
	    }
	  }
}
void unloadSlot(slot)
int slot;
{
	char *cgdate(),*cgtime();

	if (data.verbose >= 3)
	  fprintf(tattle,"*-/- unloadSlot -/-*\n");

	sprintf(msg_text," - unloading slot %d",slot);
	XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),
	  msg_text);
	XmUpdateDisplay(chd_stat_text);

	sprintf(msg_text,"%s %s - ",cgdate(),cgtime());
	if (data.verbose)
	  fprintf(tattle,"%s",msg_text);
	XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
	  msg_text);

	sprintf(msg_text,"unload slot %d",slot);
	chd_cmd(msg_text);
	XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		msg_text);
	XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		"\n");
	chd_stat(TRUE,TRUE);

}
