/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/Label.h>
#include <Xm/Separator.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <localsys.h>
#include <cu_defs.h>
#include "HelpObject.h"
#include <eventnames.h>
#include <globs.h>
#include <resources.h>
#include <help_defs.h>

extern char *optarg;
extern int optind, opterr;

int chdc_pid,dd_pid;
DriveDataInfo drive_info;
FILE *tattle = NULL;
FILE *rsh_file;
FILE *fdatain;
XtAppContext app_con;
XtWorkProcId WorkProcID;
Widget toplevel,chd_stat_text;
Widget drive_list,slot_list,selected_list;
Widget process_button,delay_button,quit_dialog;
Widget history_text1,history_text2;
Window busy_win;
Widget history_dialog;
Display *dpy;
XmString pause_label,resume_label;
char msg_text[256];

int	cartNumber 		= 0;
float   totalBytes		= 0.;
char	volume[32];
char	deviceName[1024]	= {"{none}"};
unsigned int deviceNumber	= 0;
unsigned int slot		= 0;
unsigned int den		= 0;
unsigned int unit		= 0;

/* static int	defaultRead	=	1024 * 512;  - j.m.wade 3/23/94 */
static int	defaultRead	=	1024 * 32;
static int	defaultWrite	=	1024 * 32;

int tape	= -1;
Boolean segy_skip = FALSE;
Boolean mvs_skip = TRUE;
Boolean hdr_skip = FALSE;

int datain, dataout;

char* iobuffer	= 0;
long blen	= 0L;
long bout	= 0L;
int  inputEOF	= 0;
long bgood	= 0L;	/* number of bytes with data */

ApplicationData data;

static XrmOptionDescRec options[] = {
	{"-b",		"*blockSize",	XrmoptionSepArg,	"0"},
	{"-r",		"*totape",	XrmoptionNoArg,		"FALSE"},
	{"-h",		"*help",	XrmoptionNoArg,		"TRUE"},
	{"-v",		"*verbose",	XrmoptionSepArg,	"1"},
	{"-V",		"*tattle",	XrmoptionNoArg,		"1"},
	{"-t",		"*tattle",	XrmoptionSepArg,	"1"},
	{"-g",		"*green",	XrmoptionNoArg,		"TRUE"},
	{"-mvs",	"*mvs",		XrmoptionNoArg,		"TRUE"},
	{"-host",	"*host",	XrmoptionSepArg,	""},
	{"-segy",	"*segy",	XrmoptionNoArg,		"TRUE"}};

static XtResource resources[] = {
	{ "unit", "Unit", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,unit),
	    XtRString, ""},
	{ "density", "Density", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,density),
	    XtRString, "default"},
	{ "compression", "Compression", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,compression),
	    XtRString, "default"},
	{ "bsd", "bsd", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,bsd),
	    XtRString, "default"},
	{ "byteswap", "Byteswap", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,byte_swap),
	    XtRString, "default"},
	{ "variableblock", "VariableBlock", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,variable_block),
	    XtRString, "default"},
	{ "rewind", "Rewind", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,rewind),
	    XtRString, "default"},
	{ "author", "Author", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,author),
	    XtRString, ""},
	{ "blockSize", "BlockSize", XtRInt, sizeof(int),
	    XtOffset(ApplicationDataPtr,blockSize),
	    XtRImmediate, (XtPointer) 0},
	{ "help", "Help", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,help),
	    XtRString, "FALSE"},
	{ "tattle", "Tattle", XtRShort, sizeof(short),
	    XtOffset(ApplicationDataPtr,tattle),
	    XtRString, (XtPointer) 0},
	{ "totape", "ToTape", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,totape),
	    XtRString, "TRUE"},
	{ "verbose", "Verbose", XtRShort, sizeof(short),
	    XtOffset(ApplicationDataPtr,verbose),
	    XtRImmediate, (XtPointer) 0},
	{ "green", "Green", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,green),
	    XtRString, "FALSE"},
	{ "mvs", "Mvs", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,mvs),
	    XtRString, "FALSE"},
	{ "host", "Host", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,host),
	    XtRString, ""},
	{ "segy", "Segy", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,segy),
	    XtRString, "FALSE"} };

int fileIsOk()
{
    int rsh_fd,rem_cmd();
    struct stat ss;
    char *normal_rewind_status;
    if (strlen(data.host) == 0) {
      if(stat(deviceName, &ss) < 0) {
	fprintf(stderr, "\ncram: can't stat %s.\n\n", deviceName);
	return 0;
      }
      if(!S_ISCHR(ss.st_mode)) {
	fprintf(stderr,
		"\ncram: %s is not a character special file.\n\n",
		deviceName);
	return 0;
      }
      tape = open(deviceName, data.totape ? O_WRONLY : O_RDONLY);
      if(tape < 0) {
	/* if (data.verbose) perror("fileIsOk"); */

	sprintf(msg_text, "Unable to open %s for %s - %s",
	  deviceName,data.totape ? "writing" : "reading",strerror(errno) );
	XmTextSetString(chd_stat_text,msg_text);
	XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		msg_text);
	XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		"\n");

	if (data.verbose) {
	  fprintf(tattle,"\n%s\n",msg_text);
	  }

	return 0;
        }
      else {
	sprintf(msg_text, "%s opened for %s on unit %d",
	  deviceName,data.totape ? "writing" : "reading",tape );
	XmTextSetString(chd_stat_text,msg_text);
	XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		msg_text);
	XmTextInsert(history_text1,XmTextGetLastPosition(history_text1),
		"\n");
	if (data.verbose) fprintf(tattle,"\n%s\n",msg_text);
	}
      }
    else {
      if (data.mvs && mvs_skip) {
	normal_rewind_status = drive_info.rewind;
	drive_info.rewind = "nr";
	if (determine_device() == (int)NULL) {
	  ok_enable();
	  return 0;
	  }
	}
      data.totape ? 
       sprintf(msg_text,"rsh %s dd of=%s obs=%d ibs=20b",
	data.host, deviceName, data.blockSize) :
       sprintf(msg_text,"rsh %s dd if=%s obs=20b ibs=%d",
	data.host, deviceName, data.blockSize);

      if (data.verbose) fprintf(tattle,"%s\n",msg_text);
      if ((tape = rem_cmd(msg_text,data.totape ? "w" : "r",&dd_pid)) == 0) {
	sprintf(msg_text, "Unable to open %s on %s for %s ",
	  deviceName,data.host,data.totape ? "writing" : "reading" );
	XmTextSetString(chd_stat_text,msg_text);

	if (data.verbose) {
	  fprintf(tattle,"\n%s",msg_text);
	  }
	return 0;
	}

      if (data.verbose)
	fprintf(tattle,"remote data transfer is via pid %d\n",dd_pid);

      if (data.mvs && mvs_skip) {
	drive_info.rewind = normal_rewind_status;
	if (determine_device() == (int)NULL) {
	  ok_enable();
	  return 0;
	  }
	}
      }
    return 1;
}
void finishDrive()
{
    if (tape >= 0) {
      if (strlen(data.host) != 0) {
	if ( data.verbose >= 1)
	  fprintf(tattle, "** Closing %s on %s\n", deviceName,data.host);
/*
	if (pclose(rsh_file) != 0)
	  perror("XCRAM10");
	if (close(tape) != 0)
	  perror("XCRAM10");
*/
	if (data.verbose)
	  fprintf(tattle,"kill %d\n",dd_pid);
	if ( kill(dd_pid,SIGTERM) != 0)
	  perror("XCRAM10");
	}
      else {
	if ( data.verbose >= 1)
	  fprintf(tattle, "** Closing %s\n", deviceName);
	}

      close(tape);
      tape = -1;
      }
}

long getInput()
{
    char *tmp_buffer;
    static int green_word = 0;
    long bytesIn;
	if(data.verbose >= 3)
	  fprintf(tattle,"*-/- getInput -/-*\n");
    if(data.totape) {
	bytesIn = fread(iobuffer, 1, data.blockSize, fdatain);

	if(bytesIn < data.blockSize) {
	    inputEOF = 1;
	    if(bytesIn < 1)
		bytesIn = 0;
	}
    } else {
	bytesIn = 0;
        if (data.mvs && mvs_skip) {
	  bytesIn = read(tape, iobuffer, 240);
	  if(data.verbose >= 1)
	    fprintf(tattle, "V: %ld in (mvs tape label header - skipped)\n",
		bytesIn);
	  if(bytesIn < 240) {
	    inputEOF = 1;
	    bytesIn = 0;
	    }
	  bytesIn = read(tape, iobuffer, data.blockSize);
	  if(data.verbose >= 2)
	    fprintf(tattle, "V: %ld in (mvs eof marker - skipped)\n", bytesIn);
	  if(bytesIn != 0) {
	    inputEOF = 1;
	    }
	  if (strlen(data.host) && !fileIsOk()) {
	    inputEOF = 1;
	    bytesIn = 0;
	    }
	  mvs_skip = FALSE;
	  }
        else if (data.segy && segy_skip) {
	  bytesIn = read(tape, iobuffer, 3200);
	  if(data.verbose >= 1)
	    fprintf(tattle, "V: %ld in (segy reel header - skipped)\n", bytesIn);
	  if(bytesIn < 3200) {
	    inputEOF = 1;
	    bytesIn = 0;
	    }
	  bytesIn = read(tape, iobuffer, 400);
	  if(data.verbose >= 2)
	    fprintf(tattle, "V: %ld in (segy reel header - skipped)\n", bytesIn);
	  if(bytesIn < 400) {
	    inputEOF = 1;
	    bytesIn = 0;
	    }
	  segy_skip = FALSE;
	  }
	else if ( hdr_skip ) {
	  if (data.green) {		/* may be other types of skips */
	    do {
	      bytesIn = read(tape, iobuffer, data.blockSize);
	      if (green_word == 0) {
	        green_word = *(int *)iobuffer;
		if (data.verbose >= 2)
	          fprintf(tattle,"skipping %d byte line header\n",green_word);
	        }
	      if ((green_word-4) < bytesIn) {
		bytesIn -= green_word+4;
		tmp_buffer = (char *) XtMalloc(bytesIn);
		memcpy(tmp_buffer,iobuffer+green_word+4,bytesIn);
		memcpy(iobuffer,tmp_buffer,bytesIn);
		XtFree(tmp_buffer);
		hdr_skip = FALSE;
		green_word = 0;
		}
	      else
		green_word -= bytesIn;
	      } while (green_word != 0);
	    }
	  }

	if (bytesIn == 0)
	  bytesIn = read(tape, iobuffer, data.blockSize);

	if(bytesIn < 1) {
	    if (errno == EIO) {
	      sprintf(msg_text,"xalert -C XCram10 OK 'XCRAM10 has received I/O error %d' 'and aborted media changer communication' ",errno);
	      system(msg_text);
	      perror("XCRAM10");
	      inputEOF = -1;
	      }
	    else
	      inputEOF = 1;
	    bytesIn = 0;
	}
    }
    return bytesIn;
}

static void usage()
{
    fprintf(stderr, "cram usage:  function                   default value\n");
    fprintf(stderr, "              -r read tape                write tape\n");
    fprintf(stderr, "              -V verbose operation            off\n");
    fprintf(stderr,"		    (sysout file of form XCRAM10.nnnnn)\n");
    fprintf(stderr, "              -b block-size                  32768\n");
    fprintf(stderr, "              -g skip header based on green word\n");
    fprintf(stderr, "              -host remote host machine      none\n");
    fprintf(stderr, "              -segy segy input data          off\n");
    fprintf(stderr,"		    (skip subsequent reel header blocks)\n");
    fprintf(stderr, "              -mvs mvs input data            off\n");
    fprintf(stderr,"		    (skip tape label blocks)\n");
    fprintf(stderr, "\n");
}

void main(argc,argv)
     int argc;
     char **argv;
{
	Window top_window;
	unsigned int screen_number;
	unsigned long mask;
	XSetWindowAttributes attr;
	XtTypeConverter menu_default();
	Arg args[15];
	int nargs;
	int pid,status,hour;
	Widget history_label1,history_label2;
	Widget menubar;
	Widget file_pulldown,file_but;
	Widget option_pulldown,option_but;
	Widget misc_pulldown,misc_but;
	Widget history_button,comment_button;
	Widget drive_button,drive_dialog,drive_frame,drive_form;
	Widget comment_label,comment_dialog,comment_text;
	Widget form1;
	Widget save_button;
	Widget mail_button,dismiss_button,pause_button,quit_button;
	Widget slot_label,selected_label;
	Widget pane;
	Widget heading_label,frame,separator,form,unit_pd,unit_options;
	Widget *delay_widgets;
	Widget top_delay_dialog,delay_dialog,date_label,time_label;
	Widget heading,ok_delay_button,cancel_delay_button,help_delay_button;
	Widget date_form,time_form,button_form;
	Widget month_text,punc,day_text,year_text,hour_text,minute_text;
	Widget drive_options,ok_drive_button;
	Widget density_pd, density_options, density;
#ifdef SUNSYSTEM
	Widget  low_density_label,
		medium_density_label, high_density_label,
		ultra_high_density_label;
	Widget bsd_pd,bsd_options,
		bsd_on_label,bsd_off_label;
#endif
#ifdef SGISYSTEM
	Widget bpi_800_density_label,
		bpi_1600_density_label, bpi_3200_density_label,
		bpi_6250_density_label, bpi_8200_density_label,
		bpi_8500_density_label;
	Widget vblk_pd,vblk_options,
		vblk_on_label,vblk_off_label;
	Widget byteswap_pd,byteswap_options,
		byteswap_on_label,byteswap_off_label;
#endif
	Widget compression_pd, compression_options;
	Widget compression_off_label,compression_on_label;
	Widget rewind_pd, rewind_options;
	Widget default_label,no_rewind_label, rewind_label;
	Widget default_child,*drive_widgets;
	Widget am_pm_pd,am_pm_option,am_but,pm_but;
	Widget help_pulldown,help_button,help_general;
	Widget host_form,host_label,host_text;
	void set_dialog_focus();
	char *help_path;
	char *cgdate(),*cgtime(),*char_buf;
	int drive;
	unsigned char rc_menu_type;
	XmString label,accel_label,colon,slash;
	static XtCallbackRec cb_struct[2];
	struct stat statbuf;
	char *tattle_file;
	char *tattle_cmd[256];
	static char	chd_status[60];
	int opt;

	int c;

	datain = dup(0); dataout = dup(1);
/*
	fdatain = (FILE *) malloc(sizeof(FILE));
	memcpy(fdatain,stdin,sizeof(FILE));
	fdatain->_file = (char) datain;
*/
	signal(SIGPIPE, SIG_IGN);	/* ignore pipe signals */

	fdatain = fdopen(datain,"r");
	if (fdatain == NULL) {
	  fprintf(stderr,"XCRAM10 Error: ");
	  fprintf(stderr,"Could not get FILE structure for input data\n");
	  exit(1);
	  }

/* I need to do this before call XtAppInitialize so that I don't initialize
   X in the child application. As a result, I need to get a couple of
   arguments the old-fashioned way.
*/
/* name should be XCram10 */

/*
	toplevel = XtAppInitialize (&app_con, "XChd", options,
			XtNumber(options), &argc, argv,
			fallback_resources, NULL, 0);
*/
	toplevel = XtAppInitialize (&app_con, "XCram10", options,
			XtNumber(options), &argc, argv,
			NULL, NULL, 0);

	XtAppSetTypeConverter(app_con,"String","MenuWidget",
		(XtTypeConverter)menu_default,NULL,0,XtCacheAll,NULL);
	XtAppSetTypeConverter(app_con,"String","Widget",
		(XtTypeConverter)menu_default,NULL,0,XtCacheAll,NULL);
	XtGetApplicationResources (toplevel, &data, resources, 
				   XtNumber(resources), NULL, 0);

	if (data.help || (argc > 1)) {
	  usage();
	  exit(1);
	  }

/*
   close the one we aren't using to prevent messages later when the pipe
   gets broken.
*/
	data.totape ? close(dataout) : close(datain);

	if (data.tattle) {
	  if (data.verbose < 1) data.verbose = 1;
	  tattle_file = (char *) malloc(24*sizeof(char));
	  if (tattle_file != NULL) {
	    sprintf(tattle_file,"XCRAM10.%06d",getpid());
	    tattle = fopen(tattle_file,"w");
	    }
	  if (tattle == NULL) tattle=stderr;
	  free(tattle_file);
	  }
	else 
	  tattle = stderr;

	setbuf(tattle,NULL);	/* setlinebuf(tattle); */

	if (data.verbose)
	  print_banner(tattle,version);

	if (data.totape && (data.mvs | data.segy)){
	  strcpy(msg_text,
	    "-segy and -mvs options are read options only; options turned off");
	  XmTextSetString(chd_stat_text,msg_text);
	  fprintf(tattle,"%s\n",msg_text);
	  data.mvs = FALSE;
	  data.segy = FALSE;
	  }

	if (strlen(data.host)) {
/*
	  sprintf(msg_text,"/home/gpsa/zjmw36/bin/sun4/mid-man -v -e telnet %s 5090",data.host);

	  sprintf(msg_text,"telnet %s 5090",data.host);
	  xs_talkto(msg_text,&chdc_pid);
*/
	  fprintf(stderr,"XCRAM10: Remote hosts function not currently ");
	  fprintf(stderr,"available\n         Process must be started ");
	  fprintf(stderr,"locally on the remote machine.\n");
	  exit(0);
	  }
	else {
/*
	  sprintf(msg_text,"/explprod/phase2/chd/chdc");
*/
	  sprintf(msg_text,"chdc");
	  xs_talkto(msg_text,&chdc_pid);
	  }

/*
	switch (data.tattle) {
	  case 0:
	    fprintf(tattle,"%s\n",msg_text);
	    xs_talkto(msg_text);
	    break;
	  case 1:
	    fprintf(tattle,"%s\n",msg_text);
	    sprintf(tattle_cmd,"/home/gpsa/zjmw36/bin/sun4/mid-man -t -e %s",
		msg_text);
	    xs_talkto(tattle_cmd);
	    break;
	  case 2:
	    fprintf(tattle,"%s\n",msg_text);
	    sprintf(tattle_cmd,"/home/gpsa/zjmw36/bin/sun4/mid-man -v -e %s",
		msg_text);
	    xs_talkto(tattle_cmd);
	  case 3:
	    fprintf(tattle,"%s\n",msg_text);
	    sprintf(tattle_cmd,"/home/gpsa/zjmw36/bin/sun4/mid-man -v -t -e %s",
		msg_text);
	    xs_talkto(tattle_cmd);
	    break;
	  }
*/

	if(data.blockSize == 0)
	    data.blockSize = data.totape ? defaultWrite : defaultRead;

	slash = XmStringCreate("/",XmSTRING_DEFAULT_CHARSET);
	colon = XmStringCreate(":",XmSTRING_DEFAULT_CHARSET);

	XtVaSetValues(toplevel,
			XmNallowShellResize,	TRUE,
			XmNmappedWhenManaged,	TRUE,
			NULL);

	form1 = XtVaCreateManagedWidget("form1",xmFormWidgetClass,toplevel,
			XmNallowOverlap,	FALSE,
			XmNresizable,		TRUE,
			XmNresizePolicy,	XmRESIZE_ANY,
			NULL);

	menubar = XmCreateMenuBar(form1,"menuBar",NULL,0);
	XtVaSetValues(menubar,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		5,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,		5,
			NULL);

	XtManageChild(menubar);

	file_pulldown = XmCreatePulldownMenu(menubar,"file_pd",NULL,0);
	file_but = XtVaCreateManagedWidget("File",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'F',
			XmNsubMenuId,		file_pulldown,
			NULL);

	label = XmStringCreate("Process",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+P",XmSTRING_DEFAULT_CHARSET);
	process_button = XtVaCreateManagedWidget("process",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'P',
			XmNaccelerator,		"Ctrl<Key>p",
			XmNacceleratorText,	accel_label,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);
	XmStringFree(accel_label);

	label = XmStringCreate("Process At",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+A",XmSTRING_DEFAULT_CHARSET);
	delay_button = XtVaCreateManagedWidget("delay",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'A',
			XmNaccelerator,		"Ctrl<Key>a",
			XmNacceleratorText,	accel_label,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);
	XmStringFree(accel_label);

	nargs = 0;
	XtSetArg(args[nargs], XmNallowShellResize, FALSE); nargs++;
	delay_dialog = XmCreateFormDialog(file_but,"delay_dialog",
		args, nargs);

	XtVaSetValues(delay_dialog,
			XmNmarginWidth,		10,
			XmNmarginHeight,	10,
			XmNborderWidth,		10,
			XmNallowShellResize,	FALSE,
			NULL);

	XtAddCallback(delay_dialog, XmNhelpCallback,
		(XtCallbackProc) XuHelper, (XtPointer) "Delay_Dialog.help");

	label = XmStringCreate("Enter Start Time for Job",
		XmSTRING_DEFAULT_CHARSET);
	heading = XtVaCreateManagedWidget("delay_label",
		xmLabelWidgetClass, delay_dialog,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, delay_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		heading,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	date_form = XtVaCreateManagedWidget("date_form",
		xmFormWidgetClass, delay_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNmarginWidth,		10,
			XmNmarginHeight,	10,
			NULL);

	label = XmStringCreate("Date:",XmSTRING_DEFAULT_CHARSET);
	date_label = XtVaCreateManagedWidget("date_label",
		xmLabelWidgetClass, date_form,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	month_text = XtVaCreateManagedWidget("delaymonth",
		xmTextWidgetClass, date_form,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		date_label,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNcolumns,		2,
			NULL);

	XtAddEventHandler(month_text,KeyPressMask,FALSE,date_motion,
		(XtPointer) 12);

	punc = XtVaCreateManagedWidget("punc",
		xmLabelWidgetClass, date_form,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		month_text,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNlabelString,		slash,
			NULL);

	day_text = XtVaCreateManagedWidget("delayday",
		xmTextWidgetClass, date_form,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		punc,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNcolumns,		2,
			NULL);

	XtAddEventHandler(day_text,KeyPressMask,FALSE,date_motion,(XtPointer)31);

	punc = XtVaCreateManagedWidget("punc",
		xmLabelWidgetClass, date_form,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		day_text,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNlabelString,		slash,
			NULL);

	year_text = XtVaCreateManagedWidget("delayyear",
		xmTextWidgetClass, date_form,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		punc,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNcolumns,		2,
			NULL);

	XtAddEventHandler(year_text,KeyPressMask,FALSE,date_motion,
		(XtPointer) 99);

	time_form = XtVaCreateManagedWidget("time_form",
		xmFormWidgetClass, delay_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		date_form,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNmarginWidth,		10,
			XmNmarginHeight,	10,
			NULL);

	label = XmStringCreate("Time:",XmSTRING_DEFAULT_CHARSET);
	time_label = XtVaCreateManagedWidget("time_label",
		xmLabelWidgetClass, time_form,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	hour_text = XtVaCreateManagedWidget("delayhour",
		xmTextWidgetClass, time_form,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		time_label,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNcolumns,		2,
			NULL);

	XtAddEventHandler(hour_text,KeyPressMask,FALSE,date_motion,(XtPointer)12);

	punc = XtVaCreateManagedWidget("punc",
		xmLabelWidgetClass, time_form,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		hour_text,
			XmNtopAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,		hour_text,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNlabelString,		colon,
			NULL);

	minute_text = XtVaCreateManagedWidget("delayminute",
		xmTextWidgetClass, time_form,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		punc,
			XmNcolumns,		2,
			XmNbottomAttachment,	XmATTACH_FORM,
			NULL);

	XtAddEventHandler(minute_text,KeyPressMask,FALSE,date_motion,(XtPointer)59);

	am_pm_pd = XmCreatePulldownMenu(time_form, 
		"am_pm_pd", NULL, 0);

	nargs = 0;
	XtSetArg(args[nargs],	XmNsubMenuId,	am_pm_pd);	nargs++;
	XtSetArg(args[nargs],	XmNmarginHeight,	0);	nargs++;
	XtSetArg(args[nargs],	XmNmarginWidth,		0);	nargs++;
	XtSetArg(args[nargs],	XmNshadowThickness,	0);	nargs++;
	XtSetArg(args[nargs],	XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); nargs++;
	XtSetArg(args[nargs],	XmNtopWidget, hour_text);	nargs++;
	XtSetArg(args[nargs],	XmNleftAttachment, XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],	XmNleftWidget,	minute_text); nargs++;
	am_pm_option = XmCreateOptionMenu(time_form,
			"am_pm_option", args, nargs);
	XtManageChild(am_pm_option);

	label= XmStringCreate("am",XmSTRING_DEFAULT_CHARSET);
	am_but  = XtVaCreateManagedWidget("am_but",
		xmPushButtonWidgetClass, am_pm_pd,
			XmNlabelString,		label,
			XmNuserData,		0,
			NULL);
	XmStringFree(label);

	label= XmStringCreate("pm",XmSTRING_DEFAULT_CHARSET);
	pm_but  = XtVaCreateManagedWidget("pm_but",
		xmPushButtonWidgetClass, am_pm_pd,
			XmNlabelString,		label,
			XmNuserData,		12,
			NULL);
	XmStringFree(label);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, delay_dialog,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		time_form,
			NULL);

	button_form = XtVaCreateManagedWidget("button_form",
		xmFormWidgetClass, delay_dialog,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNmarginWidth,		10,
			XmNmarginHeight,	10,
			NULL);

	label = XmStringCreate("OK",XmSTRING_DEFAULT_CHARSET);
	ok_delay_button = XtVaCreateManagedWidget("ok_delay",
		xmPushButtonWidgetClass, button_form,
        		XmNlabelString,		label,
        		XmNleftAttachment,	XmATTACH_POSITION,
        		XmNtopAttachment,	XmATTACH_FORM,
        		XmNleftAttachment,	XmATTACH_POSITION,
        		XmNleftPosition,	10,
        		XmNrightAttachment,	XmATTACH_POSITION,
        		XmNrightPosition,	30,
			NULL);
	XmStringFree(label);


	label = XmStringCreate("Cancel",XmSTRING_DEFAULT_CHARSET);
	cancel_delay_button = XtVaCreateManagedWidget("cancel_delay",
		xmPushButtonWidgetClass, button_form,
        		XmNlabelString,		label,
        		XmNleftAttachment,	XmATTACH_POSITION,
        		XmNtopAttachment,	XmATTACH_FORM,
        		XmNleftAttachment,	XmATTACH_POSITION,
        		XmNleftPosition,	40,
        		XmNrightAttachment,	XmATTACH_POSITION,
        		XmNrightPosition,	60,
			NULL);
	XmStringFree(label);

	label = XmStringCreate("Help",XmSTRING_DEFAULT_CHARSET);
	help_delay_button = XtVaCreateManagedWidget("help_delay",
		xmPushButtonWidgetClass, button_form,
        		XmNlabelString,		label,
        		XmNleftAttachment,	XmATTACH_POSITION,
        		XmNtopAttachment,	XmATTACH_FORM,
        		XmNleftAttachment,	XmATTACH_POSITION,
        		XmNleftPosition,	70,
        		XmNrightAttachment,	XmATTACH_POSITION,
        		XmNrightPosition,	90,
			NULL);
	XmStringFree(label);

	XtAddCallback(help_delay_button, XmNactivateCallback,
		(XtCallbackProc) XuHelper, (XtPointer) "Delay_Dialog.help");

	char_buf = cgdate();
	XmTextSetString(year_text,char_buf+6);
	*(char_buf+5) = '\0';
	XmTextSetString(day_text,char_buf+3);
	*(char_buf+2) = '\0';
	XmTextSetString(month_text,char_buf);

	char_buf = cgtime();
	*(char_buf+5) = '\0';
	XmTextSetString(minute_text,char_buf+3);

	*(char_buf+2) = '\0';
	sscanf(char_buf,"%d",&hour);
	if (hour > 11) {
	  if (hour > 12) {
	    hour-=12;
	    sprintf(char_buf,"%2d",hour);
	    }
	  XtVaSetValues(am_pm_option,
		XmNmenuHistory,		pm_but,
		NULL);
	  }

	XmTextSetString(hour_text,char_buf);

	XtAddCallback(ok_delay_button,XmNactivateCallback,
		drop_dialog,delay_dialog);
	XtAddCallback(cancel_delay_button,XmNactivateCallback,
		drop_dialog,delay_dialog);

	delay_widgets = (Widget *) XtMalloc(7*sizeof(Widget));
	*(delay_widgets+0) = month_text;
	*(delay_widgets+1) = day_text;
	*(delay_widgets+2) = year_text;
	*(delay_widgets+3) = hour_text;
	*(delay_widgets+4) = minute_text;
	*(delay_widgets+5) = am_pm_option;
	*(delay_widgets+6) = delay_dialog;
	XtAddCallback(ok_delay_button,XmNactivateCallback,
		set_delay,delay_widgets);

	label = XmStringCreate("Quit",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+Q",XmSTRING_DEFAULT_CHARSET);
	quit_button = XtVaCreateManagedWidget("quit",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'Q',
			XmNaccelerator,		"Ctrl<Key>q",
			XmNacceleratorText,	accel_label,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);
	XmStringFree(accel_label);

	option_pulldown = XmCreatePulldownMenu(menubar,"option_pd",NULL,0);
	option_but = XtVaCreateManagedWidget("Options",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'O',
			XmNsubMenuId,		option_pulldown,
			NULL);

	label = XmStringCreate("Tape Drive Characteristics",
		XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+T",XmSTRING_DEFAULT_CHARSET);
	drive_button = XtVaCreateManagedWidget("DriveOptions",
		xmPushButtonWidgetClass, option_pulldown,
			XmNmnemonic,		's',
			XmNaccelerator,		"Ctrl<Key>t",
			XmNacceleratorText,	accel_label,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);
	XmStringFree(accel_label);

	pause_label = XmStringCreate("Pause",XmSTRING_DEFAULT_CHARSET);
	resume_label = XmStringCreate("Resume",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+S",XmSTRING_DEFAULT_CHARSET);
	pause_button = XtVaCreateManagedWidget("pause",
		xmPushButtonWidgetClass, option_pulldown,
			XmNmnemonic,		's',
			XmNaccelerator,		"Ctrl<Key>s",
			XmNacceleratorText,	accel_label,
        		XmNlabelString,		pause_label,
			NULL);
	XmStringFree(accel_label);

	XtAddCallback(pause_button,XmNactivateCallback,
		mypause,NULL);

	XuSet_Help(pause_button,"Opt_Dsc.help");

	misc_pulldown = XmCreatePulldownMenu(menubar,"misc_pd",NULL,0);
	misc_but = XtVaCreateManagedWidget("Misc",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'M',
			XmNsubMenuId,		misc_pulldown,
			NULL);

	label = XmStringCreate("History",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+H",XmSTRING_DEFAULT_CHARSET);
	history_button = XtVaCreateManagedWidget("history",
		xmPushButtonWidgetClass, misc_pulldown,
			XmNmnemonic,		'h',
			XmNaccelerator,		"Ctrl<Key>h",
			XmNacceleratorText,	accel_label,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);
	XmStringFree(accel_label);

	XtAddCallback(history_button, XmNhelpCallback,
		(XtCallbackProc) XuHelper, (XtPointer) "History_Dialog.help");

	nargs = 0;
	XtSetArg(args[nargs],XmNallowShellResize, TRUE); nargs++;
	XtSetArg(args[nargs],XmNautoUnmanage, FALSE); nargs++;
	history_dialog = XmCreateFormDialog(history_button,"history_dialog",
		args,nargs);

	save_button = XtVaCreateManagedWidget("save",
		xmPushButtonWidgetClass, history_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	20,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	40,
			NULL);

	dismiss_button = XtVaCreateManagedWidget("dismiss",
		xmPushButtonWidgetClass, history_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	60,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	80,
			NULL);

	pane = XtVaCreateManagedWidget("pane",
		xmPanedWindowWidgetClass, history_dialog,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,     XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget, 	dismiss_button,
			NULL);

	form = XtVaCreateManagedWidget("form",
		xmFormWidgetClass, pane,
			NULL);

	label = XmStringCreateLtoR(
		"Brief Tape Mount History",
		XmSTRING_DEFAULT_CHARSET);
	history_label1 = XtVaCreateManagedWidget("hist_label1",
		xmLabelWidgetClass, form,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],XmNtopWidget,	history_label1); nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNrightAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNbottomAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNautoShowCursorPosition,	TRUE); nargs++;
	XtSetArg(args[nargs],XmNrows, 		10);		nargs++;
	XtSetArg(args[nargs],XmNcolumns,	90);		nargs++;
	XtSetArg(args[nargs],XmNscrollingPolicy, XmAUTOMATIC);	nargs++;
	XtSetArg(args[nargs],XmNscrollBarDisplayPolicy, XmAS_NEEDED); nargs++;
	XtSetArg(args[nargs],XmNeditable, 	FALSE); nargs++;
	XtSetArg(args[nargs],XmNeditMode, 	XmMULTI_LINE_EDIT); nargs++;
	history_text1 = XmCreateScrolledText(form,"history_text",
		args,nargs);

	XtManageChild(history_text1);

	form = XtVaCreateManagedWidget("form",
		xmFormWidgetClass, pane,
			NULL);

	label = XmStringCreateLtoR(
		"Full Changer Mechanism Dialog",
		XmSTRING_DEFAULT_CHARSET);
	history_label2 = XtVaCreateManagedWidget("hist_label2",
		xmLabelWidgetClass, form,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],XmNtopWidget, history_label2); nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNrightAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNbottomAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNautoShowCursorPosition,	TRUE); nargs++;
	XtSetArg(args[nargs],XmNrows, 		24);		nargs++;
	XtSetArg(args[nargs],XmNcolumns,	90);		nargs++;
	XtSetArg(args[nargs],XmNscrollingPolicy, XmAUTOMATIC);	nargs++;
	XtSetArg(args[nargs],XmNscrollBarDisplayPolicy, XmAS_NEEDED); nargs++;
	XtSetArg(args[nargs],XmNeditable, 	FALSE); nargs++;
	XtSetArg(args[nargs],XmNeditMode, 	XmMULTI_LINE_EDIT); nargs++;
	history_text2 = XmCreateScrolledText(form,"history_text",
		args,nargs);

	XtManageChild(history_text2);
	XtManageChild(pane);
	XtVaSetValues (history_text1, XmNautoShowCursorPosition, TRUE, NULL);
	XtVaSetValues (history_text2, XmNautoShowCursorPosition, TRUE, NULL);

	XtAddCallback(history_button,XmNactivateCallback,
		pop_dialog,history_dialog);
	XtAddCallback(dismiss_button,XmNactivateCallback,
		drop_dialog,history_dialog);
	XtAddCallback(save_button,XmNactivateCallback,
		do_save_history,NULL);

	label = XmStringCreate("Comments",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+C",XmSTRING_DEFAULT_CHARSET);
	comment_button = XtVaCreateManagedWidget("comments",
		xmPushButtonWidgetClass, misc_pulldown,
			XmNmnemonic,		'c',
			XmNaccelerator,		"Ctrl<Key>c",
			XmNacceleratorText,	accel_label,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);
	XmStringFree(accel_label);

	nargs = 0;
	XtSetArg(args[nargs],XmNallowShellResize, TRUE); nargs++;
	comment_dialog = XmCreateFormDialog(comment_button,"comment_dialog",
		args,nargs);

	sprintf(msg_text,"Comments will be mailed to %s",data.author);
	label = XmStringCreate(msg_text,XmSTRING_DEFAULT_CHARSET);
	comment_label = XtVaCreateManagedWidget("comment_label",
		xmLabelWidgetClass, comment_dialog,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNtopOffset,		5,
			XmNbottomAttachment,	XmATTACH_NONE,
/*
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	comment_text,
*/
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	mail_button = XtVaCreateManagedWidget("mail",
		xmPushButtonWidgetClass, comment_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
/*
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		comment_text,
*/
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	20,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	40,
			NULL);

	dismiss_button = XtVaCreateManagedWidget("cancel",
		xmPushButtonWidgetClass, comment_dialog,
			XmNtopAttachment,	XmATTACH_NONE,
/*
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		comment_text,
*/
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	60,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	80,
			NULL);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET);  nargs++;
	XtSetArg(args[nargs],XmNtopWidget,	comment_label);    nargs++;
	XtSetArg(args[nargs],XmNtopOffset,		5);	   nargs++;
	XtSetArg(args[nargs],XmNbottomAttachment, XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],XmNbottomWidget,	mail_button);    nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNrightAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNrows, 		24);		nargs++;
	XtSetArg(args[nargs],XmNcolumns,	80);		nargs++;
	XtSetArg(args[nargs],XmNscrollingPolicy, XmAUTOMATIC);	nargs++;
	XtSetArg(args[nargs],XmNscrollBarDisplayPolicy, XmAS_NEEDED); nargs++;
	XtSetArg(args[nargs],XmNeditable, 	TRUE);		nargs++;
	XtSetArg(args[nargs],XmNeditMode, 	XmMULTI_LINE_EDIT); nargs++;
	comment_text = XmCreateScrolledText(comment_dialog,"comment_text",
		args,nargs);

	XtManageChild(comment_text);

/*
	XtVaSetValues(comment_text,
			NULL);
	XtManageChild(comment_text);
*/

	XtAddCallback(comment_button,XmNactivateCallback,
		pop_dialog,comment_dialog);
	XtAddCallback(comment_button,XmNactivateCallback,
		set_dialog_focus,comment_text);
	XtAddCallback(mail_button,XmNactivateCallback,
		comments,comment_text);
	XtAddCallback(dismiss_button,XmNactivateCallback,
		drop_dialog,comment_dialog);

	XuSet_Help(menubar,"MenuB_Dsc.help");
	XuCreateHelpPulldown(menubar);
	XuSet_Help_Shell(toplevel);
	help_path = getenv("XCRAM10_HELPDIR");
	if (help_path == (char *)NULL) help_path = ".";
	XuSet_Help_Path(help_path);
	XuSet_Help_Index(help_items,(sizeof(help_items)/sizeof(char *))/2);
	XuSet_Help_Version(version);

        frame = XtVaCreateManagedWidget("frame",
		xmFrameWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		menubar,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	label = XmStringCreateLtoR(
		data.totape ? "Write Data to Exabyte Tape(s)" :
			 "Read Data from Exabyte Tape(s)",
		XmSTRING_DEFAULT_CHARSET);

        heading_label = XtVaCreateManagedWidget("heading_label",
		xmLabelWidgetClass, frame,
			XmNalignment,		XmALIGNMENT_CENTER,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	if (strlen(data.host)) {
          separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		frame,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

          frame = XtVaCreateManagedWidget("frame",
		xmFrameWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	  form = XtVaCreateManagedWidget("host_form",
		xmFormWidgetClass, frame,
			XmNallowOverlap,	FALSE,
			XmNresizable,		FALSE,
			NULL);

	  label = XmStringCreateLtoR("Host Machine: ",
		XmSTRING_DEFAULT_CHARSET);
 	  host_label = XtVaCreateManagedWidget("drive_form",
		xmLabelWidgetClass, form,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNleftAttachment,	XmATTACH_FORM,
        		XmNlabelString,		label,
			NULL);
	  XmStringFree(label);
 	  host_text = XtVaCreateManagedWidget("host_text",
		xmTextWidgetClass, form,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		host_label,
        		XmNcolumns,		strlen(data.host),
        		XmNvalue,		data.host,
        		XmNeditable,		FALSE,
			NULL);
	  }

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		frame,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

        frame = XtVaCreateManagedWidget("frame",
		xmFrameWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	form = XtVaCreateManagedWidget("drive_form",
		xmFormWidgetClass, frame,
			XmNallowOverlap,	FALSE,
			XmNresizable,		FALSE,
			NULL);

	XuSet_Help(form,"Unit_Dsc.help");

	unit_pd = XmCreatePulldownMenu(form, 
		"unit_pd", NULL, 0);

	label = XmStringCreateLtoR("Drive Unit: ",
		XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs],	XmNsubMenuId,	unit_pd);	nargs++;
	XtSetArg(args[nargs],	XmNlabelString,	label);		nargs++;
	XtSetArg(args[nargs],	XmNmarginHeight,	0);	nargs++;
	XtSetArg(args[nargs],	XmNmarginWidth,		0);	nargs++;
	XtSetArg(args[nargs],	XmNtopAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],	XmNleftAttachment, XmATTACH_FORM); nargs++;
/*
	XtSetArg(args[nargs],	XmNbottomAttachment, XmATTACH_FORM); nargs++;
*/
	XtSetArg(args[nargs],	XmNbottomAttachment, XmATTACH_NONE); nargs++;
	unit_options = XmCreateOptionMenu(form,
			"unit_options", args, nargs);
	XmStringFree(label);

	XtManageChild(unit_options);

	nargs = 0;
	XtSetArg(args[nargs],XmNallowShellResize, TRUE); nargs++;
	XtSetArg(args[nargs],XmNautoUnmanage, FALSE); nargs++;
	XtSetArg(args[nargs],XmNborderWidth, 5); nargs++;
	XtSetArg(args[nargs],XmNleftOffset, 5); nargs++;
	XtSetArg(args[nargs],XmNrightOffset, 5); nargs++;
	drive_dialog = XmCreateFormDialog(drive_button,"drive_dialog",
		args,nargs);

        drive_frame = XtVaCreateManagedWidget("frame",
		xmFrameWidgetClass, drive_dialog,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	drive_form = XtVaCreateManagedWidget("drive_form",
		xmFormWidgetClass, drive_frame,
			XmNallowOverlap,	FALSE,
			XmNresizable,		FALSE,
			NULL);

	XuSet_Help(drive_form,"Drive_Opts.help");

	label = XmStringCreateLtoR("Tape Drive Options",
		XmSTRING_DEFAULT_CHARSET);
	default_label = XtVaCreateManagedWidget("heading",
		xmLabelWidgetClass, drive_form, 
			XmNtopAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_NONE,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, drive_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		default_label,
			XmNtopOffset,		5,
			XmNbottomAttachment,	XmATTACH_NONE,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);
	XtManageChild(separator);

	density_pd = XmCreatePulldownMenu(drive_form, 
		"density_pd", NULL, 0);

	label = XmStringCreateLtoR("Density:", XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs],	XmNsubMenuId, density_pd);	nargs++;
	XtSetArg(args[nargs],	XmNlabelString,	label);		nargs++;
	XtSetArg(args[nargs],	XmNmarginHeight,	0);	nargs++;
	XtSetArg(args[nargs],	XmNmarginWidth,		0);	nargs++;
	XtSetArg(args[nargs],	XmNtopAttachment, XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],	XmNtopWidget, separator);	nargs++;
	XtSetArg(args[nargs],	XmNtopOffset,		5);	nargs++;
	XtSetArg(args[nargs],	XmNbottomAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNleftAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNrightAttachment, XmATTACH_FORM); nargs++;
	density_options = XmCreateOptionMenu(drive_form,
			"density_options", args, nargs);
	XmStringFree(label);

#ifdef SUNSYSTEM
	label = XmStringCreateLtoR("Default",XmSTRING_DEFAULT_CHARSET);
	default_label = XtVaCreateManagedWidget("default",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		DEFAULT_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(default_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

	label = XmStringCreateLtoR("Low",
		XmSTRING_DEFAULT_CHARSET);
	low_density_label = XtVaCreateManagedWidget("low",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		LOW_DENSITY,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(low_density_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

	label = XmStringCreateLtoR("Medium",
		XmSTRING_DEFAULT_CHARSET);
	medium_density_label = XtVaCreateManagedWidget("medium",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		MEDIUM_DENSITY,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(medium_density_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

	label = XmStringCreateLtoR("High",
		XmSTRING_DEFAULT_CHARSET);
	high_density_label = XtVaCreateManagedWidget("high",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		HIGH_DENSITY,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(high_density_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

	label = XmStringCreateLtoR("Ultra",XmSTRING_DEFAULT_CHARSET);
	ultra_high_density_label = XtVaCreateManagedWidget("ultra",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		ULTRA_HIGH_DENSITY,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(ultra_high_density_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);
#endif

#ifdef SGISYSTEM
	label = XmStringCreateLtoR("Default",XmSTRING_DEFAULT_CHARSET);
	default_label = XtVaCreateManagedWidget("default",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		DEFAULT_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(default_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

	label = XmStringCreateLtoR("800",XmSTRING_DEFAULT_CHARSET);
	bpi_800_density_label = XtVaCreateManagedWidget("800",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		BPI_800_DENSITY,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(bpi_800_density_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

	label = XmStringCreateLtoR("1600",XmSTRING_DEFAULT_CHARSET);
	bpi_1600_density_label = XtVaCreateManagedWidget("1600",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		BPI_1600_DENSITY,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(bpi_1600_density_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

	label = XmStringCreateLtoR("3200",XmSTRING_DEFAULT_CHARSET);
	bpi_3200_density_label = XtVaCreateManagedWidget("3200",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		BPI_3200_DENSITY,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(bpi_3200_density_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

	label = XmStringCreateLtoR("6250",XmSTRING_DEFAULT_CHARSET);
	bpi_6250_density_label = XtVaCreateManagedWidget("6250",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		BPI_6250_DENSITY,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(bpi_6250_density_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

	label = XmStringCreateLtoR("8200",XmSTRING_DEFAULT_CHARSET);
	bpi_8200_density_label = XtVaCreateManagedWidget("8200",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		BPI_8200_DENSITY,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(bpi_8200_density_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

	label = XmStringCreateLtoR("8500",XmSTRING_DEFAULT_CHARSET);
	bpi_8500_density_label = XtVaCreateManagedWidget("8500",
		xmPushButtonWidgetClass, density_pd, 
			XmNlabelString,		label,
			XmNuserData,		BPI_8500_DENSITY,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(bpi_8500_density_label, XmNactivateCallback,
		save_drive_options, DENSITY_OPTION);

#endif

	default_child = XtNameToWidget(density_pd,data.density);
	if ((default_child != NULL) && XtIsWidget(default_child)) {
	  XtVaSetValues(density_options,
		XmNmenuHistory,	default_child,
		NULL);
	  }

	XtManageChild(density_options);
	{
	int button;
	XtVaGetValues(density_options,
		XmNbuttonSet,	&button,
		NULL);
	}

	compression_pd = XmCreatePulldownMenu(drive_form, 
		"compression_pd", NULL, 0);

	label = XmStringCreateLtoR("Compression:", XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs],	XmNsubMenuId, compression_pd);	nargs++;
	XtSetArg(args[nargs],	XmNlabelString,	label);		nargs++;
	XtSetArg(args[nargs],	XmNmarginHeight,	0);	nargs++;
	XtSetArg(args[nargs],	XmNmarginWidth,		0);	nargs++;
	XtSetArg(args[nargs],	XmNtopAttachment, XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],	XmNtopWidget,	density_options); nargs++;
	XtSetArg(args[nargs],	XmNbottomAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNleftAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNrightAttachment, XmATTACH_FORM); nargs++;
	compression_options = XmCreateOptionMenu(drive_form,
			"compression_options", args, nargs);
	XmStringFree(label);

	label = XmStringCreateLtoR("Default",XmSTRING_DEFAULT_CHARSET);
	default_label = XtVaCreateManagedWidget("default",
		xmPushButtonWidgetClass, compression_pd, 
			XmNlabelString,		label,
			XmNuserData,		DEFAULT_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(default_label, XmNactivateCallback,
		save_drive_options, (XtPointer) COMPRESSION_OPTION);

	label = XmStringCreateLtoR("On",XmSTRING_DEFAULT_CHARSET);
	compression_on_label = XtVaCreateManagedWidget("on",
		xmPushButtonWidgetClass, compression_pd, 
			XmNlabelString,		label,
			XmNuserData,		ON_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(compression_on_label, XmNactivateCallback,
		save_drive_options, (XtPointer) COMPRESSION_OPTION);

	label = XmStringCreateLtoR("Off",XmSTRING_DEFAULT_CHARSET);
	compression_off_label = XtVaCreateManagedWidget("off",
		xmPushButtonWidgetClass, compression_pd, 
			XmNlabelString,		label,
			XmNuserData,		OFF_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(compression_off_label, XmNactivateCallback,
		save_drive_options, (XtPointer) COMPRESSION_OPTION);

	XtManageChild(compression_options);

	default_child = XtNameToWidget(compression_pd,data.compression);
	if ((default_child != NULL) && XtIsWidget(default_child)) {
	  XtVaSetValues(compression_options,
		XmNmenuHistory,	default_child,
		NULL);
	  }

#ifdef SUNSYSTEM
	bsd_pd = XmCreatePulldownMenu(drive_form, "bsd_pd", NULL, 0);

	label = XmStringCreateLtoR("BSD behavior:", XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs],	XmNsubMenuId, bsd_pd);		nargs++;
	XtSetArg(args[nargs],	XmNlabelString,	label);		nargs++;
	XtSetArg(args[nargs],	XmNmarginHeight,	0);	nargs++;
	XtSetArg(args[nargs],	XmNmarginWidth,		0);	nargs++;
	XtSetArg(args[nargs],	XmNtopAttachment, XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],	XmNtopWidget, compression_options); nargs++;
	XtSetArg(args[nargs],	XmNbottomAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNleftAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNrightAttachment, XmATTACH_FORM); nargs++;
	bsd_options = XmCreateOptionMenu(drive_form,"bsd_options", args, nargs);
	XmStringFree(label);

	label = XmStringCreateLtoR("Default", XmSTRING_DEFAULT_CHARSET);
	default_label = XtVaCreateManagedWidget("default",
		xmPushButtonWidgetClass, bsd_pd, 
			XmNlabelString,		label,
			XmNuserData,		DEFAULT_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(default_label, XmNactivateCallback,
		save_drive_options, (XtPointer) BSD_OPTION);

	label = XmStringCreateLtoR("On", XmSTRING_DEFAULT_CHARSET);
	bsd_on_label = XtVaCreateManagedWidget("on",
		xmPushButtonWidgetClass, bsd_pd, 
			XmNlabelString,		label,
			XmNuserData,		ON_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(bsd_on_label, XmNactivateCallback,
		save_drive_options, (XtPointer) BSD_OPTION);

	label = XmStringCreateLtoR("Off", XmSTRING_DEFAULT_CHARSET);
	bsd_off_label = XtVaCreateManagedWidget("off",
		xmPushButtonWidgetClass, bsd_pd, 
			XmNlabelString,		label,
			XmNuserData,		OFF_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(bsd_off_label, XmNactivateCallback,
		save_drive_options, (XtPointer) BSD_OPTION);

	XtManageChild(bsd_options);

	default_child = XtNameToWidget(bsd_pd,data.bsd);
	if ((default_child != NULL) && XtIsWidget(default_child)) {
	  XtVaSetValues(bsd_options,
		XmNmenuHistory,	default_child,
		NULL);
	  }
#endif
#ifdef SGISYSTEM
	vblk_pd = XmCreatePulldownMenu(drive_form, "vblk_pd", NULL, 0);

	label = XmStringCreateLtoR("Variable Blocksize:", XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs],	XmNsubMenuId, vblk_pd);		nargs++;
	XtSetArg(args[nargs],	XmNlabelString,	label);		nargs++;
	XtSetArg(args[nargs],	XmNmarginHeight,	0);	nargs++;
	XtSetArg(args[nargs],	XmNmarginWidth,		0);	nargs++;
	XtSetArg(args[nargs],	XmNtopAttachment, XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],	XmNtopWidget, compression_options);	nargs++;
	XtSetArg(args[nargs],	XmNbottomAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNleftAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNrightAttachment, XmATTACH_FORM); nargs++;
	vblk_options = XmCreateOptionMenu(drive_form,"vblk_options", args, nargs);
	XmStringFree(label);

	label = XmStringCreateLtoR("Default", XmSTRING_DEFAULT_CHARSET);
	default_label = XtVaCreateManagedWidget("default",
		xmPushButtonWidgetClass, vblk_pd, 
			XmNlabelString,		label,
			XmNuserData,		DEFAULT_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(default_label, XmNactivateCallback,
		save_drive_options, (XtPointer) VARIABLE_BLOCKSIZE_OPTION);

	label = XmStringCreateLtoR("On", XmSTRING_DEFAULT_CHARSET);
	vblk_on_label = XtVaCreateManagedWidget("on",
		xmPushButtonWidgetClass, vblk_pd, 
			XmNlabelString,		label,
			XmNuserData,		ON_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(vblk_on_label, XmNactivateCallback,
		save_drive_options, (XtPointer) VARIABLE_BLOCKSIZE_OPTION);

	label = XmStringCreateLtoR("Off", XmSTRING_DEFAULT_CHARSET);
	vblk_off_label = XtVaCreateManagedWidget("off",
		xmPushButtonWidgetClass, vblk_pd, 
			XmNlabelString,		label,
			XmNuserData,		OFF_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(vblk_off_label, XmNactivateCallback,
		save_drive_options, (XtPointer) VARIABLE_BLOCKSIZE_OPTION);

	XtManageChild(vblk_options);

	default_child = XtNameToWidget(vblk_pd,data.variable_block);
	if ((default_child != NULL) && XtIsWidget(default_child)) {
	  XtVaSetValues(vblk_options,
		XmNmenuHistory,	default_child,
		NULL);
	  }

	byteswap_pd = XmCreatePulldownMenu(drive_form, "byteswap_pd", NULL, 0);

	label = XmStringCreateLtoR("Byte swapping:", XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs],	XmNsubMenuId, byteswap_pd);	nargs++;
	XtSetArg(args[nargs],	XmNlabelString,	label);		nargs++;
	XtSetArg(args[nargs],	XmNmarginHeight,	0);	nargs++;
	XtSetArg(args[nargs],	XmNmarginWidth,		0);	nargs++;
	XtSetArg(args[nargs],	XmNleftAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNrightAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],	XmNbottomAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNtopAttachment, XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],	XmNtopWidget, vblk_options);	nargs++;
	byteswap_options = XmCreateOptionMenu(drive_form,"byteswap_options", args, nargs);
	XmStringFree(label);

	label = XmStringCreateLtoR("Default", XmSTRING_DEFAULT_CHARSET);
	default_label = XtVaCreateManagedWidget("default",
		xmPushButtonWidgetClass, byteswap_pd, 
			XmNlabelString,		label,
			XmNuserData,		DEFAULT_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(default_label, XmNactivateCallback,
		save_drive_options, (XtPointer) BYTE_SWAP_OPTION);

	label = XmStringCreateLtoR("On", XmSTRING_DEFAULT_CHARSET);
	byteswap_on_label = XtVaCreateManagedWidget("on",
		xmPushButtonWidgetClass, byteswap_pd, 
			XmNlabelString,		label,
			XmNuserData,		ON_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(byteswap_on_label, XmNactivateCallback,
		save_drive_options, (XtPointer) BYTE_SWAP_OPTION);

	label = XmStringCreateLtoR("Off", XmSTRING_DEFAULT_CHARSET);
	byteswap_off_label = XtVaCreateManagedWidget("off",
		xmPushButtonWidgetClass, byteswap_pd, 
			XmNlabelString,		label,
			XmNuserData,		OFF_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(byteswap_off_label, XmNactivateCallback,
		save_drive_options, (XtPointer) BYTE_SWAP_OPTION);

	XtManageChild(byteswap_options);

	default_child = XtNameToWidget(byteswap_pd,data.byte_swap);
	if ((default_child != NULL) && XtIsWidget(default_child)) {
	  XtVaSetValues(byteswap_options,
		XmNmenuHistory,	default_child,
		NULL);
	  }
#endif

	label = XmStringCreateLtoR("Rewind:", XmSTRING_DEFAULT_CHARSET);

	rewind_pd = XmCreatePulldownMenu(drive_form, 
		"rewind_pd", NULL, 0);

	nargs = 0;
	XtSetArg(args[nargs],	XmNsubMenuId, rewind_pd);	nargs++;
	XtSetArg(args[nargs],	XmNlabelString,	label);		nargs++;
	XtSetArg(args[nargs],	XmNmarginHeight,	0);	nargs++;
	XtSetArg(args[nargs],	XmNmarginWidth,		0);	nargs++;
	XtSetArg(args[nargs],	XmNleftAttachment, XmATTACH_NONE); nargs++;
	XtSetArg(args[nargs],	XmNrightAttachment, XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],	XmNtopAttachment, XmATTACH_WIDGET); nargs++;
#ifdef SUNSYSTEM
	XtSetArg(args[nargs],	XmNtopWidget,	 bsd_options); nargs++;
#endif
#ifdef SGISYSTEM
	XtSetArg(args[nargs],	XmNtopWidget,	 byteswap_options); nargs++;
#endif
	XtSetArg(args[nargs],	XmNbottomAttachment, XmATTACH_NONE); nargs++;
	rewind_options = XmCreateOptionMenu(drive_form,
			"rewind_options", args, nargs);
	XmStringFree(label);

	label = XmStringCreateLtoR("Default",
		XmSTRING_DEFAULT_CHARSET);
	default_label = XtVaCreateManagedWidget("default",
		xmPushButtonWidgetClass, rewind_pd, 
			XmNlabelString,		label,
			XmNuserData,		DEFAULT_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(default_label, XmNactivateCallback,
		save_drive_options, (XtPointer) REWIND_OPTION);

	label = XmStringCreateLtoR("On",
		XmSTRING_DEFAULT_CHARSET);
	rewind_label = XtVaCreateManagedWidget("on",
		xmPushButtonWidgetClass, rewind_pd, 
			XmNlabelString,		label,
			XmNuserData,		ON_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(rewind_label, XmNactivateCallback,
		save_drive_options, (XtPointer) REWIND_OPTION);

	label = XmStringCreateLtoR("Off",
		XmSTRING_DEFAULT_CHARSET);
	no_rewind_label = XtVaCreateManagedWidget("off",
		xmPushButtonWidgetClass, rewind_pd, 
			XmNlabelString,		label,
			XmNuserData,		OFF_OPTION,
			XmNsensitive,		TRUE,
			NULL);
	XmStringFree(label);
	XtAddCallback(no_rewind_label, XmNactivateCallback,
		save_drive_options, (XtPointer) REWIND_OPTION);
	XtManageChild(rewind_options);

	default_child = XtNameToWidget(rewind_pd,data.rewind);
	if ((default_child != NULL) && XtIsWidget(default_child)) {
	  XtVaSetValues(rewind_options,
		XmNmenuHistory,	default_child,
		NULL);
	  }
        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, drive_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		rewind_options,
			XmNtopOffset,		5,
			XmNbottomAttachment,	XmATTACH_NONE,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);
	XtManageChild(separator);

	dismiss_button = XtVaCreateManagedWidget("dismiss",
		xmPushButtonWidgetClass, drive_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNtopOffset,		5,
			XmNbottomOffset,	5,
			XmNbottomAttachment,	XmATTACH_NONE,
/*
        		XmNleftAttachment,	XmATTACH_FORM,
        		XmNrightAttachment,	XmATTACH_FORM,
*/
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	10,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	45,
			NULL);
	XtManageChild(dismiss_button);

	help_button = XtVaCreateManagedWidget("help",
		xmPushButtonWidgetClass, drive_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNtopOffset,		5,
			XmNbottomOffset,	5,
			XmNbottomAttachment,	XmATTACH_NONE,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	55,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	90,
			NULL);
	XtManageChild(help_button);

	XtAddCallback(help_button, XmNactivateCallback,
		(XtCallbackProc) XuHelper, (XtPointer) "Drive_Opts.help");

	XuSet_Help(drive_button,"Drive_Opts.help");

	XtAddCallback(drive_button,XmNactivateCallback,pop_dialog,drive_dialog);

	XtAddCallback(dismiss_button,XmNactivateCallback,
		drop_dialog,drive_dialog);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		frame,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

        frame = XtVaCreateManagedWidget("frame",
		xmFrameWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	form = XtVaCreateManagedWidget("slot_form",
		xmFormWidgetClass, frame,
			XmNallowOverlap,	FALSE,
			XmNresizable,		TRUE,
			XmNresizePolicy,	XmRESIZE_ANY,
			NULL);

	label = XmStringCreateLtoR(
		" Slot    Unit    Arg    Den    Phys    Stat      Volume",
		XmSTRING_DEFAULT_CHARSET);

        slot_label = XtVaCreateManagedWidget("slot_label",
		xmLabelWidgetClass, form,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		label,
			NULL);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],XmNtopWidget,	slot_label);	nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNrightAttachment,XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNborderWidth,		0);	nargs++;
	XtSetArg(args[nargs],XmNvisibleItemCount,	10);	nargs++;
	slot_list = XmCreateScrolledList(form,"slot_list", args, nargs);
	XuSet_Help(slot_list,"SlotList_Dsc.help");

	XtAddCallback(slot_list,XmNdefaultActionCallback,make_selection,NULL);
	XtManageChild(slot_list);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		frame,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

        frame = XtVaCreateManagedWidget("frame",
		xmFrameWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	form = XtVaCreateManagedWidget("selected_form",
		xmFormWidgetClass, frame,
			XmNallowOverlap,	FALSE,
			XmNresizable,		TRUE,
			XmNresizePolicy,	XmRESIZE_ANY,
			NULL);

        selected_label = XtVaCreateManagedWidget("selected_label",
		xmLabelWidgetClass, form,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNtopWidget,		form,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
        		XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	nargs = 0;
	XtSetArg(args[nargs],XmNtopAttachment,	XmATTACH_WIDGET); nargs++;
	XtSetArg(args[nargs],XmNtopWidget,	selected_label); nargs++;
	XtSetArg(args[nargs],XmNleftAttachment,	XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNrightAttachment,XmATTACH_FORM); nargs++;
	XtSetArg(args[nargs],XmNborderWidth,		0);	nargs++;
	XtSetArg(args[nargs],XmNvisibleItemCount,	10);	nargs++;
	selected_list = XmCreateScrolledList(form,"selected_list", args, nargs);
	XuSet_Help(selected_list,"SelectedList_Dsc.help");

	XtManageChild(selected_list);

	XtAddCallback(selected_list,XmNdefaultActionCallback,
		delete_selection,NULL);

	XtAddCallback(process_button,XmNactivateCallback,doit,
		(XtPointer) CHD_INITIAL_LOAD);
	XtAddCallback(process_button,XmNactivateCallback,
	  disable_button,process_button);
	XtAddCallback(process_button,XmNactivateCallback,
	  disable_button,delay_button);

	XtAddCallback(delay_button,XmNactivateCallback,pop_dialog,
		delay_dialog);
	XtAddCallback(ok_delay_button,XmNactivateCallback,
	  disable_button,process_button);
	XtAddCallback(ok_delay_button,XmNactivateCallback,
	  disable_button,delay_button);

	nargs = 0;
	label = XmStringCreate("Confirm Exit",XmSTRING_DEFAULT_CHARSET);
	XtSetArg(args[nargs],XmNmessageString,	label);		nargs++;
	quit_dialog = XmCreateQuestionDialog(file_but,"confirm",
		args, nargs);
	XmStringFree(label);

	XtAddCallback(quit_dialog,XmNokCallback,quit,NULL);
	XtAddCallback(quit_dialog,XmNcancelCallback,resume,NULL);
	XtUnmanageChild(XmMessageBoxGetChild(quit_dialog,
		XmDIALOG_HELP_BUTTON));

	XtAddCallback(quit_button,XmNactivateCallback,
		confirm_quit,quit_dialog);

        separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		frame,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	chd_stat_text = XtVaCreateManagedWidget("chd_status",
		xmTextWidgetClass, form1,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator,
			XmNtopOffset,		5,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNbottomOffset,	5,
			XmNeditable,		TRUE,
/*
			XmNeditMode,		XmMULTI_LINE_EDIT,
			XmNwordWrap,		TRUE,
			XmNresizeHeight,	FALSE,
*/
			XmNeditMode,		XmSINGLE_LINE_EDIT,
			XmNcolumns,		80,
			XmNresizeWidth,		TRUE,
			NULL);
	XtAddCallback(chd_stat_text, XmNactivateCallback, send_to_chd, "");
/* 
 this will handle output from the media-changer that we weren't expecting

	XtAppAddInput(app_con,0,XtInputReadMask,extra_stuff,chd_stat_text);
*/

/*	get the status from chdc's startup; this actually catches any
	child failure, but chdc is our only child thus far.
*/

/*
	if ((pid = wait3(&status,WNOHANG,NULL)) != 0) {
*/
	if ((pid = waitpid(-1,&status,WNOHANG)) != 0) {
	  fprintf(tattle,"child process id %d exited with status %d\n",
		pid,status);
	  fprintf(stderr,"media changer has apparently failed\n");
	  exit(1);
	  }

	if (chd_stat(TRUE,TRUE) != 210) {
	  strcpy(msg_text,"ERROR - Unable to start media changer");
	  XmTextSetString(chd_stat_text,msg_text);
	  if (data.verbose) fprintf(tattle,msg_text);
	  }

/*	put the appropriate unit numbers in the option menu */

	list_units(unit_pd);

	default_child = XtNameToWidget(unit_pd,data.unit);
	if ((default_child != NULL) && XtIsWidget(default_child)) {
	  XtVaSetValues(unit_options,
		XmNmenuHistory,	default_child,
		NULL);
	  }

	/* Make the widgets appear on the screen. */

	XtRealizeWidget(toplevel);

	dpy = XtDisplay(toplevel);
	top_window = XtWindow(toplevel);
	screen_number = DefaultScreen(dpy);

/* Define a busy window to be managed when processing is taking place */

     /* Ignore device events while the busy cursor is displayed. */

	mask = CWDontPropagate | CWCursor;
	attr.do_not_propagate_mask =  (KeyPressMask | KeyReleaseMask |
		ButtonPressMask | ButtonReleaseMask | PointerMotionMask);
	attr.cursor = XCreateFontCursor(dpy, XC_watch);

	busy_win = XCreateWindow(dpy, top_window, 0, 0,
		DisplayWidth(dpy,screen_number),
		DisplayHeight(dpy,screen_number),
		(unsigned int) 0, CopyFromParent, InputOnly,
		CopyFromParent, mask, &attr);

/*
	delete_atom = XmInternAtom( dpy,"WM_DELETE_WINDOW",False);
	if ( delete_atom != (Atom) None ) {
	  XmAddWMProtocols(toplevel,&delete_atom, 1);
          XmAddWMProtocolCallback(toplevel, delete_atom, wm_exit,
		(XtPointer) quit);
	  }
*/

	XtVaGetValues(unit_options,
		XmNmenuHistory,	&default_child,
		NULL);

	if ((default_child != NULL) && XtIsObject(default_child)) {
	  XtCallCallbacks(default_child,XmNactivateCallback, NULL);
	  }

	XtVaGetValues(density_options,
		XmNmenuHistory,	&default_child,
		NULL);
	{
	int button;
	XtVaGetValues(density_options,
		XmNbuttonSet,	&button,
		NULL);
	}

	if ((default_child != NULL) && XtIsObject(default_child)) {
	  XtVaGetValues(default_child,
		XmNuserData,	&drive_info.density,
		NULL);
	  }

	XtVaGetValues(compression_options,
		XmNmenuHistory,	&default_child,
		NULL);

	if ((default_child != NULL) && XtIsObject(default_child))
	  XtVaGetValues(default_child,
		XmNuserData,	&drive_info.compression,
		NULL);

	XtVaGetValues(rewind_options,
		XmNmenuHistory,	&default_child,
		NULL);

	if ((default_child != NULL) && XtIsObject(default_child))
	  XtVaGetValues(default_child,
		XmNuserData,	&drive_info.rewind,
		NULL);

#ifdef SUNSYSTEM
	XtVaGetValues(bsd_options,
		XmNmenuHistory,	&default_child,
		NULL);

	if ((default_child != NULL) && XtIsObject(default_child))
	  XtVaGetValues(default_child,
		XmNuserData,	&drive_info.bsd,
		NULL);
#endif
#ifdef SGISYSTEM
	XtVaGetValues(vblk_options,
		XmNmenuHistory,	&default_child,
		NULL);

	if ((default_child != NULL) && XtIsObject(default_child))
	  XtVaGetValues(default_child,
		XmNuserData,	&drive_info.variable_block,
		NULL);

	XtVaGetValues(byteswap_options,
		XmNmenuHistory,	&default_child,
		NULL);

	if ((default_child != NULL) && XtIsObject(default_child))
	  XtVaGetValues(default_child,
		XmNuserData,	&drive_info.byte_swap,
		NULL);
#endif

	XmStringFree(slash); XmStringFree(colon); 

	/* Wait for i/o and dispatch. */

	XtAppMainLoop(app_con);
}
void mypause(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
	if(data.verbose >= 3)
	  fprintf(tattle,"*-/- mypause -/-*\n");

	if (WorkProcID != (XtWorkProcId)NULL) {
	  XtRemoveWorkProc(WorkProcID);
/* - thought this would alleviate the pause->quit problem, but it hoses resume
	  WorkProcID = NULL;
*/
 	  XtVaSetValues(widget,
		XmNlabelString,		resume_label,
		NULL);
	  XtManageChild(widget);
	  XtRemoveCallback(widget,XmNactivateCallback,mypause,client_data);
	  XtAddCallback(widget,XmNactivateCallback,resume,client_data);
	  }
	else
	  XmTextSetString(chd_stat_text,"Nothing to pause");
}
void resume(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
	if(data.verbose >= 3)
	  fprintf(tattle,"*-/- resume -/-*\n");

	if (WorkProcID != (XtWorkProcId) NULL) {
	  WorkProcID = data.totape ? 
	    XtAppAddWorkProc(app_con,IOtoTape,NULL) :
	    XtAppAddWorkProc(app_con,IOfromTape,NULL);
 	  XtVaSetValues(widget,
		XmNlabelString,		pause_label,
		NULL);
	  XtManageChild(widget);
	  XtRemoveCallback(widget,XmNactivateCallback,resume,client_data);
	  XtAddCallback(widget,XmNactivateCallback,mypause,client_data);
	  }
}

void disable_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
	XtVaSetValues((Widget) client_data,
		XmNsensitive,	FALSE,
		NULL);
}
void doit(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
	if(data.verbose >= 3)
	  fprintf(tattle,"*-/- doit -/-*\n");

	WorkProcID = XtAppAddWorkProc(app_con,loader,client_data);
}
void ok_enable(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
	if(data.verbose >= 3) {
	  fprintf(tattle,"*-/- ok_enable -/-*\n");
	  fprintf(tattle,"delay_button = 0x%08x (%s)\n",delay_button,XtName(delay_button));
	  fprintf(tattle,"process_button = 0x%08x (%s)\n",process_button,XtName(process_button));
	  }

	XtVaSetValues((Widget) delay_button,
		XmNsensitive,	TRUE,
		NULL);
	XtVaSetValues((Widget) process_button,
		XmNsensitive,	TRUE,
		NULL);
}
void list_slots(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
	char *selection;
	int drive,unit;
	XtPointer drive_unit;
	int slot = 1;
	int chd_status;
	char identifier[32],stat[32];
	int arg,den,phys;
	char list_item[80];
	XmString item;
	int list_pos = 1;
	int nbytes;
	char *chd_line;

	if(data.verbose >= 3)
	  fprintf(tattle,"*-/- list_slots -/-*\n");

	XmListDeleteAllItems(slot_list);

	XtVaGetValues(widget,
		XmNuserData, &drive_unit,
		NULL);

	if(data.verbose >= 2)
	   fprintf(tattle,"drive_unit = %d\n",drive_unit);

	sprintf(msg_text,"query drive %d",drive_unit);
	chd_cmd(msg_text);

	if (chd_stat(FALSE,FALSE) != 282) {
	  chd_response(FALSE);
	  XmTextSetString(chd_stat_text,
		"Specified unit not found");
	  }
	else {
	 chd_line = get_chd_line(FALSE);
	 sscanf(chd_line,
	    " Drive %d Unit %d Arg %d Den %d Phys %d Stat %s Vol %s",
	    &drive,&drive_unit,&arg,&den,&phys,stat,deviceName);
	 XtFree(chd_line);

	 chd_cmd("query all");

	 do {
	   if ((chd_status = chd_stat(FALSE,FALSE)) < 400) {
	    chd_line = get_chd_line(FALSE);
	    sscanf(chd_line,"%s",identifier);
	    if (strcmp(identifier,"Slot") == 0) {
	      sscanf(chd_line+strlen(identifier),
		"%d Unit %d Arg %d Den %d Phys %d Stat %s Vol %s",
		&slot,&unit,&arg,&den,&phys,stat,volume);
	      if (unit == (int)drive_unit) {
	        sprintf(list_item,
		  " %2d      %2d      %2d      %d      %d      %-8s  %-16s",
		  slot,unit,arg,den,phys,stat,volume);
	        item = XmStringCreateLtoR(&list_item[0],XmSTRING_DEFAULT_CHARSET);
/*
	        if(data.verbose >= 2)
	          fprintf(tattle,"%s\n",list_item);
*/
	        XmListAddItem(slot_list,item,list_pos);
	        XmStringFree(item);
	        list_pos++;
	        }
	      }
	    XtFree(chd_line);
	    }
	   else
	     chd_response(FALSE);

	   } while (chd_status != 285);
	 }
}

void delete_selection(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
	XmListDeletePos(widget,
	  ((XmListCallbackStruct *)call_data)->item_position);
}

void make_selection(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
	char *selection;
	int slot;
	if(data.verbose >= 3)
	  fprintf(tattle,"*-/- make_selection -/-*\n");
	XmListAddItemUnselected(selected_list,
		((XmListCallbackStruct *)call_data)->item,0);
	XmListDeselectPos(widget,
	  ((XmListCallbackStruct *)call_data)->item_position);
}
void extra_stuff(w, fid, id)
Widget w;
int *fid;
XtInputId *id;
{
	char buf[BUFSIZ];
	int nbytes, i;

	if(data.verbose >= 3)
	  fprintf(tattle,"*-/- extra_stuff -/-*\n");

	nbytes = read(*fid, buf, BUFSIZ);

	if(data.verbose >= 2)
	  fprintf(tattle,"fd = %d; nbytes = %d\n",*fid,nbytes);

	if (nbytes && buf[0] != '\n') {
	  buf[nbytes] = '\0';
	  XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),
		buf);
	  if(data.verbose >= 2)
	    fprintf(tattle,"extra_stuff: %s\n",buf);
	  }
}

void updateSlotItem(list_xmstring)
XmString list_xmstring;
{
	int slot;
	int chd_status,unit,arg,den,phys;
	char **list_item;
	char stat[32];
	XmString item;
	char *chd_line;
	int j,list_slot;
	XmStringTable list_items;
	int num_list_items;

	list_item = (char **) XtMalloc(sizeof(char *));

	if(data.verbose >= 3)
	  fprintf(tattle,"*-/- updateSlotItem -/-*\n");

	if ( XmStringGetLtoR(list_xmstring,
	    XmSTRING_DEFAULT_CHARSET, list_item) ) {
	    sscanf(*list_item,"%d",&slot);
	
	  sprintf(msg_text,"query slot %d",slot);
	  chd_cmd(msg_text);

	  if (chd_stat(FALSE,FALSE) == 281) {
	    chd_line = get_chd_line(FALSE);
	    if (sscanf(chd_line,
		" Slot %d Unit %d Arg %d Den %d Phys %d Stat %s Vol %s",
		&slot,&unit,&arg,&den,&phys,stat,volume) != 7) {
	      if(data.verbose >= 2)
	        fprintf(tattle,"flushing stdin\n");
	      chd_response(FALSE);
	      }
	    else {
	      sprintf(*list_item,
		" %2d      %2d      %2d      %d      %d      %-8s  %-16s",
		slot,unit,arg,den,phys,stat,volume);
	      item = XmStringCreateLtoR(*list_item,XmSTRING_DEFAULT_CHARSET);
	      if (data.verbose)
	        fprintf(tattle,
		  " Slot %d Unit %d Arg %d Den %d Phys %d Stat %s Vol %s\n",
		  slot,unit,arg,den,phys,stat,volume);

/* I actually fetch the XmString list for each widget and find the
   appropriate slot to replace. Apparantly, Motif copies the original
   strings so the addresses may be incorrect in one or the other.
*/

	      XtVaGetValues(slot_list,
		XmNitems, &list_items,
		XmNitemCount, &num_list_items,
		NULL);

	      for (j=0; j<num_list_items; j++) {
		if ( XmStringGetLtoR(*(list_items+j),
			XmSTRING_DEFAULT_CHARSET, list_item) ) {
		  sscanf(*list_item,"%d",&list_slot);
		  if (list_slot == slot)
		    XmListReplaceItems(slot_list,list_items+j,1,&item);
		  }
		}

	      XtVaGetValues(selected_list,
		XmNitems, &list_items,
		XmNitemCount, &num_list_items,
		NULL);

	      for (j=0; j<num_list_items; j++) {
		if ( XmStringGetLtoR(*(list_items+j),
			XmSTRING_DEFAULT_CHARSET, list_item) ) {
		  sscanf(*list_item,"%d",&list_slot);
		  if (list_slot == slot)
		    XmListReplaceItems(selected_list,list_items+j,1,&item);
		  }
		}
/*
	      XmListReplaceItems(slot_list,&list_xmstring,1,&item);
	      XmListReplaceItems(selected_list,&list_xmstring,1,&item);
*/
	      XmStringFree(item);
	      }
	    }
	  else
	    chd_response(FALSE);
	  XtFree(*list_item);
	  }
}
XtTypeConverter menu_default(display,args,arg_count,from,to,data)
Display *display;
XrmValue *args,*from,*to;
XtPointer *data;
{
	to->addr = (XtPointer) XtMalloc (sizeof(Widget));
	*(Widget *)to->addr = XtNameToWidget(toplevel,(char *)from->addr);
	fprintf(stderr,"menu_default: name = %s, widget = %08x\n",
		(char *)from->addr,*(Widget *)to->addr);
	return((XtTypeConverter)TRUE);
}
void set_dialog_focus(widget,client_data,call_data)
Widget widget;		/* unused */
Widget client_data;
XtPointer call_data;	/* unused */
{
	XmProcessTraversal((Widget)client_data,XmTRAVERSE_CURRENT);
}
