/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	write a series of cartridges to stdout
*/
#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/MessageB.h>
#include "HelpObject.h"
#include "globs.h"

/*
**	IO() returns 0 until it's finished, at which time it
**	returns 1.
*/
Boolean IOfromTape()
{
	int bout;

	if (data.verbose >= 3)
	  fprintf(tattle,"*-/- IOfromTape -/-*\n");

	bgood = getInput();
	if(bgood <= 0) {
	  sprintf(msg_text,"%.0f total bytes read",totalBytes);
	  XmTextSetString(chd_stat_text,msg_text);
	  if (data.verbose) 
	    fprintf(tattle,"\n%s\n",msg_text);
	  finishDrive();
	  if (inputEOF > 0)
	    WorkProcID = XtAppAddWorkProc(app_con,loader,NULL);
	  else {
	    WorkProcID = NULL;
	    close(stdin);
	    }
	  return TRUE;
	  }

	(void) signal(SIGPIPE, SIG_IGN);
	bout = write(dataout, iobuffer, bgood);

	if ( bout < bgood ) {
	  sprintf(msg_text," unable to write output");
	    if ( data.verbose )
	      fprintf(tattle,"\nIOfromTape:%s\n",msg_text);
	  finishDrive();
	  XmTextSetString(chd_stat_text,msg_text);
	  WorkProcID = XtAppAddWorkProc(app_con,loader,(XtPointer)EOF);
	  return TRUE;
	  }

	(void) signal(SIGPIPE, SIG_DFL); 
	totalBytes += bout;

	sprintf(msg_text,"%d (%.0f total) bytes read",bout,totalBytes);
	XmTextSetString(chd_stat_text,msg_text);

	if (data.verbose >= 2) 
	  fprintf(tattle,"\n%s",msg_text);

	XmUpdateDisplay(chd_stat_text);
	return FALSE;
}
