C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE DIstance SORT traces, record-by-record
C
C**********************************************************************C
C
C xorder reads each seismic record, sorts the trace ordering according
C to either ascending or descending order, then outputs the record
C
C SUBROUTINE CALLS: RTAPE, HLH, SAVE, SORT
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
 
      integer itr ( SZLNHD )
      integer itr0 ( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , lbytes, nbytes, luout
      integer     argis
      integer     idist(2*SZLNHD),indx(2*SZLNHD),jndx(2*SZLNHD)
      integer     istat(2*SZLNHD)
c      real        dmin, dmax

      integer     array
      pointer     (wkarry, array(1))

      CHARACTER   NAME * 6, ntap * 255, otap * 255
      
#include <f77/pid.h>
      logical verbos,reverse,heap,back,query
 
      DATA NAME     /'XORDER'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      data verbos/.true./, back/.false./

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
          call help()
          stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     read command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,reverse,verbos)

C**********************************************************************C
C     get logical data units, get header values, update line header
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'xorder: no header read on unit ',luin
         write(LERR,*)'ntap =  ',ntap
         write(LERR,*)'FATAL'
         stop
      endif

      CALL HLHprt    ( ITR , LBYTES, NAME, 6,         LERR)

c------
c     save certain parameters

#include <f77/saveh.h>
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('PrTrNm',ifmt_PrTrNm,l_PrTrNm,ln_PrTrNm,TRACEHEADER)

      if(nsamp .gt. SZLNHD) nsamp=SZLNHD

      call savhlh( itr, lbytes, lbyout)

      call wrtape(luout,itr,lbyout)

C**********************************************************************C
C     print out key header values
C**********************************************************************C
       write(LERR,*)
       write(LERR,*)' Values read from input data set line header'
       write(LERR,*)
       write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Output traces/rec  =  ', ntr
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform
        if(reverse) then
            write(LERR,*)' Restore original trace order'
        else
            write(LERR,*)' Order trace in ascending offset'
        endif
c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.


      items    = ntrc * (ITRWRD + nsamp)

      write(LERR,*)'items= ',items
      call galloc (wkarry, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

      items = items * SZSMPD
      call vclr (array, 1, ntrc*nsamp)

c---------------------------------------------------
 

C**********************************************************************C
C
C     read record, sort on distances, limit distances, then output
C
C**********************************************************************C
 
      itemt = ITRWRD + nsamp
      
      DO  JJ = 1, NREC

           il = 0
           id = 0

           DO  KK = 1, NTRC

              nbytes=0
              CALL RTAPE  ( LUIN , itr, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istatic , TRACEHEADER)

               if (reverse)
     1         call saver2(itr,ifmt_PrTrNm,l_PrTrNm, ln_PrTrNm,
     2                     istat(kk), TRACEHEADER)

c---------------------------
c  put traces into array
c  put dead trcs into array


              IF (istatic .ne. 30000) THEN

                 il = il + 1
                 call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       irec      , TRACEHEADER)

                 if (reverse) then
                    call saver2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                          idist(il) , TRACEHEADER)
                 else
                    call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          idist(il) , TRACEHEADER)
                    indx (il) = il
                 endif

                 istrc = (il - 1) * itemt

                 do    i = 1, itemt
                    array (istrc+i) = itr(i)
                 enddo

                 if (.not. reverse) istat (kk) = 1

              ELSE

                 if (.not. reverse) istat (kk) = 0

              ENDIF


          ENDDO

          nlive = il

c------------------
c sort on distances
c of live traces

          call sort (idist, jndx, nlive, back)

          ic = 0

          IF (reverse) THEN

             DO  KK = 1, ntrc
 
c------------------------------------------------------------
c  put traces into output vector in ascending distance order
c  and output within range of distances
 
c                if (istat(kk) .eq. 1) then
                 if (kk .le. nlive) then

                    ic = ic + 1
                    istrc = (jndx(ic)-1) * itemt
 
                    do  i = 1, itemt
                        itr(i) = array (istrc+i)
                    enddo
                    itrc = indx (jndx(kk))
                    call savew2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                          itrc  , TRACEHEADER)
                    call wrtape (luout, itr, nbytes)

                 else

                    call savew2(itr0,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec  , TRACEHEADER)
                    call savew2(itr0,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          kk    , TRACEHEADER)
                    call wrtape (luout, itr0, nbytes)

                 endif
 
c---------------------------------------------------------------
 
             ENDDO

          ELSE

             DO  KK = 1, nlive

c------------------------------------------------------------
c  put traces into output vector in ascending distance order
c  and output within range of distances

                    ic = ic + 1
                    istrc = (jndx(kk)-1) * itemt

                    do  i = 1, itemt
                        itr(i) = array (istrc+i)
                    enddo
                    itrc = indx (jndx(kk))
                    ist  = istat (kk)
                    call savew2(itr,ifmt_PrTrNm,l_PrTrNm, ln_PrTrNm,
     1                          ist   , TRACEHEADER)
                    call savew2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                          itrc  , TRACEHEADER)
                    call wrtape (luout, itr, nbytes)
 
c---------------------------------------------------------------

             ENDDO

             IF (ic .lt. ntrc) THEN
                do  kk = ic+1, ntrc
                    call savew2(itr0,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec  , TRACEHEADER)
                    call savew2(itr0,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          kk    , TRACEHEADER)
                    ist  = istat (kk)
                    call savew2(itr0,ifmt_PrTrNm,l_PrTrNm, ln_PrTrNm,
     1                          ist   , TRACEHEADER)
                    call savew2(itr0,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          30000 , TRACEHEADER)
                    call wrtape (luout, itr0, nbytes)
                enddo
             ENDIF

          ENDIF


      ENDDO

  999 continue
       call lbclos(luin)
       call lbclos(luout)
      END

      subroutine sort(ix, key, no, back)
c-----
c     This provides a sort of items
c     x(i) is the array to be sorted
c     key(i) is the pointer array
c     no is the number of points to be sorted
c     After the sort x(i) will be ordered from least to
c           greatest
c     key(1) will point to the position in the original array
c     with the least value
c-----
      dimension ix(1),key(1)
      dimension iy(20000), ley(20000)
      logical   back

      do 1 i=1,no
    1 key(i)=i
      mo=no
    2 if(mo-15)21,21,23
   21 if(mo-1)29,29,22
   22 mo=2*(mo/4)+1
      goto 24
   23 mo=2*(mo/8)+1
   24 ko=no-mo
      jo=1
   25 i=jo
   26 if(ix(i)-ix(i+mo))28,28,27
   27 temp=ix(i)
      ix(i)=ix(i+mo)
      ix(i+mo)=temp
      kemp=key(i)
      key(i)=key(i+mo)
      key(i+mo)=kemp
      i=i-mo
      if(i-1)28,26,26
   28 jo=jo+1
      if(jo-ko)25,25,2
   29 continue

      if (back) then
         do 100 j = 1, no
            iy (no-j+1) = ix(j)
            ley(no-j+1) = key(j)
100      continue
         do 101 j = 1, no
            ix(j) = iy(j)
            key(j) = ley(j)
101      continue
         return
      else
         return
      endif

      end

c------------------
c  online help

      subroutine help
#include <f77/iounit.h>

      
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for xorder: sort traces'
        write(LER,*)'       record-by-record according to ascending'
        write(LER,*)'       trace distances, or unsort to original'
        write(LER,*)'       trace order'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-R         -- restore original trace order'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' xorder -N[] -O[] [ -R -V ]'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,reverse,verbos)
c-----
c     get command arguments
c
c     ntap  - C*255  input file name
c     otap  - C*255  output file name
c     ntr   - I      output traces/rec
c    dmin   - R      min distance to stack
c    dmax   - R      max distance to stack
c  offfar   - R      near offset for spread model
c     dx    - R      group interval
c    ndx    - I      Number groups
c    pass   - L      pass range of distances
c   nopad   - L      do not pad output records
c   split   - L      split spread
c   model   - L      model spread
c   reverse - L      reverse order of distances
c    verbos - L      verbose output or not
c-----
      
#include <f77/iounit.h>
      integer    argis
      logical    verbos, reverse
      character  ntap*(*), otap*(*)

         call argstr('-N',ntap,' ',' ') 
         call argstr('-O',otap,' ',' ') 
c         call argr4('-dmax',dmax, 99999., 99999.)
c         call argr4('-dmin',dmin,-99999.,-99999.)
         reverse = (argis('-R') .gt. 0)
         verbos  = (argis('-V') .gt. 0)

      return
      end

      subroutine reorder (inout, jndx, n)

#include <f77/lhdrsz.h>

      integer    inout(*), jndx(*)
      integer    itmp(SZLNHD)

      do  1  i = 1, n

          itmp(i) = inout( jndx(i) )
1     continue

      do  2  i = 1, n

          inout(i) = itmp(i)
2     continue

      return
      end
