/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  mouse event handling.

  Written by Douglas Horn.
*/
#include <stdlib.h>
#include "Panel.h"
#include "ikp_globalE.h"

extern void pipe_dialog(int);
extern void manage_dialog(int);
extern void set_current_module(int);

/*
  This function handles all
  pushed mouse button events.
*/
void button_pushEH(Widget w,
		   XtPointer client_data,
		   XEvent *event)
{
  int x,y,module_number;

  x=event->xbutton.x;
  y=event->xbutton.y-(MODULE_HEIGHT/2);

				/* Compute with module have been selected. */
  module_number=(int)(y/(MODULE_HEIGHT*3));

  if (x<(WIDTH/2)-MODULE_WIDTH) {
    set_current_module(module_number);
  } else {
				/* Compute if a pipe is being changed or a
				   module is being editted. */
    if (y>((MODULE_HEIGHT*3*(module_number+1))-MODULE_HEIGHT))
      pipe_dialog(module_number);
    else 
      manage_dialog(module_number);
  }
  draw_modules();
}



/*
  This function handles all
  released mouse button events.
*/
void button_releaseEH(Widget w,
		      XtPointer client_data,
		      XEvent *event)
{
}



/*
  This function handles all
  mouse movement events.
*/
void moving_mouseEH(Widget w,
		    XtPointer client_data,
		    XEvent *event)
{
}

