/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <X11/Intrinsic.h>
#include "XmAll.h"
#include "XmCreateVa.h"
#include "Xgoodies.h"	/* CBl */
#include "std.h"


extern CB_PROTO( showWatchCB )
extern CB_PROTO( hideWatchCB )


Widget OkCancelHelpButtons( Widget parent, Widget topWidget,
				XtCallbackProc OkCB, XtCallbackProc CancelCB,
				XtCallbackProc HelpCB )
{
	Widget		form, button;

	/* form is used so that it can be attached with offsets (margins) to
	parent form thereby allowing inherent buttons to maintain constant
	height via top only attachment.
	*/
	form = XmCreateFormVa( parent, "OkCancelHelpform",
				XmNtopAttachment, XmATTACH_WIDGET,
				XmNtopWidget, topWidget,
				XmNtopOffset, 5,
				XmNleftAttachment, XmATTACH_FORM,
				XmNrightAttachment, XmATTACH_FORM,
				XmNbottomAttachment, XmATTACH_FORM,
				XmNbottomOffset, 5,
				(String)NULL );

	if( OkCB )
	{
		button = XmCreatePushButtonVa( form, "OK",
				XmNleftAttachment, XmATTACH_POSITION,
				XmNleftPosition, 5,
				XmNrightAttachment, XmATTACH_POSITION,
				XmNrightPosition, 20,
				XmNtopAttachment, XmATTACH_WIDGET,
				XmNtopWidget, topWidget,
				XmNtopOffset, 5,
				XmNactivateCallback,
					CBlist( showWatchCB, NULL,
						OkCB, NULL,
						hideWatchCB, NULL,
						NULL ),
				(String)NULL );

		XmAddTabGroup( button );
	}

	if( CancelCB )
	{
		button = XmCreatePushButtonVa( form, "Cancel",
				XmNleftAttachment, XmATTACH_POSITION,
				XmNleftPosition, 42,
				XmNrightAttachment, XmATTACH_POSITION,
				XmNrightPosition, 57,
				XmNtopAttachment, XmATTACH_WIDGET,
				XmNtopWidget, topWidget,
				XmNtopOffset, 5,
				XmNactivateCallback, CBl( CancelCB, NULL ),
				(String)NULL );

		XmAddTabGroup( button );
	}

	if( HelpCB )
	{
		button = XmCreatePushButtonVa( form, "Help",
				XmNleftAttachment, XmATTACH_POSITION,
				XmNleftPosition, 80,
				XmNrightAttachment, XmATTACH_POSITION,
				XmNrightPosition, 95,
				XmNtopAttachment, XmATTACH_WIDGET,
				XmNtopWidget, topWidget,
				XmNtopOffset, 5,
				XmNactivateCallback, CBl( HelpCB, NULL ),
				(String)NULL );

		XmAddTabGroup( button );
	}

	return form;
}
