/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions
  for converting agm picks to xsd
  picks.
*/


#include <sys/types.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <pwd.h>
#include "xdisplayP.h"
#include "prototyping.h"

typedef struct {		/* Structure to store picks for agm. */
  float x;
  float y;
  float z;
} Tuple, *Tupleptr; 

typedef struct {		/* Units for agm (i.e. feet, meters, etc... */
  char *x;
  char *y;
  char *z;
} Units;


				/* Function to convert agm picks 
				   to xsd picks */
void convert_to_picks(long id, char *filename)
{
  extern int agm_to_picks( char*, Tuple***, unsigned**, unsigned*, char**, Units* );
  Tuple **curves;		/* Stores the agm segments. */
  int *nptspercurve;		/* The number of points per segment. */
  int ncurves,n,m,n1;
  char *modelname=NULL;
  Units units;		/* Units from agm (i.e. feet,meters, etc... */

				/* Call Bob Mars function to read segments. */
  if (agm_to_picks(filename,&curves,(unsigned**)&nptspercurve,(unsigned*)&ncurves,&modelname,&units)!=0) {
    error_message("Cannot read pick file.");
    return;
  } 

				/* Take agm pick and store them in to
				   xsd internal pick format. */
	for (n=0; n<ncurves; n++) {
		n1=next_picks();
		picks[n1].id=id;
		picks[n1].color=xdisplay[id].pick_color;
		if( picks[n1].color>end_pick_color || picks[n1].color<start_pick_color )
			picks[n1].color=start_pick_color;
		picks[n1].record=(int *)malloc(nptspercurve[n]*sizeof(int));
		picks[n1].trace=(int *)malloc(nptspercurve[n]*sizeof(int));
		picks[n1].sample=(int *)malloc(nptspercurve[n]*sizeof(int));
		picks[n1].size=nptspercurve[n];
		for (m=0; m<nptspercurve[n]; m++) {
			picks[n1].record[m] = (curves[n][m].y - xdisplay[id].axis_offset[0])
				/ xdisplay[id].axis_units[0] +0.5;
			if( picks[n1].record[m] == 0 )
				picks[n1].record[m] = 1;
			picks[n1].trace[m] = (curves[n][m].x - xdisplay[id].axis_offset[1])
				/ xdisplay[id].axis_units[1] +0.5;
			picks[n1].sample[m] = (curves[n][m].z - xdisplay[id].axis_offset[2])
				/ xdisplay[id].axis_units[2] +0.5;
		}
	}

				/* Free agm segment space. */
	if(curves){
		int i;
		for(i=0; i<ncurves; i++ )
			free(curves[i] );
		free(curves);
		curves=NULL;
	}
	if(nptspercurve)
	{
		free(nptspercurve);
		nptspercurve=NULL;
	}

	return; 
}
