/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifdef SUN
#include "agm_datatypes.h"
#endif
#ifdef I_AM_A_CRAY
#include "agm_da_types.h"
#endif


/****** AGM tables ******/

typedef struct {					/* MDMODMISC */
   String	userid;
   String	ownername;
   String	expirydate;
   String	description;
} Mdmodmisc, *Mdmodmiscptr;

typedef struct {					/* MDMODWRLD */
   Units	units;
   Factors	factors;
   Extents	extents;
} Mdmodwrld, *Mdmodwrldptr;

typedef struct {					/* MDMODLOC */
   Location	location;
   float	zoffset;
   float	azimuth;
   float	latitude;
   float	longitude;
   String	projectionsystem;
} Mdmodloc, *Mdmodlocptr;

typedef struct {					/* MDVERMISC */
   Id		parent;
   String	creationdate;
   String	creationtime;
   String	lastupdate;
   String	lastuptime;
   String	description;
} Mdvermisc, *Mdvermiscptr;

typedef struct {					/* MDLINEAGE */
   String	history;
} Mdlineage, *Mdlineageptr;

typedef struct {					/* MDCOLMISC */
   Id		parent;
   Type		type;
   String	description;
} Mdcolmisc, *Mdcolmiscptr;

typedef struct {					/* MDATBCOMP */
   Id		componentid;
   float	component;
} Mdatbcomp, *Mdatbcompptr;


/************************** Model Tree ADT's ***********************/


/*********** Generic ***********/

typedef struct genericptrlist {				/* Generic Ptr List */
   void                    *genericptr;
   struct genericptrlist   *next;
} Genericptrlist, *Genericptrlistptr;

typedef struct idlist {					/* Id List */
   Id				id;
   struct idlist		*next;
} Idlist, *Idlistptr;

/*********** Specific ***********/

typedef struct componentlist {				/* MDATBCOMP */
   Id				id;
   float			component;
   struct componentlist		*next;
} Componentlist, *Componentlistptr;

typedef struct locationlist {				/* MDATBLOC */
   Id				id;
   Location			location;
   struct locationlist		*next;
} Locationlist, *Locationlistptr;

typedef struct collectionlist {				/* Collections */
   Id				id;
   Mdcolmiscptr			mdcolmiscptr;
   Idlistptr			segmentidlistptr;
   Idlistptr			attributeidlistptr;
   struct collectionlist	*next;
} Collectionlist, *Collectionlistptr; 

typedef struct attributeset {
   unsigned int			nelements;
   float			*elements;
} Attributeset, *Attributesetptr;

typedef struct attributelist {				/* Attribute Pool */
   Id				id; 
   String			abbreviation;
   Locationlistptr		locationlistptr;
   Componentlistptr		componentlistptr;
   Attributesetptr		attributesetptr;
   struct attributelist		*next;
} Attributelist, *Attributelistptr;
 
typedef Attributelistptr	*Attributehashtable;  /* array of ptrs */

typedef struct segmentlist {				/* Segment Pool */
   Id				id;
   Id				maxpointid;  /* points need not be ordered */
   Tupleptr			pointlistptr;
   struct segmentlist		*next; 
} Segmentlist, *Segmentlistptr;

typedef Segmentlistptr		*Segmenthashtable;  /* array of ptrs */

typedef struct attributemisc {				/* Attribute Misc. */
   String			abbreviation;
   Unit				unit;
   Factor			factor;
   String			description;
   struct attributemisc		*next;
} Attributemisc, *Attributemiscptr;

typedef struct versionlist {				/* Version */
   Version			version;
   Mdvermiscptr			mdvermiscptr;
   Mdlineageptr			mdlineageptr;
   Collectionlistptr		collectionlistptr;
   Collectionlistptr		end_collectionlistptr;
   struct versionlist		*next;
} Versionlist, *Versionlistptr;

typedef struct {					/* Model Information */
   Mdmodmiscptr			mdmodmiscptr;
   Mdmodwrldptr			mdmodwrldptr;
   Mdmodlocptr			mdmodlocptr;
} Modelinfo, *Modelinfoptr;

typedef struct modellist {				/* Root */
   String			modelname;
   Modelinfoptr			modelinfoptr;
   Versionlistptr		versionlistptr;
   Attributemiscptr		attributemiscptr;
   Segmenthashtable		segmentpool;
   Attributehashtable		attributepool;
   struct modellist		*next;
} Modellist, *Modellistptr;
