/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "xdisplayP.h"
#include "prototyping.h"

extern int join_segment;	/* Indicates the segments are being joined. */

static CB_PROTO( grid_attr_allCB )
static CB_PROTO( grid_attr_parametersCB )

static Widget grid_x=NULL;
static Widget grid_y=NULL;
Widget attr_toggle[2];

/*
  This function copies the attributes
  of one window to another window.
*/
void copy_attributes(int image_count, long id)
{
  traceH[image_count]=traceH[id];
  raster_color_red[image_count]=raster_color_red[id];
  raster_color_green[image_count]=raster_color_green[id];
  raster_color_blue[image_count]=raster_color_blue[id];

  xdisplay[image_count].parent=image_count;
  xdisplay[image_count].sort=xdisplay[id].sort;
  xdisplay[image_count].middle=xdisplay[id].middle;
  xdisplay[image_count].pick_x=xdisplay[id].pick_x;
  xdisplay[image_count].pick_y=xdisplay[id].pick_y;
  xdisplay[image_count].offset=xdisplay[id].offset;
  xdisplay[image_count].scalar=xdisplay[id].scalar;
  xdisplay[image_count].axis_flag=xdisplay[id].axis_flag;
  xdisplay[image_count].flip_flag=xdisplay[id].flip_flag;
  xdisplay[image_count].upside_flag=xdisplay[id].upside_flag;
  xdisplay[image_count].swap_flag=xdisplay[id].swap_flag;
  xdisplay[image_count].axis_units[0]=xdisplay[id].axis_units[0];
  xdisplay[image_count].axis_units[1]=xdisplay[id].axis_units[1];
  xdisplay[image_count].axis_units[2]=xdisplay[id].axis_units[2];
  xdisplay[image_count].axis_offset[0]=xdisplay[id].axis_offset[0];
  xdisplay[image_count].axis_offset[1]=xdisplay[id].axis_offset[1];
  xdisplay[image_count].axis_offset[2]=xdisplay[id].axis_offset[2];
  strcpy(xdisplay[image_count].hostname,xdisplay[id].hostname);

  nrec[image_count]=nrec[id];
  ntrace[image_count]=ntrace[id];
  nsamp[image_count]=nsamp[id];
  srec[image_count]=srec[id];
  erec[image_count]=erec[id];
  irec[image_count]=irec[id];
  strace[image_count]=strace[id];
  etrace[image_count]=etrace[id];
  itrace[image_count]=itrace[id];
  ssamp[image_count]=ssamp[id];
  esamp[image_count]=esamp[id];
  isamp[image_count]=isamp[id];
}

  

/*
  This function tries to return
  the best screen size for a 
  particular image.
*/
void screen_size(long id, int *width, int *height)
{
				/* Add 50 pixels for axis. */
  if (xdisplay[id].axis_flag) {
    *width+=75;
    *height+=75; /* DWN 04/17/98 added 25 to match change in display.c */
  }

				/* Check against the MAX_WIDTH for xsd. */
  if (*width > MAX_WIDTH) {
    *width=MAX_WIDTH;
    *height+=18;
  }

				/* Check against the MIN_WIDTH for xsd. */
  if (*width < MIN_WIDTH) {
    *width=MIN_WIDTH;
    *width+=18;
  }

				/* Check against the MAX_HEIGHT for xsd. */
  if (*height > MAX_HEIGHT-MIN_HEIGHT) {
    *height=MAX_HEIGHT-MIN_HEIGHT;
    *width+=18;
  }

  *width+=15;
  *height+=15;                          /* Patch for sizing (scrollbars). */

}



/*
  This function prompts the 
  user for a comment for the
  window.
*/
void commentCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ClientData *message;

  static Widget prompt = NULL;
  long id = (long)client_data;	/* RJM: handle 64-bit architectures */

  if( prompt != NULL )	/* RJM: added */
  {
    XtManageChild( prompt );
    return;
  }

  prompt=XmCreatePromptDialogVa(w,"Label",
				XmNdialogTitle,XMstr("Comment Window"),
				XmNtextString,XMstr(xdisplay[id].comment),
				XmNselectionLabelString,XMstr("Input Comment"),
				XmNautoUnmanage,True,	/* RJM: added */
				NULL);
  XmRemoveTabGroup(prompt);
  XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_TEXT));
  XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_HELP_BUTTON));

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=prompt;
  message->id=id;
  XtAddCallback(prompt,XmNokCallback,attach_commentCB,message);
  XtAddCallback(prompt,XmNhelpCallback,helpCB,"comment.help");
}



/*
  This function attach the comment
  to the window.
*/
void attach_commentCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct	*CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  char *label;
  long id;	/* RJM: handle 64-bit architectures */
 
  id=message->id;

				/* Get input from prompt dialog. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&label);

				/* Check if there was a value entered. */
  if (*label=='\0') {
    if( message->w )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

				/* Store the label for the window. */
  strcpy(xdisplay[id].comment,label);

				/* Update the window title. */
  window_title(buf,id);
  
  XtVaSetValues(xdisplay[id].window,
		XmNtitle,buf,
		NULL);

  if( message->w )
    XtDestroyWidget( message->w );
  free(message);
}




/*
  This function sets the mouse mode
*/
void set_modeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int value;
  long	id, temp;	/* RJM: handle 64-bit architectures */

  temp=(long)client_data;

				/* Get window id. */
  id=temp&0x0fff;

				/* Get mode value. */
  value=temp>>12;

				/* Store the mode for the window. */
  xdisplay[id].mode=value;

  set_mode_label(value,id);

  if (value==1)
    if (edit_mode!=0)
      quit_edit();

				/* Check if the mode is edit segments. */
  switch (value) {
  case 2:
  case 3:
  case 4:
  case 5:
  case 6:
  case 7:
  case 8:
  case 9:
  case 10:
  case 11:
  case 15: 
  case 16: 
  case 17: 
  case 21: 
  case 22: 
  case 23: 
  case 24: 
  case 25: 
				/* If there is another edit segment 
				   window quit it. */
    edit_picks(w,id);		/* Start edit segment mode. */
  }

				/* Refresh the window switching to 
				   zoom or odometer. */
  if ((value==0)||(value==1)) {
    expose_image(id);
  }
}


/*
  This function create a dialog
  for the window attributes.
*/
void grid_attributesCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog_form;
  Widget dialog_window;
  Widget label;
  Widget *buttons;
  Pixel m;
  long id = (long)client_data;	/* RJM: handle 64-bit architectures */
  ClientData *message;

  dialog_form=XmCreateFormDialogVa(xdisplay[id].window,"form",
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,XMstr("Window Attributes"),
				   XmNvisual,visual,
				   XmNdepth,screenDepth,
				   XtNmanageChild,False,
				   NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"window_attributes.help");
  
  dialog_window=XmCreateRowColumnVa(dialog_form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,1,
				    XmNtopAttachment,XmATTACH_FORM,
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNrightAttachment,XmATTACH_FORM,
				    NULL);
  
  
  attr_toggle[0]=XmCreateToggleButtonVa(dialog_window,"Grid on/off",
					NULL);
  XmToggleButtonSetState(attr_toggle[0],xdisplay[id].grid_flag,False);

  attr_toggle[1]=XmCreateToggleButtonVa(dialog_window,"Solid Grid Line",
					NULL);
  XmToggleButtonSetState(attr_toggle[1],xdisplay[id].solid_flag,False);
  
  dialog_window=XmCreateRowColumnVa(dialog_form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,3,
				    XmNtopAttachment,XmATTACH_WIDGET,
				    XmNtopWidget,dialog_window,
				    XmNleftAttachment,XmATTACH_FORM,
				    NULL);

  label=XmCreateLabelVa(dialog_window,"Grid x & z",
			NULL);

  sprintf(buf,"%d",xdisplay[id].grid_x);
  
  grid_x=XmCreateTextVa(dialog_window,"text",
			XmNvalue,buf,
			XmNcolumns,4,
			NULL);

  sprintf(buf,"%d",xdisplay[id].grid_y);
  
  grid_y=XmCreateTextVa(dialog_window,"text",
			XmNvalue,buf,
			XmNcolumns,4,
			NULL);
 
  label=XmCreateLabelVa(dialog_form,"Select Grid Color",
			XmNleftAttachment,XmATTACH_FORM,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,dialog_window,
			XmNtopOffset,10,
			NULL);
  
  dialog_window=XmCreateRowColumnVa(dialog_form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,6,
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,label,
				    XmNrightAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_WIDGET,
				    XmNtopWidget,label,
				    NULL);
  
  (void)XmCreatePushButtonVa(dialog_window,"  ",
		XmNarmColor,black,
		XmNbackground,white,
		XmNtopShadowColor, black,
                XmNbottomShadowColor, black,
                XmNhighlightColor, white,
                XmNselectColor, black,
		XmNactivateCallback,
			CBl( set_grid_colorCB, (XtPointer)((id<<8)|white) ),
		NULL);
 
  (void)XmCreatePushButtonVa(dialog_window,"  ",
		XmNarmColor,black,
		XmNbackground,black,
		XmNtopShadowColor, black,
                XmNbottomShadowColor, black,
                XmNhighlightColor, white,
                XmNselectColor, black,
		XmNactivateCallback,
			CBl( set_grid_colorCB, (XtPointer)((id<<8)|black) ),
		NULL);
 
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
  buttons = (Widget*)malloc( (end_pick_color-start_pick_color+1) * sizeof( Widget ) );
#endif

  for (m=start_pick_color; m<=end_pick_color; m++)
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
    buttons[m-start_pick_color] = XmCreatePushButtonVa(dialog_window,"  ",
#else
    (void)XmCreatePushButtonVa(dialog_window,"  ",
#endif
		XmNarmColor,black,
		XmNbackground,(Pixel)m,
		XmNtopShadowColor, black,
                XmNbottomShadowColor, black,
                XmNhighlightColor, white,
                XmNselectColor, black,
		XmNactivateCallback,
			CBl( set_grid_colorCB, (XtPointer)((id<<8)|m) ),
		NULL);

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  
  (void)XmCreatePushButtonVa(dialog_form,"  OK  ",
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,dialog_window,
		XmNtopOffset,20,
		XmNbottomAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_FORM,
		XmNactivateCallback,
			CBl( grid_attr_parametersCB, (XtPointer)message ),
		NULL);

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  
  (void)XmCreatePushButtonVa(dialog_form,"Set All",
		XmNtopAttachment,XmATTACH_WIDGET, 
		XmNtopWidget,dialog_window,
		XmNtopOffset,20,
		XmNbottomAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_POSITION,
		XmNleftPosition,40,
		XmNactivateCallback,
			CBl( grid_attr_allCB, (XtPointer)message ),
		NULL);
  
  (void)XmCreatePushButtonVa(dialog_form,"Cancel",
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,dialog_window,
		XmNtopOffset,20,
		XmNbottomAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		XmNactivateCallback,
			CBl( destroyCB, (XtPointer)dialog_form ),
				/* RJM: destroyCB OK since no instance dependencies */
		NULL);

  XtManageChild(dialog_form);

  XSetWindowColormap(display,XtWindow(XtParent(dialog_form)),xdisplay[id].cmap);
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
  for( m = 0; m < end_pick_color-start_pick_color+1; m++ )
	XSetWindowColormap(display,XtWindow(buttons[m]),xdisplay[id].cmap);
  free( buttons );
#endif
}


/*
  This function set the color for the grid.
*/
void set_grid_colorCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id;	/* RJM: handle 64-bit architectures */
  Pixel color;
 
  id =((long)client_data>>8);	/* RJM: handle 64-bit architectures */
  color=((long)client_data&0xff);	/* RJM: handle 64-bit architectures */

  xdisplay[id].grid_color=color;
}



/*
  This function get the attribute parameters.
*/
static CB_DECL( grid_attr_parametersCB )
{
  ClientData *message=(ClientData *)client_data;
  long id;	/* RJM: handle 64-bit architectures */
  char *str;

  id=message->id;

  xdisplay[id].grid_flag=XmToggleButtonGetState(attr_toggle[0]);
  xdisplay[id].solid_flag=XmToggleButtonGetState(attr_toggle[1]);

  XtSetArg(args[0],XmNvalue,&str);
  XtGetValues(grid_x,args,1);
  sscanf(str,"%d",&xdisplay[id].grid_x);

  XtGetValues(grid_y,args,1);
  sscanf(str,"%d",&xdisplay[id].grid_y);

  if (xdisplay[id].grid_x <=0 )
    xdisplay[id].grid_x=20;

  if (xdisplay[id].grid_y <=0 )
    xdisplay[id].grid_y=20;

  expose_image(id);

  if( message->w )
    XtDestroyWidget( message->w );
  free(message);
}



/*
  This function get the attribute parameters
  and set all the windows to those values. 
*/
static CB_DECL( grid_attr_allCB )
{
  ClientData *message=(ClientData *)client_data;
  int n;
  long id;	/* RJM: handle 64-bit architectures */
  Boolean expose_flag=False;
  char *str;

  id=message->id;

/*xdisplay[id].text_flag=XmToggleButtonGetState(attr_toggle[0]); RJM: old!

  if (xdisplay[id].axis_flag!=XmToggleButtonGetState(attr_toggle[1]))
    expose_flag=True;
  xdisplay[id].axis_flag=XmToggleButtonGetState(attr_toggle[1]);
  xdisplay[id].grid_flag=XmToggleButtonGetState(attr_toggle[2]);
  xdisplay[id].solid_flag=XmToggleButtonGetState(attr_toggle[3]);
*/
  xdisplay[id].grid_flag=XmToggleButtonGetState(attr_toggle[0]);
  xdisplay[id].solid_flag=XmToggleButtonGetState(attr_toggle[1]);

  XtSetArg(args[0],XmNvalue,&str);
  XtGetValues(grid_x,args,1);
  sscanf(str,"%d",&xdisplay[id].grid_x);

  XtGetValues(grid_y,args,1);
  sscanf(str,"%d",&xdisplay[id].grid_y);

  if (xdisplay[id].grid_x <=0 )
    xdisplay[id].grid_x=20;

  if (xdisplay[id].grid_y <=0 )
    xdisplay[id].grid_y=20;

  if ((!xdisplay[id].hide_flag)&&(expose_flag)) {
    /* If window is not hidden unmap then map. */
    XtUnmapWidget(xdisplay[id].window);
    XtMapWidget(xdisplay[id].window);
  }

  for (n=1; n<MAX_IMAGES; n++)
    if (xdisplay[n].init==-1) {
      xdisplay[n].label_flag=xdisplay[id].label_flag;
      xdisplay[n].text_flag=xdisplay[id].text_flag;

      if (xdisplay[n].axis_flag!=xdisplay[id].axis_flag)
	expose_flag=True;
      else 
	expose_flag=False;
      xdisplay[n].overlay_flag=xdisplay[id].overlay_flag;
      xdisplay[n].axis_flag=xdisplay[id].axis_flag;
      xdisplay[n].grid_flag=xdisplay[id].grid_flag;
      xdisplay[n].solid_flag=xdisplay[id].solid_flag;
      xdisplay[n].grid_x=xdisplay[id].grid_x;
      xdisplay[n].grid_y=xdisplay[id].grid_y;
      xdisplay[n].grid_color=xdisplay[id].grid_color;
      if ((!xdisplay[n].hide_flag)&&(expose_flag)) {
                                /* If window is not hidden unmap then map. */
	XtUnmapWidget(xdisplay[n].window);
	XtMapWidget(xdisplay[n].window);
      } 
    }

  expose_all_images();

  if( message->w )
    XtDestroyWidget( message->w );
  free(message);
}




/*
  This function get value of a toggle button
  and set client_data to that value.
*/
void set_flagCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  *(Boolean*)client_data=XmToggleButtonGetState(w);
}


/*
  Find the cursor location.
*/
void locate_cursor(int *x, int *y)
{
  Window root,child,window;
  int root_x=0,root_y=0,win_x,win_y;
  unsigned	keys_buttons;

  window=XtWindow(top_level);
  if (window!=(Window)NULL)
    XQueryPointer(display,window,&root,&child,&root_x,&root_y,&win_x,&win_y,&keys_buttons);

  if (root_x>100) 
    root_x-=100; 
  else 
    root_x=0;
  if (root_y>100) 
    root_y-=100; 
  else 
    root_y=0;

  *x=root_x;
  *y=root_y;

  return;
}


/*
  This function displays an error
  dialog with an error message.
*/
void error_message(char *text)
{
  Widget error;
  int root_x,root_y;

  if (text==NULL || strlen(text)==0) return;

  XBell(display,100);

fprintf( stderr, "'%s'\n", text );
  error=XmCreateErrorDialogVa(top_level,"error",
			      XmNmessageString,XMstr(text),
			      XmNdialogTitle,XMstr("Error Message"),
			      NULL);
  XtUnmanageChild (XmMessageBoxGetChild (error,XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild (XmMessageBoxGetChild (error,XmDIALOG_HELP_BUTTON));
  XtAddCallback(error,XmNokCallback,destroyCB,error);

  locate_cursor(&root_x,&root_y);

  if ((root_x!=0)||(root_y!=0)) {
    XtVaSetValues(error,
		  XmNdefaultPosition,False,
		  XmNx,root_x,
		  XmNy,root_y,
		  NULL);
  }
}



/*
  This function displays a message
  in a dialog.
*/
void msg_message(char *text)
{
  Widget msg;
  int root_x,root_y;

  XBell(display,100);

  locate_cursor(&root_x,&root_y);

  
  msg=XmCreateInformationDialogVa(top_level,"msg",  
				  XmNmessageString,XMstr(text),
				  XmNdialogTitle,XMstr("Message"),
				  NULL);
  XtAddCallback(msg,XmNokCallback,destroyCB,msg);
  XtAddCallback(msg,XmNcancelCallback,destroyCB,msg);

  if ((root_x!=0)||(root_y!=0)) {
    XtVaSetValues(msg,
		  XmNdefaultPosition,False,
		  XmNx,root_x,
		  XmNy,root_y,
		  NULL);
  }
}



/*
  This function creates the text string that 
  goes on the top of each seismic window. 
*/
void window_title(char *buf, long id)
{
  sprintf(buf,"%d Window: %d - %s %s - %s %d %d %d,%d %d %d,%d %d %d #%s#",
	  xdisplay[id].sequence,id,xdisplay[id].time,xdisplay[id].date,
	  xdisplay[id].filename,srec[id],erec[id],irec[id],strace[id],
	  etrace[id],itrace[id],ssamp[id],esamp[id],isamp[id],
	  xdisplay[id].comment);
}


void set_mode_label(int value, long id)
{
  if (xdisplay[id].init!=-1) {
    return;
  }

  if( !xdisplay[id].mode_label  ||  !XtIsWidget( xdisplay[id].mode_label ) )
    return;	/* RJM: added: parent widget (window) can be destroyed which
			wipes out this widget */

  sprintf(buf,"Mode:\n");
  switch (value) {
  case 0: strcat(buf," Drag & Zoom"); break;
  case 1: strcat(buf," Pick               "); break;
  case 2: strcat(buf," Select Segment     "); break;
  case 3: strcat(buf," Move Pick          "); break;
  case 4: strcat(buf," Add Pick           "); break;
  case 5: strcat(buf," Delete Pick        "); break;
  case 6: strcat(buf," Split Segment      "); break;
  case 7: strcat(buf," Join Segment       "); break;
  case 8: strcat(buf," Move Segment       "); break;
  case 9: strcat(buf," Round to Point     "); break;
  case 10: strcat(buf," Round to Horizontal"); break;
  case 11: strcat(buf," Round to Vertical  "); break;
  case 12: strcat(buf,"                    "); break;
  case 13: strcat(buf,"                    "); break;
  case 14: strcat(buf," Position Label     "); break;
  case 15: strcat(buf," Round Picks Left   "); break;
  case 16: strcat(buf," Round Picks Right  "); break;
  case 17: strcat(buf," Add Segment        "); break;
  case 18: strcat(buf," Model Builder      "); break;
  case 19: strcat(buf," Generating         "); break;
  case 20: strcat(buf,"                    "); break;
  case 21: strcat(buf," Delete Segment     "); break;
  case 22: strcat(buf," Duplicate Segment  "); break;
  case 23: strcat(buf," Refine Segment     "); break;
  case 24: strcat(buf," Label Segment      "); break;
  case 25: strcat(buf," Color Segment      "); break;
  case 26: strcat(buf," Printing Section   "); break;
  case 27: strcat(buf," Single Pick Segment"); break;
  case 28: strcat(buf," Paint              "); break;
  }

  XtSetArg(args[0],XmNlabelString,XMstr(buf));
  XtSetValues(xdisplay[id].mode_label,args,1);
}
