/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  dual contrast and bias adjustments. 
*/


#include "xdisplayP.h"
#include "prototyping.h"


extern Widget scale_bias[MAX_IMAGES];
extern Widget scale_contrast[MAX_IMAGES];
extern Widget global_toggle[MAX_IMAGES];
extern Widget scale_bias1[MAX_IMAGES];
extern Widget scale_contrast1[MAX_IMAGES];

extern Widget draw_color[MAX_IMAGES];
extern int global_bias;
extern int global_contrast;


/*
  This function creates the sliders for 
  dual contrast and bias controls.
*/
void color_half(Widget main_form, long id)
{
  Widget form;
  Widget frame;
  Widget label;

  xdisplay[id].mode=1;
  set_mode_label(1,id);
  
  frame=XmCreateFrameVa(main_form,"frame",
			XmNleftAttachment,XmATTACH_FORM,
			XmNtopAttachment,XmATTACH_FORM,
			NULL);		       
  
  form=XmCreateFormVa(frame,"form",NULL);
  
  
  label=XmCreatePushButtonVa(form,"Cont",
			     XmNleftAttachment,XmATTACH_FORM,
			     XmNtopAttachment,XmATTACH_FORM,	/* RJM */
/*			     XmNbottomAttachment,XmATTACH_FORM, */
/* CAN'T DO BOTTOM ATTACHMENT BECAUSE xdisplay[id].label BELOW ATTACHES TO SAME
FORM BOTTOM */
			     NULL);		       
  
  scale_contrast[id]=XmCreateScaleVa(form,"scale",
				     XmNshowValue,True,
				     XmNorientation,XmHORIZONTAL,
				     XmNprocessingDirection,XmMAX_ON_RIGHT,
				     XmNtopAttachment,XmATTACH_FORM,
				     XmNleftAttachment,XmATTACH_WIDGET,
				     XmNleftWidget,label,
				     XmNminimum,-100,
				     XmNmaximum,100,
				     XmNdecimalPoints,2,
				     XmNscaleMultiple,1,
				     NULL);		       
  XtAddCallback(scale_contrast[id],XmNvalueChangedCallback,contrastCB,(XtPointer)id);
  XtAddCallback(scale_contrast[id],XmNdragCallback,contrastCB,(XtPointer)id);
  XmScaleSetValue(scale_contrast[id],global_contrast);

                                         /* Set call after scale is created. */
  XtAddCallback(label,XmNactivateCallback,resetCB,scale_contrast[id]);
  XtAddCallback(label,XmNactivateCallback,contrastCB,(XtPointer)id);
  XmAddTabGroup(scale_contrast[id]);
  
  
  label=XmCreatePushButtonVa(form,"Bias",
			     XmNleftAttachment,XmATTACH_WIDGET,
			     XmNleftWidget,scale_contrast[id],
			     XmNtopAttachment,XmATTACH_FORM,	/* RJM */
/*			     XmNbottomAttachment,XmATTACH_FORM, */
/* CAN'T DO BOTTOM ATTACHMENT BECAUSE xdisplay[id].label BELOW ATTACHES TO SAME
FORM BOTTOM */
			     NULL);		       
  
  scale_bias[id]=XmCreateScaleVa(form,"scale",
				 XmNshowValue,True,
				 XmNorientation,XmHORIZONTAL,
				 XmNprocessingDirection,XmMAX_ON_RIGHT,
				 XmNtopAttachment,XmATTACH_FORM,
				 XmNleftAttachment,XmATTACH_WIDGET,
				 XmNleftWidget,label,
				 XmNminimum,-100,
				 XmNmaximum,100,
				 XmNdecimalPoints,2,
				 XmNscaleMultiple,1,
				 NULL);		       
  XtAddCallback(scale_bias[id],XmNvalueChangedCallback,biasCB,(XtPointer)id);
  XtAddCallback(scale_bias[id],XmNdragCallback,biasCB,(XtPointer)id);
  XmScaleSetValue(scale_bias[id],global_bias);

                                         /* Set call after scale is created. */
  XtAddCallback(label,XmNactivateCallback,resetCB,scale_bias[id]);
  XtAddCallback(label,XmNactivateCallback,biasCB,(XtPointer)id);
  XmAddTabGroup(scale_bias[id]);

  
  global_toggle[id]=XmCreateToggleButtonVa(form,"Global",
					   XmNleftAttachment,XmATTACH_WIDGET,
					   XmNleftWidget,scale_bias[id],
					   XmNrightAttachment,XmATTACH_FORM,
					   XmNtopAttachment,XmATTACH_FORM,/*RJM*/
/*			     		   XmNbottomAttachment,XmATTACH_FORM, */
/* CAN'T DO BOTTOM ATTACHMENT BECAUSE xdisplay[id].label BELOW ATTACHES TO SAME
FORM BOTTOM */
					   NULL);		       
  XtAddCallback(global_toggle[id],XmNvalueChangedCallback,set_toggleCB,(XtPointer)id);
  
  
/*frame=XmCreateFrameVa(xdisplay[id].menu,"Mode", */
  frame=XmCreateFrameVa(main_form,"Mode",
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_WIDGET,
			XmNleftWidget,frame,
/*			XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,frame,
*/
			NULL);


  
/*form=XmCreateFormVa(frame,"Mode",NULL); RJM */
  
  sprintf(buf,"Mode:\n Picking             ");
/*xdisplay[id].mode_label=XmCreateLabelVa(form,"mode", */
  xdisplay[id].mode_label=XmCreateLabelVa(frame,"mode",
					  XmNlabelString,XMstr(buf),
					  XmNalignment,XmALIGNMENT_BEGINNING,
					  NULL);

  
  frame=XmCreateFrameVa(main_form,"frame",
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,frame,
			NULL);		       
  
  form=XmCreateFormVa(frame,"form",NULL);
  
  
  label=XmCreatePushButtonVa(form,"Cont",
			     XmNtopAttachment,XmATTACH_FORM,
/*			     XmNbottomAttachment,XmATTACH_FORM, RJM */
			     XmNleftAttachment,XmATTACH_FORM,
			     NULL);		       
  
  
  scale_contrast1[id]=XmCreateScaleVa(form,"scale",
				      XmNshowValue,True,
				      XmNorientation,XmHORIZONTAL,
				      XmNprocessingDirection,XmMAX_ON_RIGHT,
				      XmNtopAttachment,XmATTACH_FORM,
				      XmNleftAttachment,XmATTACH_WIDGET,
				      XmNleftWidget,label,
				      XmNminimum,-100,
				      XmNmaximum,100,
				      XmNdecimalPoints,2,
				      XmNscaleMultiple,1,
				      NULL);		       
  XtAddCallback(scale_contrast1[id],XmNvalueChangedCallback,contrastCB,(XtPointer)id);
  XtAddCallback(scale_contrast1[id],XmNdragCallback,contrastCB,(XtPointer)id);
  XmScaleSetValue(scale_contrast1[id],global_contrast);

                                         /* Set call after scale is created. */
  XtAddCallback(label,XmNactivateCallback,resetCB,scale_contrast1[id]);
  XtAddCallback(label,XmNactivateCallback,contrastCB,(XtPointer)id);
  XmAddTabGroup(scale_contrast1[id]);
  
  
  label=XmCreatePushButtonVa(form,"Bias",
			     XmNleftAttachment,XmATTACH_WIDGET,
			     XmNleftWidget,scale_contrast1[id],
/*			     XmNbottomAttachment,XmATTACH_FORM, RJM */
			     XmNtopAttachment,XmATTACH_FORM,
			     NULL);		       
  
  scale_bias1[id]=XmCreateScaleVa(form,"scale",
				  XmNshowValue,True,
				  XmNorientation,XmHORIZONTAL,
				  XmNprocessingDirection,XmMAX_ON_RIGHT,
				  XmNtopAttachment,XmATTACH_FORM,
				  XmNleftAttachment,XmATTACH_WIDGET,
				  XmNleftWidget,label,
				  XmNminimum,-100,
				  XmNmaximum,100,
				  XmNdecimalPoints,2,
				  XmNscaleMultiple,1,
				  NULL);		       
  XtAddCallback(scale_bias1[id],XmNvalueChangedCallback,biasCB,(XtPointer)id);
  XtAddCallback(scale_bias1[id],XmNdragCallback,biasCB,(XtPointer)id);
  XmScaleSetValue(scale_bias1[id],global_bias);

                                         /* Set call after scale is created. */
  XtAddCallback(label,XmNactivateCallback,resetCB,scale_bias1[id]); 
  XtAddCallback(label,XmNactivateCallback,biasCB,(XtPointer)id);
  XmAddTabGroup(scale_bias1[id]);
  
  
/*frame=XmCreateFrameVa(xdisplay[id].menu,"frame", */
  frame=XmCreateFrameVa(main_form,"frame",
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,frame,
			XmNbottomAttachment,XmATTACH_FORM,
			NULL);		       
  
  form=XmCreateFormVa(frame,"Color",NULL);
  
  sprintf(buf,"Record  Trace  Sample      Value  %s  %s  %s",xdisplay[id].data1,xdisplay[id].data2,xdisplay[id].data3);
  
  xdisplay[id].label=XmCreateLabelVa(form,buf,
				     XmNleftAttachment,XmATTACH_FORM,
				     XmNtopAttachment,XmATTACH_FORM,
				     XmNalignment,XmALIGNMENT_BEGINNING,
				     NULL);		       
  
  
  xdisplay[id].values=XmCreateLabelVa(form,"                                                ",
				      XmNleftAttachment,XmATTACH_FORM,
				      XmNtopAttachment,XmATTACH_WIDGET,
				      XmNtopWidget,xdisplay[id].label,
				      XmNalignment,XmALIGNMENT_END,
				      NULL);		       

  xdisplay[id].number_label=XmCreateLabelVa(form,"Segment #",
					    XmNtopAttachment,XmATTACH_FORM,
					    XmNbottomAttachment,XmATTACH_FORM,
/*					    XmNrightAttachment,XmATTACH_WIDGET,
					    XmNrightWidget,xdisplay[id].number_text,
*/
					    XmNleftAttachment,XmATTACH_WIDGET,
					    XmNleftWidget,xdisplay[id].label,
					    XmNleftOffset,50,
					    XmNsensitive,False,
					    NULL);		       

  xdisplay[id].number_text=XmCreateTextVa(form,"text",
					  XmNtopAttachment,XmATTACH_FORM,
					  XmNbottomAttachment,XmATTACH_FORM,
					  XmNleftAttachment,XmATTACH_WIDGET,
					  XmNleftWidget,xdisplay[id].number_label,
					  XmNrightAttachment,XmATTACH_FORM,
					  XmNcolumns,3,
					  XmNsensitive,False,
					  NULL);		       
  XtAddCallback(xdisplay[id].number_text,XmNactivateCallback,
		select_by_numberCB,(XtPointer)id);
  XmAddTabGroup(xdisplay[id].number_text);
  
  xdisplay[id].pick_color=black;
}



/*
  This function changes the colormap
  according to dual bias and contrast
  values.
*/
void contrast_bias_half(long id1, long id)
{
  int contrast_value;
  int bias_value;
  XColor color[256];
  XColor color1[256];
  int n,start,temp,temp1,temp2;
  int end_color_temp,start_color_temp;
  float temp_color,color_scale;

  if (xdisplay[id1].init!=-1) {
    error_message("Need to get data.");
    return;
  }

  for (n=0; n<=end_color; n++)
    color[n].pixel=n;

  XQueryColors(display,xdisplay[id1].cmap,color,(int)end_color+1);

  XmScaleGetValue(scale_bias[id],&bias_value);
  XmScaleGetValue(scale_contrast[id],&contrast_value);

  if (id!=id1) {
    XmScaleSetValue(scale_bias[id1],bias_value);
    XmScaleSetValue(scale_contrast[id1],contrast_value);
    XmToggleButtonSetState(global_toggle[id1],XmToggleButtonGetState(global_toggle[id]),False);
  }

  contrast_value/=2;

  for (n=start_color; n<=end_color; n++) {
    color[n].red=(int)*(raster_color_red[id]+n)*256;
    color[n].green=(int)*(raster_color_green[id]+n)*256;
    color[n].blue=(int)*(raster_color_blue[id]+n)*256;
  }

/*start_color_temp=54;	RJM: comment out!
  end_color_temp=153;
*/
  start_color_temp=start_color;
  end_color_temp=(start_color+end_color)/2;

  for (n=start_color_temp; n<=end_color_temp; n++) {
    color1[n].red=color[n].red;
    color1[n].blue=color[n].blue;
    color1[n].green=color[n].green;
  }

  temp=(int)((end_color_temp-start_color_temp)*(bias_value/100.0));  /* Find middle. */
  if (contrast_value<0)
    start=(int)((end_color_temp-start_color_temp)*(10*contrast_value/100.0));
  else
    start=(int)((end_color_temp-start_color_temp)*(contrast_value/100.0));
  temp1=start_color_temp+start+temp;
  temp2=end_color_temp-start+temp;
  for (n=start_color_temp; n<temp1; n++) 
    if ((n>=start_color_temp)&&(n<=end_color_temp)) {
      color[n].red=color1[start_color_temp].red;
      color[n].green=color1[start_color_temp].green;
      color[n].blue=color1[start_color_temp].blue;
    }
  for (n=temp2+1; n<=end_color_temp; n++)
    if ((n>=start_color_temp)&&(n<=end_color_temp)) {
      color[n].red=color1[end_color_temp].red;
      color[n].green=color1[end_color_temp].green;
      color[n].blue=color1[end_color_temp].blue;
    }
  temp_color=start_color_temp;
  temp1=start_color_temp+start+temp;
  temp2=end_color_temp-start+temp;
  color_scale=(float)(end_color_temp-start_color_temp)/(float)(temp2-temp1);
  for (n=temp1; n<=temp2; n++) {
    if ((n>=start_color_temp)&&(n<=end_color_temp)) {
      if ((temp_color>=start_color_temp)&&(temp_color<=end_color_temp)) {
	color[n].red=color1[(int)temp_color].red;
	color[n].green=color1[(int)temp_color].green;
	color[n].blue=color1[(int)temp_color].blue;
      }
    }
    temp_color+=color_scale;
  }

  XmScaleGetValue(scale_bias1[id],&bias_value);
  XmScaleGetValue(scale_contrast1[id],&contrast_value);

  if (id!=id1) {
    if( scale_bias1[id1] ) /* RJM: added: load 2 image files, then animate and
				notice that scale_bias1[id1]=UNDEFINED */
    	XmScaleSetValue(scale_bias1[id1],bias_value);
    if( scale_contrast1[id1] ) /* RJM: added */
    	XmScaleSetValue(scale_contrast1[id1],contrast_value);
  }


  contrast_value/=2;

/*start_color_temp=154;	RJM: comment out!
  end_color_temp=253;
*/
  start_color_temp=(start_color+end_color)/2+1;
  end_color_temp=end_color;

  for (n=start_color_temp; n<=end_color_temp; n++) {
    color1[n].red=color[n].red;
    color1[n].blue=color[n].blue;
    color1[n].green=color[n].green;
  }

  temp=(int)((end_color_temp-start_color_temp)*(bias_value/100.0));  /* Find middle. */
  if (contrast_value<0)
    start=(int)((end_color_temp-start_color_temp)*(10*contrast_value/100.0));
  else
    start=(int)((end_color_temp-start_color_temp)*(contrast_value/100.0));
  temp1=start_color_temp+start+temp;
  temp2=end_color_temp-start+temp;
  for (n=start_color_temp; n<temp1; n++) 
    if ((n>=start_color_temp)&&(n<=end_color_temp)) {
      color[n].red=color1[start_color_temp].red;
      color[n].green=color1[start_color_temp].green;
      color[n].blue=color1[start_color_temp].blue;
    }
  for (n=temp2+1; n<=end_color_temp; n++)
    if ((n>=start_color_temp)&&(n<=end_color_temp)) {
      color[n].red=color1[end_color_temp].red;
      color[n].green=color1[end_color_temp].blue;
      color[n].blue=color1[end_color_temp].green;
    }
  temp_color=start_color_temp;
  temp1=start_color_temp+start+temp;
  temp2=end_color_temp-start+temp;
  color_scale=(float)(end_color_temp-start_color_temp)/(float)(temp2-temp1);
  for (n=temp1; n<=temp2; n++) {
    if ((n>=start_color_temp)&&(n<=end_color_temp)) {
      if ((temp_color>=start_color_temp)&&(temp_color<=end_color_temp)) {
	color[n].red=color1[(int)temp_color].red;
	color[n].green=color1[(int)temp_color].green;
	color[n].blue=color1[(int)temp_color].blue;
      }
    }
    temp_color+=color_scale;
  }

  for (n=start_pick_color-3; n<=end_pick_color; n++) {
    color[n].red=(int)*(raster_color_red[id]+n)<<8;
    color[n].green=(int)*(raster_color_green[id]+n)<<8;
    color[n].blue=(int)*(raster_color_blue[id]+n)<<8;
  }
    
  XStoreColors(display,xdisplay[id1].cmap,color,(int)end_color+1);
}
