/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  getting the seismic header information.
*/

#include "xdisplayP.h"
#include "lheader.h"
#include "theader.h"
#include "prototyping.h"
#include "ut_defs.h"

#define BUF_SIZE 40

extern Boolean server_flag;
extern char *header;
extern Boolean disco_flag;
extern XtIntervalId time_out;


/*
  This function create a selection
  box contain the line header names.
*/
void line_headerCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget list_form;
  Widget frame;
  Widget button;
  char header_name[7],type[2];
  char value_char[BUF_SIZE];
  int value,m,n,error;
  long id;	/* RJM: handle 64-bit architectures */
  float value_float;
  XmString item[153];

  id=(long)client_data;

  if (!server_flag) {
    error_message("Cannot look at the line header of an image file.");
    return;
  }
 
                                /* Check if server is still running. */
  if (amoco_check_server(buf)==-1) {
#ifndef NO_TIME_OUT
    XtRemoveTimeOut(time_out);  /* abort error dialog pop-up */
#endif
    error_message(buf);
    error_message("Server error (7). Try restarting server.");
    xdisplay[id].init=0;
    return;
  }

  error=amoco_read_line_header(&header,xdisplay[id].filename);

				/* Check if line header was read. */
  if (error < 0) {
    reportDSerror( error );
    xdisplay[id].init=0;
    return;
  }

  switch (error) {
  case 1: disco_flag=False; break;
  case 2: disco_flag=True; break;
  }
  if (disco_flag) {
    error_message("Line header information not available for DISCO data sets.");
    return;
  }
  
  list_form=XmCreateFormDialogVa(w,"form",
				 XmNmarginHeight,10,
				 XmNmarginWidth,10,
				 XmNdeleteResponse,XmDO_NOTHING,
				 XmNdialogTitle,
				 XMstr("Line Header Information"),
				 XtNmanageChild,False,
				 NULL);
  XtAddCallback(list_form,XmNhelpCallback,helpCB,"lineH.help");

				/* Loop through the line header words. */
  for (m=0; m<152; m++) {
    strncpy(header_name,&lheader[m][0],6);
    header_name[6]='\0';
    type[0] = lheader[m][8];
    type[1] = '\0';

				/* Check the value type (char,integer,etc.. */
    switch ((int)type[0]) {
    case 'C':						/* character type */
      memset(value_char,0,BUF_SIZE);
      C_SAVER((int*)header,header_name,(int*)value_char,0);
      sprintf(buf,"%-41s %s",&lheader[m][0],value_char);
      break;
    case 'S':						/* short type */
      C_SAVER((int*)header,header_name,&value,0);
      sprintf(buf,"%-41s %d",&lheader[m][0],value);
      break;
    case 'I':
      C_SAVER((int*)header,header_name,&value,0);
      sprintf(buf,"%-41s %d",&lheader[m][0],value);
      break;
    case 'F':
      C_SAVER((int*)header,header_name,(int*)&value_float,0);
      sprintf(buf,"%-41s %f",&lheader[m][0],value_float);
      break;
    }
				/* Build XmString list. */
    item[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
  }

  if(header)
    free(header);
				/* Mark the end of the list. */
  item[m]=NULL;

  frame=XmCreateFrameVa(list_form,"listframe",
			XmNtopAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);

  
  (void)XmCreateScrolledListVa(frame,"Line Header",
			      XmNitems,item,
			      XmNitemCount,m,
			      XmNvisibleItemCount,25,
			      NULL);

  for (n=0; n<m; n++)
    XmStringFree(item[n]);

  button=XmCreatePushButtonVa(list_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,frame,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNleftAttachment,XmATTACH_FORM,
			      NULL);
  XtAddCallback(button,XmNactivateCallback,destroyCB,list_form);

  XtManageChild(list_form);
}


/*
  This function prompts the user 
  to selected a trace header.
*/
void trace_headerCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int m,n;
  long id;	/* RJM: handle 64-bit architectures */
  Widget list;
  XmString item[63];
  ClientData *message;

  id=(long)client_data;

				/* Build XmString list. */
  for (m=0; m<62; m++)
    item[m]=XmStringCreateLtoR(&theader[m][0],XmSTRING_DEFAULT_CHARSET);

				/* Mark the end of the list. */
  item[m]=NULL;

  
  list=XmCreateSelectionDialogVa(w,"Trace Header",
				 XmNlistItems,item,
				 XmNlistItemCount,m,
				 XmNlistVisibleItemCount,25,
				 XmNapplyLabelString,XMstr("OK All"),
				 NULL);

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=list;
  message->id=id;
  XtAddCallback(list,XmNhelpCallback,helpCB,"trace.help");
  XtAddCallback(list,XmNokCallback,set_dataCB,message);
  XtAddCallback(list,XmNcancelCallback,destroyCB,list);

  message->id=((message->id)&0x00ff);
  XtAddCallback(list,XmNapplyCallback,set_dataCB,message);

  for (n=0; n<m; n++)
    XmStringFree(item[n]);

                                /* Erases "Apply" button. Confused users. */
/*  XtUnmanageChild(XmSelectionBoxGetChild(list,XmDIALOG_APPLY_BUTTON)); */
}


/*
  This function set the trace header 
  word that is to be retrieve.
*/
void set_dataCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct *CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  char *str;
  long id;
  int data_switch;

				/* Get the window id. */
  id=((message->id)>>8);
  
				/* Get the data_switch indicate 
				   the first or second word. */
  data_switch=((message->id)&0x00ff);

  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&str);

				/* Check if trace word was selected. */
  if (! *str) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

  if (id==0) {
    for (id=0; id<MAX_IMAGES; id++)
      if (xdisplay[id].init!=0) {
	switch (data_switch) {
	case 1:
	  sscanf(str,"%s ",xdisplay[id].data1);
	  break;
	case 2:
	  sscanf(str,"%s ",xdisplay[id].data2);
	  break;
	case 3:
	  sscanf(str,"%s ",xdisplay[id].data3);
	  break;
	}
	
	sprintf(buf,"Record  Trace  Sample      Value  %s  %s  %s",xdisplay[id].data1,xdisplay[id].data2,xdisplay[id].data3);

	XtSetArg(args[0],XmNlabelString,XMstr(buf));
	XtSetValues(xdisplay[id].label,args,1);
      }
  } else {
	switch (data_switch) {
	case 1:
          sscanf(str,"%s ",xdisplay[id].data1);
	  break;
	case 2:
	  sscanf(str,"%s ",xdisplay[id].data2);
	  break;
	case 3:
	  sscanf(str,"%s ",xdisplay[id].data3);
	  break;
	default:
	  break;
	}
    
    sprintf(buf,"Record  Trace  Sample      Value  %s  %s  %s",xdisplay[id].data1,xdisplay[id].data2,xdisplay[id].data3);

    XtSetArg(args[0],XmNlabelString,XMstr(buf));
    XtSetValues(xdisplay[id].label,args,1);
  }

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
  XtFree(str);
}
