/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  creating the main menus.
*/

#include "xdisplayP.h"
#include "prototyping.h"

static void model_file(long);
static void model_zoom(long );
static void model_segment(long );
static void model_update(long );
static void model_color(long );
static void model_help();

static Widget menubar=NULL;


void model_menus(Widget main_window,Widget main_form, long id, Boolean dual_flag)
{
  XmRemoveTabGroup(main_form);

  xdisplay[id].menu=XmCreateFormVa(main_form,"menu",
				   NULL);

  XtAddCallback(xdisplay[id].menu,XmNhelpCallback,helpCB,"model_window.help");

  menubar=XmCreateMenuBarVa(main_window,"menubar",
			    NULL);
  xdisplay[id].menubar=menubar;

  model_file(id);
  model_zoom(id);
  model_segment(id);
  edit_segment_menu(id, menubar);
  model_update(id);
  model_color(id);
  model_help();

  if (dual_flag)
    color_half(xdisplay[id].menu,id);
  else
    color_sliders(xdisplay[id].menu,id);
    
  XtManageChild(xdisplay[id].menu);

  XtVaSetValues(main_window,
                XmNmenuBar,menubar,
                XmNworkWindow,main_form,
                XmNshowSeparator,True,
                NULL);
}


static void model_file(long id)
{
  Widget pulldown;
  Widget cascade;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);

  XtSetArg(args[0],XmNsubMenuId,pulldown);
  cascade=XmCreateCascadeButton(menubar,"File",args,1);
  XtManageChild(cascade);

  (void)XmCreatePushButtonVa(pulldown,"Create Velocity Tape",
			XmNactivateCallback, CBl(prompt_vel_createCB,(XtPointer)id),
			NULL);

  (void)XmCreatePushButtonVa(pulldown,"Return",
			XmNactivateCallback, CBl(delete_windowCB,(XtPointer)id),
			NULL);
}


static void model_zoom(long id)
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  XtSetArg(args[0],XmNsubMenuId,pulldown);
  cascade=XmCreateCascadeButton(menubar,"Window",args,1);
  XtManageChild(cascade);

  button=XmCreatePushButton(pulldown,"Zoom & Copy",NULL,0);
  XtAddCallback(button,XmNactivateCallback,zoom_allCB,(XtPointer)id);
  XtManageChild(button);
    
  button=XmCreatePushButton(pulldown,"Drag & Zoom",NULL,0);
  XtAddCallback(button,XmNactivateCallback,set_modeCB,(XtPointer)(0x0000|id));
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"Global",NULL,0);
  XtAddCallback(button,XmNactivateCallback,globalCB,(XtPointer)id);
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"Delete",NULL,0);
  XtAddCallback(button,XmNactivateCallback,delete_windowCB,(XtPointer)id);
  XtManageChild(button);
}


static void model_segment(long id)
{
  Widget pulldown;
  Widget toggle;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  (void)XmCreateCascadeButtonVa(menubar,"Segment",
				  XmNmnemonic,(KeySym)'S',
				  XmNsubMenuId,pulldown,
				  NULL);

  if (id!=0) {
    (void)XmCreatePushButtonVa(pulldown,"Add Segments",
				XmNmnemonic,(KeySym)'S',
				XmNacceleratorText,XMstr("Shift+S"),
				XmNaccelerator,"Shift <Key>S",
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x1000|id)),
				NULL);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Hide Segments on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].segment_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Hide Overlay on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].overlay_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Honor Record on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].record_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    xdisplay[id].record_flag=True;
    XmToggleButtonSetState(toggle,xdisplay[id].record_flag,False);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Segment Labels on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].label_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    xdisplay[id].label_flag=True;
    XmToggleButtonSetState(toggle,xdisplay[id].label_flag,False);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Segment Numbers on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].number_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    XmToggleButtonSetState(toggle,xdisplay[id].number_flag,False);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Lines on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].lines_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    XmToggleButtonSetState(toggle,xdisplay[id].lines_flag,False);
    
    
    (void)XmCreatePushButtonVa(pulldown,"Copy Segment From/To",
				XmNmnemonic,(KeySym)'C',
				XmNactivateCallback,CBl(change_recordCB,(XtPointer)id),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Auto Picking",
				XmNmnemonic,(KeySym)'u',
				XmNactivateCallback,CBl(auto_pickCB,(XtPointer)id),
				NULL);    
    
    (void)XmCreatePushButtonVa(pulldown,"Move Segment",
				XmNmnemonic,(KeySym)'M',
				XmNacceleratorText,XMstr("Ctrl+M"),
				XmNaccelerator,"Ctrl <Key>M",
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x8000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Delete Segment",
				XmNmnemonic,(KeySym)'D',
				XmNacceleratorText,XMstr("Ctrl+D"),
				XmNaccelerator,"Ctrl <Key>D",
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x15000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Duplicate Segment",
				XmNmnemonic,(KeySym)'u',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x16000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Refine Segment",
				XmNmnemonic,(KeySym)'R',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x17000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Split Segment",
				XmNmnemonic,(KeySym)'S',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x6000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Join Segment",
				XmNmnemonic,(KeySym)'J',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x7000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Label Segment",
				XmNmnemonic,(KeySym)'L',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x18000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Change Color",
				XmNmnemonic,(KeySym)'C',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x19000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Add Single Point Segment",
				XmNmnemonic,(KeySym)'A',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x1b000|id)),
				NULL);
  }
}


static void model_update(long id)
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  XtSetArg(args[0],XmNsubMenuId,pulldown);
  cascade=XmCreateCascadeButton(menubar,"Update",args,1);
  XtManageChild(cascade);

  button=XmCreatePushButton(pulldown,"Update Bodies & Velocities",NULL,0);
  XtAddCallback(button,XmNactivateCallback,regenerateCB,(XtPointer)id);
  XtManageChild(button);
}


static void model_color(long id)
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);

  XtSetArg(args[0],XmNsubMenuId,pulldown);
  cascade=XmCreateCascadeButton(menubar,"Color",args,1);
  XtManageChild(cascade);

  (void)XmCreatePushButtonVa(pulldown,"Pick Color",
                              XmNmnemonic,(KeySym)'P',
                              XmNactivateCallback,
                                CBl(pick_color_dialogCB,(XtPointer)id),
                              NULL);

  button=XmCreatePushButton(pulldown,"Set to Global Colormap",NULL,0);
  XtAddCallback(button,XmNactivateCallback,set_global_colorCB,(XtPointer)id);
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"Load Global Colormap",NULL,0);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)6L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"Load Local Colormap",NULL,0);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)10L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"Cursor Color",NULL,0);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,cursor_colorCB,(XtPointer)id);

  button=XmCreatePushButton(pulldown,"Show Colormap Scale",NULL,0);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,show_colormapCB,(XtPointer)id);

  button=XmCreatePushButton(pulldown,"Edit Colormap",NULL,0);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,edit_colormapCB,(XtPointer)id);

  button=XmCreatePushButton(pulldown,"Segment Colors",NULL,0);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,segment_colorsCB,(XtPointer)id);
}


static void model_help()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  XtSetArg(args[0],XmNsubMenuId,pulldown);
  cascade=XmCreateCascadeButton(menubar,"Help",args,1);
  XtManageChild(cascade);

  XtVaSetValues(menubar,
                XmNmenuHelpWidget,cascade,
                NULL);

  button=XmCreatePushButton(pulldown,"On Help",NULL,0);
  XtAddCallback(button,XmNactivateCallback,helpCB,"help.help");
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"On Window",NULL,0);
  XtAddCallback(button,XmNactivateCallback,helpCB,"window.help");
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"On Version",NULL,0);
  XtAddCallback(button,XmNactivateCallback,versionCB,0);
  XtManageChild(button);

}


void prompt_vel_createCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog;
  int n;
  long id;	/* RJM: handle 64-bit architectures */
  
  id=(long)client_data;
 
  n=0;
  XtSetArg(args[n],XmNmessageString,
           XMstr("First save the velocity parameters before building velocity tape?")); n++;
  XtSetArg(args[n],XmNokLabelString,XMstr(" Yes ")); n++;
  XtSetArg(args[n],XmNcancelLabelString,XMstr(" No ")); n++;
  dialog=XmCreateQuestionDialog(w,"Velocity Verification",args,n);
  XtManageChild(dialog);
 
  XtAddCallback(dialog,XmNokCallback,set_typeCB,(XtPointer)16L);
  XtAddCallback(dialog,XmNokCallback,filer_promptCB,(XtPointer)id);
  XtAddCallback(dialog,XmNokCallback,destroyCB,(XtPointer)dialog);
  XtAddCallback(dialog,XmNcancelCallback,create_vel_tapeCB,(XtPointer)id);
  XtAddCallback(dialog,XmNhelpCallback,helpCB,(XtPointer)"save_model.help");
}
